/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.Response;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeProcessorInternal;
import org.apache.coyote.http2.Http2AsyncUpgradeHandler;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http2Protocol
implements UpgradeProtocol {
    private static final Log log = LogFactory.getLog(Http2Protocol.class);
    private static final StringManager sm = StringManager.getManager(Http2Protocol.class);
    static final long DEFAULT_READ_TIMEOUT = 5000L;
    static final long DEFAULT_WRITE_TIMEOUT = 5000L;
    static final long DEFAULT_KEEP_ALIVE_TIMEOUT = 20000L;
    static final long DEFAULT_STREAM_READ_TIMEOUT = 20000L;
    static final long DEFAULT_STREAM_WRITE_TIMEOUT = 20000L;
    static final long DEFAULT_MAX_CONCURRENT_STREAMS = 100L;
    static final int DEFAULT_MAX_CONCURRENT_STREAM_EXECUTION = 20;
    static final int DEFAULT_OVERHEAD_COUNT_FACTOR = 10;
    static final int DEFAULT_OVERHEAD_RESET_FACTOR = 50;
    static final int DEFAULT_OVERHEAD_REDUCTION_FACTOR = -20;
    static final int DEFAULT_OVERHEAD_CONTINUATION_THRESHOLD = 1024;
    static final int DEFAULT_OVERHEAD_DATA_THRESHOLD = 1024;
    static final int DEFAULT_OVERHEAD_WINDOW_UPDATE_THRESHOLD = 1024;
    private static final String HTTP_UPGRADE_NAME = "h2c";
    private static final String ALPN_NAME = "h2";
    private static final byte[] ALPN_IDENTIFIER = "h2".getBytes(StandardCharsets.UTF_8);
    private long readTimeout = 5000L;
    private long writeTimeout = 5000L;
    private long keepAliveTimeout = 20000L;
    private long streamReadTimeout = 20000L;
    private long streamWriteTimeout = 20000L;
    private long maxConcurrentStreams = 100L;
    private int maxConcurrentStreamExecution = 20;
    private int initialWindowSize = 65535;
    private int maxHeaderCount = 100;
    private int maxTrailerCount = 100;
    private int overheadCountFactor = 10;
    private int overheadResetFactor = 50;
    private int overheadContinuationThreshold = 1024;
    private int overheadDataThreshold = 1024;
    private int overheadWindowUpdateThreshold = 1024;
    private boolean initiatePingDisabled = false;
    private boolean useSendfile = true;
    private AbstractHttp11Protocol<?> http11Protocol = null;
    private final RequestGroupInfo global = new RequestGroupInfo();
    private boolean discardRequestsAndResponses = false;
    private final SynchronizedStack<Request> recycledRequestsAndResponses = new SynchronizedStack();

    @Override
    public String getHttpUpgradeName(boolean bl) {
        if (bl) {
            return null;
        }
        return HTTP_UPGRADE_NAME;
    }

    @Override
    public byte[] getAlpnIdentifier() {
        return ALPN_IDENTIFIER;
    }

    @Override
    public String getAlpnName() {
        return ALPN_NAME;
    }

    @Override
    public Processor getProcessor(SocketWrapperBase<?> socketWrapperBase, Adapter adapter) {
        return new UpgradeProcessorInternal(socketWrapperBase, new UpgradeToken(this.getInternalUpgradeHandler(socketWrapperBase, adapter, null), null, null, this.getUpgradeProtocolName()), null);
    }

    @Override
    public InternalHttpUpgradeHandler getInternalUpgradeHandler(SocketWrapperBase<?> socketWrapperBase, Adapter adapter, Request request) {
        return socketWrapperBase.hasAsyncIO() ? new Http2AsyncUpgradeHandler(this, adapter, request, socketWrapperBase) : new Http2UpgradeHandler(this, adapter, request, socketWrapperBase);
    }

    @Override
    public boolean accept(Request request) {
        Enumeration<String> enumeration = request.getMimeHeaders().values("HTTP2-Settings");
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ++n;
            enumeration.nextElement();
        }
        if (n != 1) {
            return false;
        }
        Enumeration<String> enumeration2 = request.getMimeHeaders().values("Connection");
        boolean bl = false;
        while (enumeration2.hasMoreElements() && !bl) {
            bl = enumeration2.nextElement().contains("HTTP2-Settings");
        }
        return bl;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long l) {
        this.readTimeout = l;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long l) {
        this.writeTimeout = l;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long l) {
        this.keepAliveTimeout = l;
    }

    public long getStreamReadTimeout() {
        return this.streamReadTimeout;
    }

    public void setStreamReadTimeout(long l) {
        this.streamReadTimeout = l;
    }

    public long getStreamWriteTimeout() {
        return this.streamWriteTimeout;
    }

    public void setStreamWriteTimeout(long l) {
        this.streamWriteTimeout = l;
    }

    public long getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(long l) {
        this.maxConcurrentStreams = l;
    }

    public int getMaxConcurrentStreamExecution() {
        return this.maxConcurrentStreamExecution;
    }

    public void setMaxConcurrentStreamExecution(int n) {
        this.maxConcurrentStreamExecution = n;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int n) {
        this.initialWindowSize = n;
    }

    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public void setUseSendfile(boolean bl) {
        this.useSendfile = bl;
    }

    boolean isTrailerHeaderAllowed(String string) {
        return this.http11Protocol.isTrailerHeaderAllowed(string);
    }

    public void setMaxHeaderCount(int n) {
        this.maxHeaderCount = n;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public int getMaxHeaderSize() {
        return this.http11Protocol.getMaxHttpRequestHeaderSize();
    }

    public void setMaxTrailerCount(int n) {
        this.maxTrailerCount = n;
    }

    public int getMaxTrailerCount() {
        return this.maxTrailerCount;
    }

    public int getMaxTrailerSize() {
        return this.http11Protocol.getMaxTrailerSize();
    }

    public int getOverheadCountFactor() {
        return this.overheadCountFactor;
    }

    public void setOverheadCountFactor(int n) {
        this.overheadCountFactor = n;
    }

    public int getOverheadResetFactor() {
        return this.overheadResetFactor;
    }

    public void setOverheadResetFactor(int n) {
        this.overheadResetFactor = Math.max(n, 0);
    }

    public int getOverheadContinuationThreshold() {
        return this.overheadContinuationThreshold;
    }

    public void setOverheadContinuationThreshold(int n) {
        this.overheadContinuationThreshold = n;
    }

    public int getOverheadDataThreshold() {
        return this.overheadDataThreshold;
    }

    public void setOverheadDataThreshold(int n) {
        this.overheadDataThreshold = n;
    }

    public int getOverheadWindowUpdateThreshold() {
        return this.overheadWindowUpdateThreshold;
    }

    public void setOverheadWindowUpdateThreshold(int n) {
        this.overheadWindowUpdateThreshold = n;
    }

    public void setInitiatePingDisabled(boolean bl) {
        this.initiatePingDisabled = bl;
    }

    public boolean getInitiatePingDisabled() {
        return this.initiatePingDisabled;
    }

    public boolean useCompression(Request request, Response response) {
        return this.http11Protocol.useCompression(request, response);
    }

    public ContinueResponseTiming getContinueResponseTimingInternal() {
        return this.http11Protocol.getContinueResponseTimingInternal();
    }

    public AbstractHttp11Protocol<?> getHttp11Protocol() {
        return this.http11Protocol;
    }

    @Override
    public void setHttp11Protocol(AbstractHttp11Protocol<?> abstractHttp11Protocol) {
        this.http11Protocol = abstractHttp11Protocol;
        this.recycledRequestsAndResponses.setLimit(abstractHttp11Protocol.getMaxConnections());
        try {
            ObjectName objectName = this.http11Protocol.getONameForUpgrade(this.getUpgradeProtocolName());
            if (objectName != null) {
                Registry.getRegistry(null).registerComponent((Object)this.global, objectName, null);
            }
        }
        catch (Exception exception) {
            log.warn((Object)sm.getString("http2Protocol.jmxRegistration.fail"), (Throwable)exception);
        }
    }

    public String getUpgradeProtocolName() {
        if (this.http11Protocol.isSSLEnabled()) {
            return ALPN_NAME;
        }
        return HTTP_UPGRADE_NAME;
    }

    public RequestGroupInfo getGlobal() {
        return this.global;
    }

    public boolean getDiscardRequestsAndResponses() {
        return this.discardRequestsAndResponses;
    }

    public void setDiscardRequestsAndResponses(boolean bl) {
        this.discardRequestsAndResponses = bl;
    }

    Request popRequestAndResponse() {
        Request request = null;
        if (!this.discardRequestsAndResponses) {
            request = (Request)this.recycledRequestsAndResponses.pop();
        }
        if (request == null) {
            request = new Request();
            Response response = new Response();
            request.setResponse(response);
        }
        return request;
    }

    void pushRequestAndResponse(Request request) {
        if (!this.discardRequestsAndResponses) {
            this.recycledRequestsAndResponses.push((Object)request);
        }
    }
}

