/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import jakarta.servlet.ServletContext;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.StringInterpreter;

public class StringInterpreterFactory {
    public static final String STRING_INTERPRETER_CLASS_NAME = StringInterpreter.class.getName();
    private static final StringInterpreter DEFAULT_INSTANCE = new DefaultStringInterpreter();

    public static StringInterpreter getStringInterpreter(ServletContext servletContext) throws Exception {
        String string;
        StringInterpreter stringInterpreter = null;
        Object object = servletContext.getAttribute(STRING_INTERPRETER_CLASS_NAME);
        if (object instanceof StringInterpreter) {
            return (StringInterpreter)object;
        }
        if (object instanceof String) {
            stringInterpreter = StringInterpreterFactory.createInstance(servletContext, (String)object);
        }
        if (stringInterpreter == null && (string = servletContext.getInitParameter(STRING_INTERPRETER_CLASS_NAME)) != null) {
            stringInterpreter = StringInterpreterFactory.createInstance(servletContext, string);
        }
        if (stringInterpreter == null) {
            stringInterpreter = DEFAULT_INSTANCE;
        }
        servletContext.setAttribute(STRING_INTERPRETER_CLASS_NAME, (Object)stringInterpreter);
        return stringInterpreter;
    }

    private static StringInterpreter createInstance(ServletContext servletContext, String string) throws Exception {
        return (StringInterpreter)servletContext.getClassLoader().loadClass(string).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private StringInterpreterFactory() {
    }

    public static class DefaultStringInterpreter
    implements StringInterpreter {
        @Override
        public String convertString(Class<?> clazz, String string, String string2, Class<?> clazz2, boolean bl) {
            String string3 = string;
            if (!bl) {
                string3 = Generator.quote(string);
            }
            if (clazz2 != null) {
                String string4 = clazz.getCanonicalName();
                return "(" + string4 + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(" + string4 + ".class, \"" + string2 + "\", " + string3 + ", " + clazz2.getCanonicalName() + ".class)";
            }
            if (clazz == String.class) {
                return string3;
            }
            if (clazz == Boolean.TYPE) {
                return JspUtil.coerceToPrimitiveBoolean(string, bl);
            }
            if (clazz == Boolean.class) {
                return JspUtil.coerceToBoolean(string, bl);
            }
            if (clazz == Byte.TYPE) {
                return JspUtil.coerceToPrimitiveByte(string, bl);
            }
            if (clazz == Byte.class) {
                return JspUtil.coerceToByte(string, bl);
            }
            if (clazz == Character.TYPE) {
                return JspUtil.coerceToChar(string, bl);
            }
            if (clazz == Character.class) {
                return JspUtil.coerceToCharacter(string, bl);
            }
            if (clazz == Double.TYPE) {
                return JspUtil.coerceToPrimitiveDouble(string, bl);
            }
            if (clazz == Double.class) {
                return JspUtil.coerceToDouble(string, bl);
            }
            if (clazz == Float.TYPE) {
                return JspUtil.coerceToPrimitiveFloat(string, bl);
            }
            if (clazz == Float.class) {
                return JspUtil.coerceToFloat(string, bl);
            }
            if (clazz == Integer.TYPE) {
                return JspUtil.coerceToInt(string, bl);
            }
            if (clazz == Integer.class) {
                return JspUtil.coerceToInteger(string, bl);
            }
            if (clazz == Short.TYPE) {
                return JspUtil.coerceToPrimitiveShort(string, bl);
            }
            if (clazz == Short.class) {
                return JspUtil.coerceToShort(string, bl);
            }
            if (clazz == Long.TYPE) {
                return JspUtil.coerceToPrimitiveLong(string, bl);
            }
            if (clazz == Long.class) {
                return JspUtil.coerceToLong(string, bl);
            }
            if (clazz == Object.class) {
                return string3;
            }
            String string5 = this.coerceToOtherType(clazz, string, bl);
            if (string5 != null) {
                return string5;
            }
            String string6 = clazz.getCanonicalName();
            return "(" + string6 + ")org.apache.jasper.runtime.JspRuntimeLibrary.getValueFromPropertyEditorManager(" + string6 + ".class, \"" + string2 + "\", " + string3 + ")";
        }

        protected String coerceToOtherType(Class<?> clazz, String string, boolean bl) {
            return null;
        }
    }
}

