/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.res.StringManager;

public final class C2BConverter {
    private static final Log log = LogFactory.getLog(C2BConverter.class);
    private static final StringManager sm = StringManager.getManager(C2BConverter.class);
    private final CharsetEncoder encoder;
    private ByteBuffer bb = null;
    private CharBuffer cb = null;
    private final CharBuffer leftovers;

    public C2BConverter(Charset charset) {
        this.encoder = charset.newEncoder();
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPLACE);
        char[] cArray = new char[4];
        this.leftovers = CharBuffer.wrap(cArray);
    }

    public void recycle() {
        try {
            this.encoder.reset();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            log.warn((Object)sm.getString("c2bConverter.decoderResetFail", this.encoder.charset()), throwable);
        }
        this.leftovers.position(0);
    }

    public boolean isUnderflow() {
        return this.leftovers.position() > 0;
    }

    public boolean isUndeflow() {
        return this.isUnderflow();
    }

    public void convert(CharChunk charChunk, ByteChunk byteChunk) throws IOException {
        CoderResult coderResult;
        if (this.bb == null || this.bb.array() != byteChunk.getBuffer()) {
            this.bb = ByteBuffer.wrap(byteChunk.getBuffer(), byteChunk.getEnd(), byteChunk.getBuffer().length - byteChunk.getEnd());
        } else {
            this.bb.limit(byteChunk.getBuffer().length);
            this.bb.position(byteChunk.getEnd());
        }
        if (this.cb == null || this.cb.array() != charChunk.getBuffer()) {
            this.cb = CharBuffer.wrap(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
        } else {
            this.cb.limit(charChunk.getEnd());
            this.cb.position(charChunk.getStart());
        }
        if (this.leftovers.position() > 0) {
            int n = this.bb.position();
            do {
                this.leftovers.put((char)charChunk.subtract());
                this.leftovers.flip();
                coderResult = this.encoder.encode(this.leftovers, this.bb, false);
                this.leftovers.position(this.leftovers.limit());
                this.leftovers.limit(this.leftovers.array().length);
            } while (coderResult.isUnderflow() && this.bb.position() == n);
            if (coderResult.isError() || coderResult.isMalformed()) {
                coderResult.throwException();
            }
            this.cb.position(charChunk.getStart());
            this.leftovers.position(0);
        }
        if ((coderResult = this.encoder.encode(this.cb, this.bb, false)).isError() || coderResult.isMalformed()) {
            coderResult.throwException();
        } else if (coderResult.isOverflow()) {
            byteChunk.setEnd(this.bb.position());
            charChunk.setStart(this.cb.position());
        } else if (coderResult.isUnderflow()) {
            byteChunk.setEnd(this.bb.position());
            charChunk.setStart(this.cb.position());
            if (charChunk.getLength() > 0) {
                this.leftovers.limit(this.leftovers.array().length);
                this.leftovers.position(charChunk.getLength());
                charChunk.subtract(this.leftovers.array(), 0, charChunk.getLength());
            }
        }
    }

    public void convert(CharBuffer charBuffer, ByteBuffer byteBuffer) throws IOException {
        CoderResult coderResult;
        if (this.bb == null || this.bb.array() != byteBuffer.array()) {
            this.bb = ByteBuffer.wrap(byteBuffer.array(), byteBuffer.limit(), byteBuffer.capacity() - byteBuffer.limit());
        } else {
            this.bb.limit(byteBuffer.capacity());
            this.bb.position(byteBuffer.limit());
        }
        if (this.cb == null || this.cb.array() != charBuffer.array()) {
            this.cb = CharBuffer.wrap(charBuffer.array(), charBuffer.arrayOffset() + charBuffer.position(), charBuffer.remaining());
        } else {
            this.cb.limit(charBuffer.limit());
            this.cb.position(charBuffer.position());
        }
        if (this.leftovers.position() > 0) {
            int n = this.bb.position();
            do {
                this.leftovers.put(charBuffer.get());
                this.leftovers.flip();
                coderResult = this.encoder.encode(this.leftovers, this.bb, false);
                this.leftovers.position(this.leftovers.limit());
                this.leftovers.limit(this.leftovers.array().length);
            } while (coderResult.isUnderflow() && this.bb.position() == n);
            if (coderResult.isError() || coderResult.isMalformed()) {
                coderResult.throwException();
            }
            this.cb.position(charBuffer.position());
            this.leftovers.position(0);
        }
        if ((coderResult = this.encoder.encode(this.cb, this.bb, false)).isError() || coderResult.isMalformed()) {
            coderResult.throwException();
        } else if (coderResult.isOverflow()) {
            byteBuffer.limit(this.bb.position());
            charBuffer.position(this.cb.position());
        } else if (coderResult.isUnderflow()) {
            byteBuffer.limit(this.bb.position());
            charBuffer.position(this.cb.position());
            if (charBuffer.remaining() > 0) {
                this.leftovers.limit(this.leftovers.array().length);
                this.leftovers.position(charBuffer.remaining());
                charBuffer.get(this.leftovers.array(), 0, charBuffer.remaining());
            }
        }
    }

    public Charset getCharset() {
        return this.encoder.charset();
    }
}

