/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.descriptor.web.XmlEncodingBase;

public class ErrorPage
extends XmlEncodingBase
implements Serializable {
    private static final long serialVersionUID = 2L;
    private int errorCode = 0;
    private String exceptionType = null;
    private String location = null;

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int n) {
        this.errorCode = n;
    }

    public void setErrorCode(String string) {
        try {
            this.errorCode = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException);
        }
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String string) {
        this.exceptionType = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = UDecoder.URLDecode((String)string, (Charset)this.getCharset());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ErrorPage[");
        if (this.exceptionType == null) {
            stringBuilder.append("errorCode=");
            stringBuilder.append(this.errorCode);
        } else {
            stringBuilder.append("exceptionType=");
            stringBuilder.append(this.exceptionType);
        }
        stringBuilder.append(", location=");
        stringBuilder.append(this.location);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String getName() {
        return Objects.requireNonNullElseGet(this.exceptionType, () -> Integer.toString(this.errorCode));
    }
}

