/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TcclThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public TcclThreadFactory() {
        this("pool-" + poolNumber.getAndIncrement() + "-thread-");
    }

    public TcclThreadFactory(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = string;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        final Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement());
        if (IS_SECURITY_ENABLED) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    thread.setContextClassLoader(this.getClass().getClassLoader());
                    return null;
                }
            });
        } else {
            thread.setContextClassLoader(this.getClass().getClassLoader());
        }
        thread.setDaemon(true);
        return thread;
    }
}

