//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_PRIMVAR_SCHEMA_H
#define PXR_IMAGING_HD_PRIMVAR_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_PRIMVAR_SCHEMA_TOKENS \
    (primvarValue) \
    (indexedPrimvarValue) \
    (indices) \
    (interpolation) \
    (role) \
    (elementSize) \
    (transform) \
    (constant) \
    (uniform) \
    (varying) \
    (vertex) \
    (faceVarying) \
    (instance) \
    (point) \
    (normal) \
    (vector) \
    (color) \
    (pointIndex) \
    (edgeIndex) \
    (faceIndex) \
    (textureCoordinate) \

TF_DECLARE_PUBLIC_TOKENS(HdPrimvarSchemaTokens, HD_API,
    HD_PRIMVAR_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class HdPrimvarSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdPrimvarSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--

    // If the primvar does not have indices, GetPrimvarValue() and
    // GetIndexedPrimvarValue() will return the same thing. If the primvar
    // does has indices, GetPrimvarValue() will return the flattened value,
    // while GetIndexedPrimvarValue() will return the unflattened value.
    HD_API
    HdSampledDataSourceHandle GetPrimvarValue() const;

    HD_API
    HdSampledDataSourceHandle GetIndexedPrimvarValue() const;

    // Returns true if it contains data sources for an indexed primvar value
    // and for indices.
    HD_API
    bool IsIndexed() const;

    // If the primvar does not have indices, GetFlattenedPrimvarValue() will
    // just return the primvarValue data source which is also returned by
    // GetPrimVarValue().
    // If the primvar does have indices, GetFlattenedPrivmarValue() will return
    // the flattened value.
    //
    // Note that GetPrimvarValue actually flattens the primvar even though
    // the name and the grouping under ACCESSORS suggests that it is merely
    // retrieving the primvarValue data source.
    //
    // The behavior of GetPrimvarValue might be conformed to simply return
    // the primvarValue data source. Thus, clients who need the flattening
    // behavior should explicitly call GetFlattenedPrimvarValue.
    //
    HD_API
    HdSampledDataSourceHandle GetFlattenedPrimvarValue() const;

// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HD_API
    HdIntArrayDataSourceHandle GetIndices() const;

    HD_API
    HdTokenDataSourceHandle GetInterpolation() const;

    HD_API
    HdTokenDataSourceHandle GetRole() const;

    /// The number of values in the value array that must be aggregated for
    /// each element on the the primitive (same as UsdGeomPrimvar).
    HD_API
    HdIntDataSourceHandle GetElementSize() const; 

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdSampledDataSourceHandle &primvarValue,
        const HdSampledDataSourceHandle &indexedPrimvarValue,
        const HdIntArrayDataSourceHandle &indices,
        const HdTokenDataSourceHandle &interpolation,
        const HdTokenDataSourceHandle &role,
        const HdIntDataSourceHandle &elementSize
    );

    /// \class HdPrimvarSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetPrimvarValue(
            const HdSampledDataSourceHandle &primvarValue);
        HD_API
        Builder &SetIndexedPrimvarValue(
            const HdSampledDataSourceHandle &indexedPrimvarValue);
        HD_API
        Builder &SetIndices(
            const HdIntArrayDataSourceHandle &indices);
        HD_API
        Builder &SetInterpolation(
            const HdTokenDataSourceHandle &interpolation);
        HD_API
        Builder &SetRole(
            const HdTokenDataSourceHandle &role);
        HD_API
        Builder &SetElementSize(
            const HdIntDataSourceHandle &elementSize);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdSampledDataSourceHandle _primvarValue;
        HdSampledDataSourceHandle _indexedPrimvarValue;
        HdIntArrayDataSourceHandle _indices;
        HdTokenDataSourceHandle _interpolation;
        HdTokenDataSourceHandle _role;
        HdIntDataSourceHandle _elementSize;

    };

    /// Returns token data source for use as interpolation value.
    ///
    /// The following values will be stored statically and reused for future
    /// calls:
    /// - HdPrimvarSchemaTokens->constant
    /// - HdPrimvarSchemaTokens->uniform
    /// - HdPrimvarSchemaTokens->varying
    /// - HdPrimvarSchemaTokens->vertex
    /// - HdPrimvarSchemaTokens->faceVarying
    /// - HdPrimvarSchemaTokens->instance
    HD_API
    static HdTokenDataSourceHandle BuildInterpolationDataSource(
        const TfToken &interpolation);

    /// Returns token data source for use as role value.
    ///
    /// The following values will be stored statically and reused for future
    /// calls:
    /// - HdPrimvarSchemaTokens->point
    /// - HdPrimvarSchemaTokens->normal
    /// - HdPrimvarSchemaTokens->vector
    /// - HdPrimvarSchemaTokens->color
    /// - HdPrimvarSchemaTokens->pointIndex
    /// - HdPrimvarSchemaTokens->edgeIndex
    /// - HdPrimvarSchemaTokens->faceIndex
    /// - HdPrimvarSchemaTokens->textureCoordinate
    HD_API
    static HdTokenDataSourceHandle BuildRoleDataSource(
        const TfToken &role);

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif