
/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * MetricType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_2;

import org.virtualbox_7_2.jaxws.*;
import javax.xml.ws.*;

/**
Metric names
Interface ID: <code>{ADF26EDC-7E32-11EE-B962-0242AC120002}</code>
*/
public enum MetricType
{

/**
Invalid name
*/
    Invalid(0),

/**
Cpu Utilization
*/
    CpuUtilization(1),

/**
Memory Utilization
*/
    MemoryUtilization(2),

/**
Disk Bytes Read
*/
    DiskBytesRead(3),

/**
Disk Bytes Written
*/
    DiskBytesWritten(4),

/**
Networks Bytes In
*/
    NetworksBytesIn(5),

/**
Networks Bytes Out
*/
    NetworksBytesOut(6);

    private final int value;

    MetricType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static MetricType fromValue(long v)
    {
        for (MetricType c: MetricType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static MetricType fromValue(String v)
    {
        return valueOf(MetricType.class, v);
    }
}

