/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceViewsManager;
import org.graalvm.visualvm.core.ui.DataSourceWindow;
import org.graalvm.visualvm.core.ui.DataSourceWindowListener;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class DataSourceWindowManager {
    private static final RequestProcessor processor = new RequestProcessor("DataSourceWindowManager Processor");
    private static final Logger LOGGER = Logger.getLogger(DataSourceWindowManager.class.getName());
    private static DataSourceWindowManager sharedInstance;
    private final Map<DataSource, List<DataSourceWindowListener>> windowListeners = new WeakHashMap<DataSource, List<DataSourceWindowListener>>();
    private final Map<DataSource, DataSourceWindow> openedWindows = Collections.synchronizedMap(new HashMap());
    private final Map<DataSource, Set<DataSourceView>> openedViews = Collections.synchronizedMap(new HashMap());
    private final Runnable closingHandler = new Runnable(){

        @Override
        public void run() {
            Collection allViews = DataSourceWindowManager.this.openedViews.values();
            for (Set dataSourceViews : allViews) {
                for (DataSourceView view : dataSourceViews) {
                    view.viewWillBeRemoved();
                }
            }
        }
    };
    private boolean reloadingView;

    public static synchronized DataSourceWindowManager sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new DataSourceWindowManager();
        }
        return sharedInstance;
    }

    public boolean canOpenDataSource(DataSource dataSource) {
        return DataSourceViewsManager.sharedInstance().hasViewsFor(dataSource);
    }

    public void openDataSource(DataSource dataSource) {
        this.openDataSource(dataSource, true);
    }

    public void openDataSource(final DataSource dataSource, final boolean selectView) {
        processor.post(new Runnable(){

            @Override
            public void run() {
                DataSourceWindowManager.this.openDataSource(dataSource, selectView, 0);
            }
        });
    }

    public void openDataSource(final DataSource dataSource, final boolean selectView, final int viewIndex) {
        processor.post(new Runnable(){

            @Override
            public void run() {
                DataSourceWindowManager.this.openWindowAndAddView(dataSource, null, viewIndex, selectView, selectView, selectView);
            }
        });
    }

    public boolean isDataSourceOpened(DataSource dataSource) {
        return this.openedWindows.get(dataSource) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D extends DataSource> void addWindowListener(D dataSource, DataSourceWindowListener<D> listener) {
        Map<DataSource, List<DataSourceWindowListener>> map = this.windowListeners;
        synchronized (map) {
            List<DataSourceWindowListener> listeners = this.windowListeners.get(dataSource);
            if (listeners == null) {
                listeners = new ArrayList<DataSourceWindowListener>();
                this.windowListeners.put(dataSource, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D extends DataSource> void removeWindowListener(D dataSource, DataSourceWindowListener<D> listener) {
        Map<DataSource, List<DataSourceWindowListener>> map = this.windowListeners;
        synchronized (map) {
            List<DataSourceWindowListener> listeners = this.windowListeners.get(dataSource);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D extends DataSource> void notifyWindowOpened(D dataSource) {
        Map<DataSource, List<DataSourceWindowListener>> map = this.windowListeners;
        synchronized (map) {
            List<DataSourceWindowListener> listeners = this.windowListeners.get(dataSource);
            if (listeners != null) {
                for (DataSourceWindowListener listener : new ArrayList<DataSourceWindowListener>(listeners)) {
                    listener.windowOpened(dataSource);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D extends DataSource> void notifyWindowClosed(D dataSource) {
        Map<DataSource, List<DataSourceWindowListener>> map = this.windowListeners;
        synchronized (map) {
            List<DataSourceWindowListener> listeners = this.windowListeners.get(dataSource);
            if (listeners != null) {
                for (DataSourceWindowListener listener : new ArrayList<DataSourceWindowListener>(listeners)) {
                    listener.windowClosed(dataSource);
                }
            }
        }
    }

    public void closeDataSource(final DataSource dataSource) {
        processor.post(new Runnable(){

            @Override
            public void run() {
                DataSource viewMaster = DataSourceWindowManager.getViewMaster(dataSource);
                final DataSourceWindow window = (DataSourceWindow)DataSourceWindowManager.this.openedWindows.get(viewMaster);
                if (window == null) {
                    return;
                }
                if (dataSource == viewMaster) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            window.removeAllViews();
                        }
                    });
                } else {
                    Set views = (Set)DataSourceWindowManager.this.openedViews.get(dataSource);
                    if (views != null) {
                        final HashSet viewsF = new HashSet(views);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (DataSourceView view : viewsF) {
                                    if (!window.containsView(view)) continue;
                                    window.removeView(view);
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    public void selectView(final DataSourceView view) {
        processor.post(new Runnable(){

            @Override
            public void run() {
                DataSourceWindowManager.this.openWindowAndAddView(view.getDataSource(), view, 0, true, true, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openWindowAndAddView(final DataSource dataSource, DataSourceView view, int viewIndex, boolean selectView, final boolean selectWindow, final boolean windowToFront) {
        final DataSource viewMaster = DataSourceWindowManager.getViewMaster(dataSource);
        final DataSourceWindow[] window = new DataSourceWindow[]{this.openedWindows.get(viewMaster)};
        final boolean wasOpened = window[0] != null;
        ProgressHandle pHandle = !wasOpened || this.reloadingView ? ProgressHandle.createHandle((String)NbBundle.getMessage(DataSourceWindowManager.class, (String)"LBL_Opening", (Object)DataSourceDescriptorFactory.getDescriptor(dataSource).getName())) : null;
        try {
            List<? extends DataSourceView> views;
            if (!wasOpened || this.reloadingView) {
                pHandle.setInitialDelay(0);
                pHandle.start();
                if (!this.reloadingView) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                window[0] = new DataSourceWindow(viewMaster);
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.severe("Failed to create window for " + dataSource);
                    }
                    this.openedWindows.put(viewMaster, window[0]);
                } else {
                    this.reloadingView = false;
                }
                views = DataSourceViewsManager.sharedInstance().getViews(viewMaster);
                this.addViews(window[0], views);
            }
            if (dataSource != viewMaster) {
                views = DataSourceViewsManager.sharedInstance().getViews(dataSource);
                this.addViews(window[0], views);
                if (selectView && view == null && viewIndex >= 0) {
                    if (viewIndex >= views.size()) {
                        viewIndex = -1;
                    }
                    if (viewIndex != -1) {
                        view = views.get(viewIndex);
                    }
                }
            }
            if (selectView && view == null && viewIndex > 0) {
                views = window[0].getViews();
                if (viewIndex >= views.size()) {
                    viewIndex = -1;
                }
                if (viewIndex != -1) {
                    view = views.get(viewIndex);
                }
            }
            final DataSourceView viewToSelectF = selectView ? view : null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (viewToSelectF != null) {
                        if (window[0].containsView(viewToSelectF)) {
                            window[0].selectView(viewToSelectF);
                        } else if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.warning("Tried to select not opened view " + viewToSelectF);
                        }
                    }
                    if (!wasOpened) {
                        window[0].open();
                    }
                    if (selectWindow) {
                        window[0].requestActive();
                    }
                    if (windowToFront) {
                        window[0].toFront();
                    }
                    if (!wasOpened) {
                        DataSourceWindowManager.this.notifyWindowOpened(dataSource);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(pHandle){
                final /* synthetic */ ProgressHandle val$pHandle;
                {
                    this.val$pHandle = progressHandle;
                }

                @Override
                public void run() {
                    if (this.val$pHandle != null) {
                        this.val$pHandle.finish();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    static DataSource getViewMaster(DataSource dataSource) {
        DataSource master = dataSource.getMaster();
        while (master != null && master != DataSource.ROOT) {
            dataSource = master;
            master = dataSource.getMaster();
        }
        return dataSource;
    }

    private <X extends DataSourceView> void addViews(final DataSourceWindow window, List<X> views) {
        final ArrayList<DataSourceView> newViews = new ArrayList<DataSourceView>();
        for (DataSourceView view : views) {
            if (window.containsView(view)) continue;
            newViews.add(view);
        }
        for (DataSourceView view : newViews) {
            try {
                DataSource dataSource = view.getDataSource();
                Set<DataSourceView> cachedViews = this.openedViews.get(dataSource);
                if (cachedViews == null) {
                    cachedViews = new HashSet<DataSourceView>();
                    this.openedViews.put(dataSource, cachedViews);
                }
                cachedViews.add(view);
                view.viewWillBeAdded();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to pre-initialize view " + view, e);
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    for (DataSourceView view : newViews) {
                        try {
                            window.addView(view);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, "Failed to initialize view " + view, e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize views for " + window.getDataSource(), e);
        }
        for (DataSourceView view : newViews) {
            try {
                view.viewAdded();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to post-initialize view " + view, e);
            }
        }
    }

    void reopenDataSource(final DataSource dataSource) {
        processor.post(new Runnable(){

            @Override
            public void run() {
                DataSourceWindow window;
                DataSource viewMaster = DataSourceWindowManager.getViewMaster(dataSource);
                DataSourceWindow dataSourceWindow = window = viewMaster == null ? null : (DataSourceWindow)DataSourceWindowManager.this.openedWindows.get(viewMaster);
                if (window == null) {
                    return;
                }
                Set _views = (Set)DataSourceWindowManager.this.openedViews.get(dataSource);
                if (_views == null) {
                    return;
                }
                final HashMap<String, DataSourceView> oldViews = new HashMap<String, DataSourceView>();
                for (DataSourceView view : _views) {
                    oldViews.put(view.getName(), view);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final Set opened = (Set)DataSourceWindowManager.this.openedViews.get(dataSource);
                        for (DataSourceView view : oldViews.values()) {
                            window.clearView(view, processor);
                            opened.remove(view);
                        }
                        processor.post(new Runnable(){

                            @Override
                            public void run() {
                                final List<? extends DataSourceView> newViews = DataSourceViewsManager.sharedInstance().getViews(dataSource);
                                for (DataSourceView dataSourceView : newViews) {
                                    opened.add(dataSourceView);
                                    try {
                                        dataSourceView.viewWillBeAdded();
                                    }
                                    catch (Exception e) {
                                        LOGGER.log(Level.SEVERE, "Failed to pre-initialize view " + dataSourceView, e);
                                    }
                                    oldViews.remove(dataSourceView.getName());
                                }
                                if (opened.isEmpty()) {
                                    DataSourceWindowManager.this.openedViews.remove(dataSource);
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (DataSourceView view : oldViews.values()) {
                                            window.closeUnregisteredView(view);
                                        }
                                        for (int i = 0; i < newViews.size(); ++i) {
                                            window.updateView((DataSourceView)newViews.get(i), i);
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    void unregisterClosedWindow(DataSourceWindow window) {
        DataSource dataSource = window.getDataSource();
        this.openedWindows.remove(dataSource);
        this.notifyWindowClosed(dataSource);
    }

    void unregisterClosedView(DataSourceView view) {
        DataSource dataSource = view.getDataSource();
        Set<DataSourceView> views = this.openedViews.get(dataSource);
        if (views != null) {
            views.remove(view);
            if (views.isEmpty()) {
                this.openedViews.remove(dataSource);
            }
        } else if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("Tried to unregister not opened view " + view);
        }
    }

    private DataSourceWindowManager() {
        VisualVM.getInstance().notifyWhenClosing(this.closingHandler);
    }
}

