/* DisplayManager.h - Menu suppor class to 
   the Display menu functions for the 
   Macintosh OS X SDL port of Atari800
   Mark Grebe <atarimac@cox.net>
   
   Based on the Preferences pane of the
   TextEdit application.

*/
#import <Cocoa/Cocoa.h>

@interface DisplayManager : NSObject
{
    IBOutlet id doubleSizeItem;
    IBOutlet id fullscreenItem;
    IBOutlet id widthModeItem;
    IBOutlet id displayFpsItem;
    IBOutlet id grabMouseItem;
}
+ (DisplayManager *)sharedInstance;
- (void)setDoublesizeMenu:(int)doubleSize;
- (void)setWidthmodeMenu:(int)widthMode;
- (void)setGrabmouseMenu:(int)mouseOn;
- (void)setFpsMenu:(int)fpsOn;
- (IBAction)doubleSize:(id)sender;
- (IBAction)fullScreen:(id)sender;
- (IBAction)grabMouse:(id)sender;
- (IBAction)displayFps:(id)sender;
- (IBAction)interlacedScreenshot:(id)sender;
- (IBAction)screenshot:(id)sender;
- (IBAction)widthMode:(id)sender;
@end
