/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-22 20:09
 */
 
#ifndef PIECEREQUEST_H_
#define PIECEREQUEST_H_

#include <string>
#include <list>

typedef struct
{
	unsigned int offset;
	unsigned int length;
	bool requested;
	std::string data;
} TRequest;
typedef std::list<TRequest> TRequestList;

class CPieceRequest
{
public:
	CPieceRequest();
	virtual ~CPieceRequest();
private:
	unsigned int _pieceIndex;		
	unsigned int _pieceLength;
	TRequestList _requestList;
public:
	void alloc(unsigned int pieceIndex, unsigned int pieceLength, unsigned int maxRequestLength);
	unsigned int getPieceIndex();
	unsigned int getPieceLength();
	unsigned int getPendingCount();
	bool cancelPendingRequest(unsigned int& pieceIndex, unsigned int& offset, unsigned int& length);
	bool complete();
	std::string getPiece();
	bool getRequest(unsigned int& pieceIndex, unsigned int& offset, unsigned int& length);		
	bool addPieceData(unsigned int offset, const char* data, size_t length);
	void clearRequest();
};

#endif /*PIECEREQUEST_H_*/
