/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2014-2025 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_template_db_tbl.h"

/* Define the template match patterns */
/*
 * List of protocol matches
 */
struct bnxt_ulp_class_match_info ulp_class_match_list[] = {
	[1] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB800000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		},
	},
	[2] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[3] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[4] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA40000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[5] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA78000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		},
	},
	[6] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA36000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		},
	},
	[7] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[8] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[9] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[10] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[11] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49E00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 11,
		[55] = 12,
		[57] = 13,
		[59] = 14,
		[61] = 15,
		[63] = 16,
		[65] = 17,
		[67] = 18,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[12] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48D80000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 11,
		[35] = 12,
		[37] = 13,
		[39] = 14,
		[41] = 15,
		[43] = 16,
		[45] = 17,
		[47] = 18,
		[49] = 19,
		[51] = 20,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[13] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[85] = 5,
		[87] = 6,
		[89] = 7,
		[91] = 8,
		[93] = 9,
		[95] = 10,
		[97] = 11,
		[99] = 12,
		[101] = 13,
		},
	},
	[14] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[103] = 5,
		[105] = 6,
		[107] = 7,
		[109] = 8,
		},
	},
	[15] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[85] = 8,
		[87] = 9,
		[89] = 10,
		[91] = 11,
		[93] = 12,
		[95] = 13,
		[97] = 14,
		[99] = 15,
		[101] = 16,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[16] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[103] = 8,
		[105] = 9,
		[107] = 10,
		[109] = 11,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[17] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[85] = 8,
		[87] = 9,
		[89] = 10,
		[91] = 11,
		[93] = 12,
		[95] = 13,
		[97] = 14,
		[99] = 15,
		[101] = 16,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[18] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[103] = 8,
		[105] = 9,
		[107] = 10,
		[109] = 11,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[19] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[85] = 11,
		[87] = 12,
		[89] = 13,
		[91] = 14,
		[93] = 15,
		[95] = 16,
		[97] = 17,
		[99] = 18,
		[101] = 19,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[20] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[103] = 11,
		[105] = 12,
		[107] = 13,
		[109] = 14,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[21] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[85] = 13,
		[87] = 14,
		[89] = 15,
		[91] = 16,
		[93] = 17,
		[95] = 18,
		[97] = 19,
		[99] = 20,
		[101] = 21,
		},
	},
	[22] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[85] = 15,
		[87] = 16,
		[89] = 17,
		[91] = 18,
		[93] = 19,
		[95] = 20,
		[97] = 21,
		[99] = 22,
		[101] = 23,
		},
	},
	[23] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		},
	},
	[24] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		},
	},
	[25] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[85] = 16,
		[87] = 17,
		[89] = 18,
		[91] = 19,
		[93] = 20,
		[95] = 21,
		[97] = 22,
		[99] = 23,
		[101] = 24,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[26] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[85] = 18,
		[87] = 19,
		[89] = 20,
		[91] = 21,
		[93] = 22,
		[95] = 23,
		[97] = 24,
		[99] = 25,
		[101] = 26,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[27] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[103] = 16,
		[105] = 17,
		[107] = 18,
		[109] = 19,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[28] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[103] = 18,
		[105] = 19,
		[107] = 20,
		[109] = 21,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[29] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[85] = 16,
		[87] = 17,
		[89] = 18,
		[91] = 19,
		[93] = 20,
		[95] = 21,
		[97] = 22,
		[99] = 23,
		[101] = 24,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[30] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[85] = 18,
		[87] = 19,
		[89] = 20,
		[91] = 21,
		[93] = 22,
		[95] = 23,
		[97] = 24,
		[99] = 25,
		[101] = 26,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[31] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[103] = 16,
		[105] = 17,
		[107] = 18,
		[109] = 19,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[32] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[103] = 18,
		[105] = 19,
		[107] = 20,
		[109] = 21,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[33] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 11,
		[55] = 12,
		[57] = 13,
		[59] = 14,
		[61] = 15,
		[63] = 16,
		[65] = 17,
		[67] = 18,
		[85] = 19,
		[87] = 20,
		[89] = 21,
		[91] = 22,
		[93] = 23,
		[95] = 24,
		[97] = 25,
		[99] = 26,
		[101] = 27,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[34] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 11,
		[35] = 12,
		[37] = 13,
		[39] = 14,
		[41] = 15,
		[43] = 16,
		[45] = 17,
		[47] = 18,
		[49] = 19,
		[51] = 20,
		[85] = 21,
		[87] = 22,
		[89] = 23,
		[91] = 24,
		[93] = 25,
		[95] = 26,
		[97] = 27,
		[99] = 28,
		[101] = 29,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[35] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 11,
		[55] = 12,
		[57] = 13,
		[59] = 14,
		[61] = 15,
		[63] = 16,
		[65] = 17,
		[67] = 18,
		[103] = 19,
		[105] = 20,
		[107] = 21,
		[109] = 22,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[36] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 11,
		[35] = 12,
		[37] = 13,
		[39] = 14,
		[41] = 15,
		[43] = 16,
		[45] = 17,
		[47] = 18,
		[49] = 19,
		[51] = 20,
		[103] = 21,
		[105] = 22,
		[107] = 23,
		[109] = 24,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[37] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A100000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[38] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006840000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[39] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[40] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[41] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105800000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 21,
		[55] = 6,
		[56] = 22,
		[57] = 7,
		[58] = 23,
		[59] = 8,
		[60] = 24,
		[61] = 9,
		[62] = 25,
		[63] = 10,
		[64] = 26,
		[65] = 11,
		[66] = 27,
		[67] = 12,
		[68] = 28,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[42] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841600000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[43] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101600000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[44] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006840580000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[34] = 23,
		[35] = 6,
		[36] = 24,
		[37] = 7,
		[38] = 25,
		[39] = 8,
		[40] = 26,
		[41] = 9,
		[42] = 27,
		[43] = 10,
		[44] = 28,
		[45] = 11,
		[46] = 29,
		[47] = 12,
		[48] = 30,
		[49] = 13,
		[50] = 31,
		[51] = 14,
		[52] = 32,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[45] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170B00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[54] = 24,
		[55] = 6,
		[56] = 25,
		[57] = 7,
		[58] = 26,
		[59] = 8,
		[60] = 27,
		[61] = 9,
		[62] = 28,
		[63] = 10,
		[64] = 29,
		[65] = 11,
		[66] = 30,
		[67] = 12,
		[68] = 31,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[46] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2C0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 26,
		[56] = 27,
		[58] = 28,
		[60] = 29,
		[62] = 30,
		[64] = 31,
		[66] = 32,
		[68] = 33,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[47] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702C0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[34] = 24,
		[36] = 25,
		[38] = 26,
		[40] = 27,
		[42] = 28,
		[44] = 29,
		[46] = 30,
		[48] = 31,
		[50] = 32,
		[52] = 33,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[48] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0B0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[34] = 26,
		[35] = 6,
		[36] = 27,
		[37] = 7,
		[38] = 28,
		[39] = 8,
		[40] = 29,
		[41] = 9,
		[42] = 30,
		[43] = 10,
		[44] = 31,
		[45] = 11,
		[46] = 32,
		[47] = 12,
		[48] = 33,
		[49] = 13,
		[50] = 34,
		[51] = 14,
		[52] = 35,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[49] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A160000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 21,
		[88] = 22,
		[90] = 23,
		[92] = 24,
		[94] = 25,
		[96] = 26,
		[98] = 27,
		[100] = 28,
		[102] = 29,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[50] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006858000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[86] = 23,
		[88] = 24,
		[90] = 25,
		[92] = 26,
		[94] = 27,
		[96] = 28,
		[98] = 29,
		[100] = 30,
		[102] = 31,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[51] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A160000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[104] = 21,
		[105] = 14,
		[106] = 22,
		[107] = 15,
		[108] = 23,
		[109] = 16,
		[110] = 24,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[52] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006858000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[104] = 23,
		[105] = 16,
		[106] = 24,
		[107] = 17,
		[108] = 25,
		[109] = 18,
		[110] = 26,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[53] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 24,
		[88] = 25,
		[90] = 26,
		[92] = 27,
		[94] = 28,
		[96] = 29,
		[98] = 30,
		[100] = 31,
		[102] = 32,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[54] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[86] = 26,
		[88] = 27,
		[90] = 28,
		[92] = 29,
		[94] = 30,
		[96] = 31,
		[98] = 32,
		[100] = 33,
		[102] = 34,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[55] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[104] = 24,
		[105] = 14,
		[106] = 25,
		[107] = 15,
		[108] = 26,
		[109] = 16,
		[110] = 27,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[56] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[104] = 26,
		[105] = 16,
		[106] = 27,
		[107] = 17,
		[108] = 28,
		[109] = 18,
		[110] = 29,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[57] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105E00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 21,
		[55] = 6,
		[56] = 22,
		[57] = 7,
		[58] = 23,
		[59] = 8,
		[60] = 24,
		[61] = 9,
		[62] = 25,
		[63] = 10,
		[64] = 26,
		[65] = 11,
		[66] = 27,
		[67] = 12,
		[68] = 28,
		[86] = 29,
		[88] = 30,
		[90] = 31,
		[92] = 32,
		[94] = 33,
		[96] = 34,
		[98] = 35,
		[100] = 36,
		[102] = 37,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[58] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841780000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[86] = 31,
		[88] = 32,
		[90] = 33,
		[92] = 34,
		[94] = 35,
		[96] = 36,
		[98] = 37,
		[100] = 38,
		[102] = 39,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[59] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101780000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 31,
		[88] = 32,
		[90] = 33,
		[92] = 34,
		[94] = 35,
		[96] = 36,
		[98] = 37,
		[100] = 38,
		[102] = 39,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[60] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB0068405E0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[34] = 23,
		[35] = 6,
		[36] = 24,
		[37] = 7,
		[38] = 25,
		[39] = 8,
		[40] = 26,
		[41] = 9,
		[42] = 27,
		[43] = 10,
		[44] = 28,
		[45] = 11,
		[46] = 29,
		[47] = 12,
		[48] = 30,
		[49] = 13,
		[50] = 31,
		[51] = 14,
		[52] = 32,
		[86] = 33,
		[88] = 34,
		[90] = 35,
		[92] = 36,
		[94] = 37,
		[96] = 38,
		[98] = 39,
		[100] = 40,
		[102] = 41,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[61] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105E00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 21,
		[55] = 6,
		[56] = 22,
		[57] = 7,
		[58] = 23,
		[59] = 8,
		[60] = 24,
		[61] = 9,
		[62] = 25,
		[63] = 10,
		[64] = 26,
		[65] = 11,
		[66] = 27,
		[67] = 12,
		[68] = 28,
		[103] = 13,
		[104] = 29,
		[105] = 14,
		[106] = 30,
		[107] = 15,
		[108] = 31,
		[109] = 16,
		[110] = 32,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[62] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841780000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[103] = 15,
		[104] = 31,
		[105] = 16,
		[106] = 32,
		[107] = 17,
		[108] = 33,
		[109] = 18,
		[110] = 34,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[63] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101780000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[104] = 31,
		[105] = 14,
		[106] = 32,
		[107] = 15,
		[108] = 33,
		[109] = 16,
		[110] = 34,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[64] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB0068405E0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[34] = 23,
		[35] = 6,
		[36] = 24,
		[37] = 7,
		[38] = 25,
		[39] = 8,
		[40] = 26,
		[41] = 9,
		[42] = 27,
		[43] = 10,
		[44] = 28,
		[45] = 11,
		[46] = 29,
		[47] = 12,
		[48] = 30,
		[49] = 13,
		[50] = 31,
		[51] = 14,
		[52] = 32,
		[103] = 15,
		[104] = 33,
		[105] = 16,
		[106] = 34,
		[107] = 17,
		[108] = 35,
		[109] = 18,
		[110] = 36,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[65] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[54] = 24,
		[55] = 6,
		[56] = 25,
		[57] = 7,
		[58] = 26,
		[59] = 8,
		[60] = 27,
		[61] = 9,
		[62] = 28,
		[63] = 10,
		[64] = 29,
		[65] = 11,
		[66] = 30,
		[67] = 12,
		[68] = 31,
		[86] = 32,
		[88] = 33,
		[90] = 34,
		[92] = 35,
		[94] = 36,
		[96] = 37,
		[98] = 38,
		[100] = 39,
		[102] = 40,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[66] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 26,
		[56] = 27,
		[58] = 28,
		[60] = 29,
		[62] = 30,
		[64] = 31,
		[66] = 32,
		[68] = 33,
		[86] = 34,
		[88] = 35,
		[90] = 36,
		[92] = 37,
		[94] = 38,
		[96] = 39,
		[98] = 40,
		[100] = 41,
		[102] = 42,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[67] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[34] = 24,
		[36] = 25,
		[38] = 26,
		[40] = 27,
		[42] = 28,
		[44] = 29,
		[46] = 30,
		[48] = 31,
		[50] = 32,
		[52] = 33,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 34,
		[88] = 35,
		[90] = 36,
		[92] = 37,
		[94] = 38,
		[96] = 39,
		[98] = 40,
		[100] = 41,
		[102] = 42,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[68] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[34] = 26,
		[35] = 6,
		[36] = 27,
		[37] = 7,
		[38] = 28,
		[39] = 8,
		[40] = 29,
		[41] = 9,
		[42] = 30,
		[43] = 10,
		[44] = 31,
		[45] = 11,
		[46] = 32,
		[47] = 12,
		[48] = 33,
		[49] = 13,
		[50] = 34,
		[51] = 14,
		[52] = 35,
		[86] = 36,
		[88] = 37,
		[90] = 38,
		[92] = 39,
		[94] = 40,
		[96] = 41,
		[98] = 42,
		[100] = 43,
		[102] = 44,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[69] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[54] = 24,
		[55] = 6,
		[56] = 25,
		[57] = 7,
		[58] = 26,
		[59] = 8,
		[60] = 27,
		[61] = 9,
		[62] = 28,
		[63] = 10,
		[64] = 29,
		[65] = 11,
		[66] = 30,
		[67] = 12,
		[68] = 31,
		[103] = 13,
		[104] = 32,
		[105] = 14,
		[106] = 33,
		[107] = 15,
		[108] = 34,
		[109] = 16,
		[110] = 35,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[70] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 26,
		[56] = 27,
		[58] = 28,
		[60] = 29,
		[62] = 30,
		[64] = 31,
		[66] = 32,
		[68] = 33,
		[103] = 15,
		[104] = 34,
		[105] = 16,
		[106] = 35,
		[107] = 17,
		[108] = 36,
		[109] = 18,
		[110] = 37,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[71] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[34] = 24,
		[36] = 25,
		[38] = 26,
		[40] = 27,
		[42] = 28,
		[44] = 29,
		[46] = 30,
		[48] = 31,
		[50] = 32,
		[52] = 33,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[104] = 34,
		[105] = 14,
		[106] = 35,
		[107] = 15,
		[108] = 36,
		[109] = 16,
		[110] = 37,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[72] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[34] = 26,
		[35] = 6,
		[36] = 27,
		[37] = 7,
		[38] = 28,
		[39] = 8,
		[40] = 29,
		[41] = 9,
		[42] = 30,
		[43] = 10,
		[44] = 31,
		[45] = 11,
		[46] = 32,
		[47] = 12,
		[48] = 33,
		[49] = 13,
		[50] = 34,
		[51] = 14,
		[52] = 35,
		[103] = 15,
		[104] = 36,
		[105] = 16,
		[106] = 37,
		[107] = 17,
		[108] = 38,
		[109] = 18,
		[110] = 39,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[73] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_T_MPLS |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBC16000000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[54] = 7,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[69] = 5,
		[70] = 6,
		},
	},
	[74] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_T_MPLS |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBC05800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 7,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[69] = 5,
		[70] = 6,
		},
	},
	[75] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_T_MPLS |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBC17800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[54] = 7,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[69] = 5,
		[70] = 6,
		[86] = 15,
		[88] = 16,
		[90] = 17,
		[92] = 18,
		[94] = 19,
		[96] = 20,
		[98] = 21,
		[100] = 22,
		[102] = 23,
		},
	},
	[76] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_T_MPLS |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBC05E00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 7,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[69] = 5,
		[70] = 6,
		[86] = 17,
		[88] = 18,
		[90] = 19,
		[92] = 20,
		[94] = 21,
		[96] = 22,
		[98] = 23,
		[100] = 24,
		[102] = 25,
		},
	},
	[77] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_T_MPLS |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBC17800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[54] = 7,
		[56] = 8,
		[58] = 9,
		[60] = 10,
		[62] = 11,
		[64] = 12,
		[66] = 13,
		[68] = 14,
		[69] = 5,
		[70] = 6,
		[104] = 15,
		[106] = 16,
		[108] = 17,
		[110] = 18,
		},
	},
	[78] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_T_MPLS |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBC05E00000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 7,
		[36] = 8,
		[38] = 9,
		[40] = 10,
		[42] = 11,
		[44] = 12,
		[46] = 13,
		[48] = 14,
		[50] = 15,
		[52] = 16,
		[69] = 5,
		[70] = 6,
		[104] = 17,
		[106] = 18,
		[108] = 19,
		[110] = 20,
		},
	},
	[79] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x200A000000000000,
	.field_opt_bitmap = 0x9000000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[80] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x2002800000000000,
	.field_opt_bitmap = 0x9000000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 3,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[81] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301800000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[53] = 2,
		[54] = 21,
		[55] = 3,
		[56] = 22,
		[57] = 4,
		[58] = 23,
		[59] = 5,
		[60] = 24,
		[61] = 6,
		[62] = 25,
		[63] = 7,
		[64] = 26,
		[65] = 8,
		[66] = 27,
		[67] = 9,
		[68] = 28,
		[103] = 10,
		[105] = 11,
		[107] = 12,
		[109] = 13,
		[123] = 14,
		[124] = 15,
		[125] = 16,
		[126] = 17,
		},
	},
	[82] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[33] = 2,
		[35] = 3,
		[37] = 4,
		[39] = 5,
		[41] = 6,
		[43] = 7,
		[45] = 8,
		[47] = 9,
		[49] = 10,
		[51] = 11,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[103] = 12,
		[105] = 13,
		[107] = 14,
		[109] = 15,
		[123] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		},
	},
	[83] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 2,
		[55] = 3,
		[57] = 4,
		[59] = 5,
		[61] = 6,
		[63] = 7,
		[65] = 8,
		[67] = 9,
		[103] = 10,
		[105] = 11,
		[107] = 12,
		[109] = 13,
		[123] = 14,
		[124] = 15,
		[125] = 16,
		[126] = 17,
		},
	},
	[84] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0180000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[33] = 2,
		[34] = 23,
		[35] = 3,
		[36] = 24,
		[37] = 4,
		[38] = 25,
		[39] = 5,
		[40] = 26,
		[41] = 6,
		[42] = 27,
		[43] = 7,
		[44] = 28,
		[45] = 8,
		[46] = 29,
		[47] = 9,
		[48] = 30,
		[49] = 10,
		[50] = 31,
		[51] = 11,
		[52] = 32,
		[103] = 12,
		[105] = 13,
		[107] = 14,
		[109] = 15,
		[123] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		},
	},
	[85] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[53] = 2,
		[54] = 21,
		[55] = 3,
		[56] = 22,
		[57] = 4,
		[58] = 23,
		[59] = 5,
		[60] = 24,
		[61] = 6,
		[62] = 25,
		[63] = 7,
		[64] = 26,
		[65] = 8,
		[66] = 27,
		[67] = 9,
		[68] = 28,
		[86] = 29,
		[88] = 30,
		[90] = 31,
		[92] = 32,
		[94] = 33,
		[96] = 34,
		[98] = 35,
		[100] = 36,
		[102] = 37,
		[103] = 10,
		[105] = 11,
		[107] = 12,
		[109] = 13,
		[123] = 14,
		[124] = 15,
		[125] = 16,
		[126] = 17,
		},
	},
	[86] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[33] = 2,
		[35] = 3,
		[37] = 4,
		[39] = 5,
		[41] = 6,
		[43] = 7,
		[45] = 8,
		[47] = 9,
		[49] = 10,
		[51] = 11,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[86] = 31,
		[88] = 32,
		[90] = 33,
		[92] = 34,
		[94] = 35,
		[96] = 36,
		[98] = 37,
		[100] = 38,
		[102] = 39,
		[103] = 12,
		[105] = 13,
		[107] = 14,
		[109] = 15,
		[123] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		},
	},
	[87] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 2,
		[55] = 3,
		[57] = 4,
		[59] = 5,
		[61] = 6,
		[63] = 7,
		[65] = 8,
		[67] = 9,
		[86] = 31,
		[88] = 32,
		[90] = 33,
		[92] = 34,
		[94] = 35,
		[96] = 36,
		[98] = 37,
		[100] = 38,
		[102] = 39,
		[103] = 10,
		[105] = 11,
		[107] = 12,
		[109] = 13,
		[123] = 14,
		[124] = 15,
		[125] = 16,
		[126] = 17,
		},
	},
	[88] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C01E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[33] = 2,
		[34] = 23,
		[35] = 3,
		[36] = 24,
		[37] = 4,
		[38] = 25,
		[39] = 5,
		[40] = 26,
		[41] = 6,
		[42] = 27,
		[43] = 7,
		[44] = 28,
		[45] = 8,
		[46] = 29,
		[47] = 9,
		[48] = 30,
		[49] = 10,
		[50] = 31,
		[51] = 11,
		[52] = 32,
		[86] = 33,
		[88] = 34,
		[90] = 35,
		[92] = 36,
		[94] = 37,
		[96] = 38,
		[98] = 39,
		[100] = 40,
		[102] = 41,
		[103] = 12,
		[105] = 13,
		[107] = 14,
		[109] = 15,
		[123] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		},
	},
	[89] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010301E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[53] = 2,
		[54] = 21,
		[55] = 3,
		[56] = 22,
		[57] = 4,
		[58] = 23,
		[59] = 5,
		[60] = 24,
		[61] = 6,
		[62] = 25,
		[63] = 7,
		[64] = 26,
		[65] = 8,
		[66] = 27,
		[67] = 9,
		[68] = 28,
		[103] = 10,
		[104] = 29,
		[105] = 11,
		[106] = 30,
		[107] = 12,
		[108] = 31,
		[109] = 13,
		[110] = 32,
		[123] = 14,
		[124] = 15,
		[125] = 16,
		[126] = 17,
		},
	},
	[90] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[33] = 2,
		[35] = 3,
		[37] = 4,
		[39] = 5,
		[41] = 6,
		[43] = 7,
		[45] = 8,
		[47] = 9,
		[49] = 10,
		[51] = 11,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[103] = 12,
		[104] = 31,
		[105] = 13,
		[106] = 32,
		[107] = 14,
		[108] = 33,
		[109] = 15,
		[110] = 34,
		[123] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		},
	},
	[91] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 2,
		[55] = 3,
		[57] = 4,
		[59] = 5,
		[61] = 6,
		[63] = 7,
		[65] = 8,
		[67] = 9,
		[103] = 10,
		[104] = 31,
		[105] = 11,
		[106] = 32,
		[107] = 12,
		[108] = 33,
		[109] = 13,
		[110] = 34,
		[123] = 14,
		[124] = 15,
		[125] = 16,
		[126] = 17,
		},
	},
	[92] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C01E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 4,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[33] = 2,
		[34] = 23,
		[35] = 3,
		[36] = 24,
		[37] = 4,
		[38] = 25,
		[39] = 5,
		[40] = 26,
		[41] = 6,
		[42] = 27,
		[43] = 7,
		[44] = 28,
		[45] = 8,
		[46] = 29,
		[47] = 9,
		[48] = 30,
		[49] = 10,
		[50] = 31,
		[51] = 11,
		[52] = 32,
		[103] = 12,
		[104] = 33,
		[105] = 13,
		[106] = 34,
		[107] = 14,
		[108] = 35,
		[109] = 15,
		[110] = 36,
		[123] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		},
	},
	[93] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_ICMP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xC0800000000000,
	.field_opt_bitmap = 0x8010300600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 5,
	.field_list = {
		[1] = 1,
		[7] = 18,
		[9] = 19,
		[11] = 20,
		[24] = 31,
		[26] = 32,
		[28] = 33,
		[30] = 34,
		[32] = 35,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 2,
		[55] = 3,
		[57] = 4,
		[59] = 5,
		[61] = 6,
		[63] = 7,
		[65] = 8,
		[67] = 9,
		[103] = 10,
		[105] = 11,
		[107] = 12,
		[109] = 13,
		[123] = 14,
		[124] = 15,
		[125] = 16,
		[126] = 17,
		},
	},
	[94] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_F2 |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_ICMP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x30200000000000,
	.field_opt_bitmap = 0x80040C0180000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 5,
	.field_list = {
		[1] = 1,
		[7] = 20,
		[9] = 21,
		[11] = 22,
		[24] = 33,
		[26] = 34,
		[28] = 35,
		[30] = 36,
		[32] = 37,
		[33] = 2,
		[34] = 23,
		[35] = 3,
		[36] = 24,
		[37] = 4,
		[38] = 25,
		[39] = 5,
		[40] = 26,
		[41] = 6,
		[42] = 27,
		[43] = 7,
		[44] = 28,
		[45] = 8,
		[46] = 29,
		[47] = 9,
		[48] = 30,
		[49] = 10,
		[50] = 31,
		[51] = 11,
		[52] = 32,
		[103] = 12,
		[105] = 13,
		[107] = 14,
		[109] = 15,
		[123] = 16,
		[124] = 17,
		[125] = 18,
		[126] = 19,
		},
	},
	[95] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_GENEVE |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xA002800000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 6,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		},
	},
	[96] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_SRV6 |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xD800000000000,
	.field_opt_bitmap = 0xB04000B000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 7,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 20,
		[55] = 6,
		[56] = 21,
		[57] = 7,
		[58] = 22,
		[59] = 8,
		[60] = 23,
		[61] = 9,
		[62] = 24,
		[63] = 10,
		[64] = 25,
		[65] = 11,
		[66] = 26,
		[67] = 12,
		[68] = 27,
		[71] = 13,
		[73] = 14,
		[75] = 15,
		[77] = 16,
		[79] = 17,
		[81] = 18,
		[83] = 19,
		},
	},
	[97] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_SRV6 |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xD800000000000,
	.field_opt_bitmap = 0xB04000BC00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 7,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 20,
		[55] = 6,
		[56] = 21,
		[57] = 7,
		[58] = 22,
		[59] = 8,
		[60] = 23,
		[61] = 9,
		[62] = 24,
		[63] = 10,
		[64] = 25,
		[65] = 11,
		[66] = 26,
		[67] = 12,
		[68] = 27,
		[71] = 13,
		[73] = 14,
		[75] = 15,
		[77] = 16,
		[79] = 17,
		[81] = 18,
		[83] = 19,
		[86] = 28,
		[88] = 29,
		[90] = 30,
		[92] = 31,
		[94] = 32,
		[96] = 33,
		[98] = 34,
		[100] = 35,
		[102] = 36,
		},
	},
	[98] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_SRV6 |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0xD800000000000,
	.field_opt_bitmap = 0xB04000BC00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 1,
	.flow_pattern_id = 7,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 20,
		[55] = 6,
		[56] = 21,
		[57] = 7,
		[58] = 22,
		[59] = 8,
		[60] = 23,
		[61] = 9,
		[62] = 24,
		[63] = 10,
		[64] = 25,
		[65] = 11,
		[66] = 26,
		[67] = 12,
		[68] = 27,
		[71] = 13,
		[73] = 14,
		[75] = 15,
		[77] = 16,
		[79] = 17,
		[81] = 18,
		[83] = 19,
		[104] = 28,
		[106] = 29,
		[108] = 30,
		[110] = 31,
		},
	},
	[99] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01C160000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[53] = 5,
		[54] = 15,
		[55] = 6,
		[56] = 16,
		[57] = 7,
		[58] = 17,
		[59] = 8,
		[60] = 18,
		[61] = 9,
		[62] = 19,
		[63] = 10,
		[64] = 20,
		[65] = 11,
		[66] = 21,
		[67] = 12,
		[68] = 22,
		},
	},
	[100] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB007058000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 17,
		[56] = 18,
		[58] = 19,
		[60] = 20,
		[62] = 21,
		[64] = 22,
		[66] = 23,
		[68] = 24,
		},
	},
	[101] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01C058000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[34] = 15,
		[36] = 16,
		[38] = 17,
		[40] = 18,
		[42] = 19,
		[44] = 20,
		[46] = 21,
		[48] = 22,
		[50] = 23,
		[52] = 24,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		},
	},
	[102] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB007016000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[33] = 5,
		[34] = 17,
		[35] = 6,
		[36] = 18,
		[37] = 7,
		[38] = 19,
		[39] = 8,
		[40] = 20,
		[41] = 9,
		[42] = 21,
		[43] = 10,
		[44] = 22,
		[45] = 11,
		[46] = 23,
		[47] = 12,
		[48] = 24,
		[49] = 13,
		[50] = 25,
		[51] = 14,
		[52] = 26,
		},
	},
	[103] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01D0B0000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[22] = 15,
		[53] = 5,
		[54] = 16,
		[55] = 6,
		[56] = 17,
		[57] = 7,
		[58] = 18,
		[59] = 8,
		[60] = 19,
		[61] = 9,
		[62] = 20,
		[63] = 10,
		[64] = 21,
		[65] = 11,
		[66] = 22,
		[67] = 12,
		[68] = 23,
		},
	},
	[104] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00742C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[22] = 17,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 18,
		[56] = 19,
		[58] = 20,
		[60] = 21,
		[62] = 22,
		[64] = 23,
		[66] = 24,
		[68] = 25,
		},
	},
	[105] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01D02C000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[22] = 15,
		[34] = 16,
		[36] = 17,
		[38] = 18,
		[40] = 19,
		[42] = 20,
		[44] = 21,
		[46] = 22,
		[48] = 23,
		[50] = 24,
		[52] = 25,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		},
	},
	[106] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00740B000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[22] = 17,
		[33] = 5,
		[34] = 18,
		[35] = 6,
		[36] = 19,
		[37] = 7,
		[38] = 20,
		[39] = 8,
		[40] = 21,
		[41] = 9,
		[42] = 22,
		[43] = 10,
		[44] = 23,
		[45] = 11,
		[46] = 24,
		[47] = 12,
		[48] = 25,
		[49] = 13,
		[50] = 26,
		[51] = 14,
		[52] = 27,
		},
	},
	[107] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01C178000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[53] = 5,
		[54] = 15,
		[55] = 6,
		[56] = 16,
		[57] = 7,
		[58] = 17,
		[59] = 8,
		[60] = 18,
		[61] = 9,
		[62] = 19,
		[63] = 10,
		[64] = 20,
		[65] = 11,
		[66] = 21,
		[67] = 12,
		[68] = 22,
		[86] = 23,
		[88] = 24,
		[90] = 25,
		[92] = 26,
		[94] = 27,
		[96] = 28,
		[98] = 29,
		[100] = 30,
		[102] = 31,
		},
	},
	[108] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00705E000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 17,
		[56] = 18,
		[58] = 19,
		[60] = 20,
		[62] = 21,
		[64] = 22,
		[66] = 23,
		[68] = 24,
		[86] = 25,
		[88] = 26,
		[90] = 27,
		[92] = 28,
		[94] = 29,
		[96] = 30,
		[98] = 31,
		[100] = 32,
		[102] = 33,
		},
	},
	[109] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01C05E000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[34] = 15,
		[36] = 16,
		[38] = 17,
		[40] = 18,
		[42] = 19,
		[44] = 20,
		[46] = 21,
		[48] = 22,
		[50] = 23,
		[52] = 24,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 25,
		[88] = 26,
		[90] = 27,
		[92] = 28,
		[94] = 29,
		[96] = 30,
		[98] = 31,
		[100] = 32,
		[102] = 33,
		},
	},
	[110] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB007017800000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[33] = 5,
		[34] = 17,
		[35] = 6,
		[36] = 18,
		[37] = 7,
		[38] = 19,
		[39] = 8,
		[40] = 20,
		[41] = 9,
		[42] = 21,
		[43] = 10,
		[44] = 22,
		[45] = 11,
		[46] = 23,
		[47] = 12,
		[48] = 24,
		[49] = 13,
		[50] = 25,
		[51] = 14,
		[52] = 26,
		[86] = 27,
		[88] = 28,
		[90] = 29,
		[92] = 30,
		[94] = 31,
		[96] = 32,
		[98] = 33,
		[100] = 34,
		[102] = 35,
		},
	},
	[111] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01C178000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[53] = 5,
		[54] = 15,
		[55] = 6,
		[56] = 16,
		[57] = 7,
		[58] = 17,
		[59] = 8,
		[60] = 18,
		[61] = 9,
		[62] = 19,
		[63] = 10,
		[64] = 20,
		[65] = 11,
		[66] = 21,
		[67] = 12,
		[68] = 22,
		[104] = 23,
		[106] = 24,
		[108] = 25,
		[110] = 26,
		},
	},
	[112] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00705E000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 17,
		[56] = 18,
		[58] = 19,
		[60] = 20,
		[62] = 21,
		[64] = 22,
		[66] = 23,
		[68] = 24,
		[104] = 25,
		[106] = 26,
		[108] = 27,
		[110] = 28,
		},
	},
	[113] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01C05E000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[34] = 15,
		[36] = 16,
		[38] = 17,
		[40] = 18,
		[42] = 19,
		[44] = 20,
		[46] = 21,
		[48] = 22,
		[50] = 23,
		[52] = 24,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[104] = 25,
		[106] = 26,
		[108] = 27,
		[110] = 28,
		},
	},
	[114] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB007017800000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[33] = 5,
		[34] = 17,
		[35] = 6,
		[36] = 18,
		[37] = 7,
		[38] = 19,
		[39] = 8,
		[40] = 20,
		[41] = 9,
		[42] = 21,
		[43] = 10,
		[44] = 22,
		[45] = 11,
		[46] = 23,
		[47] = 12,
		[48] = 24,
		[49] = 13,
		[50] = 25,
		[51] = 14,
		[52] = 26,
		[104] = 27,
		[106] = 28,
		[108] = 29,
		[110] = 30,
		},
	},
	[115] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01D0BC000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[22] = 15,
		[53] = 5,
		[54] = 16,
		[55] = 6,
		[56] = 17,
		[57] = 7,
		[58] = 18,
		[59] = 8,
		[60] = 19,
		[61] = 9,
		[62] = 20,
		[63] = 10,
		[64] = 21,
		[65] = 11,
		[66] = 22,
		[67] = 12,
		[68] = 23,
		[86] = 24,
		[88] = 25,
		[90] = 26,
		[92] = 27,
		[94] = 28,
		[96] = 29,
		[98] = 30,
		[100] = 31,
		[102] = 32,
		},
	},
	[116] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00742F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[22] = 17,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 18,
		[56] = 19,
		[58] = 20,
		[60] = 21,
		[62] = 22,
		[64] = 23,
		[66] = 24,
		[68] = 25,
		[86] = 26,
		[88] = 27,
		[90] = 28,
		[92] = 29,
		[94] = 30,
		[96] = 31,
		[98] = 32,
		[100] = 33,
		[102] = 34,
		},
	},
	[117] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01D02F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[22] = 15,
		[34] = 16,
		[36] = 17,
		[38] = 18,
		[40] = 19,
		[42] = 20,
		[44] = 21,
		[46] = 22,
		[48] = 23,
		[50] = 24,
		[52] = 25,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 26,
		[88] = 27,
		[90] = 28,
		[92] = 29,
		[94] = 30,
		[96] = 31,
		[98] = 32,
		[100] = 33,
		[102] = 34,
		},
	},
	[118] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00740BC00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[22] = 17,
		[33] = 5,
		[34] = 18,
		[35] = 6,
		[36] = 19,
		[37] = 7,
		[38] = 20,
		[39] = 8,
		[40] = 21,
		[41] = 9,
		[42] = 22,
		[43] = 10,
		[44] = 23,
		[45] = 11,
		[46] = 24,
		[47] = 12,
		[48] = 25,
		[49] = 13,
		[50] = 26,
		[51] = 14,
		[52] = 27,
		[86] = 28,
		[88] = 29,
		[90] = 30,
		[92] = 31,
		[94] = 32,
		[96] = 33,
		[98] = 34,
		[100] = 35,
		[102] = 36,
		},
	},
	[119] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01D0BC000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[22] = 15,
		[53] = 5,
		[54] = 16,
		[55] = 6,
		[56] = 17,
		[57] = 7,
		[58] = 18,
		[59] = 8,
		[60] = 19,
		[61] = 9,
		[62] = 20,
		[63] = 10,
		[64] = 21,
		[65] = 11,
		[66] = 22,
		[67] = 12,
		[68] = 23,
		[104] = 24,
		[106] = 25,
		[108] = 26,
		[110] = 27,
		},
	},
	[120] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00742F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[22] = 17,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 18,
		[56] = 19,
		[58] = 20,
		[60] = 21,
		[62] = 22,
		[64] = 23,
		[66] = 24,
		[68] = 25,
		[104] = 26,
		[106] = 27,
		[108] = 28,
		[110] = 29,
		},
	},
	[121] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01D02F000000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 13,
		[21] = 14,
		[22] = 15,
		[34] = 16,
		[36] = 17,
		[38] = 18,
		[40] = 19,
		[42] = 20,
		[44] = 21,
		[46] = 22,
		[48] = 23,
		[50] = 24,
		[52] = 25,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[104] = 26,
		[106] = 27,
		[108] = 28,
		[110] = 29,
		},
	},
	[122] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_T_GRE |
		BNXT_ULP_HDR_BIT_T_GRE_OPT |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00740BC00000000,
	.field_exclude_bitmap = 0x2000000000000000,
	.class_tid = 1,
	.flow_pattern_id = 8,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[20] = 15,
		[21] = 16,
		[22] = 17,
		[33] = 5,
		[34] = 18,
		[35] = 6,
		[36] = 19,
		[37] = 7,
		[38] = 20,
		[39] = 8,
		[40] = 21,
		[41] = 9,
		[42] = 22,
		[43] = 10,
		[44] = 23,
		[45] = 11,
		[46] = 24,
		[47] = 12,
		[48] = 25,
		[49] = 13,
		[50] = 26,
		[51] = 14,
		[52] = 27,
		[104] = 28,
		[106] = 29,
		[108] = 30,
		[110] = 31,
		},
	},
	[123] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB800000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		},
	},
	[124] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[125] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[126] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA40000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[127] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA78000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		},
	},
	[128] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA36000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		},
	},
	[129] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[130] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[131] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4F000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[132] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46C00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[133] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49E00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 11,
		[55] = 12,
		[57] = 13,
		[59] = 14,
		[61] = 15,
		[63] = 16,
		[65] = 17,
		[67] = 18,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[134] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48D80000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 11,
		[35] = 12,
		[37] = 13,
		[39] = 14,
		[41] = 15,
		[43] = 16,
		[45] = 17,
		[47] = 18,
		[49] = 19,
		[51] = 20,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[135] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[85] = 5,
		[87] = 6,
		[89] = 7,
		[91] = 8,
		[93] = 9,
		[95] = 10,
		[97] = 11,
		[99] = 12,
		[101] = 13,
		},
	},
	[136] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBE00000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[103] = 5,
		[105] = 6,
		[107] = 7,
		[109] = 8,
		},
	},
	[137] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[85] = 8,
		[87] = 9,
		[89] = 10,
		[91] = 11,
		[93] = 12,
		[95] = 13,
		[97] = 14,
		[99] = 15,
		[101] = 16,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[138] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[103] = 8,
		[105] = 9,
		[107] = 10,
		[109] = 11,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[139] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[85] = 8,
		[87] = 9,
		[89] = 10,
		[91] = 11,
		[93] = 12,
		[95] = 13,
		[97] = 14,
		[99] = 15,
		[101] = 16,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[140] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBAC0000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[103] = 8,
		[105] = 9,
		[107] = 10,
		[109] = 11,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[141] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[85] = 11,
		[87] = 12,
		[89] = 13,
		[91] = 14,
		[93] = 15,
		[95] = 16,
		[97] = 17,
		[99] = 18,
		[101] = 19,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[142] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA58000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[103] = 11,
		[105] = 12,
		[107] = 13,
		[109] = 14,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[143] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[85] = 13,
		[87] = 14,
		[89] = 15,
		[91] = 16,
		[93] = 17,
		[95] = 18,
		[97] = 19,
		[99] = 20,
		[101] = 21,
		},
	},
	[144] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[85] = 15,
		[87] = 16,
		[89] = 17,
		[91] = 18,
		[93] = 19,
		[95] = 20,
		[97] = 21,
		[99] = 22,
		[101] = 23,
		},
	},
	[145] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA7E000000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		},
	},
	[146] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA37800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		},
	},
	[147] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[85] = 16,
		[87] = 17,
		[89] = 18,
		[91] = 19,
		[93] = 20,
		[95] = 21,
		[97] = 22,
		[99] = 23,
		[101] = 24,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[148] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[85] = 18,
		[87] = 19,
		[89] = 20,
		[91] = 21,
		[93] = 22,
		[95] = 23,
		[97] = 24,
		[99] = 25,
		[101] = 26,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[149] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[103] = 16,
		[105] = 17,
		[107] = 18,
		[109] = 19,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[150] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[103] = 18,
		[105] = 19,
		[107] = 20,
		[109] = 21,
		[111] = 5,
		[115] = 6,
		[119] = 7,
		},
	},
	[151] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[85] = 16,
		[87] = 17,
		[89] = 18,
		[91] = 19,
		[93] = 20,
		[95] = 21,
		[97] = 22,
		[99] = 23,
		[101] = 24,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[152] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[85] = 18,
		[87] = 19,
		[89] = 20,
		[91] = 21,
		[93] = 22,
		[95] = 23,
		[97] = 24,
		[99] = 25,
		[101] = 26,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[153] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA4FC00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 8,
		[55] = 9,
		[57] = 10,
		[59] = 11,
		[61] = 12,
		[63] = 13,
		[65] = 14,
		[67] = 15,
		[103] = 16,
		[105] = 17,
		[107] = 18,
		[109] = 19,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[154] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA46F00000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 8,
		[35] = 9,
		[37] = 10,
		[39] = 11,
		[41] = 12,
		[43] = 13,
		[45] = 14,
		[47] = 15,
		[49] = 16,
		[51] = 17,
		[103] = 18,
		[105] = 19,
		[107] = 20,
		[109] = 21,
		[112] = 5,
		[116] = 6,
		[120] = 7,
		},
	},
	[155] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 11,
		[55] = 12,
		[57] = 13,
		[59] = 14,
		[61] = 15,
		[63] = 16,
		[65] = 17,
		[67] = 18,
		[85] = 19,
		[87] = 20,
		[89] = 21,
		[91] = 22,
		[93] = 23,
		[95] = 24,
		[97] = 25,
		[99] = 26,
		[101] = 27,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[156] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 11,
		[35] = 12,
		[37] = 13,
		[39] = 14,
		[41] = 15,
		[43] = 16,
		[45] = 17,
		[47] = 18,
		[49] = 19,
		[51] = 20,
		[85] = 21,
		[87] = 22,
		[89] = 23,
		[91] = 24,
		[93] = 25,
		[95] = 26,
		[97] = 27,
		[99] = 28,
		[101] = 29,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[157] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA49F80000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 11,
		[55] = 12,
		[57] = 13,
		[59] = 14,
		[61] = 15,
		[63] = 16,
		[65] = 17,
		[67] = 18,
		[103] = 19,
		[105] = 20,
		[107] = 21,
		[109] = 22,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[158] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_OI_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xBA48DE0000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 0,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 11,
		[35] = 12,
		[37] = 13,
		[39] = 14,
		[41] = 15,
		[43] = 16,
		[45] = 17,
		[47] = 18,
		[49] = 19,
		[51] = 20,
		[103] = 21,
		[105] = 22,
		[107] = 23,
		[109] = 24,
		[111] = 5,
		[112] = 8,
		[115] = 6,
		[116] = 9,
		[119] = 7,
		[120] = 10,
		},
	},
	[159] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A100000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[160] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006840000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[161] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[162] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[163] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105800000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 21,
		[55] = 6,
		[56] = 22,
		[57] = 7,
		[58] = 23,
		[59] = 8,
		[60] = 24,
		[61] = 9,
		[62] = 25,
		[63] = 10,
		[64] = 26,
		[65] = 11,
		[66] = 27,
		[67] = 12,
		[68] = 28,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[164] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[165] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101600000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[166] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006840580000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[34] = 23,
		[35] = 6,
		[36] = 24,
		[37] = 7,
		[38] = 25,
		[39] = 8,
		[40] = 26,
		[41] = 9,
		[42] = 27,
		[43] = 10,
		[44] = 28,
		[45] = 11,
		[46] = 29,
		[47] = 12,
		[48] = 30,
		[49] = 13,
		[50] = 31,
		[51] = 14,
		[52] = 32,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[167] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170B00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[54] = 24,
		[55] = 6,
		[56] = 25,
		[57] = 7,
		[58] = 26,
		[59] = 8,
		[60] = 27,
		[61] = 9,
		[62] = 28,
		[63] = 10,
		[64] = 29,
		[65] = 11,
		[66] = 30,
		[67] = 12,
		[68] = 31,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[168] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2C0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 26,
		[56] = 27,
		[58] = 28,
		[60] = 29,
		[62] = 30,
		[64] = 31,
		[66] = 32,
		[68] = 33,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[169] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702C0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[34] = 24,
		[36] = 25,
		[38] = 26,
		[40] = 27,
		[42] = 28,
		[44] = 29,
		[46] = 30,
		[48] = 31,
		[50] = 32,
		[52] = 33,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[170] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0B0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[34] = 26,
		[35] = 6,
		[36] = 27,
		[37] = 7,
		[38] = 28,
		[39] = 8,
		[40] = 29,
		[41] = 9,
		[42] = 30,
		[43] = 10,
		[44] = 31,
		[45] = 11,
		[46] = 32,
		[47] = 12,
		[48] = 33,
		[49] = 13,
		[50] = 34,
		[51] = 14,
		[52] = 35,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[171] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A160000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 21,
		[88] = 22,
		[90] = 23,
		[92] = 24,
		[94] = 25,
		[96] = 26,
		[98] = 27,
		[100] = 28,
		[102] = 29,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[172] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006858000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[86] = 23,
		[88] = 24,
		[90] = 25,
		[92] = 26,
		[94] = 27,
		[96] = 28,
		[98] = 29,
		[100] = 30,
		[102] = 31,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[173] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A160000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[104] = 21,
		[105] = 14,
		[106] = 22,
		[107] = 15,
		[108] = 23,
		[109] = 16,
		[110] = 24,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[174] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006858000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[104] = 23,
		[105] = 16,
		[106] = 24,
		[107] = 17,
		[108] = 25,
		[109] = 18,
		[110] = 26,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[175] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 24,
		[88] = 25,
		[90] = 26,
		[92] = 27,
		[94] = 28,
		[96] = 29,
		[98] = 30,
		[100] = 31,
		[102] = 32,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[176] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[86] = 26,
		[88] = 27,
		[90] = 28,
		[92] = 29,
		[94] = 30,
		[96] = 31,
		[98] = 32,
		[100] = 33,
		[102] = 34,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[177] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A17C000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[104] = 24,
		[105] = 14,
		[106] = 25,
		[107] = 15,
		[108] = 26,
		[109] = 16,
		[110] = 27,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[178] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685F000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[104] = 26,
		[105] = 16,
		[106] = 27,
		[107] = 17,
		[108] = 28,
		[109] = 18,
		[110] = 29,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[179] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 21,
		[55] = 6,
		[56] = 22,
		[57] = 7,
		[58] = 23,
		[59] = 8,
		[60] = 24,
		[61] = 9,
		[62] = 25,
		[63] = 10,
		[64] = 26,
		[65] = 11,
		[66] = 27,
		[67] = 12,
		[68] = 28,
		[86] = 29,
		[88] = 30,
		[90] = 31,
		[92] = 32,
		[94] = 33,
		[96] = 34,
		[98] = 35,
		[100] = 36,
		[102] = 37,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[180] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[86] = 31,
		[88] = 32,
		[90] = 33,
		[92] = 34,
		[94] = 35,
		[96] = 36,
		[98] = 37,
		[100] = 38,
		[102] = 39,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[181] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 31,
		[88] = 32,
		[90] = 33,
		[92] = 34,
		[94] = 35,
		[96] = 36,
		[98] = 37,
		[100] = 38,
		[102] = 39,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[182] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB0068405E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[34] = 23,
		[35] = 6,
		[36] = 24,
		[37] = 7,
		[38] = 25,
		[39] = 8,
		[40] = 26,
		[41] = 9,
		[42] = 27,
		[43] = 10,
		[44] = 28,
		[45] = 11,
		[46] = 29,
		[47] = 12,
		[48] = 30,
		[49] = 13,
		[50] = 31,
		[51] = 14,
		[52] = 32,
		[86] = 33,
		[88] = 34,
		[90] = 35,
		[92] = 36,
		[94] = 37,
		[96] = 38,
		[98] = 39,
		[100] = 40,
		[102] = 41,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[183] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A105E00000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[53] = 5,
		[54] = 21,
		[55] = 6,
		[56] = 22,
		[57] = 7,
		[58] = 23,
		[59] = 8,
		[60] = 24,
		[61] = 9,
		[62] = 25,
		[63] = 10,
		[64] = 26,
		[65] = 11,
		[66] = 27,
		[67] = 12,
		[68] = 28,
		[103] = 13,
		[104] = 29,
		[105] = 14,
		[106] = 30,
		[107] = 15,
		[108] = 31,
		[109] = 16,
		[110] = 32,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[184] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB006841780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 23,
		[56] = 24,
		[58] = 25,
		[60] = 26,
		[62] = 27,
		[64] = 28,
		[66] = 29,
		[68] = 30,
		[103] = 15,
		[104] = 31,
		[105] = 16,
		[106] = 32,
		[107] = 17,
		[108] = 33,
		[109] = 18,
		[110] = 34,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[185] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A101780000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[34] = 21,
		[36] = 22,
		[38] = 23,
		[40] = 24,
		[42] = 25,
		[44] = 26,
		[46] = 27,
		[48] = 28,
		[50] = 29,
		[52] = 30,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[104] = 31,
		[105] = 14,
		[106] = 32,
		[107] = 15,
		[108] = 33,
		[109] = 16,
		[110] = 34,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[186] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB0068405E0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[34] = 23,
		[35] = 6,
		[36] = 24,
		[37] = 7,
		[38] = 25,
		[39] = 8,
		[40] = 26,
		[41] = 9,
		[42] = 27,
		[43] = 10,
		[44] = 28,
		[45] = 11,
		[46] = 29,
		[47] = 12,
		[48] = 30,
		[49] = 13,
		[50] = 31,
		[51] = 14,
		[52] = 32,
		[103] = 15,
		[104] = 33,
		[105] = 16,
		[106] = 34,
		[107] = 17,
		[108] = 35,
		[109] = 18,
		[110] = 36,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[187] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[54] = 24,
		[55] = 6,
		[56] = 25,
		[57] = 7,
		[58] = 26,
		[59] = 8,
		[60] = 27,
		[61] = 9,
		[62] = 28,
		[63] = 10,
		[64] = 29,
		[65] = 11,
		[66] = 30,
		[67] = 12,
		[68] = 31,
		[86] = 32,
		[88] = 33,
		[90] = 34,
		[92] = 35,
		[94] = 36,
		[96] = 37,
		[98] = 38,
		[100] = 39,
		[102] = 40,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[188] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 26,
		[56] = 27,
		[58] = 28,
		[60] = 29,
		[62] = 30,
		[64] = 31,
		[66] = 32,
		[68] = 33,
		[86] = 34,
		[88] = 35,
		[90] = 36,
		[92] = 37,
		[94] = 38,
		[96] = 39,
		[98] = 40,
		[100] = 41,
		[102] = 42,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[189] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[34] = 24,
		[36] = 25,
		[38] = 26,
		[40] = 27,
		[42] = 28,
		[44] = 29,
		[46] = 30,
		[48] = 31,
		[50] = 32,
		[52] = 33,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[86] = 34,
		[88] = 35,
		[90] = 36,
		[92] = 37,
		[94] = 38,
		[96] = 39,
		[98] = 40,
		[100] = 41,
		[102] = 42,
		[103] = 13,
		[105] = 14,
		[107] = 15,
		[109] = 16,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[190] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[34] = 26,
		[35] = 6,
		[36] = 27,
		[37] = 7,
		[38] = 28,
		[39] = 8,
		[40] = 29,
		[41] = 9,
		[42] = 30,
		[43] = 10,
		[44] = 31,
		[45] = 11,
		[46] = 32,
		[47] = 12,
		[48] = 33,
		[49] = 13,
		[50] = 34,
		[51] = 14,
		[52] = 35,
		[86] = 36,
		[88] = 37,
		[90] = 38,
		[92] = 39,
		[94] = 40,
		[96] = 41,
		[98] = 42,
		[100] = 43,
		[102] = 44,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[191] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A170BC0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[53] = 5,
		[54] = 24,
		[55] = 6,
		[56] = 25,
		[57] = 7,
		[58] = 26,
		[59] = 8,
		[60] = 27,
		[61] = 9,
		[62] = 28,
		[63] = 10,
		[64] = 29,
		[65] = 11,
		[66] = 30,
		[67] = 12,
		[68] = 31,
		[103] = 13,
		[104] = 32,
		[105] = 14,
		[106] = 33,
		[107] = 15,
		[108] = 34,
		[109] = 16,
		[110] = 35,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[192] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV6 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C2F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[54] = 26,
		[56] = 27,
		[58] = 28,
		[60] = 29,
		[62] = 30,
		[64] = 31,
		[66] = 32,
		[68] = 33,
		[103] = 15,
		[104] = 34,
		[105] = 16,
		[106] = 35,
		[107] = 17,
		[108] = 36,
		[109] = 18,
		[110] = 37,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[193] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB01A1702F0000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 21,
		[8] = 3,
		[9] = 22,
		[10] = 4,
		[11] = 23,
		[34] = 24,
		[36] = 25,
		[38] = 26,
		[40] = 27,
		[42] = 28,
		[44] = 29,
		[46] = 30,
		[48] = 31,
		[50] = 32,
		[52] = 33,
		[53] = 5,
		[55] = 6,
		[57] = 7,
		[59] = 8,
		[61] = 9,
		[63] = 10,
		[65] = 11,
		[67] = 12,
		[103] = 13,
		[104] = 34,
		[105] = 14,
		[106] = 35,
		[107] = 15,
		[108] = 36,
		[109] = 16,
		[110] = 37,
		[123] = 17,
		[124] = 18,
		[125] = 19,
		[126] = 20,
		},
	},
	[194] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_HDR_BIT_I_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB00685C0BC000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 1,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[7] = 23,
		[8] = 3,
		[9] = 24,
		[10] = 4,
		[11] = 25,
		[33] = 5,
		[34] = 26,
		[35] = 6,
		[36] = 27,
		[37] = 7,
		[38] = 28,
		[39] = 8,
		[40] = 29,
		[41] = 9,
		[42] = 30,
		[43] = 10,
		[44] = 31,
		[45] = 11,
		[46] = 32,
		[47] = 12,
		[48] = 33,
		[49] = 13,
		[50] = 34,
		[51] = 14,
		[52] = 35,
		[103] = 15,
		[104] = 36,
		[105] = 16,
		[106] = 37,
		[107] = 17,
		[108] = 38,
		[109] = 18,
		[110] = 39,
		[123] = 19,
		[124] = 20,
		[125] = 21,
		[126] = 22,
		},
	},
	[195] = {
	.app_id = 0,
	.hdr_bitmap = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_GENEVE |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_man_bitmap = 0x0,
	.field_opt_bitmap = 0xB002800000000000,
	.field_exclude_bitmap = 0x0,
	.class_tid = 2,
	.flow_pattern_id = 2,
	.field_list = {
		[1] = 1,
		[6] = 2,
		[8] = 3,
		[10] = 4,
		[33] = 5,
		[35] = 6,
		[37] = 7,
		[39] = 8,
		[41] = 9,
		[43] = 10,
		[45] = 11,
		[47] = 12,
		[49] = 13,
		[51] = 14,
		[103] = 15,
		[105] = 16,
		[107] = 17,
		[109] = 18,
		},
	}
};
