"""
Generates font-face file for a family name.
"""

import os
import sys

if __name__ == "__main__":
    if len(sys.argv) < 3:
        print(
            "Args must be: <family-name> <output-dir>")
        sys.exit(1)

    name = sys.argv[1]
    weights = (('100', 'Thin'),
               ('200', 'ExtraLight'),
               ('300', 'Light'),
               ('400', 'Regular'),
               ('500', 'Medium'),
               ('600', 'SemiBold'),
               ('700', 'Bold'),
               ('800', 'ExtraBold'),
               ('900', 'Black'))

    filename_head = "-".join(name.split(" "))
    css_file_path = os.path.join(
        sys.argv[2], filename_head + "-font-face.css")

    with open(css_file_path, 'w') as of:
        output = "/* Generated by script */"
        for weight in weights:
            filename = filename_head + "-" + weight[1]
            output += """
@font-face {{
  font-family: {0};
  src: url('fonts/webfonts/{1}.woff2') format('woff2');
  font-weight: {3};
  font-style: normal;
  font-display: swap;
}}
""".format(name, filename, filename, weight[0])

        of.write(output)
