/* $Id: kmer-search.h 224753 2021-12-13 00:40:32Z twu $ */
#ifndef KMER_SEARCH_INCLUDED
#define KMER_SEARCH_INCLUDED

#include "mode.h"
#include "list.h"
#include "indexdb.h"
#include "iit-read-univ.h"
#include "transcriptome.h"
#include "compress.h"
#include "genome.h"
#include "indel.h"

#include "bool.h"
#include "univdiag.h"
#include "stage1hr.h"
#include "stage3hr.h"
#include "listpool.h"
#include "hitlistpool.h"
#include "mergeinfo.h"

typedef struct Path_T *Path_T;


extern void
Kmer_search_transcriptome_single (int *found_score_overall, int *found_score_within_trims,
				  List_T *sense_hits_gplus, List_T *sense_hits_gminus,
				  List_T *antisense_hits_gplus, List_T *antisense_hits_gminus,

				  char *queryuc_ptr, int querylength,
				  Trcoord_T **tplus_stream_array, int *tplus_streamsize_array, int *tplus_diagterm_array,
				  Trcoord_T **tminus_stream_array, int *tminus_streamsize_array, int *tminus_diagterm_array,
				  int *mismatch_positions_alloc, Compress_T query_compress_fwd, Compress_T query_compress_rev,
				  Univ_IIT_T transcript_iit, Transcriptome_T transcriptome,
				  Indelinfo_T indelinfo, Mergeinfo_uint4_T mergeinfo,
				  int nmismatches_allowed, bool first_read_p,
				  Listpool_T listpool, Hitlistpool_T hitlistpool, int level);

/* Does not take paired_end_p as a parameter.  ? Generates both sense and antisense */
extern void
Kmer_search_genome_ends_exact (bool *abort_exact_p, int *found_score_overall, int *found_score_within_trims,
			       List_T *sense_hits_gplus, List_T *sense_hits_gminus,
			       List_T *antisense_hits_gplus, List_T *antisense_hits_gminus,
			       Stage1_T stage1, int querylength, int *mismatch_positions_alloc,
			       Spliceinfo_T spliceinfo,
			       Compress_T query_compress_fwd, Compress_T query_compress_rev,
			       int genestrand, bool first_read_p, int nmismatches_allowed,
			       Listpool_T listpool, Hitlistpool_T hitlistpool, int level);

/* Takes sizelimit because merging can be expensive */
extern void
Kmer_search_genome_ends_approx (int *found_score_overall, int *found_score_within_trims,
				List_T *sense_hits_gplus, List_T *sense_hits_gminus,
				List_T *antisense_hits_gplus, List_T *antisense_hits_gminus,
				Stage1_T stage1, int *mismatch_positions_alloc, Mergeinfo_T mergeinfo,
				Compress_T query_compress_fwd, Compress_T query_compress_rev,
				int querylength, int genestrand, bool first_read_p, int nmismatches_allowed,
				int max_deletionlen, Chrpos_T overall_max_distance, int sizelimit,
				Listpool_T listpool, Hitlistpool_T hitlistpool, int level);

extern void
Kmer_search_setup (Mode_T mode_in, int index1part_tr_in,
		   int index1part_in, int index1interval_in, int local1part_in,
		   Trcoord_T transcriptomelength_in, int min_intronlength_in,
		   Univ_IIT_T chromosome_iit_in, Univcoord_T genomelength_in,
		   int circular_typeint_in, bool *circularp_in, 
		   Genome_T genomebits_in, Genome_T genomebits_alt_in, Genome_T transcriptomebits_in,
		   Indexdb_T indexdb_in, Indexdb_T indexdb2_in, Indexdb_T indexdb_tr_in,
		   bool splicingp_in, Univcoord_T *splicesites_in, Splicetype_T *splicetypes_in,
		   Chrpos_T *splicedists_in, int nsplicesites_in);
#endif
