#ifndef INC_config_hpp__
#define INC_config_hpp__

/**
 * <b>SOFTWARE RIGHTS</b>
 * <p>
 * ANTLR 2.6.0 MageLang Insitute, 1999
 * <p>
 * We reserve no legal rights to the ANTLR--it is fully in the
 * public domain. An individual or company may do whatever
 * they wish with source code distributed with ANTLR or the
 * code generated by ANTLR, including the incorporation of
 * ANTLR, or its output, into commerical software.
 * <p>
 * We encourage users to develop software with ANTLR. However,
 * we do ask that credit is given to us for developing
 * ANTLR. By "credit", we mean that if you use ANTLR or
 * incorporate any source code into one of your programs
 * (commercial product, research project, or otherwise) that
 * you acknowledge this fact somewhere in the documentation,
 * research report, etc... If you like ANTLR and have
 * developed a nice tool with the output, please mention that
 * you developed it using ANTLR. In addition, we ask that the
 * headers remain intact in our source code. As long as these
 * guidelines are kept, we expect to continue enhancing this
 * system and expect to make other tools available as they are
 * completed.
 * <p>
 * The ANTLR gang:
 * @version ANTLR 2.6.0 MageLang Insitute, 1999
 * @author Terence Parr, <a href=http://www.MageLang.com>MageLang Institute</a>
 * @author <br>John Lilley, <a href=http://www.Empathy.com>Empathy Software</a>
 * @author <br><a href="mailto:pete@yamuna.demon.co.uk">Pete Wells</a>
 */

/*
 * Just a simple configuration file to differentiate between the
 * various compilers used.
 */

#ifdef _MSC_VER // Microsoft Visual C++

// This warning really gets on my nerves.
// It's the one about symbol longer than 256 chars, and it happens
// all the time with STL.
#pragma warning( disable : 4786 )

// Now, some defines for shortcomings in the MS compiler:

// Not allowed to put 'static const int XXX=20;' in a class definition
#define NO_STATIC_CONSTS
// Using vector<XXX> requires operator<(X,X) to be defined
#define NEEDS_OPERATOR_LESS_THAN
// No strcasecmp in the C library (so use stricmp instead)
// - Anyone know which is in which standard?
#define NO_STRCASECMP

#endif

//
// SunPro Compiler (Using OBJECTSPACE STL)
//
#ifdef __SUNPRO_CC

#undef namespace
#define namespace


#undef explicit
#define explicit

#define exception os_exception
#define bad_exception os_bad_exception

// Not allowed to put 'static const int XXX=20;' in a class definition
#define NO_STATIC_CONSTS
// Using vector<XXX> requires operator<(X,X) to be defined
#define NEEDS_OPERATOR_LESS_THAN

#endif

//
// Inprise C++ Builder 3.0
//
#ifdef __BCPLUSPLUS__
#define NO_TEMPLATE_PARTS
#define NO_STRCASECMP
#endif

#ifdef __IBMCPP__ // IBM VisualAge C++ ( which includes the Dinkumware C++ Library )

// No strcasecmp in the C library (so use stricmp instead)
// - Anyone know which is in which standard?
#define NO_STRCASECMP

#endif

#endif //INC_config_hpp__

