#!/usr/bin/env python

"""
Increment the hour in a datetime string, wrapping round within any given range.
"""

import sys

try:
    dt_str = sys.argv[1]
    first, last = (sys.argv[2:4] + [None, None])[:2]
except (IndexError, ValueError):
    sys.exit(1)

if not dt_str:
    sys.exit(1)

try:
    date_str = dt_str[:9]
    hour = int(dt_str[9:11])
    min_sec_str = dt_str[11:]
except ValueError:
    sys.exit(1)

if not first:
    first = 0
else:
    first = int(first)

if not last:
    last = 23
else:
    last = int(last)

hour += 1
if hour > last:
    hour = first

print '%s%02d%s' % (date_str, hour, min_sec_str)

# vim: tabstop=4 expandtab shiftwidth=4
