
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCalendarWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCalendarWidget>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QCalendar>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDate>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QTextCharFormat>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCalendarWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCalendarWidget::staticMetaObject);
}


// QCalendar QCalendarWidget::calendar()


static void _init_f_calendar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QCalendar > ();
}

static void _call_f_calendar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCalendar > ((QCalendar)((QCalendarWidget *)cls)->calendar ());
}


// int QCalendarWidget::dateEditAcceptDelay()


static void _init_f_dateEditAcceptDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dateEditAcceptDelay_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCalendarWidget *)cls)->dateEditAcceptDelay ());
}


// QMap<QDate, QTextCharFormat> QCalendarWidget::dateTextFormat()


static void _init_f_dateTextFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMap<QDate, QTextCharFormat> > ();
}

static void _call_f_dateTextFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMap<QDate, QTextCharFormat> > ((QMap<QDate, QTextCharFormat>)((QCalendarWidget *)cls)->dateTextFormat ());
}


// QTextCharFormat QCalendarWidget::dateTextFormat(QDate date)


static void _init_f_dateTextFormat_c899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_dateTextFormat_c899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QCalendarWidget *)cls)->dateTextFormat (arg1));
}


// Qt::DayOfWeek QCalendarWidget::firstDayOfWeek()


static void _init_f_firstDayOfWeek_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::DayOfWeek>::target_type > ();
}

static void _call_f_firstDayOfWeek_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::DayOfWeek>::target_type > ((qt_gsi::Converter<Qt::DayOfWeek>::target_type)qt_gsi::CppToQtAdaptor<Qt::DayOfWeek>(((QCalendarWidget *)cls)->firstDayOfWeek ()));
}


// QTextCharFormat QCalendarWidget::headerTextFormat()


static void _init_f_headerTextFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_headerTextFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QCalendarWidget *)cls)->headerTextFormat ());
}


// QCalendarWidget::HorizontalHeaderFormat QCalendarWidget::horizontalHeaderFormat()


static void _init_f_horizontalHeaderFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type > ();
}

static void _call_f_horizontalHeaderFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type > ((qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type)qt_gsi::CppToQtAdaptor<QCalendarWidget::HorizontalHeaderFormat>(((QCalendarWidget *)cls)->horizontalHeaderFormat ()));
}


// bool QCalendarWidget::isDateEditEnabled()


static void _init_f_isDateEditEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDateEditEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendarWidget *)cls)->isDateEditEnabled ());
}


// bool QCalendarWidget::isGridVisible()


static void _init_f_isGridVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isGridVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendarWidget *)cls)->isGridVisible ());
}


// bool QCalendarWidget::isNavigationBarVisible()


static void _init_f_isNavigationBarVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNavigationBarVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendarWidget *)cls)->isNavigationBarVisible ());
}


// QDate QCalendarWidget::maximumDate()


static void _init_f_maximumDate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_maximumDate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDate > ((QDate)((QCalendarWidget *)cls)->maximumDate ());
}


// QDate QCalendarWidget::minimumDate()


static void _init_f_minimumDate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_minimumDate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDate > ((QDate)((QCalendarWidget *)cls)->minimumDate ());
}


// QSize QCalendarWidget::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QCalendarWidget *)cls)->minimumSizeHint ());
}


// int QCalendarWidget::monthShown()


static void _init_f_monthShown_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_monthShown_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCalendarWidget *)cls)->monthShown ());
}


// QDate QCalendarWidget::selectedDate()


static void _init_f_selectedDate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_selectedDate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDate > ((QDate)((QCalendarWidget *)cls)->selectedDate ());
}


// QCalendarWidget::SelectionMode QCalendarWidget::selectionMode()


static void _init_f_selectionMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type > ();
}

static void _call_f_selectionMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type > ((qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type)qt_gsi::CppToQtAdaptor<QCalendarWidget::SelectionMode>(((QCalendarWidget *)cls)->selectionMode ()));
}


// void QCalendarWidget::setCalendar(QCalendar calendar)


static void _init_f_setCalendar_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("calendar");
  decl->add_arg<QCalendar > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCalendar_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar arg1 = gsi::arg_reader<QCalendar >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setCalendar (arg1);
}


// void QCalendarWidget::setCurrentPage(int year, int month)


static void _init_f_setCurrentPage_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentPage_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setCurrentPage (arg1, arg2);
}


// void QCalendarWidget::setDateEditAcceptDelay(int delay)


static void _init_f_setDateEditAcceptDelay_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delay");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDateEditAcceptDelay_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setDateEditAcceptDelay (arg1);
}


// void QCalendarWidget::setDateEditEnabled(bool enable)


static void _init_f_setDateEditEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDateEditEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setDateEditEnabled (arg1);
}


// void QCalendarWidget::setDateRange(QDate min, QDate max)


static void _init_f_setDateRange_1690 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<QDate > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<QDate > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setDateRange_1690 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  QDate arg2 = gsi::arg_reader<QDate >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setDateRange (arg1, arg2);
}


// void QCalendarWidget::setDateTextFormat(QDate date, const QTextCharFormat &format)


static void _init_f_setDateTextFormat_3605 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setDateTextFormat_3605 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  const QTextCharFormat &arg2 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setDateTextFormat (arg1, arg2);
}


// void QCalendarWidget::setFirstDayOfWeek(Qt::DayOfWeek dayOfWeek)


static void _init_f_setFirstDayOfWeek_1612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dayOfWeek");
  decl->add_arg<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFirstDayOfWeek_1612 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::DayOfWeek>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setFirstDayOfWeek (qt_gsi::QtToCppAdaptor<Qt::DayOfWeek>(arg1).cref());
}


// void QCalendarWidget::setGridVisible(bool show)


static void _init_f_setGridVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("show");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGridVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setGridVisible (arg1);
}


// void QCalendarWidget::setHeaderTextFormat(const QTextCharFormat &format)


static void _init_f_setHeaderTextFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeaderTextFormat_2814 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCharFormat &arg1 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setHeaderTextFormat (arg1);
}


// void QCalendarWidget::setHorizontalHeaderFormat(QCalendarWidget::HorizontalHeaderFormat format)


static void _init_f_setHorizontalHeaderFormat_4307 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalHeaderFormat_4307 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setHorizontalHeaderFormat (qt_gsi::QtToCppAdaptor<QCalendarWidget::HorizontalHeaderFormat>(arg1).cref());
}


// void QCalendarWidget::setMaximumDate(QDate date)


static void _init_f_setMaximumDate_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumDate_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setMaximumDate (arg1);
}


// void QCalendarWidget::setMinimumDate(QDate date)


static void _init_f_setMinimumDate_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumDate_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setMinimumDate (arg1);
}


// void QCalendarWidget::setNavigationBarVisible(bool visible)


static void _init_f_setNavigationBarVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNavigationBarVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setNavigationBarVisible (arg1);
}


// void QCalendarWidget::setSelectedDate(QDate date)


static void _init_f_setSelectedDate_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectedDate_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setSelectedDate (arg1);
}


// void QCalendarWidget::setSelectionMode(QCalendarWidget::SelectionMode mode)


static void _init_f_setSelectionMode_3362 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionMode_3362 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setSelectionMode (qt_gsi::QtToCppAdaptor<QCalendarWidget::SelectionMode>(arg1).cref());
}


// void QCalendarWidget::setVerticalHeaderFormat(QCalendarWidget::VerticalHeaderFormat format)


static void _init_f_setVerticalHeaderFormat_4067 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalHeaderFormat_4067 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setVerticalHeaderFormat (qt_gsi::QtToCppAdaptor<QCalendarWidget::VerticalHeaderFormat>(arg1).cref());
}


// void QCalendarWidget::setWeekdayTextFormat(Qt::DayOfWeek dayOfWeek, const QTextCharFormat &format)


static void _init_f_setWeekdayTextFormat_4318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dayOfWeek");
  decl->add_arg<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setWeekdayTextFormat_4318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::DayOfWeek>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & >() (args, heap);
  const QTextCharFormat &arg2 = gsi::arg_reader<const QTextCharFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->setWeekdayTextFormat (qt_gsi::QtToCppAdaptor<Qt::DayOfWeek>(arg1).cref(), arg2);
}


// void QCalendarWidget::showNextMonth()


static void _init_f_showNextMonth_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showNextMonth_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->showNextMonth ();
}


// void QCalendarWidget::showNextYear()


static void _init_f_showNextYear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showNextYear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->showNextYear ();
}


// void QCalendarWidget::showPreviousMonth()


static void _init_f_showPreviousMonth_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showPreviousMonth_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->showPreviousMonth ();
}


// void QCalendarWidget::showPreviousYear()


static void _init_f_showPreviousYear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showPreviousYear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->showPreviousYear ();
}


// void QCalendarWidget::showSelectedDate()


static void _init_f_showSelectedDate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showSelectedDate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->showSelectedDate ();
}


// void QCalendarWidget::showToday()


static void _init_f_showToday_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showToday_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget *)cls)->showToday ();
}


// QSize QCalendarWidget::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QCalendarWidget *)cls)->sizeHint ());
}


// QCalendarWidget::VerticalHeaderFormat QCalendarWidget::verticalHeaderFormat()


static void _init_f_verticalHeaderFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type > ();
}

static void _call_f_verticalHeaderFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type > ((qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type)qt_gsi::CppToQtAdaptor<QCalendarWidget::VerticalHeaderFormat>(((QCalendarWidget *)cls)->verticalHeaderFormat ()));
}


// QTextCharFormat QCalendarWidget::weekdayTextFormat(Qt::DayOfWeek dayOfWeek)


static void _init_f_weekdayTextFormat_c1612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dayOfWeek");
  decl->add_arg<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > (argspec_0);
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_weekdayTextFormat_c1612 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::DayOfWeek>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & >() (args, heap);
  ret.write<QTextCharFormat > ((QTextCharFormat)((QCalendarWidget *)cls)->weekdayTextFormat (qt_gsi::QtToCppAdaptor<Qt::DayOfWeek>(arg1).cref()));
}


// int QCalendarWidget::yearShown()


static void _init_f_yearShown_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_yearShown_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCalendarWidget *)cls)->yearShown ());
}


// static QString QCalendarWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCalendarWidget::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCalendarWidget () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("calendar", "@brief Method QCalendar QCalendarWidget::calendar()\n", true, &_init_f_calendar_c0, &_call_f_calendar_c0);
  methods += new qt_gsi::GenericMethod (":dateEditAcceptDelay", "@brief Method int QCalendarWidget::dateEditAcceptDelay()\n", true, &_init_f_dateEditAcceptDelay_c0, &_call_f_dateEditAcceptDelay_c0);
  methods += new qt_gsi::GenericMethod ("dateTextFormat", "@brief Method QMap<QDate, QTextCharFormat> QCalendarWidget::dateTextFormat()\n", true, &_init_f_dateTextFormat_c0, &_call_f_dateTextFormat_c0);
  methods += new qt_gsi::GenericMethod ("dateTextFormat", "@brief Method QTextCharFormat QCalendarWidget::dateTextFormat(QDate date)\n", true, &_init_f_dateTextFormat_c899, &_call_f_dateTextFormat_c899);
  methods += new qt_gsi::GenericMethod (":firstDayOfWeek", "@brief Method Qt::DayOfWeek QCalendarWidget::firstDayOfWeek()\n", true, &_init_f_firstDayOfWeek_c0, &_call_f_firstDayOfWeek_c0);
  methods += new qt_gsi::GenericMethod (":headerTextFormat", "@brief Method QTextCharFormat QCalendarWidget::headerTextFormat()\n", true, &_init_f_headerTextFormat_c0, &_call_f_headerTextFormat_c0);
  methods += new qt_gsi::GenericMethod (":horizontalHeaderFormat", "@brief Method QCalendarWidget::HorizontalHeaderFormat QCalendarWidget::horizontalHeaderFormat()\n", true, &_init_f_horizontalHeaderFormat_c0, &_call_f_horizontalHeaderFormat_c0);
  methods += new qt_gsi::GenericMethod ("isDateEditEnabled?|:dateEditEnabled", "@brief Method bool QCalendarWidget::isDateEditEnabled()\n", true, &_init_f_isDateEditEnabled_c0, &_call_f_isDateEditEnabled_c0);
  methods += new qt_gsi::GenericMethod ("isGridVisible?|:gridVisible", "@brief Method bool QCalendarWidget::isGridVisible()\n", true, &_init_f_isGridVisible_c0, &_call_f_isGridVisible_c0);
  methods += new qt_gsi::GenericMethod ("isNavigationBarVisible?|:navigationBarVisible", "@brief Method bool QCalendarWidget::isNavigationBarVisible()\n", true, &_init_f_isNavigationBarVisible_c0, &_call_f_isNavigationBarVisible_c0);
  methods += new qt_gsi::GenericMethod (":maximumDate", "@brief Method QDate QCalendarWidget::maximumDate()\n", true, &_init_f_maximumDate_c0, &_call_f_maximumDate_c0);
  methods += new qt_gsi::GenericMethod (":minimumDate", "@brief Method QDate QCalendarWidget::minimumDate()\n", true, &_init_f_minimumDate_c0, &_call_f_minimumDate_c0);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QCalendarWidget::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod ("monthShown", "@brief Method int QCalendarWidget::monthShown()\n", true, &_init_f_monthShown_c0, &_call_f_monthShown_c0);
  methods += new qt_gsi::GenericMethod (":selectedDate", "@brief Method QDate QCalendarWidget::selectedDate()\n", true, &_init_f_selectedDate_c0, &_call_f_selectedDate_c0);
  methods += new qt_gsi::GenericMethod (":selectionMode", "@brief Method QCalendarWidget::SelectionMode QCalendarWidget::selectionMode()\n", true, &_init_f_selectionMode_c0, &_call_f_selectionMode_c0);
  methods += new qt_gsi::GenericMethod ("setCalendar", "@brief Method void QCalendarWidget::setCalendar(QCalendar calendar)\n", false, &_init_f_setCalendar_1311, &_call_f_setCalendar_1311);
  methods += new qt_gsi::GenericMethod ("setCurrentPage", "@brief Method void QCalendarWidget::setCurrentPage(int year, int month)\n", false, &_init_f_setCurrentPage_1426, &_call_f_setCurrentPage_1426);
  methods += new qt_gsi::GenericMethod ("setDateEditAcceptDelay|dateEditAcceptDelay=", "@brief Method void QCalendarWidget::setDateEditAcceptDelay(int delay)\n", false, &_init_f_setDateEditAcceptDelay_767, &_call_f_setDateEditAcceptDelay_767);
  methods += new qt_gsi::GenericMethod ("setDateEditEnabled|dateEditEnabled=", "@brief Method void QCalendarWidget::setDateEditEnabled(bool enable)\n", false, &_init_f_setDateEditEnabled_864, &_call_f_setDateEditEnabled_864);
  methods += new qt_gsi::GenericMethod ("setDateRange", "@brief Method void QCalendarWidget::setDateRange(QDate min, QDate max)\n", false, &_init_f_setDateRange_1690, &_call_f_setDateRange_1690);
  methods += new qt_gsi::GenericMethod ("setDateTextFormat", "@brief Method void QCalendarWidget::setDateTextFormat(QDate date, const QTextCharFormat &format)\n", false, &_init_f_setDateTextFormat_3605, &_call_f_setDateTextFormat_3605);
  methods += new qt_gsi::GenericMethod ("setFirstDayOfWeek|firstDayOfWeek=", "@brief Method void QCalendarWidget::setFirstDayOfWeek(Qt::DayOfWeek dayOfWeek)\n", false, &_init_f_setFirstDayOfWeek_1612, &_call_f_setFirstDayOfWeek_1612);
  methods += new qt_gsi::GenericMethod ("setGridVisible|gridVisible=", "@brief Method void QCalendarWidget::setGridVisible(bool show)\n", false, &_init_f_setGridVisible_864, &_call_f_setGridVisible_864);
  methods += new qt_gsi::GenericMethod ("setHeaderTextFormat|headerTextFormat=", "@brief Method void QCalendarWidget::setHeaderTextFormat(const QTextCharFormat &format)\n", false, &_init_f_setHeaderTextFormat_2814, &_call_f_setHeaderTextFormat_2814);
  methods += new qt_gsi::GenericMethod ("setHorizontalHeaderFormat|horizontalHeaderFormat=", "@brief Method void QCalendarWidget::setHorizontalHeaderFormat(QCalendarWidget::HorizontalHeaderFormat format)\n", false, &_init_f_setHorizontalHeaderFormat_4307, &_call_f_setHorizontalHeaderFormat_4307);
  methods += new qt_gsi::GenericMethod ("setMaximumDate|maximumDate=", "@brief Method void QCalendarWidget::setMaximumDate(QDate date)\n", false, &_init_f_setMaximumDate_899, &_call_f_setMaximumDate_899);
  methods += new qt_gsi::GenericMethod ("setMinimumDate|minimumDate=", "@brief Method void QCalendarWidget::setMinimumDate(QDate date)\n", false, &_init_f_setMinimumDate_899, &_call_f_setMinimumDate_899);
  methods += new qt_gsi::GenericMethod ("setNavigationBarVisible|navigationBarVisible=", "@brief Method void QCalendarWidget::setNavigationBarVisible(bool visible)\n", false, &_init_f_setNavigationBarVisible_864, &_call_f_setNavigationBarVisible_864);
  methods += new qt_gsi::GenericMethod ("setSelectedDate|selectedDate=", "@brief Method void QCalendarWidget::setSelectedDate(QDate date)\n", false, &_init_f_setSelectedDate_899, &_call_f_setSelectedDate_899);
  methods += new qt_gsi::GenericMethod ("setSelectionMode|selectionMode=", "@brief Method void QCalendarWidget::setSelectionMode(QCalendarWidget::SelectionMode mode)\n", false, &_init_f_setSelectionMode_3362, &_call_f_setSelectionMode_3362);
  methods += new qt_gsi::GenericMethod ("setVerticalHeaderFormat|verticalHeaderFormat=", "@brief Method void QCalendarWidget::setVerticalHeaderFormat(QCalendarWidget::VerticalHeaderFormat format)\n", false, &_init_f_setVerticalHeaderFormat_4067, &_call_f_setVerticalHeaderFormat_4067);
  methods += new qt_gsi::GenericMethod ("setWeekdayTextFormat", "@brief Method void QCalendarWidget::setWeekdayTextFormat(Qt::DayOfWeek dayOfWeek, const QTextCharFormat &format)\n", false, &_init_f_setWeekdayTextFormat_4318, &_call_f_setWeekdayTextFormat_4318);
  methods += new qt_gsi::GenericMethod ("showNextMonth", "@brief Method void QCalendarWidget::showNextMonth()\n", false, &_init_f_showNextMonth_0, &_call_f_showNextMonth_0);
  methods += new qt_gsi::GenericMethod ("showNextYear", "@brief Method void QCalendarWidget::showNextYear()\n", false, &_init_f_showNextYear_0, &_call_f_showNextYear_0);
  methods += new qt_gsi::GenericMethod ("showPreviousMonth", "@brief Method void QCalendarWidget::showPreviousMonth()\n", false, &_init_f_showPreviousMonth_0, &_call_f_showPreviousMonth_0);
  methods += new qt_gsi::GenericMethod ("showPreviousYear", "@brief Method void QCalendarWidget::showPreviousYear()\n", false, &_init_f_showPreviousYear_0, &_call_f_showPreviousYear_0);
  methods += new qt_gsi::GenericMethod ("showSelectedDate", "@brief Method void QCalendarWidget::showSelectedDate()\n", false, &_init_f_showSelectedDate_0, &_call_f_showSelectedDate_0);
  methods += new qt_gsi::GenericMethod ("showToday", "@brief Method void QCalendarWidget::showToday()\n", false, &_init_f_showToday_0, &_call_f_showToday_0);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QCalendarWidget::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":verticalHeaderFormat", "@brief Method QCalendarWidget::VerticalHeaderFormat QCalendarWidget::verticalHeaderFormat()\n", true, &_init_f_verticalHeaderFormat_c0, &_call_f_verticalHeaderFormat_c0);
  methods += new qt_gsi::GenericMethod ("weekdayTextFormat", "@brief Method QTextCharFormat QCalendarWidget::weekdayTextFormat(Qt::DayOfWeek dayOfWeek)\n", true, &_init_f_weekdayTextFormat_c1612, &_call_f_weekdayTextFormat_c1612);
  methods += new qt_gsi::GenericMethod ("yearShown", "@brief Method int QCalendarWidget::yearShown()\n", true, &_init_f_yearShown_c0, &_call_f_yearShown_c0);
  methods += gsi::qt_signal<QDate > ("activated(QDate)", "activated", gsi::arg("date"), "@brief Signal declaration for QCalendarWidget::activated(QDate date)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QDate > ("clicked(QDate)", "clicked", gsi::arg("date"), "@brief Signal declaration for QCalendarWidget::clicked(QDate date)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int > ("currentPageChanged(int, int)", "currentPageChanged", gsi::arg("year"), gsi::arg("month"), "@brief Signal declaration for QCalendarWidget::currentPageChanged(int year, int month)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QCalendarWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCalendarWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QCalendarWidget::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("selectionChanged()", "selectionChanged", "@brief Signal declaration for QCalendarWidget::selectionChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QCalendarWidget::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QCalendarWidget::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QCalendarWidget::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCalendarWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QWidget> &qtdecl_QWidget ();

qt_gsi::QtNativeClass<QCalendarWidget> decl_QCalendarWidget (qtdecl_QWidget (), "QtWidgets", "QCalendarWidget_Native",
  methods_QCalendarWidget (),
  "@hide\n@alias QCalendarWidget");

GSI_QTWIDGETS_PUBLIC gsi::Class<QCalendarWidget> &qtdecl_QCalendarWidget () { return decl_QCalendarWidget; }

}


class QCalendarWidget_Adaptor : public QCalendarWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCalendarWidget_Adaptor();

  //  [adaptor ctor] QCalendarWidget::QCalendarWidget(QWidget *parent)
  QCalendarWidget_Adaptor() : QCalendarWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCalendarWidget::QCalendarWidget(QWidget *parent)
  QCalendarWidget_Adaptor(QWidget *parent) : QCalendarWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QCalendarWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QCalendarWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QCalendarWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QCalendarWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QCalendarWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QCalendarWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QCalendarWidget::focusNextChild()
  bool fp_QCalendarWidget_focusNextChild_0 () {
    return QCalendarWidget::focusNextChild();
  }

  //  [expose] bool QCalendarWidget::focusPreviousChild()
  bool fp_QCalendarWidget_focusPreviousChild_0 () {
    return QCalendarWidget::focusPreviousChild();
  }

  //  [expose] bool QCalendarWidget::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCalendarWidget_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCalendarWidget::isSignalConnected(signal);
  }

  //  [expose] int QCalendarWidget::receivers(const char *signal)
  int fp_QCalendarWidget_receivers_c1731 (const char *signal) const {
    return QCalendarWidget::receivers(signal);
  }

  //  [expose] QObject *QCalendarWidget::sender()
  QObject * fp_QCalendarWidget_sender_c0 () const {
    return QCalendarWidget::sender();
  }

  //  [expose] int QCalendarWidget::senderSignalIndex()
  int fp_QCalendarWidget_senderSignalIndex_c0 () const {
    return QCalendarWidget::senderSignalIndex();
  }

  //  [expose] void QCalendarWidget::updateCell(QDate date)
  void fp_QCalendarWidget_updateCell_899 (QDate date) {
    QCalendarWidget::updateCell(date);
  }

  //  [expose] void QCalendarWidget::updateCells()
  void fp_QCalendarWidget_updateCells_0 () {
    QCalendarWidget::updateCells();
  }

  //  [expose] void QCalendarWidget::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QCalendarWidget_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QCalendarWidget::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [emitter impl] void QCalendarWidget::activated(QDate date)
  void emitter_QCalendarWidget_activated_899(QDate date)
  {
    emit QCalendarWidget::activated(date);
  }

  //  [emitter impl] void QCalendarWidget::clicked(QDate date)
  void emitter_QCalendarWidget_clicked_899(QDate date)
  {
    emit QCalendarWidget::clicked(date);
  }

  //  [emitter impl] void QCalendarWidget::currentPageChanged(int year, int month)
  void emitter_QCalendarWidget_currentPageChanged_1426(int year, int month)
  {
    emit QCalendarWidget::currentPageChanged(year, month);
  }

  //  [emitter impl] void QCalendarWidget::customContextMenuRequested(const QPoint &pos)
  void emitter_QCalendarWidget_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QCalendarWidget::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QCalendarWidget::destroyed(QObject *)
  void emitter_QCalendarWidget_destroyed_1302(QObject *arg1)
  {
    emit QCalendarWidget::destroyed(arg1);
  }

  //  [adaptor impl] bool QCalendarWidget::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QCalendarWidget::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QCalendarWidget_Adaptor, bool>(&QCalendarWidget_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QCalendarWidget::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QCalendarWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QCalendarWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QCalendarWidget_Adaptor, int, int>(&QCalendarWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QCalendarWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QCalendarWidget::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QCalendarWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QCalendarWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QCalendarWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QCalendarWidget::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QCalendarWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QCalendarWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QCalendarWidget_Adaptor, QSize>(&QCalendarWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QCalendarWidget::minimumSizeHint();
    }
  }

  //  [emitter impl] void QCalendarWidget::objectNameChanged(const QString &objectName)
  void emitter_QCalendarWidget_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QCalendarWidget::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QCalendarWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QCalendarWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QCalendarWidget_Adaptor, QPaintEngine *>(&QCalendarWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QCalendarWidget::paintEngine();
    }
  }

  //  [emitter impl] void QCalendarWidget::selectionChanged()
  void emitter_QCalendarWidget_selectionChanged_0()
  {
    emit QCalendarWidget::selectionChanged();
  }

  //  [adaptor impl] void QCalendarWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QCalendarWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QCalendarWidget_Adaptor, bool>(&QCalendarWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QCalendarWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QCalendarWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QCalendarWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QCalendarWidget_Adaptor, QSize>(&QCalendarWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QCalendarWidget::sizeHint();
    }
  }

  //  [emitter impl] void QCalendarWidget::windowIconChanged(const QIcon &icon)
  void emitter_QCalendarWidget_windowIconChanged_1787(const QIcon &icon)
  {
    emit QCalendarWidget::windowIconChanged(icon);
  }

  //  [emitter impl] void QCalendarWidget::windowIconTextChanged(const QString &iconText)
  void emitter_QCalendarWidget_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QCalendarWidget::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QCalendarWidget::windowTitleChanged(const QString &title)
  void emitter_QCalendarWidget_windowTitleChanged_2025(const QString &title)
  {
    emit QCalendarWidget::windowTitleChanged(title);
  }

  //  [adaptor impl] void QCalendarWidget::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QCalendarWidget::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QCalendarWidget_Adaptor, QActionEvent *>(&QCalendarWidget_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QCalendarWidget::actionEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QCalendarWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QCalendarWidget_Adaptor, QEvent *>(&QCalendarWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QCalendarWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QCalendarWidget::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCalendarWidget_Adaptor, QChildEvent *>(&QCalendarWidget_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QCalendarWidget::childEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QCalendarWidget::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QCalendarWidget_Adaptor, QCloseEvent *>(&QCalendarWidget_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QCalendarWidget::closeEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QCalendarWidget::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QCalendarWidget_Adaptor, QContextMenuEvent *>(&QCalendarWidget_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QCalendarWidget::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QCalendarWidget::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCalendarWidget_Adaptor, QEvent *>(&QCalendarWidget_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QCalendarWidget::customEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCalendarWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCalendarWidget_Adaptor, const QMetaMethod &>(&QCalendarWidget_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCalendarWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCalendarWidget::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QCalendarWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QCalendarWidget_Adaptor, QDragEnterEvent *>(&QCalendarWidget_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QCalendarWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QCalendarWidget::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QCalendarWidget_Adaptor, QDragLeaveEvent *>(&QCalendarWidget_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QCalendarWidget::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QCalendarWidget::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QCalendarWidget_Adaptor, QDragMoveEvent *>(&QCalendarWidget_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QCalendarWidget::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QCalendarWidget::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QCalendarWidget_Adaptor, QDropEvent *>(&QCalendarWidget_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QCalendarWidget::dropEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QCalendarWidget::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QCalendarWidget_Adaptor, QEnterEvent *>(&QCalendarWidget_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QCalendarWidget::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QCalendarWidget::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QCalendarWidget::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCalendarWidget_Adaptor, bool, QEvent *>(&QCalendarWidget_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QCalendarWidget::event(_event);
    }
  }

  //  [adaptor impl] bool QCalendarWidget::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QCalendarWidget::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCalendarWidget_Adaptor, bool, QObject *, QEvent *>(&QCalendarWidget_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QCalendarWidget::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QCalendarWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QCalendarWidget_Adaptor, QFocusEvent *>(&QCalendarWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QCalendarWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QCalendarWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QCalendarWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QCalendarWidget_Adaptor, bool, bool>(&QCalendarWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QCalendarWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QCalendarWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QCalendarWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QCalendarWidget_Adaptor, QFocusEvent *>(&QCalendarWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QCalendarWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QCalendarWidget::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QCalendarWidget_Adaptor, QHideEvent *>(&QCalendarWidget_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QCalendarWidget::hideEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QCalendarWidget::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QCalendarWidget_Adaptor, QPainter *>(&QCalendarWidget_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QCalendarWidget::initPainter(painter);
    }
  }

  //  [adaptor impl] void QCalendarWidget::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QCalendarWidget::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QCalendarWidget_Adaptor, QInputMethodEvent *>(&QCalendarWidget_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QCalendarWidget::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QCalendarWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QCalendarWidget_Adaptor, QKeyEvent *>(&QCalendarWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QCalendarWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QCalendarWidget::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QCalendarWidget_Adaptor, QKeyEvent *>(&QCalendarWidget_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QCalendarWidget::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QCalendarWidget::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QCalendarWidget_Adaptor, QEvent *>(&QCalendarWidget_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QCalendarWidget::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QCalendarWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QCalendarWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QCalendarWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QCalendarWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QCalendarWidget::metric(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QCalendarWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QCalendarWidget_Adaptor, QMouseEvent *>(&QCalendarWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QCalendarWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QCalendarWidget::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QCalendarWidget_Adaptor, QMouseEvent *>(&QCalendarWidget_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QCalendarWidget::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QCalendarWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QCalendarWidget_Adaptor, QMouseEvent *>(&QCalendarWidget_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QCalendarWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QCalendarWidget::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QCalendarWidget_Adaptor, QMouseEvent *>(&QCalendarWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QCalendarWidget::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QCalendarWidget::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QCalendarWidget_Adaptor, QMoveEvent *>(&QCalendarWidget_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QCalendarWidget::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QCalendarWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QCalendarWidget::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QCalendarWidget_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QCalendarWidget_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QCalendarWidget::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QCalendarWidget::paintCell(QPainter *painter, const QRect &rect, QDate date)
  void cbs_paintCell_c3901_0(QPainter *painter, const QRect &rect, QDate date) const
  {
    QCalendarWidget::paintCell(painter, rect, date);
  }

  virtual void paintCell(QPainter *painter, const QRect &rect, QDate date) const
  {
    if (cb_paintCell_c3901_0.can_issue()) {
      cb_paintCell_c3901_0.issue<QCalendarWidget_Adaptor, QPainter *, const QRect &, QDate>(&QCalendarWidget_Adaptor::cbs_paintCell_c3901_0, painter, rect, date);
    } else {
      QCalendarWidget::paintCell(painter, rect, date);
    }
  }

  //  [adaptor impl] void QCalendarWidget::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QCalendarWidget::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QCalendarWidget_Adaptor, QPaintEvent *>(&QCalendarWidget_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QCalendarWidget::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QCalendarWidget::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QCalendarWidget::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QCalendarWidget_Adaptor, QPaintDevice *, QPoint *>(&QCalendarWidget_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QCalendarWidget::redirected(offset);
    }
  }

  //  [adaptor impl] void QCalendarWidget::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QCalendarWidget::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QCalendarWidget_Adaptor, QResizeEvent *>(&QCalendarWidget_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QCalendarWidget::resizeEvent(event);
    }
  }

  //  [adaptor impl] QPainter *QCalendarWidget::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QCalendarWidget::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QCalendarWidget_Adaptor, QPainter *>(&QCalendarWidget_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QCalendarWidget::sharedPainter();
    }
  }

  //  [adaptor impl] void QCalendarWidget::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QCalendarWidget::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QCalendarWidget_Adaptor, QShowEvent *>(&QCalendarWidget_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QCalendarWidget::showEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QCalendarWidget::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QCalendarWidget_Adaptor, QTabletEvent *>(&QCalendarWidget_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QCalendarWidget::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QCalendarWidget::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCalendarWidget_Adaptor, QTimerEvent *>(&QCalendarWidget_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QCalendarWidget::timerEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QCalendarWidget::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QCalendarWidget_Adaptor, QWheelEvent *>(&QCalendarWidget_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QCalendarWidget::wheelEvent(event);
    }
  }

  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintCell_c3901_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QCalendarWidget_Adaptor::~QCalendarWidget_Adaptor() { }

//  Constructor QCalendarWidget::QCalendarWidget(QWidget *parent) (adaptor class)

static void _init_ctor_QCalendarWidget_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QCalendarWidget_Adaptor> ();
}

static void _call_ctor_QCalendarWidget_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QCalendarWidget_Adaptor *> (new QCalendarWidget_Adaptor (arg1));
}


// void QCalendarWidget::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// emitter void QCalendarWidget::activated(QDate date)

static void _init_emitter_activated_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activated_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_activated_899 (arg1);
}


// void QCalendarWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QCalendarWidget::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QCalendarWidget::clicked(QDate date)

static void _init_emitter_clicked_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_clicked_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_clicked_899 (arg1);
}


// void QCalendarWidget::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QCalendarWidget::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QCalendarWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_create_2208 (arg1, arg2, arg3);
}


// emitter void QCalendarWidget::currentPageChanged(int year, int month)

static void _init_emitter_currentPageChanged_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_currentPageChanged_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_currentPageChanged_1426 (arg1, arg2);
}


// emitter void QCalendarWidget::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_customContextMenuRequested_1916 (arg1);
}


// void QCalendarWidget::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QCalendarWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_destroy_1620 (arg1, arg2);
}


// emitter void QCalendarWidget::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_destroyed_1302 (arg1);
}


// void QCalendarWidget::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QCalendarWidget::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QCalendarWidget::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QCalendarWidget::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QCalendarWidget::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QCalendarWidget::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QCalendarWidget::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCalendarWidget::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QCalendarWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QCalendarWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_focusNextChild_0 ());
}


// bool QCalendarWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QCalendarWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QCalendarWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_focusPreviousChild_0 ());
}


// bool QCalendarWidget::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QCalendarWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QCalendarWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QCalendarWidget::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QCalendarWidget::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QCalendarWidget::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QCalendarWidget::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QCalendarWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QCalendarWidget::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_isSignalConnected_c2394 (arg1));
}


// void QCalendarWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QCalendarWidget::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QCalendarWidget::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QCalendarWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QCalendarWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QCalendarWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QCalendarWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QCalendarWidget::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QCalendarWidget::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QCalendarWidget::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QCalendarWidget::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QCalendarWidget::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QCalendarWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QCalendarWidget::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_objectNameChanged_4567 (arg1);
}


// void QCalendarWidget::paintCell(QPainter *painter, const QRect &rect, QDate date)

static void _init_cbs_paintCell_c3901_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("date");
  decl->add_arg<QDate > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paintCell_c3901_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRect &arg2 = args.read<const QRect & > (heap);
  QDate arg3 = args.read<QDate > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_paintCell_c3901_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paintCell_c3901_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_paintCell_c3901_0 = cb;
}


// QPaintEngine *QCalendarWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QCalendarWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QCalendarWidget::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QCalendarWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_receivers_c1731 (arg1));
}


// QPaintDevice *QCalendarWidget::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QCalendarWidget_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QCalendarWidget::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// emitter void QCalendarWidget::selectionChanged()

static void _init_emitter_selectionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_selectionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_selectionChanged_0 ();
}


// exposed QObject *QCalendarWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_sender_c0 ());
}


// exposed int QCalendarWidget::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_senderSignalIndex_c0 ());
}


// void QCalendarWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QCalendarWidget::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QCalendarWidget_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QCalendarWidget::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QCalendarWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QCalendarWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QCalendarWidget::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QCalendarWidget::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QCalendarWidget::updateCell(QDate date)

static void _init_fp_updateCell_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateCell_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_updateCell_899 (arg1);
}


// exposed void QCalendarWidget::updateCells()

static void _init_fp_updateCells_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateCells_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_updateCells_0 ();
}


// exposed void QCalendarWidget::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_updateMicroFocus_2420 (arg1);
}


// void QCalendarWidget::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCalendarWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QCalendarWidget::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_windowIconChanged_1787 (arg1);
}


// emitter void QCalendarWidget::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_windowIconTextChanged_2025 (arg1);
}


// emitter void QCalendarWidget::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCalendarWidget_Adaptor *)cls)->emitter_QCalendarWidget_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QCalendarWidget> &qtdecl_QCalendarWidget ();

static gsi::Methods methods_QCalendarWidget_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCalendarWidget::QCalendarWidget(QWidget *parent)\nThis method creates an object of class QCalendarWidget.", &_init_ctor_QCalendarWidget_Adaptor_1315, &_call_ctor_QCalendarWidget_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QCalendarWidget::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("emit_activated", "@brief Emitter for signal void QCalendarWidget::activated(QDate date)\nCall this method to emit this signal.", false, &_init_emitter_activated_899, &_call_emitter_activated_899);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QCalendarWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCalendarWidget::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_clicked", "@brief Emitter for signal void QCalendarWidget::clicked(QDate date)\nCall this method to emit this signal.", false, &_init_emitter_clicked_899, &_call_emitter_clicked_899);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QCalendarWidget::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QCalendarWidget::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QCalendarWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_currentPageChanged", "@brief Emitter for signal void QCalendarWidget::currentPageChanged(int year, int month)\nCall this method to emit this signal.", false, &_init_emitter_currentPageChanged_1426, &_call_emitter_currentPageChanged_1426);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QCalendarWidget::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCalendarWidget::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QCalendarWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCalendarWidget::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCalendarWidget::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QCalendarWidget::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QCalendarWidget::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QCalendarWidget::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QCalendarWidget::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QCalendarWidget::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QCalendarWidget::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QCalendarWidget::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QCalendarWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QCalendarWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QCalendarWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QCalendarWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QCalendarWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QCalendarWidget::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QCalendarWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QCalendarWidget::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QCalendarWidget::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QCalendarWidget::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QCalendarWidget::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCalendarWidget::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QCalendarWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QCalendarWidget::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QCalendarWidget::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QCalendarWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QCalendarWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QCalendarWidget::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QCalendarWidget::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QCalendarWidget::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QCalendarWidget::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QCalendarWidget::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QCalendarWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QCalendarWidget::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*paintCell", "@brief Virtual method void QCalendarWidget::paintCell(QPainter *painter, const QRect &rect, QDate date)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintCell_c3901_0, &_call_cbs_paintCell_c3901_0);
  methods += new qt_gsi::GenericMethod ("*paintCell", "@hide", true, &_init_cbs_paintCell_c3901_0, &_call_cbs_paintCell_c3901_0, &_set_callback_cbs_paintCell_c3901_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QCalendarWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QCalendarWidget::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCalendarWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QCalendarWidget::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QCalendarWidget::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("emit_selectionChanged", "@brief Emitter for signal void QCalendarWidget::selectionChanged()\nCall this method to emit this signal.", false, &_init_emitter_selectionChanged_0, &_call_emitter_selectionChanged_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCalendarWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCalendarWidget::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QCalendarWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QCalendarWidget::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QCalendarWidget::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QCalendarWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QCalendarWidget::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCalendarWidget::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateCell", "@brief Method void QCalendarWidget::updateCell(QDate date)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateCell_899, &_call_fp_updateCell_899);
  methods += new qt_gsi::GenericMethod ("*updateCells", "@brief Method void QCalendarWidget::updateCells()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateCells_0, &_call_fp_updateCells_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QCalendarWidget::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QCalendarWidget::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QCalendarWidget::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QCalendarWidget::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QCalendarWidget::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QCalendarWidget_Adaptor> decl_QCalendarWidget_Adaptor (qtdecl_QCalendarWidget (), "QtWidgets", "QCalendarWidget",
  methods_QCalendarWidget_Adaptor (),
  "@qt\n@brief Binding of QCalendarWidget");

}


//  Implementation of the enum wrapper class for QCalendarWidget::HorizontalHeaderFormat
namespace qt_gsi
{

static gsi::Enum<QCalendarWidget::HorizontalHeaderFormat> decl_QCalendarWidget_HorizontalHeaderFormat_Enum ("QtWidgets", "QCalendarWidget_HorizontalHeaderFormat",
    gsi::enum_const ("NoHorizontalHeader", QCalendarWidget::NoHorizontalHeader, "@brief Enum constant QCalendarWidget::NoHorizontalHeader") +
    gsi::enum_const ("SingleLetterDayNames", QCalendarWidget::SingleLetterDayNames, "@brief Enum constant QCalendarWidget::SingleLetterDayNames") +
    gsi::enum_const ("ShortDayNames", QCalendarWidget::ShortDayNames, "@brief Enum constant QCalendarWidget::ShortDayNames") +
    gsi::enum_const ("LongDayNames", QCalendarWidget::LongDayNames, "@brief Enum constant QCalendarWidget::LongDayNames"),
  "@qt\n@brief This class represents the QCalendarWidget::HorizontalHeaderFormat enum");

static gsi::QFlagsClass<QCalendarWidget::HorizontalHeaderFormat > decl_QCalendarWidget_HorizontalHeaderFormat_Enums ("QtWidgets", "QCalendarWidget_QFlags_HorizontalHeaderFormat",
  "@qt\n@brief This class represents the QFlags<QCalendarWidget::HorizontalHeaderFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCalendarWidget> inject_QCalendarWidget_HorizontalHeaderFormat_Enum_in_parent (decl_QCalendarWidget_HorizontalHeaderFormat_Enum.defs ());
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_HorizontalHeaderFormat_Enum_as_child (decl_QCalendarWidget_HorizontalHeaderFormat_Enum, "HorizontalHeaderFormat");
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_HorizontalHeaderFormat_Enums_as_child (decl_QCalendarWidget_HorizontalHeaderFormat_Enums, "QFlags_HorizontalHeaderFormat");

}


//  Implementation of the enum wrapper class for QCalendarWidget::SelectionMode
namespace qt_gsi
{

static gsi::Enum<QCalendarWidget::SelectionMode> decl_QCalendarWidget_SelectionMode_Enum ("QtWidgets", "QCalendarWidget_SelectionMode",
    gsi::enum_const ("NoSelection", QCalendarWidget::NoSelection, "@brief Enum constant QCalendarWidget::NoSelection") +
    gsi::enum_const ("SingleSelection", QCalendarWidget::SingleSelection, "@brief Enum constant QCalendarWidget::SingleSelection"),
  "@qt\n@brief This class represents the QCalendarWidget::SelectionMode enum");

static gsi::QFlagsClass<QCalendarWidget::SelectionMode > decl_QCalendarWidget_SelectionMode_Enums ("QtWidgets", "QCalendarWidget_QFlags_SelectionMode",
  "@qt\n@brief This class represents the QFlags<QCalendarWidget::SelectionMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCalendarWidget> inject_QCalendarWidget_SelectionMode_Enum_in_parent (decl_QCalendarWidget_SelectionMode_Enum.defs ());
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_SelectionMode_Enum_as_child (decl_QCalendarWidget_SelectionMode_Enum, "SelectionMode");
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_SelectionMode_Enums_as_child (decl_QCalendarWidget_SelectionMode_Enums, "QFlags_SelectionMode");

}


//  Implementation of the enum wrapper class for QCalendarWidget::VerticalHeaderFormat
namespace qt_gsi
{

static gsi::Enum<QCalendarWidget::VerticalHeaderFormat> decl_QCalendarWidget_VerticalHeaderFormat_Enum ("QtWidgets", "QCalendarWidget_VerticalHeaderFormat",
    gsi::enum_const ("NoVerticalHeader", QCalendarWidget::NoVerticalHeader, "@brief Enum constant QCalendarWidget::NoVerticalHeader") +
    gsi::enum_const ("ISOWeekNumbers", QCalendarWidget::ISOWeekNumbers, "@brief Enum constant QCalendarWidget::ISOWeekNumbers"),
  "@qt\n@brief This class represents the QCalendarWidget::VerticalHeaderFormat enum");

static gsi::QFlagsClass<QCalendarWidget::VerticalHeaderFormat > decl_QCalendarWidget_VerticalHeaderFormat_Enums ("QtWidgets", "QCalendarWidget_QFlags_VerticalHeaderFormat",
  "@qt\n@brief This class represents the QFlags<QCalendarWidget::VerticalHeaderFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCalendarWidget> inject_QCalendarWidget_VerticalHeaderFormat_Enum_in_parent (decl_QCalendarWidget_VerticalHeaderFormat_Enum.defs ());
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_VerticalHeaderFormat_Enum_as_child (decl_QCalendarWidget_VerticalHeaderFormat_Enum, "VerticalHeaderFormat");
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_VerticalHeaderFormat_Enums_as_child (decl_QCalendarWidget_VerticalHeaderFormat_Enums, "QFlags_VerticalHeaderFormat");

}

