package org.jdom.test.cases;

import static org.junit.Assert.*;
import org.junit.Test;

import org.jdom.JDOMFactory;
import org.jdom.SlimJDOMFactory;
import org.jdom.Text;

@SuppressWarnings("javadoc")
public class TestSlimJDOMFactoryNoText extends AbstractTestJDOMFactory {

	/**
	 * @param located
	 */
	public TestSlimJDOMFactoryNoText() {
		super(false);
	}

	@Override
	protected JDOMFactory buildFactory() {
		return new SlimJDOMFactory(false);
	}

	@Test
	public void testCaching() {
		SlimJDOMFactory fac = new SlimJDOMFactory(false);
		Text ta = fac.text("hi");
		String hi = ta.getText();
		// we expect the StringBin to compact a string value... should no longer
		// be the intern value.
		assertTrue("hi" == hi);
		assertTrue("hi" == hi.intern());
		
		Text tb = fac.text("hi");
		assertTrue("hi" == tb.getText());
		assertTrue(hi == tb.getText());
		
		fac.clearCache();
		
		Text tc = fac.text("hi");
		assertTrue("hi" == tc.getText());
		assertTrue(hi == tc.getText());
		
		assertTrue(hi.equals(tc.getText()));
	}
}
