//start of Factory.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * Factory.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.lang.reflect;

//import classes and interfaces
import java.lang.reflect.Constructor;
import java.text.NumberFormat;

//import exceptions
import java.lang.NoSuchMethodException;
import java.lang.ClassNotFoundException;
import java.lang.InstantiationException;
import java.lang.reflect.InvocationTargetException;

/**
 * NX ɂȂObject ̔z񂩂A
 * createInstance() ɂĐVCX^Xo
 * [eBeBNXB
 * 
 * <pre>
 * -- revision history --
 * $Log: Factory.java,v $
 * Revision 1.0  2002/10/01 00:00:00  dangan
 * first edition
 * add to version control
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class Factory{


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private Factory()
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private Factory(){  }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
	//	create instance
    //------------------------------------------------------------------
    //  public static Object createInstance( String classname, Object[] args )
    //  public static Object createInstance( Class clas, Object[] args )
    //------------------------------------------------------------------
    /**
     * classname ŎNX̃CX^X𐶐B
     * RXgN^ɂ args ̌^ƈv̂gpB
     * 
     * @param classname NX
     * @param args      ̔z
     * 
     * @return ꂽCX^X
     *         args ƌ^񂪃}b`
     *         RXgN^݂Ȃꍇ null
     * 
     * @exception InvocationTargetException
     *                 RXgN^ŗOꍇ
     * 
     * @exception InstantiationException
     *                 abstractNX̃CX^X𓾂悤Ƃꍇ
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Object createInstance( String classname, Object[] args )
                                              throws InvocationTargetException,
                                                     InstantiationException,
                                                     ClassNotFoundException,
                                                     NoSuchMethodException {
        return Factory.createInstance( Class.forName( classname ), args );
    }

    /**
     * type ŎNX̃CX^X𐶐B
     * RXgN^ɂ args ̌^ƈv̂gpB
     * 
     * @param type NX
     * @param args ̔z
     * 
     * @return ꂽCX^X
     *         args ƌ^񂪃}b`
     *         RXgN^݂Ȃꍇ null
     * 
     * @exception InvocationTargetException
     *                 RXgN^ŗOꍇ
     * 
     * @exception InstantiationException
     *                 abstractNX̃CX^X𓾂悤Ƃꍇ
     */
    public static Object createInstance( Class type, Object[] args ) 
                                              throws InvocationTargetException,
                                                     InstantiationException,
                                                     NoSuchMethodException {
        Constructor constructor = Factory.getMatchFullConstructor( type, args );

        if( constructor == null ){
            constructor = Factory.getConstructor( type, args );

            if( constructor != null )
                args        = Type.parseAll( constructor.getParameterTypes(), args );
        }

        if( constructor != null ){
            try{
                return constructor.newInstance( args );
            }catch( IllegalAccessException exception ){
                throw new IllegalAccessError( exception.toString() );
            }
        }else{
            throw new NoSuchMethodException();
        }
    }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
    //  get constructor
    //------------------------------------------------------------------
    //  public static Constructor getConstructor( String   classname,
    //                                            Object[] args )
    //  public static Constructor getConstructor( Class type, Object[] args )
    //  public static Constructor getConstructor( String   classname,
    //                                            Object[] args, boolean all )
    //  public static Constructor getConstructor( Class type,
    //                                            Object[] args, boolean  all )
    //------------------------------------------------------------------
    /**
     * classname ŎNX public ȃRXgN^̂A
     * args  Type.parse ꍇAƂĎ󂯓邱Ƃ
     * ł̂𓾂B
     * 
     * @param classname NXB
     *                  ̌^̃CX^X𐶐邽߂
     *                  RXgN^𓾂B
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨRXgN^ȊÔ̂\B
     * 
     * @return args Ɏ邱ƂłRXgN^B
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Constructor getConstructor( String   classname,
                                              Object[] args ) 
                                                throws  ClassNotFoundException {
        return Factory.getConstructor( Class.forName( classname ),
                                       args );
    }
    
    /**
     * type public ȃRXgN^̂Aargs  
     * Type.parse ꍇ ƂĎ󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B 
     *             ̌^̃CX^X𐶐邽߂̃RXgN^𓾂B
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨRXgN^ȊÔ̂\B
     * 
     * @return args Ɏ邱ƂłRXgN^B
     *         Ȃ nullB
     */
    public static Constructor getConstructor( Class    type,
                                              Object[] args ){
        return Factory.getConstructor( type, args, false );
    }

    /**
     * classnameŎNX RXgN^̂Aargs  
     * Type.parse  ƂĎ󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     *                  ̌^̃CX^X𐶐邽߂̃RXgN^𓾂B
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨRXgN^ȊÔ̂\B
     * @param all  public ̃RXgN^݂̂Ȃ falseB
     *             public, protected, private, pbP[WvCx[g
     *             SẴRXgN^񂳂Ȃ trueB
     * 
     * @return args Ɏ邱ƂłRXgN^B
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Constructor getConstructor( String   classname,
                                              Object[] args,
                                              boolean  all ) 
                                                throws  ClassNotFoundException {
        return Factory.getConstructor( Class.forName( classname ),
                                       args,
                                       all );
    }

    /**
     * type ̃RXgN^̂Aargs  Type.parse ꍇ
     * ƂĎ󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B 
     *             ̌^̃CX^X𐶐邽߂̃RXgN^𓾂B
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨRXgN^ȊÔ̂\B
     * @param all  public ̃RXgN^݂̂Ȃ falseB
     *             public, protected, private, pbP[WvCx[g
     *             SẴRXgN^񂳂Ȃ trueB
     * 
     * @return args Ɏ邱ƂłRXgN^B
     *         Ȃ nullB
     */
    public static Constructor getConstructor( Class    type,
                                              Object[] args,
                                              boolean  all ){
        Constructor[] constructors = all 
                                   ? type.getDeclaredConstructors()
                                   : type.getConstructors();

        for( int i = 0 ; i < constructors.length ; i++ )
            if( Type.matchFullAll( constructors[i].getParameterTypes(), args ) )
                return constructors[i];

        for( int i = 0 ; i < constructors.length ; i++ )
            if( Type.matchRestrictAll( constructors[i].getParameterTypes(), args ) )
                return constructors[i];

        for( int i = 0 ; i < constructors.length ; i++ )
            if( Type.matchAll( constructors[i].getParameterTypes(), args ) )
                return constructors[i];

        
        return null;        
    }


    //------------------------------------------------------------------
	//	shared method
    //------------------------------------------------------------------
    //  get match full constructor
    //------------------------------------------------------------------
    //  public static Constructor getMatchFullConstructor( String   classname,
    //                                                     Object[] args )
    //  public static Constructor getMatchFullConstructor( Class type, 
    //                                                     Object[] args )
    //  public static Constructor getMatchFullConstructor( String   classname,
    //                                            Object[] args, boolean all )
    //  public static Constructor getMatchFullConstructor( Class type, 
    //                                            Object[] args, boolean all )
    //------------------------------------------------------------------
    /**
     * classname ŎNX public ȃRXgN^̂A
     * args  ̂܂܈ƂĎ󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     *                  ̌^̃CX^X𐶐邽߂
     *                  RXgN^𓾂B
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨRXgN^ȊÔ̂\B
     * 
     * @return args Ɏ邱ƂłRXgN^B
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Constructor getMatchFullConstructor( String   classname,
                                                       Object[] args ) 
                                                throws  ClassNotFoundException {
        return Factory.getMatchFullConstructor( Class.forName( classname ),
                                                args );
    }

    /**
     * type  public ȃRXgN^̂Aargs 
     * ̂܂܈ƂĎ󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B 
     *             ̌^̃CX^X𐶐邽߂̃RXgN^𓾂B
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨRXgN^ȊÔ̂\B
     * 
     * @return args Ɏ邱ƂłRXgN^B
     *         Ȃ nullB
     */
    public static Constructor getMatchFullConstructor( Class    type, 
                                                       Object[] args ){
        return Factory.getMatchFullConstructor( type, args, false );
    }

    /**
     * classname ŎNX RXgN^̂A
     * args  ̂܂܈ƂĎ󂯓邱Ƃł̂𓾂B
     * 
     * @param classname NXB
     *                  ̌^̃CX^X𐶐邽߂
     *                  RXgN^𓾂B
     * @param args      zB
     *                  null ܂߂ĂǂAnull gpꍇ
     *                  Object ̃TuNXłΑSă}b`Ă܂߁A
     *                  ړĨRXgN^ȊÔ̂\B
     * 
     * @return args Ɏ邱ƂłRXgN^B
     *         Ȃ nullB
     * 
     * @exception ClassNotFoundException
     *                 classname ŎNX݂Ȃꍇ
     */
    public static Constructor getMatchFullConstructor( String   classname,
                                                       Object[] args,
                                                       boolean  all ) 
                                                throws  ClassNotFoundException {
        return Factory.getMatchFullConstructor( Class.forName( classname ),
                                                args, 
                                                all );
    }

    /**
     * type ̃RXgN^̂Aargs 
     * ̂܂܈ƂĎ󂯓邱Ƃł̂𓾂B
     * 
     * @param type ^B 
     *             ̌^̃CX^X𐶐邽߂̃RXgN^𓾂B
     * @param args zB
     *             null ܂߂ĂǂAnull gpꍇ
     *             Object ̃TuNXłΑSă}b`Ă܂߁A
     *             ړĨRXgN^ȊÔ̂\B
     * @param all  public ̃RXgN^݂̂Ȃ falseB
     *             public, protected, private, pbP[WvCx[g
     *             SẴRXgN^񂳂Ȃ trueB
     * 
     * @return args Ɏ邱ƂłRXgN^B
     *         Ȃ nullB
     */
    public static Constructor getMatchFullConstructor( Class    type, 
                                                       Object[] args,
                                                       boolean  all ){
        Constructor[] constructors = all 
                                   ? type.getDeclaredConstructors()
                                   : type.getConstructors();

        for( int i = 0 ; i < constructors.length ; i++ )
            if( Type.matchFullAll( constructors[i].getParameterTypes(), args ) )
                return constructors[i];
        
        return null;
    }

}
//end of Factory.java
