
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileBarAttributes.h
    \brief Definition of Bar Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef BarAttributes_H
#define BarAttributes_H

#include "magics.h"
#include "GraphShade.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class BarAttributes 
{
public:
//  --  constructor
    BarAttributes();
    
//  --  destructor
    virtual ~BarAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const BarAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string orientation_;
	double width_;
	string bar_style_;
	int thickness_;
	bool clipping_;
	stringarray annotation_;
	double annotation_size_;
	double min_value_;
	Justification justification_;
	LineStyle style_;
	unique_ptr<Colour> line_colour_;
	unique_ptr<Colour> colour_;
	unique_ptr<GraphShade> shade_;
	unique_ptr<Colour> annotation_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const BarAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

