// Identifier type class -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "IdType.h"
#include "LeafValue.h"
#include "Constraint.h"
#include "Range.h"
#include "Printer.h"

/** @file IdType.C
 * Identifier data type
 */

/* Copyright  1998-2001 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

class Value&
IdType::getFirstValue () const
{
  return *new class LeafValue (*this, 0);
}

class Value&
IdType::getLastValue () const
{
  return *new class LeafValue (*this, mySize - 1);
}

card_t
IdType::do_getNumValues () const
{
  assert (!myConstraint);
  return mySize;
}

card_t
IdType::convert (const class Value& value) const
{
  assert (&value.getType () == this);
  assert (!myConstraint);
  return card_t (static_cast<const class LeafValue&>(value));
}

class Value*
IdType::convert (card_t number) const
{
  assert (number < mySize);
  assert (!myConstraint);
  return new class LeafValue (*this, number);
}

#ifdef EXPR_COMPILE
# include "StringBuffer.h"

void
IdType::compileDefinition (class StringBuffer& out,
			   unsigned indent) const
{
  out.indent (indent);
  out.append ("unsigned");
}

void
IdType::do_compileConversion (class StringBuffer& out,
			      unsigned indent,
			      const char* value,
			      const char* number,
			      bool add) const
{
  out.indent (indent);
  out.append (number);
  out.append (add ? "+=" : "=");
  out.append (value);
  out.append (";\n");
}

#endif // EXPR_COMPILE

void
IdType::display (const class Printer& printer) const
{
  printer.printRaw ("id");
  printer.delimiter ('[');
  printer.print (mySize);
  printer.delimiter (']');
  assert (!myConstraint);
}
