"use strict";
/* IMPORT */
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../utils");
var reusable_1 = require("../channels/reusable");
/* HSL */
var HSL = {
    /* VARIABLES */
    re: /^hsla?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(?:deg|grad|rad|turn)?)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(%)?))?\s*?\)$/i,
    hueRe: /^(.+?)(deg|grad|rad|turn)$/i,
    /* HELPERS */
    _hue2deg: function (hue) {
        var match = hue.match(HSL.hueRe);
        if (match) {
            var number = match[1], unit = match[2];
            switch (unit) {
                case 'grad': return utils_1.default.channel.clamp.h(parseFloat(number) * .9);
                case 'rad': return utils_1.default.channel.clamp.h(parseFloat(number) * 180 / Math.PI);
                case 'turn': return utils_1.default.channel.clamp.h(parseFloat(number) * 360);
            }
        }
        return utils_1.default.channel.clamp.h(parseFloat(hue));
    },
    /* API */
    parse: function (color) {
        var charCode = color.charCodeAt(0);
        if (charCode !== 104 && charCode !== 72)
            return; // 'h'/'H'
        var match = color.match(HSL.re);
        if (!match)
            return;
        var h = match[1], s = match[2], l = match[3], a = match[4], isAlphaPercentage = match[5];
        return reusable_1.default.set({
            h: HSL._hue2deg(h),
            s: utils_1.default.channel.clamp.s(parseFloat(s)),
            l: utils_1.default.channel.clamp.l(parseFloat(l)),
            a: a ? utils_1.default.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
        }, color);
    },
    stringify: function (channels) {
        if (channels.a < 1) { // HSLA
            return "hsla(" + utils_1.default.lang.round(channels.h) + ", " + utils_1.default.lang.round(channels.s) + "%, " + utils_1.default.lang.round(channels.l) + "%, " + channels.a + ")";
        }
        else { // HSL
            return "hsl(" + utils_1.default.lang.round(channels.h) + ", " + utils_1.default.lang.round(channels.s) + "%, " + utils_1.default.lang.round(channels.l) + "%)";
        }
    }
};
/* EXPORT */
exports.default = HSL;
