/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.turbine.util.Log;
import org.apache.xerces.utils.Base64;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.chefproject.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Xml {
    public static Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (Exception any) {
            Log.warn("chef", "Xml.createDocument: " + any.toString());
            return null;
        }
    }

    public static Document readDocument(String name) {
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(name), "UTF-8");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(in);
            Document doc = docBuilder.parse(inputSource);
            return doc;
        }
        catch (Exception any) {
            Log.warn("chef", "Xml.readDocument: " + any.toString());
            return null;
        }
    }

    public static Document readDocumentFromString(String in) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(new StringReader(in));
            Document doc = docBuilder.parse(inputSource);
            return doc;
        }
        catch (Exception any) {
            Log.warn("chef", "Xml.readDocumentFromString: " + any.toString());
            return null;
        }
    }

    public static void writeDocument(Document doc, String fileName) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
            XMLSerializer s = new XMLSerializer(out, new OutputFormat("xml", "UTF-8", true));
            s.serialize(doc);
            out.close();
        }
        catch (Exception any) {
            Log.warn("chef", "Xml.writeDocument: " + any.toString());
        }
    }

    public static String writeDocumentToString(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            XMLSerializer s = new XMLSerializer(sw, new OutputFormat("xml", "UTF-8", true));
            s.serialize(doc);
            sw.flush();
            return sw.toString();
        }
        catch (Exception any) {
            Log.warn("chef", "Xml.writeDocumentToString: " + any.toString());
            return null;
        }
    }

    public static void encodeAttribute(Element el, String tag, String value) {
        Base64 b = new Base64();
        try {
            byte[] encoded = Base64.encode((byte[])value.getBytes("UTF-8"));
            String enc = new String(encoded);
            el.setAttribute(tag, enc);
        }
        catch (Exception e) {
            Log.warn("chef", "Xml.encodeAttribute: " + e);
        }
    }

    public static String decodeAttribute(Element el, String tag) {
        String body = StringUtil.trimToNull(el.getAttribute(tag));
        if (body != null) {
            try {
                Base64 b = new Base64();
                byte[] decoded = Base64.decode((byte[])body.getBytes("UTF-8"));
                body = new String(decoded, "UTF-8");
            }
            catch (Exception e) {
                Log.warn("chef", "Xml.decodeAttribute: " + e);
            }
        }
        if (body == null) {
            body = "";
        }
        return body;
    }
}

