///
/// @file  FactorTable.cpp
/// @see   FactorTable.hpp for documentation
///
/// Copyright (C) 2022 Kim Walisch, <kim.walisch@gmail.com>
///
/// This file is distributed under the BSD License. See the COPYING
/// file in the top level directory.
///

#include <BaseFactorTable.hpp>
#include <pod_vector.hpp>

#include <stdint.h>

namespace primecount {

/// This lookup table contains the first 480 numbers
/// that are not divisible by 2, 3, 5, 7 and 11. The
/// size of the table was obtained using the formula:
/// \prod_{i=1}^{5} primes[i] - 1.
///
const pod_array<uint16_t, 480> BaseFactorTable::coprime_ =
{
  1, 13, 17, 19, 23, 29, 31, 37, 41, 43,
  47, 53, 59, 61, 67, 71, 73, 79, 83, 89,
  97, 101, 103, 107, 109, 113, 127, 131, 137, 139,
  149, 151, 157, 163, 167, 169, 173, 179, 181, 191,
  193, 197, 199, 211, 221, 223, 227, 229, 233, 239,
  241, 247, 251, 257, 263, 269, 271, 277, 281, 283,
  289, 293, 299, 307, 311, 313, 317, 323, 331, 337,
  347, 349, 353, 359, 361, 367, 373, 377, 379, 383,
  389, 391, 397, 401, 403, 409, 419, 421, 431, 433,
  437, 439, 443, 449, 457, 461, 463, 467, 479, 481,
  487, 491, 493, 499, 503, 509, 521, 523, 527, 529,
  533, 541, 547, 551, 557, 559, 563, 569, 571, 577,
  587, 589, 593, 599, 601, 607, 611, 613, 617, 619,
  629, 631, 641, 643, 647, 653, 659, 661, 667, 673,
  677, 683, 689, 691, 697, 701, 703, 709, 713, 719,
  727, 731, 733, 739, 743, 751, 757, 761, 767, 769,
  773, 779, 787, 793, 797, 799, 809, 811, 817, 821,
  823, 827, 829, 839, 841, 851, 853, 857, 859, 863,
  871, 877, 881, 883, 887, 893, 899, 901, 907, 911,
  919, 923, 929, 937, 941, 943, 947, 949, 953, 961,
  967, 971, 977, 983, 989, 991, 997, 1003, 1007, 1009,
  1013, 1019, 1021, 1027, 1031, 1033, 1037, 1039, 1049, 1051,
  1061, 1063, 1069, 1073, 1079, 1081, 1087, 1091, 1093, 1097,
  1103, 1109, 1117, 1121, 1123, 1129, 1139, 1147, 1151, 1153,
  1157, 1159, 1163, 1171, 1181, 1187, 1189, 1193, 1201, 1207,
  1213, 1217, 1219, 1223, 1229, 1231, 1237, 1241, 1247, 1249,
  1259, 1261, 1271, 1273, 1277, 1279, 1283, 1289, 1291, 1297,
  1301, 1303, 1307, 1313, 1319, 1321, 1327, 1333, 1339, 1343,
  1349, 1357, 1361, 1363, 1367, 1369, 1373, 1381, 1387, 1391,
  1399, 1403, 1409, 1411, 1417, 1423, 1427, 1429, 1433, 1439,
  1447, 1451, 1453, 1457, 1459, 1469, 1471, 1481, 1483, 1487,
  1489, 1493, 1499, 1501, 1511, 1513, 1517, 1523, 1531, 1537,
  1541, 1543, 1549, 1553, 1559, 1567, 1571, 1577, 1579, 1583,
  1591, 1597, 1601, 1607, 1609, 1613, 1619, 1621, 1627, 1633,
  1637, 1643, 1649, 1651, 1657, 1663, 1667, 1669, 1679, 1681,
  1691, 1693, 1697, 1699, 1703, 1709, 1711, 1717, 1721, 1723,
  1733, 1739, 1741, 1747, 1751, 1753, 1759, 1763, 1769, 1777,
  1781, 1783, 1787, 1789, 1801, 1807, 1811, 1817, 1819, 1823,
  1829, 1831, 1843, 1847, 1849, 1853, 1861, 1867, 1871, 1873,
  1877, 1879, 1889, 1891, 1901, 1907, 1909, 1913, 1919, 1921,
  1927, 1931, 1933, 1937, 1943, 1949, 1951, 1957, 1961, 1963,
  1973, 1979, 1987, 1993, 1997, 1999, 2003, 2011, 2017, 2021,
  2027, 2029, 2033, 2039, 2041, 2047, 2053, 2059, 2063, 2069,
  2071, 2077, 2081, 2083, 2087, 2089, 2099, 2111, 2113, 2117,
  2119, 2129, 2131, 2137, 2141, 2143, 2147, 2153, 2159, 2161,
  2171, 2173, 2179, 2183, 2197, 2201, 2203, 2207, 2209, 2213,
  2221, 2227, 2231, 2237, 2239, 2243, 2249, 2251, 2257, 2263,
  2267, 2269, 2273, 2279, 2281, 2287, 2291, 2293, 2297, 2309
};

/// This lookup table returns the index of the closest
/// number <= n that is not divisible by 2, 3, 5, 7
/// and 11. The size of the table was obtained using the
/// formula: \prod_{i=1}^{5} primes[i].
///
const pod_array<int16_t, 2310> BaseFactorTable::coprime_indexes_ =
{
 -1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 1, 1, 1, 1, 2, 2, 3,
  3, 3, 3, 4, 4, 4, 4, 4, 4, 5,
  5, 6, 6, 6, 6, 6, 6, 7, 7, 7,
  7, 8, 8, 9, 9, 9, 9, 10, 10, 10,
  10, 10, 10, 11, 11, 11, 11, 11, 11, 12,
  12, 13, 13, 13, 13, 13, 13, 14, 14, 14,
  14, 15, 15, 16, 16, 16, 16, 16, 16, 17,
  17, 17, 17, 18, 18, 18, 18, 18, 18, 19,
  19, 19, 19, 19, 19, 19, 19, 20, 20, 20,
  20, 21, 21, 22, 22, 22, 22, 23, 23, 24,
  24, 24, 24, 25, 25, 25, 25, 25, 25, 25,
  25, 25, 25, 25, 25, 25, 25, 26, 26, 26,
  26, 27, 27, 27, 27, 27, 27, 28, 28, 29,
  29, 29, 29, 29, 29, 29, 29, 29, 29, 30,
  30, 31, 31, 31, 31, 31, 31, 32, 32, 32,
  32, 32, 32, 33, 33, 33, 33, 34, 34, 35,
  35, 35, 35, 36, 36, 36, 36, 36, 36, 37,
  37, 38, 38, 38, 38, 38, 38, 38, 38, 38,
  38, 39, 39, 40, 40, 40, 40, 41, 41, 42,
  42, 42, 42, 42, 42, 42, 42, 42, 42, 42,
  42, 43, 43, 43, 43, 43, 43, 43, 43, 43,
  43, 44, 44, 45, 45, 45, 45, 46, 46, 47,
  47, 47, 47, 48, 48, 48, 48, 48, 48, 49,
  49, 50, 50, 50, 50, 50, 50, 51, 51, 51,
  51, 52, 52, 52, 52, 52, 52, 53, 53, 53,
  53, 53, 53, 54, 54, 54, 54, 54, 54, 55,
  55, 56, 56, 56, 56, 56, 56, 57, 57, 57,
  57, 58, 58, 59, 59, 59, 59, 59, 59, 60,
  60, 60, 60, 61, 61, 61, 61, 61, 61, 62,
  62, 62, 62, 62, 62, 62, 62, 63, 63, 63,
  63, 64, 64, 65, 65, 65, 65, 66, 66, 66,
  66, 66, 66, 67, 67, 67, 67, 67, 67, 67,
  67, 68, 68, 68, 68, 68, 68, 69, 69, 69,
  69, 69, 69, 69, 69, 69, 69, 70, 70, 71,
  71, 71, 71, 72, 72, 72, 72, 72, 72, 73,
  73, 74, 74, 74, 74, 74, 74, 75, 75, 75,
  75, 75, 75, 76, 76, 76, 76, 77, 77, 78,
  78, 78, 78, 79, 79, 79, 79, 79, 79, 80,
  80, 81, 81, 81, 81, 81, 81, 82, 82, 82,
  82, 83, 83, 84, 84, 84, 84, 84, 84, 85,
  85, 85, 85, 85, 85, 85, 85, 85, 85, 86,
  86, 87, 87, 87, 87, 87, 87, 87, 87, 87,
  87, 88, 88, 89, 89, 89, 89, 90, 90, 91,
  91, 91, 91, 92, 92, 92, 92, 92, 92, 93,
  93, 93, 93, 93, 93, 93, 93, 94, 94, 94,
  94, 95, 95, 96, 96, 96, 96, 97, 97, 97,
  97, 97, 97, 97, 97, 97, 97, 97, 97, 98,
  98, 99, 99, 99, 99, 99, 99, 100, 100, 100,
  100, 101, 101, 102, 102, 102, 102, 102, 102, 103,
  103, 103, 103, 104, 104, 104, 104, 104, 104, 105,
  105, 105, 105, 105, 105, 105, 105, 105, 105, 105,
  105, 106, 106, 107, 107, 107, 107, 108, 108, 109,
  109, 109, 109, 110, 110, 110, 110, 110, 110, 110,
  110, 111, 111, 111, 111, 111, 111, 112, 112, 112,
  112, 113, 113, 113, 113, 113, 113, 114, 114, 115,
  115, 115, 115, 116, 116, 116, 116, 116, 116, 117,
  117, 118, 118, 118, 118, 118, 118, 119, 119, 119,
  119, 119, 119, 119, 119, 119, 119, 120, 120, 121,
  121, 121, 121, 122, 122, 122, 122, 122, 122, 123,
  123, 124, 124, 124, 124, 124, 124, 125, 125, 125,
  125, 126, 126, 127, 127, 127, 127, 128, 128, 129,
  129, 129, 129, 129, 129, 129, 129, 129, 129, 130,
  130, 131, 131, 131, 131, 131, 131, 131, 131, 131,
  131, 132, 132, 133, 133, 133, 133, 134, 134, 134,
  134, 134, 134, 135, 135, 135, 135, 135, 135, 136,
  136, 137, 137, 137, 137, 137, 137, 138, 138, 138,
  138, 138, 138, 139, 139, 139, 139, 140, 140, 140,
  140, 140, 140, 141, 141, 141, 141, 141, 141, 142,
  142, 143, 143, 143, 143, 143, 143, 144, 144, 144,
  144, 145, 145, 146, 146, 146, 146, 146, 146, 147,
  147, 147, 147, 148, 148, 148, 148, 148, 148, 149,
  149, 149, 149, 149, 149, 149, 149, 150, 150, 150,
  150, 151, 151, 152, 152, 152, 152, 152, 152, 153,
  153, 153, 153, 154, 154, 154, 154, 154, 154, 154,
  154, 155, 155, 155, 155, 155, 155, 156, 156, 156,
  156, 157, 157, 157, 157, 157, 157, 158, 158, 159,
  159, 159, 159, 160, 160, 160, 160, 160, 160, 161,
  161, 161, 161, 161, 161, 161, 161, 162, 162, 162,
  162, 162, 162, 163, 163, 163, 163, 164, 164, 165,
  165, 165, 165, 165, 165, 165, 165, 165, 165, 166,
  166, 167, 167, 167, 167, 167, 167, 168, 168, 168,
  168, 169, 169, 170, 170, 170, 170, 171, 171, 172,
  172, 172, 172, 172, 172, 172, 172, 172, 172, 173,
  173, 174, 174, 174, 174, 174, 174, 174, 174, 174,
  174, 175, 175, 176, 176, 176, 176, 177, 177, 178,
  178, 178, 178, 179, 179, 179, 179, 179, 179, 179,
  179, 180, 180, 180, 180, 180, 180, 181, 181, 181,
  181, 182, 182, 183, 183, 183, 183, 184, 184, 184,
  184, 184, 184, 185, 185, 185, 185, 185, 185, 186,
  186, 187, 187, 187, 187, 187, 187, 188, 188, 188,
  188, 189, 189, 189, 189, 189, 189, 189, 189, 190,
  190, 190, 190, 191, 191, 191, 191, 191, 191, 192,
  192, 192, 192, 192, 192, 192, 192, 193, 193, 193,
  193, 194, 194, 195, 195, 195, 195, 196, 196, 197,
  197, 197, 197, 198, 198, 198, 198, 198, 198, 198,
  198, 199, 199, 199, 199, 199, 199, 200, 200, 200,
  200, 201, 201, 201, 201, 201, 201, 202, 202, 202,
  202, 202, 202, 203, 203, 203, 203, 203, 203, 204,
  204, 205, 205, 205, 205, 205, 205, 206, 206, 206,
  206, 206, 206, 207, 207, 207, 207, 208, 208, 209,
  209, 209, 209, 210, 210, 210, 210, 210, 210, 211,
  211, 212, 212, 212, 212, 212, 212, 213, 213, 213,
  213, 214, 214, 215, 215, 215, 215, 216, 216, 217,
  217, 217, 217, 217, 217, 217, 217, 217, 217, 218,
  218, 219, 219, 219, 219, 219, 219, 219, 219, 219,
  219, 220, 220, 221, 221, 221, 221, 221, 221, 222,
  222, 222, 222, 223, 223, 223, 223, 223, 223, 224,
  224, 225, 225, 225, 225, 225, 225, 226, 226, 226,
  226, 227, 227, 228, 228, 228, 228, 229, 229, 229,
  229, 229, 229, 230, 230, 230, 230, 230, 230, 231,
  231, 231, 231, 231, 231, 231, 231, 232, 232, 232,
  232, 233, 233, 234, 234, 234, 234, 234, 234, 235,
  235, 235, 235, 235, 235, 235, 235, 235, 235, 236,
  236, 236, 236, 236, 236, 236, 236, 237, 237, 237,
  237, 238, 238, 239, 239, 239, 239, 240, 240, 241,
  241, 241, 241, 242, 242, 242, 242, 242, 242, 242,
  242, 243, 243, 243, 243, 243, 243, 243, 243, 243,
  243, 244, 244, 244, 244, 244, 244, 245, 245, 246,
  246, 246, 246, 247, 247, 247, 247, 247, 247, 247,
  247, 248, 248, 248, 248, 248, 248, 249, 249, 249,
  249, 249, 249, 250, 250, 250, 250, 251, 251, 252,
  252, 252, 252, 253, 253, 253, 253, 253, 253, 254,
  254, 255, 255, 255, 255, 255, 255, 256, 256, 256,
  256, 257, 257, 257, 257, 257, 257, 258, 258, 259,
  259, 259, 259, 259, 259, 259, 259, 259, 259, 260,
  260, 261, 261, 261, 261, 261, 261, 261, 261, 261,
  261, 262, 262, 263, 263, 263, 263, 264, 264, 265,
  265, 265, 265, 266, 266, 266, 266, 266, 266, 267,
  267, 268, 268, 268, 268, 268, 268, 269, 269, 269,
  269, 270, 270, 271, 271, 271, 271, 272, 272, 272,
  272, 272, 272, 273, 273, 273, 273, 273, 273, 274,
  274, 275, 275, 275, 275, 275, 275, 276, 276, 276,
  276, 276, 276, 277, 277, 277, 277, 277, 277, 278,
  278, 278, 278, 279, 279, 279, 279, 279, 279, 280,
  280, 280, 280, 280, 280, 280, 280, 281, 281, 281,
  281, 282, 282, 283, 283, 283, 283, 284, 284, 285,
  285, 285, 285, 286, 286, 286, 286, 286, 286, 286,
  286, 287, 287, 287, 287, 287, 287, 288, 288, 288,
  288, 289, 289, 289, 289, 289, 289, 289, 289, 290,
  290, 290, 290, 291, 291, 291, 291, 291, 291, 292,
  292, 293, 293, 293, 293, 293, 293, 294, 294, 294,
  294, 294, 294, 295, 295, 295, 295, 296, 296, 297,
  297, 297, 297, 298, 298, 298, 298, 298, 298, 299,
  299, 299, 299, 299, 299, 299, 299, 300, 300, 300,
  300, 301, 301, 302, 302, 302, 302, 303, 303, 304,
  304, 304, 304, 304, 304, 304, 304, 304, 304, 305,
  305, 306, 306, 306, 306, 306, 306, 306, 306, 306,
  306, 307, 307, 308, 308, 308, 308, 309, 309, 310,
  310, 310, 310, 311, 311, 311, 311, 311, 311, 312,
  312, 313, 313, 313, 313, 313, 313, 313, 313, 313,
  313, 314, 314, 315, 315, 315, 315, 316, 316, 316,
  316, 316, 316, 317, 317, 317, 317, 317, 317, 317,
  317, 318, 318, 318, 318, 318, 318, 319, 319, 319,
  319, 320, 320, 321, 321, 321, 321, 321, 321, 322,
  322, 322, 322, 323, 323, 323, 323, 323, 323, 324,
  324, 324, 324, 324, 324, 324, 324, 325, 325, 325,
  325, 326, 326, 326, 326, 326, 326, 327, 327, 328,
  328, 328, 328, 329, 329, 329, 329, 329, 329, 329,
  329, 330, 330, 330, 330, 330, 330, 331, 331, 331,
  331, 332, 332, 332, 332, 332, 332, 333, 333, 334,
  334, 334, 334, 335, 335, 335, 335, 335, 335, 336,
  336, 337, 337, 337, 337, 337, 337, 338, 338, 338,
  338, 338, 338, 339, 339, 339, 339, 340, 340, 340,
  340, 340, 340, 341, 341, 341, 341, 341, 341, 342,
  342, 343, 343, 343, 343, 343, 343, 344, 344, 344,
  344, 344, 344, 345, 345, 345, 345, 346, 346, 347,
  347, 347, 347, 347, 347, 347, 347, 347, 347, 348,
  348, 349, 349, 349, 349, 349, 349, 349, 349, 349,
  349, 350, 350, 351, 351, 351, 351, 352, 352, 353,
  353, 353, 353, 354, 354, 354, 354, 354, 354, 355,
  355, 356, 356, 356, 356, 356, 356, 357, 357, 357,
  357, 358, 358, 359, 359, 359, 359, 359, 359, 359,
  359, 359, 359, 360, 360, 360, 360, 360, 360, 361,
  361, 362, 362, 362, 362, 362, 362, 363, 363, 363,
  363, 364, 364, 365, 365, 365, 365, 365, 365, 366,
  366, 366, 366, 367, 367, 367, 367, 367, 367, 368,
  368, 368, 368, 368, 368, 368, 368, 369, 369, 369,
  369, 370, 370, 371, 371, 371, 371, 372, 372, 373,
  373, 373, 373, 373, 373, 373, 373, 373, 373, 373,
  373, 374, 374, 374, 374, 374, 374, 375, 375, 375,
  375, 376, 376, 376, 376, 376, 376, 377, 377, 378,
  378, 378, 378, 379, 379, 379, 379, 379, 379, 380,
  380, 381, 381, 381, 381, 381, 381, 381, 381, 381,
  381, 381, 381, 382, 382, 382, 382, 383, 383, 384,
  384, 384, 384, 385, 385, 385, 385, 385, 385, 385,
  385, 386, 386, 386, 386, 386, 386, 387, 387, 387,
  387, 388, 388, 389, 389, 389, 389, 390, 390, 391,
  391, 391, 391, 391, 391, 391, 391, 391, 391, 392,
  392, 393, 393, 393, 393, 393, 393, 393, 393, 393,
  393, 394, 394, 394, 394, 394, 394, 395, 395, 396,
  396, 396, 396, 397, 397, 397, 397, 397, 397, 398,
  398, 399, 399, 399, 399, 399, 399, 400, 400, 400,
  400, 401, 401, 402, 402, 402, 402, 403, 403, 403,
  403, 403, 403, 404, 404, 404, 404, 404, 404, 405,
  405, 406, 406, 406, 406, 406, 406, 407, 407, 407,
  407, 408, 408, 409, 409, 409, 409, 409, 409, 409,
  409, 409, 409, 410, 410, 410, 410, 410, 410, 411,
  411, 411, 411, 411, 411, 411, 411, 412, 412, 412,
  412, 412, 412, 413, 413, 413, 413, 414, 414, 415,
  415, 415, 415, 416, 416, 416, 416, 416, 416, 416,
  416, 417, 417, 417, 417, 417, 417, 418, 418, 418,
  418, 419, 419, 419, 419, 419, 419, 420, 420, 421,
  421, 421, 421, 422, 422, 422, 422, 422, 422, 423,
  423, 424, 424, 424, 424, 424, 424, 425, 425, 425,
  425, 425, 425, 426, 426, 426, 426, 426, 426, 427,
  427, 427, 427, 428, 428, 428, 428, 428, 428, 429,
  429, 430, 430, 430, 430, 430, 430, 431, 431, 431,
  431, 432, 432, 433, 433, 433, 433, 434, 434, 435,
  435, 435, 435, 435, 435, 435, 435, 435, 435, 436,
  436, 436, 436, 436, 436, 436, 436, 436, 436, 436,
  436, 437, 437, 438, 438, 438, 438, 439, 439, 440,
  440, 440, 440, 440, 440, 440, 440, 440, 440, 441,
  441, 442, 442, 442, 442, 442, 442, 443, 443, 443,
  443, 444, 444, 445, 445, 445, 445, 446, 446, 446,
  446, 446, 446, 447, 447, 447, 447, 447, 447, 448,
  448, 449, 449, 449, 449, 449, 449, 449, 449, 449,
  449, 450, 450, 451, 451, 451, 451, 451, 451, 452,
  452, 452, 452, 453, 453, 453, 453, 453, 453, 453,
  453, 453, 453, 453, 453, 453, 453, 454, 454, 454,
  454, 455, 455, 456, 456, 456, 456, 457, 457, 458,
  458, 458, 458, 459, 459, 459, 459, 459, 459, 459,
  459, 460, 460, 460, 460, 460, 460, 461, 461, 461,
  461, 462, 462, 462, 462, 462, 462, 463, 463, 464,
  464, 464, 464, 465, 465, 465, 465, 465, 465, 466,
  466, 467, 467, 467, 467, 467, 467, 468, 468, 468,
  468, 468, 468, 469, 469, 469, 469, 470, 470, 471,
  471, 471, 471, 472, 472, 472, 472, 472, 472, 473,
  473, 474, 474, 474, 474, 474, 474, 475, 475, 475,
  475, 476, 476, 477, 477, 477, 477, 478, 478, 478,
  478, 478, 478, 478, 478, 478, 478, 478, 478, 479
};

} // namespace
