% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_multiple.R
\name{combine_models}
\alias{combine_models}
\title{Combine Models fitted with \pkg{brms}}
\usage{
combine_models(..., mlist = NULL, check_data = TRUE)
}
\arguments{
\item{...}{One or more \code{brmsfit} objects.}

\item{mlist}{Optional list of one or more \code{brmsfit} objects.}

\item{check_data}{Logical; indicates if the data should be checked
for being the same across models (defaults to \code{TRUE}).
Setting it to \code{FALSE} may be useful for instance
when combining models fitted on multiple imputed data sets.}
}
\value{
A \code{brmsfit} object.
}
\description{
Combine multiple \code{brmsfit} objects, which fitted the same model.
This is usefuly for instance when having manually run models in parallel.
}
\details{
This function just takes the first model and replaces 
  its \code{stanfit} object (slot \code{fit}) by the combined 
  \code{stanfit} objects of all models.
}
