% This LilyPond file was generated by Rosegarden 22.06
\include "nederlands.ly"
\version "2.12.0"
\header {
    composer = "Steve Conrad"
    copyright = "2005"
    subtitle = "Apologies to Page, Plant et al"
    title = "Djer Fire"
    tagline = "Created using Rosegarden 22.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 18/8
    \skip 4.*102 
}
globalTempo = {
    \override Score.MetronomeMark #'transparent = ##t
    \tempo 4 = 150  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn #'force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering #'staff-padding = #'()

        \context Staff = "track 1, gtr" << 
            \set Staff.instrumentName = \markup { \center-column { "gtr " } }
            \set Staff.midiInstrument = "Acoustic Guitar (nylon)"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 1" {
                % Segment: SBLive #3 (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*6 
                \repeat unfold 3 {
                    \clef "treble_8"
                    b 16 c' e' 8 g' [ e' ] c' ) [ < g' c'' > 16 _~ < a' c'' > ] g' 8 [ e' ] g' [ c'' ) ] g 16 a c' 8 e' [ c' ] a ) [ < d' b' > ] < e' c'' > [ a ) ]  |
                    e 16 f a 8 c' [ a ] f ) [ < c' f' > 16 _~ < d' f' > ] c' 8 [ a ] c' [ f' ) ] f 16 g b 8 d' [ b ] g ) [ < c' a' > ] < d' b' > [ g ) ]  |
                } % close repeat
            } % Voice

            \context Voice = "voice 2" {
                % Segment: SBLive #3 (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*42 
                \clef "treble_8"
                a 64 _~ [ < a c' > _~ < a e' c' > _~ < a a' e' c' > _~ ] < e' a' a c' > 8. _~ < a' c' e' a > 4 _~ < a' c' e' g > < e a > 64 _~ [ < e c' a > _~ < e c' e' a > _~ < e a' c' e' a > _~ ] < a' e' e c' a > 8. _~ < a' e' c' e a > 4 _~ < a' g, d g c' e' > < a, a e > 64 _~ [ < a, a c' e > _~ < a, a e' c' e > _~ < a, a' a e' c' e > _~ ] < e' a' a, a c' e > 8. _~ < a' a, a c' e' e > 4 _~ < a' a, e a c' e' >  |
                r4. r r r r r  |
            } % Voice

            \context Voice = "voice 3" {
                % Segment: SBLive #3 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*54 
                \repeat unfold 3 {
%% 10
                    \clef "treble_8"
                    b 16 c' e' 8 g' [ e' ] c' ) [ < g' c'' > 16 _~ < a' c'' > ] g' 8 [ e' ] g' [ c'' ) ] g 16 a c' 8 e' [ c' ] a ) [ < d' b' > ] < e' c'' > [ a ) ]  |
                    e 16 f a 8 c' [ a ] f ) [ < c' f' > 16 _~ < d' f' > ] c' 8 [ a ] c' [ f' ) ] f 16 g b 8 d' [ b ] g ) [ < c' a' > ] < d' b' > [ g ) ]  |
                } % close repeat
            } % Voice

            \context Voice = "voice 4" {
                % Segment: SBLive #3
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*90 
                \clef "treble_8"
                a 64 _~ [ < a c' > _~ < a e' c' > _~ < a a' e' c' > _~ ] < e' a' a c' > 8. _~ < a' c' e' a > 4 _~ < a' c' e' g > < e a > 64 _~ [ < e c' a > _~ < e c' e' a > _~ < e a' c' e' a > _~ ] < a' e' e c' a > 8. _~ < a' e' c' e a > 4 _~ < a' g, d g c' e' > < a, a e > 64 _~ [ < a, a c' e > _~ < a, a e' c' e > _~ < a, a' a e' c' e > _~ ] < e' a' a, a c' e > 8. _~ < a' a, a c' e' e > 4 _~ < a' a, e a c' e' >  |
                r4. r r r r r  |
            } % Voice

            \context Voice = "voice 5" {
                % Segment: Nylon Guitar
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*102 
                \clef "treble_8"
                < e a, > 8 \times 2/3 { a' 64 _~ [ < a' e' > _~ < a' e' c' > _~ ] } < a' e' c' > 16. _~ < a' e' c' > 8 < e a a, > \times 2/3 { e 64 _~ [ < e a > _~ < e a c' > _~ ] } < c' a e > 16. _~ < c' a e > 8 a, a, < e a, > \times 2/3 { a' 64 _~ [ < a' e' > _~ < a' e' c' > _~ ] } < a' e' c' > 16. _~ < a' e' c' > 8 < a e a, > \times 2/3 { e 64 _~ [ < e a > _~ < e c' a > _~ ] } < a c' e > 16. _~ < c' e a > 8 a, 4 aes,  |
                < d g, > 8 \times 2/3 { g' 64 _~ [ < g' d' > _~ < g' d' b > _~ ] } < g' d' b > 16. _~ < g' d' b > 8 < g d g, > \times 2/3 { d 64 _~ [ < d g > _~ < d b g > _~ ] } < g b d > 16. _~ < b d g > 8 g, g, < d g, > \times 2/3 { g' 64 _~ [ < g' d' > _~ < g' d' b > _~ ] } < g' d' b > 16. _~ < g' d' b > 8 < d g g, > \times 2/3 { d 64 _~ [ < d g > _~ < d g b > _~ ] } < b g d > 16. _~ < b g d > 8 g, 4 aes,  |
%% 20
                < e a, > 8 \times 2/3 { a' 64 _~ [ < a' e' > _~ < a' e' c' > _~ ] } < a' e' c' > 16. _~ < a' e' c' > 8 < a e a, > \times 2/3 { e 64 _~ [ < e a > _~ < e c' a > _~ ] } < a c' e > 16. _~ < c' e a > 8 a, a, < e a, > \times 2/3 { a' 64 _~ [ < a' e' > _~ < a' e' c' > _~ ] } < a' e' c' > 16. _~ < a' e' c' > 8 < e a a, > \times 2/3 { e 64 _~ [ < e a > _~ < e a c' > _~ ] } < c' a e > 16. _~ < c' a e > 8 a, 4 aes,  |
                < d g, > 8 \times 2/3 { g' 64 _~ [ < d' g' > _~ < d' g' b > _~ ] } < d' g' b > 16. _~ < g' d' b > 8 < g d g, > \times 2/3 { d 64 _~ [ < d g > _~ < d g b > _~ ] } < b g d > 16. _~ < b g d > 8 g, g, < d g, > \times 2/3 { g' 64 _~ [ < d' g' > _~ < d' g' b > _~ ] } < d' g' b > 16. _~ < g' d' b > 8 < g d g, > \times 2/3 { d 64 _~ [ < d g > _~ < d b g > _~ ] } < b g d > 16. _~ < b g d > 8 g, 4 aes,  |
                < e a, > 8 \times 2/3 { a' 64 _~ [ < a' e' > _~ < a' e' c' > _~ ] } < a' e' c' > 16. _~ < a' e' c' > 8 < a e a, > \times 2/3 { e 64 _~ [ < e a > _~ < e c' a > _~ ] } < a c' e > 16. _~ < c' e a > 8 a, a, < e a, > \times 2/3 { a' 64 _~ [ < a' e' > _~ < a' e' c' > _~ ] } < a' e' c' > 16. _~ < a' e' c' > 8 < e a a, > \times 2/3 { e 64 _~ [ < e a > _~ < e a c' > _~ ] } < c' a e > 16. _~ < c' a e > 8 a, 4 aes,  |
                < d g, > 8 \times 2/3 { g' 64 _~ [ < d' g' > _~ < d' g' b > _~ ] } < d' g' b > 16. _~ < g' d' b > 8 < g d g, > \times 2/3 { d 64 _~ [ < d g > _~ < d g b > _~ ] } < b g d > 16. _~ < b g d > 8 g, g, < d g, > \times 2/3 { g' 64 _~ [ < d' g' > _~ < d' g' b > _~ ] } < d' g' b > 16. _~ < g' d' b > 8 < g d g, > \times 2/3 { d 64 _~ [ < d g > _~ < d b g > _~ ] } < b g d > 16. _~ < b g d > 8 g, 4 e,  |
                f, 8 _~ [ < c f, > ] < c' a > [ f ] < c f > [ < a c' > ] f [ < f c > _~ ] < a f c > [ c _~ ] < f c > _~ [ < a f c > ] < f' c' > [ a ] f < g c' > 32 _~ < a c' > 16. f 8 [ f, 16 fis, ]  |
%% 25
                g, 8 _~ [ < g, d > ] < b d' > [ g ] < d g > [ < b d' > ] g [ < d g > _~ ] < d b g > [ d _~ ] < d g > _~ [ < d b g > ] < g' d' > [ b ] g < d' a > 32 _~ < d' b > 16. g 8 [ g, 16 a, ]  |
            } % Voice

            \context Voice = "voice 6" {
                % Segment: SBLive #3
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*150 
                \repeat unfold 3 {
                    \clef "treble_8"
                    b 16 ^( c' e' 8 g' [ e' ] c' ) [ < g' c'' > 16 ^( _~ < a' c'' > ] g' 8 [ e' ] g' [ c'' ) ] g 16 ^( a c' 8 e' [ c' ] a ) [ < d' b' > ^( ] < e' c'' > [ a ) ]  |
                    e 16 ^( f a 8 c' [ a ] f ) [ < c' f' > 16 ^( _~ < d' f' > ] c' 8 [ a ] c' [ f' ) ] f 16 ^( g b 8 d' [ b ] g ) [ < c' a' > ^( ] < d' b' > [ g ) ]  |
                } % close repeat
            } % Voice

            \context Voice = "voice 7" {
                % Segment: SBLive #3 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*186 
                \clef "treble_8"
                a 64 _~ [ < a c' > _~ < a e' c' > _~ < a a' e' c' > _~ ] < e' a' a c' > 8. _~ < a' c' e' a > 4 _~ < a' c' e' g > < e a > 64 _~ [ < e c' a > _~ < e c' e' a > _~ < e a' c' e' a > _~ ] < a' e' e c' a > 8. _~ < a' e' c' e a > 4 _~ < a' g, d g c' e' > < a, a e > 64 _~ [ < a, a c' e > _~ < a, a e' c' e > _~ < a, a' a e' c' e > _~ ] < e' a' a, a c' e > 8. _~ < a' a, a c' e' e > 4 _~ < a' a, e a c' e' >  |
                r4. r r r r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 2, kbd" << 
            \set Staff.instrumentName = \markup { \center-column { "kbd " } }
            \set Staff.midiInstrument = "Acoustic Grand Piano"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 8" {
                % Segment: SBLive #3 (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*6 
                \repeat unfold 3 {
                    \clef "treble"
                    r8 r < c'' g' e' > r r r r < c'' g' e' > r r r r < e' a' c' > r r < c' a' e' > r < a' e' c' >  |
                    r8 r < f' a' c' > r r r r < f' a' c' > r r r r < b' g' d' > r r < d' b' g' > r < c'' a' d' >  |
                } % close repeat
            } % Voice

            \context Voice = "voice 9" {
                % Segment: SBLive #3 (copied) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*42 
                r4. r r r r r  |
                r8 r g' < e'' c'' > 4 c'' 8 r r r < e'' c'' > 4 c'' 8 [ g' ] a' _~ [ < a' c'' > ] < e'' c'' > 4 c'' 8  |
            } % Voice

            \context Voice = "voice 10" {
                % Segment: SBLive #3 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*54 
                \repeat unfold 3 {
%% 10
                    \clef "treble"
                    r8 r < c'' g' e' > r r r r < c'' g' e' > r r r r < e' a' c' > r r < c' a' e' > r < a' e' c' >  |
                    r8 r < f' a' c' > r r r r < f' a' c' > r r r r < b' g' d' > r r < d' b' g' > r < c'' a' d' >  |
                } % close repeat
            } % Voice

            \context Voice = "voice 11" {
                % Segment: SBLive #3 (copied) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*90 
                r4. r r r r r  |
                r8 r g' < e'' c'' > 4 c'' 8 r r r < e'' c'' > 4 c'' 8 [ g' ] a' _~ [ < a' c'' > ] < e'' c'' > 4 c'' 8  |
            } % Voice

            \context Voice = "voice 12" {
                % Segment: SBLive #3
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*102 
                r8 r < a' c' e' > 4 r8 r < a' c' e' > 4 r8 r < a' c' e' > 4 r8 r < a' c' e' > 4 < aes' ees' >  |
                r8 r < g' d' b > 4 r8 r < g' d' b > 4 r8 r < g' d' b > 4 r8 r < g' d' b > 4 < aes' ees' >  |
%% 20
                r8 r < a' e' c' > 4 r8 r < a' c' e' > 4 r8 r < a' e' c' > 4 r8 r < a' e' c' > 4 < aes' ees' >  |
                r8 r < g' b d' > 4 r8 r < g' b d' > 4 r8 r < g' b d' > 4 r8 r < g' b d' > 4 < aes' ees' >  |
                r8 r < a' e' c' > 4 r8 r < a' e' c' > 4 r8 r < a' e' c' > 4 r8 r < a' e' c' > 4 < aes' ees' >  |
                r8 r < g' b d' > 4 r8 r < g' b d' > 4 r8 r < g' b d' > 4 r8 r < g' b d' > 4 < fis' cis' >  |
                < f' a c' > 4 < f' a c' > 4. < f' a c' > 4 < f' a c' > 4. < f' a c' > 4 < f' a c' > 4. < f' a c' > 4 < fis' cis' bes > 8  |
%% 25
                < g' d' b > 4 < g' d' b > 4. < g' d' b > 4 < g' d' b > 4. < g' d' b > 4 < g' d' b > 4. < g' d' b > 4 _~ < g' d' c' > 8  |
            } % Voice

            \context Voice = "voice 13" {
                % Segment: SBLive #3
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*150 
                \repeat unfold 3 {
                    \clef "treble"
                    r8 r < c'' g' e' > r r r r < c'' g' e' > r r r r < e' a' c' > r r < c' a' e' > r < a' e' c' >  |
                    r8 r < f' a' c' > r r r r < f' a' c' > r r r r < b' g' d' > r r < d' b' g' > r < c'' a' d' >  |
                } % close repeat
            } % Voice

            \context Voice = "voice 14" {
                % Segment: SBLive #3 (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*186 
                r4. r r r r r  |
                r8 r g' < e'' c'' > 4 c'' 8 r r r < e'' c'' > 4 c'' 8 [ g' ] a' _~ [ < a' c'' > ] < e'' c'' > 4 c'' 8  |
            } % Voice

            \context Voice = "voice 15" {
                % Segment: Bright Piano
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*198 
                \times 2/3 { c' 64 _~ [ < c' g' > _~ < c' g' c'' > _~ ] } \times 2/3 { < c' g' c'' e'' > _~ [ < c' g' c'' e'' g'' > _~ < c' g' c'' e'' g'' c''' > _~ ] } < c''' g'' e'' c'' g' c' > 1 r16 r4. r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 3, kbd" << 
            \set Staff.instrumentName = \markup { \center-column { "kbd " } }
            \set Staff.midiInstrument = "Acoustic Grand Piano"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 16" {
                % Segment: SBLive #3 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*42 
                r4. r r r r r  |
                d' 8 [ e' _~ ] < e' g' > 2 g' 8 [ a' _~ ] < c'' a' > _~ < c'' a' > 4 r8 d [ e _~ ] < g e > 2  |
            } % Voice

            \context Voice = "voice 17" {
                % Segment: SBLive #3 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*90 
                r4. r r r r r  |
                d' 8 [ e' _~ ] < e' g' > 2 g' 8 [ a' _~ ] < c'' a' > _~ < c'' a' > 4 r8 d' [ e' _~ ] < g' e' > 2  |
            } % Voice

            \context Voice = "voice 18" {
                % Segment: SBLive #3
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*186 
                r4. r r r r r  |
                d' 8 [ e' _~ ] < e' g' > 2 g' 8 [ a' _~ ] < c'' a' > _~ < c'' a' > 4 r8 d [ e _~ ] < g e > 2  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 4, fiddle (melody)" << 
            \set Staff.instrumentName = \markup { \center-column { "fiddle (melody) " } }
            \set Staff.midiInstrument = "Fiddle"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 19" {
                % Segment: SBLive #5 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*54 
%% 10
                \clef "treble"
                c'' 4 r r8 r c'' 4 g' a' c'' r8 r c'' a' _~  |
                a' 4 r8 r4. r r8 g' 4 b' d'' f'' 8 [ e'' _~ ]  |
                e'' 8 c'' 4 r4. r8 r g' 4 a' c'' r8 r c'' a' _~  |
                a' 4 r8 r4. r r8 g' 4 b' d'' f'' 8 [ e'' _~ ]  |
                e'' 8 c'' 4 r4. r4 g' a' c'' r8 r c'' a' _~  |
%% 15
                a' 4 r8 r4. r r8 b' 4 b' g' g'  |
                g' 2. _~ g' 8 [ a' _~ ] a' 2. _~ a' 2  |
                r4. r r r r r  |
            } % Voice

            \context Voice = "voice 20" {
                % Segment: Campbells Violin
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*102 
                r2 r8 c'' d'' 4 e'' g'' 8 [ e'' _~ ] e'' 4 d'' 8 d'' 4 c'' 8  |
                d'' 4. d'' 8 _~ [ d'' ] c'' [ d'' ] c'' d'' 4 e'' e'' 8 [ d'' _~ ] d'' 2  |
%% 20
                r2 r8 a' b' 4 e'' 4. g'' e'' 4 d'' 8 [ c'' _~ ]  |
                c'' 4 d'' d'' 8 [ c'' ] d'' [ c'' ] d'' 4 e'' e'' 8 [ d'' _~ ] d'' 4 r8 r  |
                r2 r8 e' a' [ c'' _~ ] c'' e'' 4 g'' 8 [ e'' ] e'' [ d'' _~ ] d'' 4.  |
                r2 r8 a' c'' 4 e'' 8 g'' 4 e'' 8 e'' 2.  |
                r4. r c'' 4 c'' 8 b' 4 a' 8 _~ a' 4. r  |
%% 25
                r4. r r2 c''' 8 [ c''' ] c''' [ a'' ] g'' [ a'' ] c''' 4  |
            } % Voice

            \context Voice = "voice 21" {
                % Segment: SBLive #5
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*150 
                \clef "treble"
                c'' 4 r r8 r c'' 4 g' a' c'' r8 r c'' a' _~  |
                a' 4 r8 r4. r r8 g' 4 b' d'' f'' 8 [ e'' _~ ]  |
                e'' 8 c'' 4 r4. r8 r g' 4 a' c'' r8 r c'' a' _~  |
                a' 4 r8 r4. r r8 g' 4 b' d'' f'' 8 [ e'' _~ ]  |
%% 30
                e'' 8 c'' 4 r4. r4 g' a' c'' r8 r c'' a' _~  |
                a' 4 r8 r4. r r8 b' 4 b' g' g'  |
                g' 2. _~ g' 8 [ a' _~ ] a' 2. _~ a' 2  |
                r4. r r r r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 5, bass" << 
            \set Staff.instrumentName = \markup { \center-column { "bass " } }
            \set Staff.midiInstrument = "Fingered Bass"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 22" {
                % Segment: MIDI soundcard synth #4 (split) (split) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*6 
                \clef "bass"
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
%% 5
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                a,, \breve _~ a,, 4  |
                a,, \breve r8 r  |
            } % Voice

            \context Voice = "voice 23" {
                % Segment: MIDI soundcard synth #4 (split) (split) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*54 
%% 10
                \clef "bass"
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 g,, g,, 4. g,, 4 a,, 8 
                % warning: bar too short, padding with rests
                % 103680 + 7200 < 112320  &&  15/8 < 18/8
                r4.  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
%% 15
                f,, 4 f,, 4. f,, 4 g,, g,, 4. g,, 4 a,, 8 
                % warning: bar too short, padding with rests
                % 120960 + 7200 < 129600  &&  15/8 < 18/8
                r4.  |
                a,, \breve _~ a,, 4  |
                a,, \breve r8 r  |
            } % Voice

            \context Voice = "voice 24" {
                % Segment: MIDI soundcard synth #4 (split) (split) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*102 
                \clef "bass"
                a,, 8 a,, 4 aes,, 8 a,, 4 r8 r a,, a,, 4 aes,, 8 a,, 4 r8 r aes,, 4  |
                g,, 8 g,, 4 fis,, 8 g,, 4 r8 r g,, g,, 4 fis,, 8 g,, 4 r8 r aes,, 4  |
%% 20
                a,, 8 a,, 4 aes,, 8 a,, 4 r8 r a,, a,, 4 aes,, 8 a,, 4 r8 r aes,, 4  |
                g,, 8 g,, 4 fis,, 8 g,, 4 r g,, 8 g,, 4 fis,, 8 g,, 4 r8 r aes,, 4  |
                a,, 8 a,, 4 aes,, 8 a,, 4 r8 r a,, a,, 4 aes,, 8 a,, 4 r8 r aes,, 4  |
                g,, 8 g,, 4 fis,, 8 g,, 4 r g,, 8 g,, 4 fis,, 8 g,, 4 r8 r aes,, 4  |
                f,, 4 f,, e,, 8 f,, 4 f,, e,, 8 f,, 4 f,, e,, 8 f,, 4 fis,, 8  |
%% 25
                g,, 4 g,, fis,, 8 g,, 4 g,, fis,, 8 g,, 4 g,, fis,, 8 g,, 4 aes,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 g,, g,, 4. g,, 4 a,, 8 
                % warning: bar too short, padding with rests
                % 241920 + 7200 < 250560  &&  15/8 < 18/8
                r4.  |
%% 30
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 g,, g,, 4. g,, 4 a,, 8 
                % warning: bar too short, padding with rests
                % 259200 + 7200 < 267840  &&  15/8 < 18/8
                r4.  |
                a,, \breve _~ a,, 4  |
                a,, \breve r8 r  |
            } % Voice

            \context Voice = "voice 25" {
                % Segment: PizzicatoStrings
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*198 
                \clef "bass"
                c 32 [ g, ] c, _~ c, 1 r32 r4. r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 6, other bass" << 
            \set Staff.instrumentName = \markup { \center-column { "other bass " } }
            \set Staff.midiInstrument = "Picked Bass"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 26" {
                % Segment: SBLive #7 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*6 
                \clef "bass"
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
%% 5
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                a,, \breve _~ a,, 4  |
                a,, \breve r8 r  |
            } % Voice

            \context Voice = "voice 27" {
                % Segment: SBLive #7 (copied) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*54 
%% 10
                \clef "bass"
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
%% 15
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                a,, \breve _~ a,, 4  |
                a,, \breve r8 r  |
            } % Voice

            \context Voice = "voice 28" {
                % Segment: SBLive #7 (copied) (split) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*102 
                \clef "bass"
                a,, 8 a,, 4 aes,, 8 a,, 4 r8 r a,, a,, 4 aes,, 8 a,, 4 r8 r aes,, 4  |
                g,, 8 g,, 4 fis,, 8 g,, 4 r8 r g,, g,, 4 fis,, 8 g,, 4 r8 r aes,, 4  |
%% 20
                a,, 8 a,, 4 aes,, 8 a,, 4 r8 r a,, a,, 4 aes,, 8 a,, 4 r8 r aes,, 4  |
                g,, 8 g,, 4 fis,, 8 g,, 4 r8 r g,, g,, 4 fis,, 8 g,, 4 r8 r aes,, 4  |
                a,, 8 a,, 4 aes,, 8 a,, 4 r8 r a,, a,, 4 aes,, 8 a,, 4 r8 r aes,, 4  |
                g,, 8 g,, 4 fis,, 8 g,, 4 r8 r g,, g,, 4 fis,, 8 g,, 4 r8 r aes,, 4  |
                f,, 4 f,, e,, 8 f,, 4 f,, e,, 8 f,, 4 f,, e,, 8 f,, 4 fis,, 8  |
%% 25
                g,, 4 g,, fis,, 8 g,, 4 g,, fis,, 8 g,, 4 g,, fis,, 8 g,, 4 aes,, 8  |
            } % Voice

            \context Voice = "voice 29" {
                % Segment: SBLive #7
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*150 
                \clef "bass"
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
%% 30
                c, 4 c, 4. e, 8 [ f, ] g, 4. a,, 4 a,, 4. a,, 8 [ c, ] a,,  |
                f,, 4 f,, 4. f,, 4 r8 r r g,, 4 g,, 4. g,, 4 a,, 8  |
                a,, \breve _~ a,, 4  |
                a,, \breve r8 r  |
            } % Voice

            \context Voice = "voice 30" {
                % Segment: +++Slap Bass 2
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*198 
                \clef "bass"
                c 16 [ g, ] c, _~ c, 1 r16 r8 r r4. r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 8, drums" << 
            \set Staff.instrumentName = \markup { \center-column { "drums " } }
            \set Staff.midiInstrument = "Standard"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 31" {
                % Segment: SBLive #9 (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*6 
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 32" {
                % Segment: SBLive #9 (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*18 
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
%% 5
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 33" {
                % Segment: SBLive #9 (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*30 
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 34" {
                % Segment: SBLive #9 (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*42 
                \clef "bass"
                cis 4 fis, fis, aes, r8 fis, fis, 4 aes, fis, 8 r fis, 4  |
                cis 4 fis, 8 r fis, 4 aes, r8 fis, fis, 4 aes, fis, a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 35" {
                % Segment: SBLive #9 (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*54 
%% 10
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 36" {
                % Segment: SBLive #9 (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*66 
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 37" {
                % Segment: SBLive #9 (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*78 
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
%% 15
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 38" {
                % Segment: SBLive #9 (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*90 
                \clef "bass"
                cis 4 fis, fis, aes, r8 fis, fis, 4 aes, fis, 8 r fis, 4  |
                cis 4 fis, 8 r fis, 4 aes, r8 fis, fis, 4 aes, fis, a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 39" {
                % Segment: SBLive #9 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*102 
                \clef "bass"
                cis 4 aes, aes, aes, < a' aes, > aes, aes, aes, a' 8 [ aes, ]  |
                cis 4 aes, aes, aes, < a' aes, > aes, aes, aes, a' 8 [ aes, ]  |
            } % Voice

            \context Voice = "voice 40" {
                % Segment: SBLive #9 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*114 
%% 20
                \clef "bass"
                cis 4 aes, aes, aes, < a' aes, > aes, aes, aes, a' 8 [ aes, ]  |
                cis 4 aes, aes, aes, < a' aes, > aes, aes, aes, a' 8 [ aes, ]  |
            } % Voice

            \context Voice = "voice 41" {
                % Segment: SBLive #9 (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*126 
                \clef "bass"
                cis 4 aes, aes, aes, < a' aes, > aes, aes, aes, a' 8 [ aes, ]  |
                cis 4 aes, aes, aes, < a' aes, > aes, aes, aes, a' 8 [ aes, ]  |
            } % Voice

            \context Voice = "voice 42" {
                % Segment: SBLive #9
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*138 
                \clef "bass"
                cis 4 aes, aes, aes, < a' aes, > aes, aes, aes, a' 8 [ aes, ]  |
%% 25
                cis 4 aes, aes, aes, < a' aes, > aes, aes, aes, a' 8 [ aes, ]  |
            } % Voice

            \context Voice = "voice 43" {
                % Segment: SBLive #9 (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*150 
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 44" {
                % Segment: SBLive #9 (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*162 
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 45" {
                % Segment: SBLive #9 (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*174 
%% 30
                \clef "bass"
                cis 4 < fis, a' > fis, aes, a' 8 [ fis, ] fis, 4 aes, fis, 8 [ a' ] fis, 4  |
                cis 4 fis, 8 a' fis, 4 aes, a' 8 fis, fis, 4 aes, < a' fis, > a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 46" {
                % Segment: SBLive #9 (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*186 
                \clef "bass"
                cis 4 fis, fis, aes, r8 fis, fis, 4 aes, fis, 8 r fis, 4  |
                cis 4 fis, 8 r fis, 4 aes, r8 fis, fis, 4 aes, fis, a, 8 [ a, ]  |
            } % Voice

            \context Voice = "voice 47" {
                % Segment: SBLive #9
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*198 
                \clef "bass"
                cis 1 r8 r4. r r  |
            } % Voice
        >> % Staff ends

        \context Staff = "track 9, drums" << 
            \set Staff.instrumentName = \markup { \center-column { "drums " } }
            \set Staff.midiInstrument = "Standard"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 48" {
                % Segment: Power (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1
                \once \override Staff.TimeSignature #'style = #'numbered 
                \time 18/8
                
                \clef "bass"
                r8 d, d, [ d, ] d, 4 r d, r8 \times 2/3 { d, 16 [ d, d, ] } d, 8 d, c c b, b,  |
            } % Voice

            \context Voice = "voice 49" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*6 
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 50" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*18 
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
%% 5
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 51" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*30 
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 52" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*42 
                \clef "bass"
                b,, 4 r r d, r c r8 d, r d, r d,  |
                d, 8 [ d, ] d, 4 r8 c 4 c c 8 c 4 c 8 [ c ] b, [ b, ] a, [ a, ]  |
            } % Voice

            \context Voice = "voice 53" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*54 
%% 10
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 54" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*66 
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 55" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*78 
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
%% 15
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 56" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*90 
                \clef "bass"
                b,, 4 r r d, r c r8 d, r d, r d,  |
                d, 8 [ d, ] d, 4 r8 c 4 c c 8 c 4 c 8 [ c ] b, [ b, ] a, [ a, ]  |
            } % Voice

            \context Voice = "voice 57" {
                % Segment: Standard (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*102 
                \clef "bass"
                b,, 4 r8 c, d, 4 r8 c, b,, 4 r8 c, d, 4 r8 c, < b, e, > [ a, ]  |
                b,, 4 r8 c, d, 4 r8 c, b,, 4 r8 c, d, 4 r8 c, < a, e, > [ g, ]  |
            } % Voice

            \context Voice = "voice 58" {
                % Segment: Standard (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*114 
%% 20
                \clef "bass"
                b,, 8 c, r c, d, 4 r8 c, b,, c, r c, d, 4 r8 c, < b, e, > [ a, ]  |
                c, 8 b,, r c, d, 4 r8 c, c, b,, r c, d, 4 r8 c, < a, e, > [ g, ]  |
            } % Voice

            \context Voice = "voice 59" {
                % Segment: Standard (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*126 
                \clef "bass"
                b,, 8 c, r c, d, 4 r8 c, b,, c, r c, d, 4 r8 c, < b, e, > [ a, ]  |
                c, 8 b,, r c, d, 4 r8 c, c, b,, r c, d, 4 r8 c, < a, e, > [ g, ]  |
            } % Voice

            \context Voice = "voice 60" {
                % Segment: Standard
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*138 
                \clef "bass"
                b,, 8 c, r c, d, 4 r8 c, b,, c, r c, d, 4 r8 c, < b, e, > [ a, ]  |
%% 25
                c, 8 b,, r c, d, 4 r8 c, c, b,, r c, d, 4 r8 c, < a, e, > [ g, ]  |
            } % Voice

            \context Voice = "voice 61" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*150 
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 62" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*162 
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 63" {
                % Segment: MIDI soundcard synth #10[D] (split) (split) (copied)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*174 
%% 30
                \clef "bass"
                < b,, d, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
                < d, b,, > 8 -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ < b,, e, > ] < b,, d, > -\accent [ c, ] c, [ b,, ] c, [ b,, ]  |
            } % Voice

            \context Voice = "voice 64" {
                % Segment: MIDI soundcard synth #10[D] (split) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*186 
                \clef "bass"
                b,, 4 r r d, r c r8 d, r d, r d,  |
                d, 8 [ d, ] d, 4 r8 c 4 c c 8 c 4 c 8 [ c ] b, [ b, ] a, [ a, ]  |
            } % Voice

            \context Voice = "voice 65" {
                % Segment: Power
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 4.*198 
                \clef "bass"
                r8 d, d, [ d, ] d, 4 r d, r8 \times 2/3 { d, 16 [ d, d, ] } d, 8 d, c c b, b,  |
%% 35
                < a, b,, d, cis > 4 r8 r4. r r  |
                \bar "|."
            } % Voice
        >> % Staff (final) ends

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
