%define sover   0
%define libname libtinyframe%{sover}
Name:           tinyframe
Version:        0.1.1
Release:        1%{?dist}
Summary:        Frame Streams encoder/decoder library
Group:          Development/Libraries/C and C++

License:        LGPL-3.0-or-later
URL:            https://github.com/DNS-OARC/tinyframe
# Source needs to be generated by dist-tools/create-source-packages, see
# https://github.com/jelu/dist-tools
Source0:        %{name}_%{version}.orig.tar.gz

BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
BuildRequires:  pkgconfig

%description
Minimalistic library for encoding and decoding the Frame Streams protocol.

%package -n %{libname}
Summary:        Frame Streams encoder/decoder library
Group:          System/Libraries

%description -n %{libname}
Minimalistic library for encoding and decoding the Frame Streams protocol.

%package devel
Summary:        Frame Streams encoder/decoder library development files
Group:          Development/Libraries/C and C++
Requires:       %{libname} = %{version}

%description devel
Minimalistic library for encoding and decoding the Frame Streams protocol.


%prep
%setup -q -n %{name}_%{version}


%build
sh autogen.sh
%configure
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT


%clean
rm -rf $RPM_BUILD_ROOT


%post -n %{libname}
/sbin/ldconfig


%postun -n %{libname}
/sbin/ldconfig


%files -n %{libname}
%defattr(-,root,root,-)
%{_libdir}/libtinyframe.so.%{sover}*


%files devel
%defattr(-,root,root,-)
%{_includedir}/*
# %{_mandir}/man3/*
%{_libdir}/libtinyframe.so
%{_libdir}/pkgconfig/libtinyframe.pc
%exclude %{_libdir}/libtinyframe.a
%exclude %{_libdir}/libtinyframe.la
%{_datadir}/doc/*


%changelog
* Thu Oct 22 2020 Jerry Lundström <lundstrom.jerry@gmail.com> 0.1.1-1
- Release 0.1.1
  * This release adds a few assert check on augments to some of the function
    calls, fixes a type in configure and adds coverage tests.
    - `tinyframe_write_control()`:
      - assert arguments and content fields data
      - check for valid content field types
    - `tinyframe_write_control_start()`: assert arguments
    - `tinyframe_write_frame()`: assert arguments
    - `tinyframe_write_control_stop()`: assert arguments
    - `tinyframe_set_header()`: assert arguments
    - Remove `sprintf()` usage from tracing
  * Commits:
    c6fbfea Travis, configure
    ba616b0 Coverage
    97dfeb7 Coverage
    f69665b Badges
    907a894 COPR
    f07d4e8 Funding
    242b1b2 Trace
    8d36cf7 LGTM
* Thu Mar 19 2020 Jerry Lundström <lundstrom.jerry@gmail.com> 0.1.0-1
- Release 0.1.0
