// @HEADER
// ***********************************************************************
//
//          PyTrilinos: Python Interfaces to Trilinos Packages
//                 Copyright (2014) Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia
// Corporation, the U.S. Government retains certain rights in this
// software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact William F. Spotz (wfspotz@sandia.gov)
//
// ***********************************************************************
// @HEADER

#ifndef PYTRILINOS_NUMPYIMPORTER_HPP
#define PYTRILINOS_NUMPYIMPORTER_HPP

#include "numpy_include.hpp"

namespace PyTrilinos
{

// Singleton class that ensures that the numpy (macro) function
// import_array() gets called once and only once.

class NumPyImporter
{
#if PY_VERSION_HEX > 0x03000000
  static void * import_array_method()
  {
    // The import_array() macro has a 'return' statement in it
    import_array();
    // But this return statement should supress compiler errors
    return NULL;
  }
#endif

protected:
  // These are protected instead of private to keep compilers happy.
  ~NumPyImporter() { }
#if PY_VERSION_HEX >= 0x03000000
  NumPyImporter() {void * result = import_array_method();}
#else
  NumPyImporter() {import_array();}
#endif

private:
  NumPyImporter(const NumPyImporter & a_ref);
  const NumPyImporter & operator = (const NumPyImporter & a_rhs);

private:
  // The singleton, i.e. the only instance of this object is this
  // attribute
  static NumPyImporter m_singleton;
  
};

}  // Namespace PyTrilinos

#endif // PYTRILINOS_NUMPYIMPORTER_HPP
