// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SQDMLSL2_2D_4S_S_TRACE_AARCH64_H_
#define VIXL_SIM_SQDMLSL2_2D_4S_S_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sqdmlsl2_2D_4S_S[] = {
  0xffffff8202f40000, 0x0000000000000001,
  0xffffff0305ee0000, 0x0000000000000001,
  0xffff7f0905dc0000, 0x0000000000000001,
  0xffff7f0905dc0000, 0x0000000000000001,
  0xffffff8102fa0000, 0x0000000000000001,
  0xffff7f8702e80000, 0x0000000000000001,
  0xffff7f8702e80000, 0x0000000000000001,
  0xffff7f8701e80600, 0x0000000000000001,
  0xffff8005ffee0000, 0x0000000000000001,
  0xffff8005ffee0000, 0x0000000000000001,
  0xffff8005feee0600, 0x0000000000000001,
  0xffff8005fcee1200, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0xfffffffffd001200, 0x0000000000000001,
  0xffffffffdd00d200, 0x0000000000000001,
  0xffffffffff000600, 0x0000000000000001,
  0xfffffffffd001200, 0x0000000000000001,
  0xffffffffdd00d200, 0x0000000000000001,
  0xffffffff6003c000, 0x0000000000000001,
  0xfffffffffe000c00, 0x0000000000000001,
  0xffffffffde00cc00, 0x0000000000000001,
  0xffffffff6103ba00, 0x0000000000000001,
  0xfffffffee306ae00, 0x0000000000000001,
  0xffffffffe000c000, 0x0000000000000001,
  0xffffffff6303ae00, 0x0000000000000001,
  0xfffffffee506a200, 0x0000000000000001,
  0xfffffffe66099c00, 0x0000000000000001,
  0xffffffff8302ee00, 0x0000000000000001,
  0xffffffff0505e200, 0x0000000000000001,
  0xfffffffe8608dc00, 0x0000000000000001,
  0xffffff7e8c08ca00, 0x0000000000000001,
  0xffffffff8202f400, 0x0000000000000001,
  0xffffffff0305ee00, 0x0000000000000001,
  0xffffff7f0905dc00, 0x0000000000000001,
  0xfffffeff0e05d000, 0x0000000000000001,
  0xffffffff8102fa00, 0x0000000000000001,
  0xffffff7f8702e800, 0x0000000000000001,
  0xfffffeff8c02dc00, 0x0000000000000001,
  0xfffffe7f9002d600, 0x0000000000000001,
  0xffffff8005ffee00, 0x0000000000000001,
  0xffffff000affe200, 0x0000000000000001,
  0xfffffe800effdc00, 0x0000000000000001,
  0xffcccc800f330e00, 0x0000000000000001,
  0xffffff8004fff400, 0x0000000000000001,
  0xffffff0008ffee00, 0x0000000000000001,
  0xffcccd0009332000, 0x0000000000000001,
  0xff7779aab4331e00, 0x0000000000000001,
  0xffffff8003fffa00, 0x0000000000000001,
  0xffcccd8004332c00, 0x0000000000000001,
  0xff777a2aaf332a00, 0x0000000000000001,
  0xfef77d2ab2331800, 0x0000000000000001,
  0xffccce0000333200, 0x0000000000000001,
  0xff777aaaab333000, 0x0000000000000001,
  0xfef77daaae331e00, 0x0000000000000001,
  0xfe7780aab0331200, 0x0000000000000001,
  0xffaaacaaaafffe00, 0x0000000000000001,
  0xff2aafaaadffec00, 0x0000000000000001,
  0xfeaab2aaafffe000, 0x0000000000000001,
  0xfe2ab5aab0ffda00, 0x0000000000000001,
  0xff80030002ffee00, 0x0000000000000001,
  0xff00060004ffe200, 0x0000000000000001,
  0xfe80090005ffdc00, 0x0000000000000001,
  0xff00060005ffdc00, 0x0000000000000001,
  0xff80030001fff400, 0x0000000000000001,
  0xff00060002ffee00, 0x0000000000000001,
  0xff80030002ffee00, 0x0000000000000001,
  0x0000000001fff400, 0x0000000000000001,
  0xff80030000fffa00, 0x0000000000000001,
  0x0000000000fffa00, 0x0000000000000001,
  0x007ffd0000000000, 0x0000000000000001,
  0x00d5505555fffc00, 0x0000000000000001,
  0x007ffd0000000000, 0x0000000000000001,
  0x00fff9ffff000600, 0x0000000000000001,
  0x01554d5555000200, 0x0000000000000001,
  0x01887f5555ccca00, 0x0000000000000001,
  0x007ffcffff000600, 0x0000000000000001,
  0x00d5505555000200, 0x0000000000000001,
  0x0108825555ccca00, 0x0000000000000001,
  0x010882d552ccca00, 0x0000000000000001,
  0x0055535555fffc00, 0x0000000000000001,
  0x0088855556ccc400, 0x0000000000000001,
  0x008885d553ccc400, 0x0000000000000001,
  0x008886554fccca00, 0x0000000000000001,
  0x0033320000ccc800, 0x0000000000000001,
  0x0033327ffdccc800, 0x0000000000000001,
  0x003332fff9ccce00, 0x0000000000000001,
  0x0033337ff4ccda00, 0x0000000000000001,
  0x0000007ffd000000, 0x0000000000000001,
  0x000000fff9000600, 0x0000000000000001,
  0x0000017ff4001200, 0x0000000000000001,
  0x000001ffee002400, 0x0000000000000001,
  0x0000007ffc000600, 0x0000000000000001,
  0x000000fff7001200, 0x0000000000000001,
  0x0000017ff1002400, 0x0000000000000001,
  0x0000018070fd2400, 0x0000000000000001,
  0x0000007ffb000c00, 0x0000000000000001,
  0x000000fff5001e00, 0x0000000000000001,
  0x0000010074fd1e00, 0x0000000000000001,
  0x00000100f3fa2400, 0x0000000000000001,
  0x0000007ffa001200, 0x0000000000000001,
  0x0000008079fd1200, 0x0000000000000001,
  0x00000080f8fa1800, 0x0000000000000001,
  0x0000008176f72400, 0x0000000000000001,
  0x000000007ffd0000, 0x0000000000000001,
  0x00000000fefa0600, 0x0000000000000001,
  0x000000017cf71200, 0x0000000000000001,
  0x00000001f9f42400, 0x0000000000000001,
  0x000000007efd0600, 0x0000000000000001,
  0x00000000fcfa1200, 0x0000000000000001,
  0x0000000179f72400, 0x0000000000000001,
  0x0000000199f66400, 0x0000000000000001,
  0x000000007dfd0c00, 0x0000000000000001,
  0x00000000fafa1e00, 0x0000000000000001,
  0x000000011af95e00, 0x0000000000000001,
  0x000000011df94c00, 0x0000000000000001,
  0x000000007cfd1200, 0x0000000000000001,
  0x000000009cfc5200, 0x0000000000000001,
  0x000000009ffc4000, 0x0000000000000001,
  0x00000000a1fc3400, 0x0000000000000001,
  0x000000001fff4000, 0x0000000000000001,
  0x0000000022ff2e00, 0x0000000000000001,
  0x0000000024ff2200, 0x0000000000000001,
  0x0000000025ff1c00, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x000000000000000b,
  0x0000000000000000, 0x000000000000000d,
  0x0000000000000000, 0x000000000000000d,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000007,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xfffffffffffffffb,
  0x0000000000000000, 0xffffffffffffffbb,
  0x0000000000000000, 0xffffffffffffffff,
  0x0000000000000000, 0xfffffffffffffffb,
  0x0000000000000000, 0xffffffffffffffbb,
  0x0000000000000000, 0xfffffffffffffec1,
  0x0000000000000000, 0xfffffffffffffffd,
  0x0000000000000000, 0xffffffffffffffbd,
  0x0000000000000000, 0xfffffffffffffec3,
  0x0000000000000000, 0xfffffffffffffdc7,
  0x0000000000000000, 0xffffffffffffffc1,
  0x0000000000000000, 0xfffffffffffffec7,
  0x0000000000000000, 0xfffffffffffffdcb,
  0x0000000000000000, 0xfffffffffffffccd,
  0x0000000000000000, 0xffffffffffffff07,
  0x0000000000000000, 0xfffffffffffffe0b,
  0x0000000000000000, 0xfffffffffffffd0d,
  0x0000000000000000, 0xfffffffffffefd13,
  0x0000000000000000, 0xffffffffffffff05,
  0x0000000000000000, 0xfffffffffffffe07,
  0x0000000000000000, 0xfffffffffffefe0d,
  0x0000000000000000, 0xfffffffffffdfe11,
  0x0000000000000000, 0xffffffffffffff03,
  0x0000000000000000, 0xfffffffffffeff09,
  0x0000000000000000, 0xfffffffffffdff0d,
  0x0000000000000000, 0xfffffffffffcff0f,
  0x0000000000000000, 0xffffffffffff0007,
  0x0000000000000000, 0xfffffffffffe000b,
  0x0000000000000000, 0xfffffffffffd000d,
  0x0000000000000000, 0xffffffff999699a7,
  0x0000000000000000, 0xffffffffffff0005,
  0x0000000000000000, 0xfffffffffffe0007,
  0x0000000000000000, 0xffffffff999799a1,
  0x0000000000000000, 0xfffffffeeeeceef7,
  0x0000000000000000, 0xffffffffffff0003,
  0x0000000000000000, 0xffffffff9998999d,
  0x0000000000000000, 0xfffffffeeeedeef3,
  0x0000000000000000, 0xfffffffdeeedeef9,
  0x0000000000000000, 0xffffffff9999999b,
  0x0000000000000000, 0xfffffffeeeeeeef1,
  0x0000000000000000, 0xfffffffdeeeeeef7,
  0x0000000000000000, 0xfffffffceeeeeefb,
  0x0000000000000000, 0xffffffff55555557,
  0x0000000000000000, 0xfffffffe5555555d,
  0x0000000000000000, 0xfffffffd55555561,
  0x0000000000000000, 0xfffffffc55555563,
  0x0000000000000000, 0xffffffff00000007,
  0x0000000000000000, 0xfffffffe0000000b,
  0x0000000000000000, 0xfffffffd0000000d,
  0x0000000000000000, 0xfffffffe0000000d,
  0x0000000000000000, 0xffffffff00000005,
  0x0000000000000000, 0xfffffffe00000007,
  0x0000000000000000, 0xffffffff00000007,
  0x0000000000000000, 0x0000000000000005,
  0x0000000000000000, 0xffffffff00000003,
  0x0000000000000000, 0x0000000000000003,
  0x0000000000000000, 0x0000000100000001,
  0x0000000000000000, 0x00000001aaaaaaad,
  0x0000000000000000, 0x0000000100000001,
  0x0000000000000000, 0x00000001ffffffff,
  0x0000000000000000, 0x00000002aaaaaaab,
  0x0000000000000000, 0x0000000311111113,
  0x0000000000000000, 0x00000000ffffffff,
  0x0000000000000000, 0x00000001aaaaaaab,
  0x0000000000000000, 0x0000000211111113,
  0x0000000000000000, 0x0000000211121113,
  0x0000000000000000, 0x00000000aaaaaaad,
  0x0000000000000000, 0x0000000111111115,
  0x0000000000000000, 0x0000000111121115,
  0x0000000000000000, 0x0000000111131113,
  0x0000000000000000, 0x0000000066666669,
  0x0000000000000000, 0x0000000066676669,
  0x0000000000000000, 0x0000000066686667,
  0x0000000000000000, 0x0000000066696663,
  0x0000000000000000, 0x0000000000010001,
  0x0000000000000000, 0x000000000001ffff,
  0x0000000000000000, 0x000000000002fffb,
  0x0000000000000000, 0x000000000003fff5,
  0x0000000000000000, 0x000000000000ffff,
  0x0000000000000000, 0x000000000001fffb,
  0x0000000000000000, 0x000000000002fff5,
  0x0000000000000000, 0x00000000000300f5,
  0x0000000000000000, 0x000000000000fffd,
  0x0000000000000000, 0x000000000001fff7,
  0x0000000000000000, 0x00000000000200f7,
  0x0000000000000000, 0x00000000000201f5,
  0x0000000000000000, 0x000000000000fffb,
  0x0000000000000000, 0x00000000000100fb,
  0x0000000000000000, 0x00000000000101f9,
  0x0000000000000000, 0x00000000000102f5,
  0x0000000000000000, 0x0000000000000101,
  0x0000000000000000, 0x00000000000001ff,
  0x0000000000000000, 0x00000000000002fb,
  0x0000000000000000, 0x00000000000003f5,
  0x0000000000000000, 0x00000000000000ff,
  0x0000000000000000, 0x00000000000001fb,
  0x0000000000000000, 0x00000000000002f5,
  0x0000000000000000, 0x0000000000000335,
  0x0000000000000000, 0x00000000000000fd,
  0x0000000000000000, 0x00000000000001f7,
  0x0000000000000000, 0x0000000000000237,
  0x0000000000000000, 0x000000000000023d,
  0x0000000000000000, 0x00000000000000fb,
  0x0000000000000000, 0x000000000000013b,
  0x0000000000000000, 0x0000000000000141,
  0x0000000000000000, 0x0000000000000145,
  0x0000000000000000, 0x0000000000000041,
  0x0000000000000000, 0x0000000000000047,
  0x0000000000000000, 0x000000000000004b,
  0x0000000000000000, 0x000000000000004d,
  0x0000000000000006, 0x000000000000000d,
  0x000000000000000a, 0x0000000000000015,
  0x000000000000000c, 0x0000000000000019,
  0x000000000000000c, 0x0000000000000019,
  0x0000000000000004, 0x0000000000000009,
  0x0000000000000006, 0x000000000000000d,
  0x0000000000000006, 0x000000000000000d,
  0x0000000000000004, 0x0000000000000009,
  0x0000000000000002, 0x0000000000000005,
  0x0000000000000002, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffc, 0xfffffffffffffff9,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xfffffffffffffffa, 0xfffffffffffffff5,
  0xffffffffffffffba, 0xffffffffffffff75,
  0xfffffffffffffffe, 0xfffffffffffffffd,
  0xfffffffffffffffa, 0xfffffffffffffff5,
  0xffffffffffffffba, 0xffffffffffffff75,
  0xfffffffffffffec0, 0xfffffffffffffd81,
  0xfffffffffffffffc, 0xfffffffffffffff9,
  0xffffffffffffffbc, 0xffffffffffffff79,
  0xfffffffffffffec2, 0xfffffffffffffd85,
  0xfffffffffffffdc6, 0xfffffffffffffb8d,
  0xffffffffffffffc0, 0xffffffffffffff81,
  0xfffffffffffffec6, 0xfffffffffffffd8d,
  0xfffffffffffffdca, 0xfffffffffffffb95,
  0xfffffffffffffccc, 0xfffffffffffff999,
  0xffffffffffffff06, 0xfffffffffffffe0d,
  0xfffffffffffffe0a, 0xfffffffffffffc15,
  0xfffffffffffffd0c, 0xfffffffffffffa19,
  0xfffffffffffefd12, 0xfffffffffffdfa25,
  0xffffffffffffff04, 0xfffffffffffffe09,
  0xfffffffffffffe06, 0xfffffffffffffc0d,
  0xfffffffffffefe0c, 0xfffffffffffdfc19,
  0xfffffffffffdfe10, 0xfffffffffffbfc21,
  0xffffffffffffff02, 0xfffffffffffffe05,
  0xfffffffffffeff08, 0xfffffffffffdfe11,
  0xfffffffffffdff0c, 0xfffffffffffbfe19,
  0xfffffffffffcff0e, 0xfffffffffff9fe1d,
  0xffffffffffff0006, 0xfffffffffffe000d,
  0xfffffffffffe000a, 0xfffffffffffc0015,
  0xfffffffffffd000c, 0xfffffffffffa0019,
  0xffffffff999699a6, 0xffffffff332d334d,
  0xffffffffffff0004, 0xfffffffffffe0009,
  0xfffffffffffe0006, 0xfffffffffffc000d,
  0xffffffff999799a0, 0xffffffff332f3341,
  0xfffffffeeeeceef6, 0xfffffffdddd9dded,
  0xffffffffffff0002, 0xfffffffffffe0005,
  0xffffffff9998999c, 0xffffffff33313339,
  0xfffffffeeeedeef2, 0xfffffffddddbdde5,
  0xfffffffdeeedeef8, 0xfffffffbdddbddf1,
  0xffffffff9999999a, 0xffffffff33333335,
  0xfffffffeeeeeeef0, 0xfffffffddddddde1,
  0xfffffffdeeeeeef6, 0xfffffffbdddddded,
  0xfffffffceeeeeefa, 0xfffffff9ddddddf5,
  0xffffffff55555556, 0xfffffffeaaaaaaad,
  0xfffffffe5555555c, 0xfffffffcaaaaaab9,
  0xfffffffd55555560, 0xfffffffaaaaaaac1,
  0xfffffffc55555562, 0xfffffff8aaaaaac5,
  0xffffffff00000006, 0xfffffffe0000000d,
  0xfffffffe0000000a, 0xfffffffc00000015,
  0xfffffffd0000000c, 0xfffffffa00000019,
  0xfffffffe0000000c, 0xfffffffc00000019,
  0xffffffff00000004, 0xfffffffe00000009,
  0xfffffffe00000006, 0xfffffffc0000000d,
  0xffffffff00000006, 0xfffffffe0000000d,
  0x0000000000000004, 0x0000000000000009,
  0xffffffff00000002, 0xfffffffe00000005,
  0x0000000000000002, 0x0000000000000005,
  0x0000000100000000, 0x0000000200000001,
  0x00000001aaaaaaac, 0x0000000355555559,
  0x0000000100000000, 0x0000000200000001,
  0x00000001fffffffe, 0x00000003fffffffd,
  0x00000002aaaaaaaa, 0x0000000555555555,
  0x0000000311111112, 0x0000000622222225,
  0x00000000fffffffe, 0x00000001fffffffd,
  0x00000001aaaaaaaa, 0x0000000355555555,
  0x0000000211111112, 0x0000000422222225,
  0x0000000211121112, 0x0000000422242225,
  0x00000000aaaaaaac, 0x0000000155555559,
  0x0000000111111114, 0x0000000222222229,
  0x0000000111121114, 0x0000000222242229,
  0x0000000111131112, 0x0000000222262225,
  0x0000000066666668, 0x00000000ccccccd1,
  0x0000000066676668, 0x00000000ccceccd1,
  0x0000000066686666, 0x00000000ccd0cccd,
  0x0000000066696662, 0x00000000ccd2ccc5,
  0x0000000000010000, 0x0000000000020001,
  0x000000000001fffe, 0x000000000003fffd,
  0x000000000002fffa, 0x000000000005fff5,
  0x000000000003fff4, 0x000000000007ffe9,
  0x000000000000fffe, 0x000000000001fffd,
  0x000000000001fffa, 0x000000000003fff5,
  0x000000000002fff4, 0x000000000005ffe9,
  0x00000000000300f4, 0x00000000000601e9,
  0x000000000000fffc, 0x000000000001fff9,
  0x000000000001fff6, 0x000000000003ffed,
  0x00000000000200f6, 0x00000000000401ed,
  0x00000000000201f4, 0x00000000000403e9,
  0x000000000000fffa, 0x000000000001fff5,
  0x00000000000100fa, 0x00000000000201f5,
  0x00000000000101f8, 0x00000000000203f1,
  0x00000000000102f4, 0x00000000000205e9,
  0x0000000000000100, 0x0000000000000201,
  0x00000000000001fe, 0x00000000000003fd,
  0x00000000000002fa, 0x00000000000005f5,
  0x00000000000003f4, 0x00000000000007e9,
  0x00000000000000fe, 0x00000000000001fd,
  0x00000000000001fa, 0x00000000000003f5,
  0x00000000000002f4, 0x00000000000005e9,
  0x0000000000000334, 0x0000000000000669,
  0x00000000000000fc, 0x00000000000001f9,
  0x00000000000001f6, 0x00000000000003ed,
  0x0000000000000236, 0x000000000000046d,
  0x000000000000023c, 0x0000000000000479,
  0x00000000000000fa, 0x00000000000001f5,
  0x000000000000013a, 0x0000000000000275,
  0x0000000000000140, 0x0000000000000281,
  0x0000000000000144, 0x0000000000000289,
  0x0000000000000040, 0x0000000000000081,
  0x0000000000000046, 0x000000000000008d,
  0x000000000000004a, 0x0000000000000095,
  0x000000000000004c, 0x0000000000000099,
  0x000000000000000c, 0x00000000000000c1,
  0x0000000000000014, 0x0000000000000141,
  0x0000000000000018, 0x0000000000000181,
  0x0000000000000018, 0x0000000000000181,
  0x0000000000000008, 0x0000000000000081,
  0x000000000000000c, 0x00000000000000c1,
  0x000000000000000c, 0x00000000000000c1,
  0x0000000000000008, 0x0000000000000081,
  0x0000000000000004, 0x0000000000000041,
  0x0000000000000004, 0x0000000000000041,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffff8, 0xffffffffffffff81,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffffc, 0xffffffffffffffc1,
  0xfffffffffffffff4, 0xffffffffffffff41,
  0xffffffffffffff74, 0xfffffffffffff741,
  0xfffffffffffffffc, 0xffffffffffffffc1,
  0xfffffffffffffff4, 0xffffffffffffff41,
  0xffffffffffffff74, 0xfffffffffffff741,
  0xfffffffffffffd80, 0xffffffffffffd801,
  0xfffffffffffffff8, 0xffffffffffffff81,
  0xffffffffffffff78, 0xfffffffffffff781,
  0xfffffffffffffd84, 0xffffffffffffd841,
  0xfffffffffffffb8c, 0xffffffffffffb8c1,
  0xffffffffffffff80, 0xfffffffffffff801,
  0xfffffffffffffd8c, 0xffffffffffffd8c1,
  0xfffffffffffffb94, 0xffffffffffffb941,
  0xfffffffffffff998, 0xffffffffffff9981,
  0xfffffffffffffe0c, 0xffffffffffffe0c1,
  0xfffffffffffffc14, 0xffffffffffffc141,
  0xfffffffffffffa18, 0xffffffffffffa181,
  0xfffffffffffdfa24, 0xffffffffffdfa241,
  0xfffffffffffffe08, 0xffffffffffffe081,
  0xfffffffffffffc0c, 0xffffffffffffc0c1,
  0xfffffffffffdfc18, 0xffffffffffdfc181,
  0xfffffffffffbfc20, 0xffffffffffbfc201,
  0xfffffffffffffe04, 0xffffffffffffe041,
  0xfffffffffffdfe10, 0xffffffffffdfe101,
  0xfffffffffffbfe18, 0xffffffffffbfe181,
  0xfffffffffff9fe1c, 0xffffffffff9fe1c1,
  0xfffffffffffe000c, 0xffffffffffe000c1,
  0xfffffffffffc0014, 0xffffffffffc00141,
  0xfffffffffffa0018, 0xffffffffffa00181,
  0xffffffff332d334c, 0xfffffff332d334c1,
  0xfffffffffffe0008, 0xffffffffffe00081,
  0xfffffffffffc000c, 0xffffffffffc000c1,
  0xffffffff332f3340, 0xfffffff332f33401,
  0xfffffffdddd9ddec, 0xffffffdddd9ddec1,
  0xfffffffffffe0004, 0xffffffffffe00041,
  0xffffffff33313338, 0xfffffff333133381,
  0xfffffffddddbdde4, 0xffffffddddbdde41,
  0xfffffffbdddbddf0, 0xffffffbdddbddf01,
  0xffffffff33333334, 0xfffffff333333341,
  0xfffffffddddddde0, 0xffffffddddddde01,
  0xfffffffbddddddec, 0xffffffbddddddec1,
  0xfffffff9ddddddf4, 0xffffff9ddddddf41,
  0xfffffffeaaaaaaac, 0xffffffeaaaaaaac1,
  0xfffffffcaaaaaab8, 0xffffffcaaaaaab81,
  0xfffffffaaaaaaac0, 0xffffffaaaaaaac01,
  0xfffffff8aaaaaac4, 0xffffff8aaaaaac41,
  0xfffffffe0000000c, 0xffffffe0000000c1,
  0xfffffffc00000014, 0xffffffc000000141,
  0xfffffffa00000018, 0xffffffa000000181,
  0xfffffffc00000018, 0xffffffc000000181,
  0xfffffffe00000008, 0xffffffe000000081,
  0xfffffffc0000000c, 0xffffffc0000000c1,
  0xfffffffe0000000c, 0xffffffe0000000c1,
  0x0000000000000008, 0x0000000000000081,
  0xfffffffe00000004, 0xffffffe000000041,
  0x0000000000000004, 0x0000000000000041,
  0x0000000200000000, 0x0000002000000001,
  0x0000000355555558, 0x0000003555555581,
  0x0000000200000000, 0x0000002000000001,
  0x00000003fffffffc, 0x0000003fffffffc1,
  0x0000000555555554, 0x0000005555555541,
  0x0000000622222224, 0x0000006222222241,
  0x00000001fffffffc, 0x0000001fffffffc1,
  0x0000000355555554, 0x0000003555555541,
  0x0000000422222224, 0x0000004222222241,
  0x0000000422242224, 0x0000004222422241,
  0x0000000155555558, 0x0000001555555581,
  0x0000000222222228, 0x0000002222222281,
  0x0000000222242228, 0x0000002222422281,
  0x0000000222262224, 0x0000002222622241,
  0x00000000ccccccd0, 0x0000000ccccccd01,
  0x00000000ccceccd0, 0x0000000ccceccd01,
  0x00000000ccd0cccc, 0x0000000ccd0cccc1,
  0x00000000ccd2ccc4, 0x0000000ccd2ccc41,
  0x0000000000020000, 0x0000000000200001,
  0x000000000003fffc, 0x00000000003fffc1,
  0x000000000005fff4, 0x00000000005fff41,
  0x000000000007ffe8, 0x00000000007ffe81,
  0x000000000001fffc, 0x00000000001fffc1,
  0x000000000003fff4, 0x00000000003fff41,
  0x000000000005ffe8, 0x00000000005ffe81,
  0x00000000000601e8, 0x0000000000601e81,
  0x000000000001fff8, 0x00000000001fff81,
  0x000000000003ffec, 0x00000000003ffec1,
  0x00000000000401ec, 0x0000000000401ec1,
  0x00000000000403e8, 0x0000000000403e81,
  0x000000000001fff4, 0x00000000001fff41,
  0x00000000000201f4, 0x0000000000201f41,
  0x00000000000203f0, 0x0000000000203f01,
  0x00000000000205e8, 0x0000000000205e81,
  0x0000000000000200, 0x0000000000002001,
  0x00000000000003fc, 0x0000000000003fc1,
  0x00000000000005f4, 0x0000000000005f41,
  0x00000000000007e8, 0x0000000000007e81,
  0x00000000000001fc, 0x0000000000001fc1,
  0x00000000000003f4, 0x0000000000003f41,
  0x00000000000005e8, 0x0000000000005e81,
  0x0000000000000668, 0x0000000000006681,
  0x00000000000001f8, 0x0000000000001f81,
  0x00000000000003ec, 0x0000000000003ec1,
  0x000000000000046c, 0x00000000000046c1,
  0x0000000000000478, 0x0000000000004781,
  0x00000000000001f4, 0x0000000000001f41,
  0x0000000000000274, 0x0000000000002741,
  0x0000000000000280, 0x0000000000002801,
  0x0000000000000288, 0x0000000000002881,
  0x0000000000000080, 0x0000000000000801,
  0x000000000000008c, 0x00000000000008c1,
  0x0000000000000094, 0x0000000000000941,
  0x0000000000000098, 0x0000000000000981,
  0x00000000000000c0, 0x00000000000002ef,
  0x0000000000000140, 0x00000000000004e3,
  0x0000000000000180, 0x00000000000005dd,
  0x0000000000000180, 0x00000000000005dd,
  0x0000000000000080, 0x00000000000001f5,
  0x00000000000000c0, 0x00000000000002ef,
  0x00000000000000c0, 0x00000000000002ef,
  0x0000000000000080, 0x00000000000001f5,
  0x0000000000000040, 0x00000000000000fb,
  0x0000000000000040, 0x00000000000000fb,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff80, 0xfffffffffffffe0d,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffffc0, 0xffffffffffffff07,
  0xffffffffffffff40, 0xfffffffffffffd13,
  0xfffffffffffff740, 0xffffffffffffddd3,
  0xffffffffffffffc0, 0xffffffffffffff07,
  0xffffffffffffff40, 0xfffffffffffffd13,
  0xfffffffffffff740, 0xffffffffffffddd3,
  0xffffffffffffd800, 0xffffffffffff63c1,
  0xffffffffffffff80, 0xfffffffffffffe0d,
  0xfffffffffffff780, 0xffffffffffffdecd,
  0xffffffffffffd840, 0xffffffffffff64bb,
  0xffffffffffffb8c0, 0xfffffffffffee9af,
  0xfffffffffffff800, 0xffffffffffffe0c1,
  0xffffffffffffd8c0, 0xffffffffffff66af,
  0xffffffffffffb940, 0xfffffffffffeeba3,
  0xffffffffffff9980, 0xfffffffffffe6f9d,
  0xffffffffffffe0c0, 0xffffffffffff85ef,
  0xffffffffffffc140, 0xffffffffffff0ae3,
  0xffffffffffffa180, 0xfffffffffffe8edd,
  0xffffffffffdfa240, 0xffffffffff8191cb,
  0xffffffffffffe080, 0xffffffffffff84f5,
  0xffffffffffffc0c0, 0xffffffffffff08ef,
  0xffffffffffdfc180, 0xffffffffff820bdd,
  0xffffffffffbfc200, 0xffffffffff050dd1,
  0xffffffffffffe040, 0xffffffffffff83fb,
  0xffffffffffdfe100, 0xffffffffff8286e9,
  0xffffffffffbfe180, 0xffffffffff0588dd,
  0xffffffffff9fe1c0, 0xfffffffffe8889d7,
  0xffffffffffe000c0, 0xffffffffff8302ef,
  0xffffffffffc00140, 0xffffffffff0604e3,
  0xffffffffffa00180, 0xfffffffffe8905dd,
  0xfffffff332d334c0, 0xffffffcdfe89060f,
  0xffffffffffe00080, 0xffffffffff8301f5,
  0xffffffffffc000c0, 0xffffffffff0602ef,
  0xfffffff332f33400, 0xffffffcdff060321,
  0xffffffdddd9ddec0, 0xffffff7aa9b0ae1f,
  0xffffffffffe00040, 0xffffffffff8300fb,
  0xfffffff333133380, 0xffffffcdff83012d,
  0xffffffddddbdde40, 0xffffff7aaa2dac2b,
  0xffffffbdddbddf00, 0xfffffefdaa2daf19,
  0xfffffff333333340, 0xffffffce00000033,
  0xffffffddddddde00, 0xffffff7aaaaaab31,
  0xffffffbddddddec0, 0xfffffefdaaaaae1f,
  0xffffff9ddddddf40, 0xfffffe80aaaab013,
  0xffffffeaaaaaaac0, 0xffffffacaaaaaaff,
  0xffffffcaaaaaab80, 0xffffff2faaaaaded,
  0xffffffaaaaaaac00, 0xfffffeb2aaaaafe1,
  0xffffff8aaaaaac40, 0xfffffe35aaaab0db,
  0xffffffe0000000c0, 0xffffff83000002ef,
  0xffffffc000000140, 0xffffff06000004e3,
  0xffffffa000000180, 0xfffffe89000005dd,
  0xffffffc000000180, 0xffffff06000005dd,
  0xffffffe000000080, 0xffffff83000001f5,
  0xffffffc0000000c0, 0xffffff06000002ef,
  0xffffffe0000000c0, 0xffffff83000002ef,
  0x0000000000000080, 0x00000000000001f5,
  0xffffffe000000040, 0xffffff83000000fb,
  0x0000000000000040, 0x00000000000000fb,
  0x0000002000000000, 0x0000007d00000001,
  0x0000003555555580, 0x000000d0555555fd,
  0x0000002000000000, 0x0000007d00000001,
  0x0000003fffffffc0, 0x000000f9ffffff07,
  0x0000005555555540, 0x0000014d55555503,
  0x0000006222222240, 0x0000017f555555cb,
  0x0000001fffffffc0, 0x0000007cffffff07,
  0x0000003555555540, 0x000000d055555503,
  0x0000004222222240, 0x00000102555555cb,
  0x0000004222422240, 0x0000010255d255cb,
  0x0000001555555580, 0x00000053555555fd,
  0x0000002222222280, 0x00000085555556c5,
  0x0000002222422280, 0x0000008555d256c5,
  0x0000002222622240, 0x00000085564f55cb,
  0x0000000ccccccd00, 0x00000032000000c9,
  0x0000000ccceccd00, 0x00000032007d00c9,
  0x0000000ccd0cccc0, 0x0000003200f9ffcf,
  0x0000000ccd2ccc40, 0x000000320176fddb,
  0x0000000000200000, 0x00000000007d0001,
  0x00000000003fffc0, 0x0000000000f9ff07,
  0x00000000005fff40, 0x000000000176fd13,
  0x00000000007ffe80, 0x0000000001f3fa25,
  0x00000000001fffc0, 0x00000000007cff07,
  0x00000000003fff40, 0x0000000000f9fd13,
  0x00000000005ffe80, 0x000000000176fa25,
  0x0000000000601e80, 0x0000000001777725,
  0x00000000001fff80, 0x00000000007cfe0d,
  0x00000000003ffec0, 0x0000000000f9fb1f,
  0x0000000000401ec0, 0x0000000000fa781f,
  0x0000000000403e80, 0x0000000000faf425,
  0x00000000001fff40, 0x00000000007cfd13,
  0x0000000000201f40, 0x00000000007d7a13,
  0x0000000000203f00, 0x00000000007df619,
  0x0000000000205e80, 0x00000000007e7125,
  0x0000000000002000, 0x0000000000007d01,
  0x0000000000003fc0, 0x000000000000f907,
  0x0000000000005f40, 0x0000000000017413,
  0x0000000000007e80, 0x000000000001ee25,
  0x0000000000001fc0, 0x0000000000007c07,
  0x0000000000003f40, 0x000000000000f713,
  0x0000000000005e80, 0x0000000000017125,
  0x0000000000006680, 0x0000000000019065,
  0x0000000000001f80, 0x0000000000007b0d,
  0x0000000000003ec0, 0x000000000000f51f,
  0x00000000000046c0, 0x000000000001145f,
  0x0000000000004780, 0x000000000001174d,
  0x0000000000001f40, 0x0000000000007a13,
  0x0000000000002740, 0x0000000000009953,
  0x0000000000002800, 0x0000000000009c41,
  0x0000000000002880, 0x0000000000009e35,
  0x0000000000000800, 0x0000000000001f41,
  0x00000000000008c0, 0x000000000000222f,
  0x0000000000000940, 0x0000000000002423,
  0x0000000000000980, 0x000000000000251d,
  0x00000000000002ee, 0x00000000000002f5,
  0x00000000000004e2, 0x00000000000004ed,
  0x00000000000005dc, 0x00000000000005e9,
  0x00000000000005dc, 0x00000000000005e9,
  0x00000000000001f4, 0x00000000000001f9,
  0x00000000000002ee, 0x00000000000002f5,
  0x00000000000002ee, 0x00000000000002f5,
  0x00000000000001f4, 0x00000000000001f9,
  0x00000000000000fa, 0x00000000000000fd,
  0x00000000000000fa, 0x00000000000000fd,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffe0c, 0xfffffffffffffe09,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff06, 0xffffffffffffff05,
  0xfffffffffffffd12, 0xfffffffffffffd0d,
  0xffffffffffffddd2, 0xffffffffffffdd8d,
  0xffffffffffffff06, 0xffffffffffffff05,
  0xfffffffffffffd12, 0xfffffffffffffd0d,
  0xffffffffffffddd2, 0xffffffffffffdd8d,
  0xffffffffffff63c0, 0xffffffffffff6281,
  0xfffffffffffffe0c, 0xfffffffffffffe09,
  0xffffffffffffdecc, 0xffffffffffffde89,
  0xffffffffffff64ba, 0xffffffffffff637d,
  0xfffffffffffee9ae, 0xfffffffffffee775,
  0xffffffffffffe0c0, 0xffffffffffffe081,
  0xffffffffffff66ae, 0xffffffffffff6575,
  0xfffffffffffeeba2, 0xfffffffffffee96d,
  0xfffffffffffe6f9c, 0xfffffffffffe6c69,
  0xffffffffffff85ee, 0xffffffffffff84f5,
  0xffffffffffff0ae2, 0xffffffffffff08ed,
  0xfffffffffffe8edc, 0xfffffffffffe8be9,
  0xffffffffff8191ca, 0xffffffffff808edd,
  0xffffffffffff84f4, 0xffffffffffff83f9,
  0xffffffffffff08ee, 0xffffffffffff06f5,
  0xffffffffff820bdc, 0xffffffffff8109e9,
  0xffffffffff050dd0, 0xffffffffff030be1,
  0xffffffffffff83fa, 0xffffffffffff82fd,
  0xffffffffff8286e8, 0xffffffffff8185f1,
  0xffffffffff0588dc, 0xffffffffff0387e9,
  0xfffffffffe8889d6, 0xfffffffffe8588e5,
  0xffffffffff8302ee, 0xffffffffff8202f5,
  0xffffffffff0604e2, 0xffffffffff0404ed,
  0xfffffffffe8905dc, 0xfffffffffe8605e9,
  0xffffffcdfe89060e, 0xffffffcd981f9fb5,
  0xffffffffff8301f4, 0xffffffffff8201f9,
  0xffffffffff0602ee, 0xffffffffff0402f5,
  0xffffffcdff060320, 0xffffffcd989d9cc1,
  0xffffff7aa9b0ae1e, 0xffffff79989d9d15,
  0xffffffffff8300fa, 0xffffffffff8200fd,
  0xffffffcdff83012c, 0xffffffcd991b9ac9,
  0xffffff7aaa2dac2a, 0xffffff79991b9b1d,
  0xfffffefdaa2daf18, 0xfffffefb991b9e11,
  0xffffffce00000032, 0xffffffcd999999cd,
  0xffffff7aaaaaab30, 0xffffff7999999a21,
  0xfffffefdaaaaae1e, 0xfffffefb99999d15,
  0xfffffe80aaaab012, 0xfffffe7d99999f0d,
  0xffffffacaaaaaafe, 0xffffffac00000055,
  0xffffff2faaaaadec, 0xffffff2e00000349,
  0xfffffeb2aaaaafe0, 0xfffffeb000000541,
  0xfffffe35aaaab0da, 0xfffffe320000063d,
  0xffffff83000002ee, 0xffffff82000002f5,
  0xffffff06000004e2, 0xffffff04000004ed,
  0xfffffe89000005dc, 0xfffffe86000005e9,
  0xffffff06000005dc, 0xffffff04000005e9,
  0xffffff83000001f4, 0xffffff82000001f9,
  0xffffff06000002ee, 0xffffff04000002f5,
  0xffffff83000002ee, 0xffffff82000002f5,
  0x00000000000001f4, 0x00000000000001f9,
  0xffffff83000000fa, 0xffffff82000000fd,
  0x00000000000000fa, 0x00000000000000fd,
  0x0000007d00000000, 0x0000007e00000001,
  0x000000d0555555fc, 0x000000d2000000a9,
  0x0000007d00000000, 0x0000007e00000001,
  0x000000f9ffffff06, 0x000000fbffffff05,
  0x0000014d55555502, 0x0000014fffffffad,
  0x0000017f555555ca, 0x00000182666666dd,
  0x0000007cffffff06, 0x0000007dffffff05,
  0x000000d055555502, 0x000000d1ffffffad,
  0x00000102555555ca, 0x00000104666666dd,
  0x0000010255d255ca, 0x0000010466e466dd,
  0x00000053555555fc, 0x00000054000000a9,
  0x00000085555556c4, 0x00000086666667d9,
  0x0000008555d256c4, 0x0000008666e467d9,
  0x00000085564f55ca, 0x00000086676266dd,
  0x00000032000000c8, 0x0000003266666731,
  0x00000032007d00c8, 0x0000003266e46731,
  0x0000003200f9ffce, 0x0000003267626635,
  0x000000320176fdda, 0x0000003267e0643d,
  0x00000000007d0000, 0x00000000007e0001,
  0x0000000000f9ff06, 0x0000000000fbff05,
  0x000000000176fd12, 0x000000000179fd0d,
  0x0000000001f3fa24, 0x0000000001f7fa19,
  0x00000000007cff06, 0x00000000007dff05,
  0x0000000000f9fd12, 0x0000000000fbfd0d,
  0x000000000176fa24, 0x000000000179fa19,
  0x0000000001777724, 0x00000000017a7819,
  0x00000000007cfe0c, 0x00000000007dfe09,
  0x0000000000f9fb1e, 0x0000000000fbfb15,
  0x0000000000fa781e, 0x0000000000fc7915,
  0x0000000000faf424, 0x0000000000fcf619,
  0x00000000007cfd12, 0x00000000007dfd0d,
  0x00000000007d7a12, 0x00000000007e7b0d,
  0x00000000007df618, 0x00000000007ef811,
  0x00000000007e7124, 0x00000000007f7419,
  0x0000000000007d00, 0x0000000000007e01,
  0x000000000000f906, 0x000000000000fb05,
  0x0000000000017412, 0x000000000001770d,
  0x000000000001ee24, 0x000000000001f219,
  0x0000000000007c06, 0x0000000000007d05,
  0x000000000000f712, 0x000000000000f90d,
  0x0000000000017124, 0x0000000000017419,
  0x0000000000019064, 0x0000000000019399,
  0x0000000000007b0c, 0x0000000000007c09,
  0x000000000000f51e, 0x000000000000f715,
  0x000000000001145e, 0x0000000000011695,
  0x000000000001174c, 0x0000000000011989,
  0x0000000000007a12, 0x0000000000007b0d,
  0x0000000000009952, 0x0000000000009a8d,
  0x0000000000009c40, 0x0000000000009d81,
  0x0000000000009e34, 0x0000000000009f79,
  0x0000000000001f40, 0x0000000000001f81,
  0x000000000000222e, 0x0000000000002275,
  0x0000000000002422, 0x000000000000246d,
  0x000000000000251c, 0x0000000000002569,
  0x00000000000002f4, 0x00000000000002fb,
  0x00000000000004ec, 0x00000000000004f7,
  0x00000000000005e8, 0x00000000000005f5,
  0x00000000000005e8, 0x00000000000005f5,
  0x00000000000001f8, 0x00000000000001fd,
  0x00000000000002f4, 0x00000000000002fb,
  0x00000000000002f4, 0x00000000000002fb,
  0x00000000000001f8, 0x00000000000001fd,
  0x00000000000000fc, 0x00000000000000ff,
  0x00000000000000fc, 0x00000000000000ff,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffe08, 0xfffffffffffffe05,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff04, 0xffffffffffffff03,
  0xfffffffffffffd0c, 0xfffffffffffffd07,
  0xffffffffffffdd8c, 0xffffffffffffdd47,
  0xffffffffffffff04, 0xffffffffffffff03,
  0xfffffffffffffd0c, 0xfffffffffffffd07,
  0xffffffffffffdd8c, 0xffffffffffffdd47,
  0xffffffffffff6280, 0xffffffffffff6141,
  0xfffffffffffffe08, 0xfffffffffffffe05,
  0xffffffffffffde88, 0xffffffffffffde45,
  0xffffffffffff637c, 0xffffffffffff623f,
  0xfffffffffffee774, 0xfffffffffffee53b,
  0xffffffffffffe080, 0xffffffffffffe041,
  0xffffffffffff6574, 0xffffffffffff643b,
  0xfffffffffffee96c, 0xfffffffffffee737,
  0xfffffffffffe6c68, 0xfffffffffffe6935,
  0xffffffffffff84f4, 0xffffffffffff83fb,
  0xffffffffffff08ec, 0xffffffffffff06f7,
  0xfffffffffffe8be8, 0xfffffffffffe88f5,
  0xffffffffff808edc, 0xffffffffff7f8bef,
  0xffffffffffff83f8, 0xffffffffffff82fd,
  0xffffffffffff06f4, 0xffffffffffff04fb,
  0xffffffffff8109e8, 0xffffffffff8007f5,
  0xffffffffff030be0, 0xffffffffff0109f1,
  0xffffffffffff82fc, 0xffffffffffff81ff,
  0xffffffffff8185f0, 0xffffffffff8084f9,
  0xffffffffff0387e8, 0xffffffffff0186f5,
  0xfffffffffe8588e4, 0xfffffffffe8287f3,
  0xffffffffff8202f4, 0xffffffffff8102fb,
  0xffffffffff0404ec, 0xffffffffff0204f7,
  0xfffffffffe8605e8, 0xfffffffffe8305f5,
  0xffffffcd981f9fb4, 0xffffffcd31b6395b,
  0xffffffffff8201f8, 0xffffffffff8101fd,
  0xffffffffff0402f4, 0xffffffffff0202fb,
  0xffffffcd989d9cc0, 0xffffffcd32353661,
  0xffffff79989d9d14, 0xffffff78878a8c0b,
  0xffffffffff8200fc, 0xffffffffff8100ff,
  0xffffffcd991b9ac8, 0xffffffcd32b43465,
  0xffffff79991b9b1c, 0xffffff7888098a0f,
  0xfffffefb991b9e10, 0xfffffef988098d09,
  0xffffffcd999999cc, 0xffffffcd33333367,
  0xffffff7999999a20, 0xffffff7888888911,
  0xfffffefb99999d14, 0xfffffef988888c0b,
  0xfffffe7d99999f0c, 0xfffffe7a88888e07,
  0xffffffac00000054, 0xffffffab555555ab,
  0xffffff2e00000348, 0xffffff2c555558a5,
  0xfffffeb000000540, 0xfffffead55555aa1,
  0xfffffe320000063c, 0xfffffe2e55555b9f,
  0xffffff82000002f4, 0xffffff81000002fb,
  0xffffff04000004ec, 0xffffff02000004f7,
  0xfffffe86000005e8, 0xfffffe83000005f5,
  0xffffff04000005e8, 0xffffff02000005f5,
  0xffffff82000001f8, 0xffffff81000001fd,
  0xffffff04000002f4, 0xffffff02000002fb,
  0xffffff82000002f4, 0xffffff81000002fb,
  0x00000000000001f8, 0x00000000000001fd,
  0xffffff82000000fc, 0xffffff81000000ff,
  0x00000000000000fc, 0x00000000000000ff,
  0x0000007e00000000, 0x0000007f00000001,
  0x000000d2000000a8, 0x000000d3aaaaab55,
  0x0000007e00000000, 0x0000007f00000001,
  0x000000fbffffff04, 0x000000fdffffff03,
  0x0000014fffffffac, 0x00000152aaaaaa57,
  0x00000182666666dc, 0x00000185777777ef,
  0x0000007dffffff04, 0x0000007effffff03,
  0x000000d1ffffffac, 0x000000d3aaaaaa57,
  0x00000104666666dc, 0x00000106777777ef,
  0x0000010466e466dc, 0x0000010677f677ef,
  0x00000054000000a8, 0x00000054aaaaab55,
  0x00000086666667d8, 0x00000087777778ed,
  0x0000008666e467d8, 0x0000008777f678ed,
  0x00000086676266dc, 0x00000087787577ef,
  0x0000003266666730, 0x00000032cccccd99,
  0x0000003266e46730, 0x00000032cd4bcd99,
  0x0000003267626634, 0x00000032cdcacc9b,
  0x0000003267e0643c, 0x00000032ce49ca9f,
  0x00000000007e0000, 0x00000000007f0001,
  0x0000000000fbff04, 0x0000000000fdff03,
  0x000000000179fd0c, 0x00000000017cfd07,
  0x0000000001f7fa18, 0x0000000001fbfa0d,
  0x00000000007dff04, 0x00000000007eff03,
  0x0000000000fbfd0c, 0x0000000000fdfd07,
  0x000000000179fa18, 0x00000000017cfa0d,
  0x00000000017a7818, 0x00000000017d790d,
  0x00000000007dfe08, 0x00000000007efe05,
  0x0000000000fbfb14, 0x0000000000fdfb0b,
  0x0000000000fc7914, 0x0000000000fe7a0b,
  0x0000000000fcf618, 0x0000000000fef80d,
  0x00000000007dfd0c, 0x00000000007efd07,
  0x00000000007e7b0c, 0x00000000007f7c07,
  0x00000000007ef810, 0x00000000007ffa09,
  0x00000000007f7418, 0x000000000080770d,
  0x0000000000007e00, 0x0000000000007f01,
  0x000000000000fb04, 0x000000000000fd03,
  0x000000000001770c, 0x0000000000017a07,
  0x000000000001f218, 0x000000000001f60d,
  0x0000000000007d04, 0x0000000000007e03,
  0x000000000000f90c, 0x000000000000fb07,
  0x0000000000017418, 0x000000000001770d,
  0x0000000000019398, 0x00000000000196cd,
  0x0000000000007c08, 0x0000000000007d05,
  0x000000000000f714, 0x000000000000f90b,
  0x0000000000011694, 0x00000000000118cb,
  0x0000000000011988, 0x0000000000011bc5,
  0x0000000000007b0c, 0x0000000000007c07,
  0x0000000000009a8c, 0x0000000000009bc7,
  0x0000000000009d80, 0x0000000000009ec1,
  0x0000000000009f78, 0x000000000000a0bd,
  0x0000000000001f80, 0x0000000000001fc1,
  0x0000000000002274, 0x00000000000022bb,
  0x000000000000246c, 0x00000000000024b7,
  0x0000000000002568, 0x00000000000025b5,
  0x00000000000002fa, 0x000000000002ffef,
  0x00000000000004f6, 0x000000000004ffe3,
  0x00000000000005f4, 0x000000000005ffdd,
  0x00000000000005f4, 0x000000000005ffdd,
  0x00000000000001fc, 0x000000000001fff5,
  0x00000000000002fa, 0x000000000002ffef,
  0x00000000000002fa, 0x000000000002ffef,
  0x00000000000001fc, 0x000000000001fff5,
  0x00000000000000fe, 0x000000000000fffb,
  0x00000000000000fe, 0x000000000000fffb,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffffe04, 0xfffffffffffe000d,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffffff02, 0xffffffffffff0007,
  0xfffffffffffffd06, 0xfffffffffffd0013,
  0xffffffffffffdd46, 0xffffffffffdd00d3,
  0xffffffffffffff02, 0xffffffffffff0007,
  0xfffffffffffffd06, 0xfffffffffffd0013,
  0xffffffffffffdd46, 0xffffffffffdd00d3,
  0xffffffffffff6140, 0xffffffffff6003c1,
  0xfffffffffffffe04, 0xfffffffffffe000d,
  0xffffffffffffde44, 0xffffffffffde00cd,
  0xffffffffffff623e, 0xffffffffff6103bb,
  0xfffffffffffee53a, 0xfffffffffee306af,
  0xffffffffffffe040, 0xffffffffffe000c1,
  0xffffffffffff643a, 0xffffffffff6303af,
  0xfffffffffffee736, 0xfffffffffee506a3,
  0xfffffffffffe6934, 0xfffffffffe66099d,
  0xffffffffffff83fa, 0xffffffffff8302ef,
  0xffffffffffff06f6, 0xffffffffff0505e3,
  0xfffffffffffe88f4, 0xfffffffffe8608dd,
  0xffffffffff7f8bee, 0xffffffff7e8c08cb,
  0xffffffffffff82fc, 0xffffffffff8202f5,
  0xffffffffffff04fa, 0xffffffffff0305ef,
  0xffffffffff8007f4, 0xffffffff7f0905dd,
  0xffffffffff0109f0, 0xfffffffeff0e05d1,
  0xffffffffffff81fe, 0xffffffffff8102fb,
  0xffffffffff8084f8, 0xffffffff7f8702e9,
  0xffffffffff0186f4, 0xfffffffeff8c02dd,
  0xfffffffffe8287f2, 0xfffffffe7f9002d7,
  0xffffffffff8102fa, 0xffffffff8005ffef,
  0xffffffffff0204f6, 0xffffffff000affe3,
  0xfffffffffe8305f4, 0xfffffffe800effdd,
  0xffffffcd31b6395a, 0xffffcccc800f330f,
  0xffffffffff8101fc, 0xffffffff8004fff5,
  0xffffffffff0202fa, 0xffffffff0008ffef,
  0xffffffcd32353660, 0xffffcccd00093321,
  0xffffff78878a8c0a, 0xffff7779aab4331f,
  0xffffffffff8100fe, 0xffffffff8003fffb,
  0xffffffcd32b43464, 0xffffcccd8004332d,
  0xffffff7888098a0e, 0xffff777a2aaf332b,
  0xfffffef988098d08, 0xfffef77d2ab23319,
  0xffffffcd33333366, 0xffffccce00003333,
  0xffffff7888888910, 0xffff777aaaab3331,
  0xfffffef988888c0a, 0xfffef77daaae331f,
  0xfffffe7a88888e06, 0xfffe7780aab03313,
  0xffffffab555555aa, 0xffffaaacaaaaffff,
  0xffffff2c555558a4, 0xffff2aafaaadffed,
  0xfffffead55555aa0, 0xfffeaab2aaafffe1,
  0xfffffe2e55555b9e, 0xfffe2ab5aab0ffdb,
  0xffffff81000002fa, 0xffff80030002ffef,
  0xffffff02000004f6, 0xffff00060004ffe3,
  0xfffffe83000005f4, 0xfffe80090005ffdd,
  0xffffff02000005f4, 0xffff00060005ffdd,
  0xffffff81000001fc, 0xffff80030001fff5,
  0xffffff02000002fa, 0xffff00060002ffef,
  0xffffff81000002fa, 0xffff80030002ffef,
  0x00000000000001fc, 0x000000000001fff5,
  0xffffff81000000fe, 0xffff80030000fffb,
  0x00000000000000fe, 0x000000000000fffb,
  0x0000007f00000000, 0x00007ffd00000001,
  0x000000d3aaaaab54, 0x0000d5505555fffd,
  0x0000007f00000000, 0x00007ffd00000001,
  0x000000fdffffff02, 0x0000fff9ffff0007,
  0x00000152aaaaaa56, 0x0001554d55550003,
  0x00000185777777ee, 0x0001887f5555cccb,
  0x0000007effffff02, 0x00007ffcffff0007,
  0x000000d3aaaaaa56, 0x0000d55055550003,
  0x00000106777777ee, 0x000108825555cccb,
  0x0000010677f677ee, 0x00010882d552cccb,
  0x00000054aaaaab54, 0x000055535555fffd,
  0x00000087777778ec, 0x000088855556ccc5,
  0x0000008777f678ec, 0x00008885d553ccc5,
  0x00000087787577ee, 0x00008886554fcccb,
  0x00000032cccccd98, 0x000033320000ccc9,
  0x00000032cd4bcd98, 0x000033327ffdccc9,
  0x00000032cdcacc9a, 0x00003332fff9cccf,
  0x00000032ce49ca9e, 0x000033337ff4ccdb,
  0x00000000007f0000, 0x000000007ffd0001,
  0x0000000000fdff02, 0x00000000fff90007,
  0x00000000017cfd06, 0x000000017ff40013,
  0x0000000001fbfa0c, 0x00000001ffee0025,
  0x00000000007eff02, 0x000000007ffc0007,
  0x0000000000fdfd06, 0x00000000fff70013,
  0x00000000017cfa0c, 0x000000017ff10025,
  0x00000000017d790c, 0x000000018070fd25,
  0x00000000007efe04, 0x000000007ffb000d,
  0x0000000000fdfb0a, 0x00000000fff5001f,
  0x0000000000fe7a0a, 0x000000010074fd1f,
  0x0000000000fef80c, 0x0000000100f3fa25,
  0x00000000007efd06, 0x000000007ffa0013,
  0x00000000007f7c06, 0x000000008079fd13,
  0x00000000007ffa08, 0x0000000080f8fa19,
  0x000000000080770c, 0x000000008176f725,
  0x0000000000007f00, 0x00000000007ffd01,
  0x000000000000fd02, 0x0000000000fefa07,
  0x0000000000017a06, 0x00000000017cf713,
  0x000000000001f60c, 0x0000000001f9f425,
  0x0000000000007e02, 0x00000000007efd07,
  0x000000000000fb06, 0x0000000000fcfa13,
  0x000000000001770c, 0x000000000179f725,
  0x00000000000196cc, 0x000000000199f665,
  0x0000000000007d04, 0x00000000007dfd0d,
  0x000000000000f90a, 0x0000000000fafa1f,
  0x00000000000118ca, 0x00000000011af95f,
  0x0000000000011bc4, 0x00000000011df94d,
  0x0000000000007c06, 0x00000000007cfd13,
  0x0000000000009bc6, 0x00000000009cfc53,
  0x0000000000009ec0, 0x00000000009ffc41,
  0x000000000000a0bc, 0x0000000000a1fc35,
  0x0000000000001fc0, 0x00000000001fff41,
  0x00000000000022ba, 0x000000000022ff2f,
  0x00000000000024b6, 0x000000000024ff23,
  0x00000000000025b4, 0x000000000025ff1d,
  0x000000000002ffee, 0x000000000002fff5,
  0x000000000004ffe2, 0x000000000004ffed,
  0x000000000005ffdc, 0x000000000005ffe9,
  0x000000000005ffdc, 0x000000000005ffe9,
  0x000000000001fff4, 0x000000000001fff9,
  0x000000000002ffee, 0x000000000002fff5,
  0x000000000002ffee, 0x000000000002fff5,
  0x000000000001fff4, 0x000000000001fff9,
  0x000000000000fffa, 0x000000000000fffd,
  0x000000000000fffa, 0x000000000000fffd,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffe000c, 0xfffffffffffe0009,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0006, 0xffffffffffff0005,
  0xfffffffffffd0012, 0xfffffffffffd000d,
  0xffffffffffdd00d2, 0xffffffffffdd008d,
  0xffffffffffff0006, 0xffffffffffff0005,
  0xfffffffffffd0012, 0xfffffffffffd000d,
  0xffffffffffdd00d2, 0xffffffffffdd008d,
  0xffffffffff6003c0, 0xffffffffff600281,
  0xfffffffffffe000c, 0xfffffffffffe0009,
  0xffffffffffde00cc, 0xffffffffffde0089,
  0xffffffffff6103ba, 0xffffffffff61027d,
  0xfffffffffee306ae, 0xfffffffffee30475,
  0xffffffffffe000c0, 0xffffffffffe00081,
  0xffffffffff6303ae, 0xffffffffff630275,
  0xfffffffffee506a2, 0xfffffffffee5046d,
  0xfffffffffe66099c, 0xfffffffffe660669,
  0xffffffffff8302ee, 0xffffffffff8301f5,
  0xffffffffff0505e2, 0xffffffffff0503ed,
  0xfffffffffe8608dc, 0xfffffffffe8605e9,
  0xffffffff7e8c08ca, 0xffffffff7e8b05dd,
  0xffffffffff8202f4, 0xffffffffff8201f9,
  0xffffffffff0305ee, 0xffffffffff0303f5,
  0xffffffff7f0905dc, 0xffffffff7f0803e9,
  0xfffffffeff0e05d0, 0xfffffffeff0c03e1,
  0xffffffffff8102fa, 0xffffffffff8101fd,
  0xffffffff7f8702e8, 0xffffffff7f8601f1,
  0xfffffffeff8c02dc, 0xfffffffeff8a01e9,
  0xfffffffe7f9002d6, 0xfffffffe7f8d01e5,
  0xffffffff8005ffee, 0xffffffff8004fff5,
  0xffffffff000affe2, 0xffffffff0008ffed,
  0xfffffffe800effdc, 0xfffffffe800bffe9,
  0xffffcccc800f330e, 0xffffcccc19a5ccb5,
  0xffffffff8004fff4, 0xffffffff8003fff9,
  0xffffffff0008ffee, 0xffffffff0006fff5,
  0xffffcccd00093320, 0xffffcccc99a0ccc1,
  0xffff7779aab4331e, 0xffff777899a12215,
  0xffffffff8003fffa, 0xffffffff8002fffd,
  0xffffcccd8004332c, 0xffffcccd199cccc9,
  0xffff777a2aaf332a, 0xffff7779199d221d,
  0xfffef77d2ab23318, 0xfffef77b19a02211,
  0xffffccce00003332, 0xffffcccd9999cccd,
  0xffff777aaaab3330, 0xffff7779999a2221,
  0xfffef77daaae331e, 0xfffef77b999d2215,
  0xfffe7780aab03312, 0xfffe777d999f220d,
  0xffffaaacaaaafffe, 0xffffaaac00005555,
  0xffff2aafaaadffec, 0xffff2aae00035549,
  0xfffeaab2aaafffe0, 0xfffeaab000055541,
  0xfffe2ab5aab0ffda, 0xfffe2ab20006553d,
  0xffff80030002ffee, 0xffff80020002fff5,
  0xffff00060004ffe2, 0xffff00040004ffed,
  0xfffe80090005ffdc, 0xfffe80060005ffe9,
  0xffff00060005ffdc, 0xffff00040005ffe9,
  0xffff80030001fff4, 0xffff80020001fff9,
  0xffff00060002ffee, 0xffff00040002fff5,
  0xffff80030002ffee, 0xffff80020002fff5,
  0x000000000001fff4, 0x000000000001fff9,
  0xffff80030000fffa, 0xffff80020000fffd,
  0x000000000000fffa, 0x000000000000fffd,
  0x00007ffd00000000, 0x00007ffe00000001,
  0x0000d5505555fffc, 0x0000d5520000aaa9,
  0x00007ffd00000000, 0x00007ffe00000001,
  0x0000fff9ffff0006, 0x0000fffbffff0005,
  0x0001554d55550002, 0x0001554fffffaaad,
  0x0001887f5555ccca, 0x000188826666dddd,
  0x00007ffcffff0006, 0x00007ffdffff0005,
  0x0000d55055550002, 0x0000d551ffffaaad,
  0x000108825555ccca, 0x000108846666dddd,
  0x00010882d552ccca, 0x00010884e664dddd,
  0x000055535555fffc, 0x000055540000aaa9,
  0x000088855556ccc4, 0x000088866667ddd9,
  0x00008885d553ccc4, 0x00008886e665ddd9,
  0x00008886554fccca, 0x000088876662dddd,
  0x000033320000ccc8, 0x0000333266673331,
  0x000033327ffdccc8, 0x00003332e6653331,
  0x00003332fff9ccce, 0x0000333366623335,
  0x000033337ff4ccda, 0x00003333e65e333d,
  0x000000007ffd0000, 0x000000007ffe0001,
  0x00000000fff90006, 0x00000000fffb0005,
  0x000000017ff40012, 0x000000017ff7000d,
  0x00000001ffee0024, 0x00000001fff20019,
  0x000000007ffc0006, 0x000000007ffd0005,
  0x00000000fff70012, 0x00000000fff9000d,
  0x000000017ff10024, 0x000000017ff40019,
  0x000000018070fd24, 0x000000018073fe19,
  0x000000007ffb000c, 0x000000007ffc0009,
  0x00000000fff5001e, 0x00000000fff70015,
  0x000000010074fd1e, 0x000000010076fe15,
  0x0000000100f3fa24, 0x0000000100f5fc19,
  0x000000007ffa0012, 0x000000007ffb000d,
  0x000000008079fd12, 0x00000000807afe0d,
  0x0000000080f8fa18, 0x0000000080f9fc11,
  0x000000008176f724, 0x000000008177fa19,
  0x00000000007ffd00, 0x00000000007ffe01,
  0x0000000000fefa06, 0x0000000000fefc05,
  0x00000000017cf712, 0x00000000017cfa0d,
  0x0000000001f9f424, 0x0000000001f9f819,
  0x00000000007efd06, 0x00000000007efe05,
  0x0000000000fcfa12, 0x0000000000fcfc0d,
  0x000000000179f724, 0x000000000179fa19,
  0x000000000199f664, 0x000000000199f999,
  0x00000000007dfd0c, 0x00000000007dfe09,
  0x0000000000fafa1e, 0x0000000000fafc15,
  0x00000000011af95e, 0x00000000011afb95,
  0x00000000011df94c, 0x00000000011dfb89,
  0x00000000007cfd12, 0x00000000007cfe0d,
  0x00000000009cfc52, 0x00000000009cfd8d,
  0x00000000009ffc40, 0x00000000009ffd81,
  0x0000000000a1fc34, 0x0000000000a1fd79,
  0x00000000001fff40, 0x00000000001fff81,
  0x000000000022ff2e, 0x000000000022ff75,
  0x000000000024ff22, 0x000000000024ff6d,
  0x000000000025ff1c, 0x000000000025ff69,
  0x000000000002fff4, 0x000000000002fffb,
  0x000000000004ffec, 0x000000000004fff7,
  0x000000000005ffe8, 0x000000000005fff5,
  0x000000000005ffe8, 0x000000000005fff5,
  0x000000000001fff8, 0x000000000001fffd,
  0x000000000002fff4, 0x000000000002fffb,
  0x000000000002fff4, 0x000000000002fffb,
  0x000000000001fff8, 0x000000000001fffd,
  0x000000000000fffc, 0x000000000000ffff,
  0x000000000000fffc, 0x000000000000ffff,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffe0008, 0xfffffffffffe0005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0004, 0xffffffffffff0003,
  0xfffffffffffd000c, 0xfffffffffffd0007,
  0xffffffffffdd008c, 0xffffffffffdd0047,
  0xffffffffffff0004, 0xffffffffffff0003,
  0xfffffffffffd000c, 0xfffffffffffd0007,
  0xffffffffffdd008c, 0xffffffffffdd0047,
  0xffffffffff600280, 0xffffffffff600141,
  0xfffffffffffe0008, 0xfffffffffffe0005,
  0xffffffffffde0088, 0xffffffffffde0045,
  0xffffffffff61027c, 0xffffffffff61013f,
  0xfffffffffee30474, 0xfffffffffee3023b,
  0xffffffffffe00080, 0xffffffffffe00041,
  0xffffffffff630274, 0xffffffffff63013b,
  0xfffffffffee5046c, 0xfffffffffee50237,
  0xfffffffffe660668, 0xfffffffffe660335,
  0xffffffffff8301f4, 0xffffffffff8300fb,
  0xffffffffff0503ec, 0xffffffffff0501f7,
  0xfffffffffe8605e8, 0xfffffffffe8602f5,
  0xffffffff7e8b05dc, 0xffffffff7e8a02ef,
  0xffffffffff8201f8, 0xffffffffff8200fd,
  0xffffffffff0303f4, 0xffffffffff0301fb,
  0xffffffff7f0803e8, 0xffffffff7f0701f5,
  0xfffffffeff0c03e0, 0xfffffffeff0a01f1,
  0xffffffffff8101fc, 0xffffffffff8100ff,
  0xffffffff7f8601f0, 0xffffffff7f8500f9,
  0xfffffffeff8a01e8, 0xfffffffeff8800f5,
  0xfffffffe7f8d01e4, 0xfffffffe7f8a00f3,
  0xffffffff8004fff4, 0xffffffff8003fffb,
  0xffffffff0008ffec, 0xffffffff0006fff7,
  0xfffffffe800bffe8, 0xfffffffe8008fff5,
  0xffffcccc19a5ccb4, 0xffffcccbb33c665b,
  0xffffffff8003fff8, 0xffffffff8002fffd,
  0xffffffff0006fff4, 0xffffffff0004fffb,
  0xffffcccc99a0ccc0, 0xffffcccc33386661,
  0xffff777899a12214, 0xffff7777888e110b,
  0xffffffff8002fffc, 0xffffffff8001ffff,
  0xffffcccd199cccc8, 0xffffccccb3356665,
  0xffff7779199d221c, 0xffff7778088b110f,
  0xfffef77b19a02210, 0xfffef779088e1109,
  0xffffcccd9999cccc, 0xffffcccd33336667,
  0xffff7779999a2220, 0xffff777888891111,
  0xfffef77b999d2214, 0xfffef779888c110b,
  0xfffe777d999f220c, 0xfffe777a888e1107,
  0xffffaaac00005554, 0xffffaaab5555aaab,
  0xffff2aae00035548, 0xffff2aac5558aaa5,
  0xfffeaab000055540, 0xfffeaaad555aaaa1,
  0xfffe2ab20006553c, 0xfffe2aae555baa9f,
  0xffff80020002fff4, 0xffff80010002fffb,
  0xffff00040004ffec, 0xffff00020004fff7,
  0xfffe80060005ffe8, 0xfffe80030005fff5,
  0xffff00040005ffe8, 0xffff00020005fff5,
  0xffff80020001fff8, 0xffff80010001fffd,
  0xffff00040002fff4, 0xffff00020002fffb,
  0xffff80020002fff4, 0xffff80010002fffb,
  0x000000000001fff8, 0x000000000001fffd,
  0xffff80020000fffc, 0xffff80010000ffff,
  0x000000000000fffc, 0x000000000000ffff,
  0x00007ffe00000000, 0x00007fff00000001,
  0x0000d5520000aaa8, 0x0000d553aaab5555,
  0x00007ffe00000000, 0x00007fff00000001,
  0x0000fffbffff0004, 0x0000fffdffff0003,
  0x0001554fffffaaac, 0x00015552aaaa5557,
  0x000188826666dddc, 0x000188857777eeef,
  0x00007ffdffff0004, 0x00007ffeffff0003,
  0x0000d551ffffaaac, 0x0000d553aaaa5557,
  0x000108846666dddc, 0x000108867777eeef,
  0x00010884e664dddc, 0x00010886f776eeef,
  0x000055540000aaa8, 0x00005554aaab5555,
  0x000088866667ddd8, 0x000088877778eeed,
  0x00008886e665ddd8, 0x00008887f777eeed,
  0x000088876662dddc, 0x000088887775eeef,
  0x0000333266673330, 0x00003332cccd9999,
  0x00003332e6653330, 0x000033334ccc9999,
  0x0000333366623334, 0x00003333ccca999b,
  0x00003333e65e333c, 0x000033344cc7999f,
  0x000000007ffe0000, 0x000000007fff0001,
  0x00000000fffb0004, 0x00000000fffd0003,
  0x000000017ff7000c, 0x000000017ffa0007,
  0x00000001fff20018, 0x00000001fff6000d,
  0x000000007ffd0004, 0x000000007ffe0003,
  0x00000000fff9000c, 0x00000000fffb0007,
  0x000000017ff40018, 0x000000017ff7000d,
  0x000000018073fe18, 0x000000018076ff0d,
  0x000000007ffc0008, 0x000000007ffd0005,
  0x00000000fff70014, 0x00000000fff9000b,
  0x000000010076fe14, 0x000000010078ff0b,
  0x0000000100f5fc18, 0x0000000100f7fe0d,
  0x000000007ffb000c, 0x000000007ffc0007,
  0x00000000807afe0c, 0x00000000807bff07,
  0x0000000080f9fc10, 0x0000000080fafe09,
  0x000000008177fa18, 0x000000008178fd0d,
  0x00000000007ffe00, 0x00000000007fff01,
  0x0000000000fefc04, 0x0000000000fefe03,
  0x00000000017cfa0c, 0x00000000017cfd07,
  0x0000000001f9f818, 0x0000000001f9fc0d,
  0x00000000007efe04, 0x00000000007eff03,
  0x0000000000fcfc0c, 0x0000000000fcfe07,
  0x000000000179fa18, 0x000000000179fd0d,
  0x000000000199f998, 0x000000000199fccd,
  0x00000000007dfe08, 0x00000000007dff05,
  0x0000000000fafc14, 0x0000000000fafe0b,
  0x00000000011afb94, 0x00000000011afdcb,
  0x00000000011dfb88, 0x00000000011dfdc5,
  0x00000000007cfe0c, 0x00000000007cff07,
  0x00000000009cfd8c, 0x00000000009cfec7,
  0x00000000009ffd80, 0x00000000009ffec1,
  0x0000000000a1fd78, 0x0000000000a1febd,
  0x00000000001fff80, 0x00000000001fffc1,
  0x000000000022ff74, 0x000000000022ffbb,
  0x000000000024ff6c, 0x000000000024ffb7,
  0x000000000025ff68, 0x000000000025ffb5,
  0x000000000002fffa, 0x0000000133333333,
  0x000000000004fff6, 0x00000001ffffffff,
  0x000000000005fff4, 0x0000000266666665,
  0x000000000005fff4, 0x0000000266666665,
  0x000000000001fffc, 0x00000000cccccccd,
  0x000000000002fffa, 0x0000000133333333,
  0x000000000002fffa, 0x0000000133333333,
  0x000000000001fffc, 0x00000000cccccccd,
  0x000000000000fffe, 0x0000000066666667,
  0x000000000000fffe, 0x0000000066666667,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffffffe0004, 0xffffffff33333335,
  0x0000000000000000, 0x0000000000000001,
  0xffffffffffff0002, 0xffffffff9999999b,
  0xfffffffffffd0006, 0xfffffffecccccccf,
  0xffffffffffdd0046, 0xfffffff20000000f,
  0xffffffffffff0002, 0xffffffff9999999b,
  0xfffffffffffd0006, 0xfffffffecccccccf,
  0xffffffffffdd0046, 0xfffffff20000000f,
  0xffffffffff600140, 0xffffffc000000041,
  0xfffffffffffe0004, 0xffffffff33333335,
  0xffffffffffde0044, 0xfffffff266666675,
  0xffffffffff61013e, 0xffffffc0666666a7,
  0xfffffffffee3023a, 0xffffff8e00000073,
  0xffffffffffe00040, 0xfffffff333333341,
  0xffffffffff63013a, 0xffffffc133333373,
  0xfffffffffee50236, 0xffffff8ecccccd3f,
  0xfffffffffe660334, 0xffffff5c000000a5,
  0xffffffffff8300fa, 0xffffffce00000033,
  0xffffffffff0501f6, 0xffffff9b999999ff,
  0xfffffffffe8602f4, 0xffffff68cccccd65,
  0xffffffff7e8a02ee, 0xffffcc36cccd0097,
  0xffffffffff8200fc, 0xffffffcd999999cd,
  0xffffffffff0301fa, 0xffffff9acccccd33,
  0xffffffff7f0701f4, 0xffffcc68cccd0065,
  0xfffffffeff0a01f0, 0xffff99366666cd31,
  0xffffffffff8100fe, 0xffffffcd33333367,
  0xffffffff7f8500f8, 0xffffcc9b33336699,
  0xfffffffeff8800f4, 0xffff9968cccd3365,
  0xfffffffe7f8a00f2, 0xffff6636000099cb,
  0xffffffff8003fffa, 0xffffccce00003333,
  0xffffffff0006fff6, 0xffff999b9999ffff,
  0xfffffffe8008fff4, 0xffff6668cccd6665,
  0xffffcccbb33c665a, 0xeb84852147aeae13,
  0xffffffff8002fffc, 0xffffcccd9999cccd,
  0xffffffff0004fffa, 0xffff999acccd3333,
  0xffffcccc33386660, 0xeb84b85347ae7ae1,
  0xffff7777888e110a, 0xc962963169d09d03,
  0xffffffff8001fffe, 0xffffcccd33336667,
  0xffffccccb3356664, 0xeb84eb85ae14ae15,
  0xffff7778088b110e, 0xc962c963d036d037,
  0xfffef779088e1108, 0x962f9632036a0369,
  0xffffcccd33336666, 0xeb851eb87ae147af,
  0xffff777888891110, 0xc962fc969d0369d1,
  0xfffef779888c110a, 0x962fc964d0369d03,
  0xfffe777a888e1106, 0x8000000000000000,
  0xffffaaab5555aaaa, 0xddddddde22222223,
  0xffff2aac5558aaa4, 0xaaaaaaac55555555,
  0xfffeaaad555aaaa0, 0x8000000000000000,
  0xfffe2aae555baa9e, 0x8000000000000000,
  0xffff80010002fffa, 0xccccccce33333333,
  0xffff00020004fff6, 0x9999999bffffffff,
  0xfffe80030005fff4, 0x8000000000000000,
  0xffff00020005fff4, 0xb333333300000000,
  0xffff80010001fffc, 0xcccccccdcccccccd,
  0xffff00020002fffa, 0x9999999b33333333,
  0xffff80010002fffa, 0xccccccce33333333,
  0x000000000001fffc, 0x00000000cccccccd,
  0xffff80010000fffe, 0xcccccccd66666667,
  0x000000000000fffe, 0x0000000066666667,
  0x00007fff00000000, 0x3333333300000001,
  0x0000d553aaab5554, 0x5555555544444445,
  0x00007fff00000000, 0x3333333300000001,
  0x0000fffdffff0002, 0x666666659999999b,
  0x00015552aaaa5556, 0x7fffffffffffffff,
  0x000188857777eeee, 0x7fffffffffffffff,
  0x00007ffeffff0002, 0x333333329999999b,
  0x0000d553aaaa5556, 0x55555554dddddddf,
  0x000108867777eeee, 0x69d0369cc962fc97,
  0x00010886f776eeee, 0x69d069cffc95fc97,
  0x00005554aaab5554, 0x2222222244444445,
  0x000088877778eeec, 0x369d036a2fc962fd,
  0x00008887f777eeec, 0x369d369d62fc62fd,
  0x000088887775eeee, 0x369d69d02fc8fc97,
  0x00003332cccd9998, 0x147ae147eb851eb9,
  0x000033334ccc9998, 0x147b147b1eb81eb9,
  0x00003333ccca999a, 0x147b47adeb84b853,
  0x000033344cc7999e, 0x147b7ae051eaeb87,
  0x000000007fff0000, 0x0000333333330001,
  0x00000000fffd0002, 0x00006665ffff999b,
  0x000000017ffa0006, 0x000099986665cccf,
  0x00000001fff6000c, 0x0000ccca6665999d,
  0x000000007ffe0002, 0x00003332cccc999b,
  0x00000000fffb0006, 0x000066653332cccf,
  0x000000017ff7000c, 0x000099973332999d,
  0x000000018076ff0c, 0x000099ca6665cc9d,
  0x000000007ffd0004, 0x0000333266663335,
  0x00000000fff9000a, 0x0000666466660003,
  0x000000010078ff0a, 0x0000669799993303,
  0x0000000100f7fe0c, 0x000066ca6665ff9d,
  0x000000007ffc0006, 0x00003331ffffcccf,
  0x00000000807bff06, 0x000033653332ffcf,
  0x0000000080fafe08, 0x00003397ffffcc69,
  0x000000008178fd0c, 0x000033ca6666329d,
  0x00000000007fff00, 0x0000003333333301,
  0x0000000000fefe02, 0x00000065ffffff9b,
  0x00000000017cfd06, 0x00000098666665cf,
  0x0000000001f9fc0c, 0x000000ca6666659d,
  0x00000000007eff02, 0x00000032cccccc9b,
  0x0000000000fcfe06, 0x00000065333332cf,
  0x000000000179fd0c, 0x000000973333329d,
  0x000000000199fccc, 0x000000a3ffffff5d,
  0x00000000007dff04, 0x0000003266666635,
  0x0000000000fafe0a, 0x0000006466666603,
  0x00000000011afdca, 0x00000071333332c3,
  0x00000000011dfdc4, 0x00000072666665f5,
  0x00000000007cff06, 0x00000031ffffffcf,
  0x00000000009cfec6, 0x0000003ecccccc8f,
  0x00000000009ffec0, 0x0000003fffffffc1,
  0x0000000000a1febc, 0x00000040cccccc8d,
  0x00000000001fffc0, 0x0000000cccccccc1,
  0x000000000022ffba, 0x0000000dfffffff3,
  0x000000000024ffb6, 0x0000000eccccccbf,
  0x000000000025ffb4, 0x0000000f33333325,
  0x0000000133333332, 0x00000001ffffffff,
  0x00000001fffffffe, 0x0000000355555553,
  0x0000000266666664, 0x00000003fffffffd,
  0x0000000266666664, 0x00000003fffffffd,
  0x00000000cccccccc, 0x0000000155555555,
  0x0000000133333332, 0x00000001ffffffff,
  0x0000000133333332, 0x00000001ffffffff,
  0x00000000cccccccc, 0x0000000155555555,
  0x0000000066666666, 0x00000000aaaaaaab,
  0x0000000066666666, 0x00000000aaaaaaab,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff33333334, 0xfffffffeaaaaaaad,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff9999999a, 0xffffffff55555557,
  0xfffffffeccccccce, 0xfffffffe00000003,
  0xfffffff20000000e, 0xffffffe8aaaaaac3,
  0xffffffff9999999a, 0xffffffff55555557,
  0xfffffffeccccccce, 0xfffffffe00000003,
  0xfffffff20000000e, 0xffffffe8aaaaaac3,
  0xffffffc000000040, 0xffffff95555555c1,
  0xffffffff33333334, 0xfffffffeaaaaaaad,
  0xfffffff266666674, 0xffffffe95555556d,
  0xffffffc0666666a6, 0xffffff960000006b,
  0xffffff8e00000072, 0xffffff42000000bf,
  0xfffffff333333340, 0xffffffeaaaaaaac1,
  0xffffffc133333372, 0xffffff97555555bf,
  0xffffff8ecccccd3e, 0xffffff4355555613,
  0xffffff5c000000a4, 0xfffffeeeaaaaabbd,
  0xffffffce00000032, 0xffffffacaaaaaaff,
  0xffffff9b999999fe, 0xffffff58aaaaab53,
  0xffffff68cccccd64, 0xffffff04000000fd,
  0xffffcc36cccd0096, 0xffffa9b0aaab00fb,
  0xffffffcd999999cc, 0xffffffac00000055,
  0xffffff9acccccd32, 0xffffff57555555ff,
  0xffffcc68cccd0064, 0xffffaa04000055fd,
  0xffff99366666cd30, 0xffff54b00000ab51,
  0xffffffcd33333366, 0xffffffab555555ab,
  0xffffcc9b33336698, 0xffffaa58000055a9,
  0xffff9968cccd3364, 0xffff55040000aafd,
  0xffff6636000099ca, 0xfffeffaf555655a7,
  0xffffccce00003332, 0xffffaaacaaaaffff,
  0xffff999b9999fffe, 0xffff5558aaab5553,
  0xffff6668cccd6664, 0xffff00040000fffd,
  0xeb84852147aeae12, 0xdddcdde22223221f,
  0xffffcccd9999cccc, 0xffffaaac00005555,
  0xffff999acccd3332, 0xffff55575555ffff,
  0xeb84b85347ae7ae0, 0xdddd333577782221,
  0xc962963169d09d02, 0xa4f9a4fd05b105af,
  0xffffcccd33336666, 0xffffaaab5555aaab,
  0xeb84eb85ae14ae14, 0xdddd88897777cccd,
  0xc962c963d036d036, 0xa4f9fa5105b0b05b,
  0x962f9632036a0368, 0x8000000000000000,
  0xeb851eb87ae147ae, 0xddddddde22222223,
  0xc962fc969d0369d0, 0xa4fa4fa5b05b05b1,
  0x962fc964d0369d02, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xddddddde22222222, 0xc71c71c78e38e38f,
  0xaaaaaaac55555554, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xccccccce33333332, 0xaaaaaaacffffffff,
  0x9999999bfffffffe, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xb333333300000000, 0xd555555500000000,
  0xcccccccdcccccccc, 0xaaaaaaac55555555,
  0x9999999b33333332, 0x8000000000000000,
  0xccccccce33333332, 0xd555555500000000,
  0x00000000cccccccc, 0x2aaaaaa955555556,
  0xcccccccd66666666, 0xaaaaaaabaaaaaaab,
  0x0000000066666666, 0x00000000aaaaaaab,
  0x3333333300000000, 0x5555555500000001,
  0x5555555544444444, 0x7fffffffffffffff,
  0x3333333300000000, 0x5555555500000001,
  0x666666659999999a, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x333333329999999a, 0x5555555455555557,
  0x55555554ddddddde, 0x7fffffffffffffff,
  0x69d0369cc962fc96, 0x7fffffffffffffff,
  0x69d069cffc95fc96, 0x7fffffffffffffff,
  0x2222222244444444, 0x38e38e391c71c71d,
  0x369d036a2fc962fc, 0x5b05b05ba4fa4fa5,
  0x369d369d62fc62fc, 0x5b0605b0fa4f4fa5,
  0x369d69d02fc8fc96, 0x5b065b05a4f9a4fb,
  0x147ae147eb851eb8, 0x2222222288888889,
  0x147b147b1eb81eb8, 0x22227777dddd8889,
  0x147b47adeb84b852, 0x2222cccc8887dddf,
  0x147b7ae051eaeb86, 0x222322208887888b,
  0x0000333333330000, 0x0000555555550001,
  0x00006665ffff999a, 0x0000aaa9ffff5557,
  0x000099986665ccce, 0x0000fffdffff0003,
  0x0000ccca6665999c, 0x0001555155540005,
  0x00003332cccc999a, 0x00005554aaaa5557,
  0x000066653332ccce, 0x0000aaa8aaaa0003,
  0x000099973332999c, 0x0000fffbffff0005,
  0x000099ca6665cc9c, 0x0001005155545505,
  0x0000333266663334, 0x00005553ffffaaad,
  0x0000666466660002, 0x0000aaa75554aaaf,
  0x0000669799993302, 0x0000aafcaaa9ffaf,
  0x000066ca6665ff9c, 0x0000ab515554aa05,
  0x00003331ffffccce, 0x0000555355550003,
  0x000033653332ffce, 0x000055a8aaaa5503,
  0x00003397ffffcc68, 0x000055fd5554ff59,
  0x000033ca6666329c, 0x000056515554ff05,
  0x0000003333333300, 0x0000005555555501,
  0x00000065ffffff9a, 0x000000a9ffffff57,
  0x00000098666665ce, 0x000000fdffffff03,
  0x000000ca6666659c, 0x0000015155555405,
  0x00000032cccccc9a, 0x00000054aaaaaa57,
  0x00000065333332ce, 0x000000a8aaaaaa03,
  0x000000973333329c, 0x000000fbffffff05,
  0x000000a3ffffff5c, 0x0000011155555445,
  0x0000003266666634, 0x00000053ffffffad,
  0x0000006466666602, 0x000000a7555554af,
  0x00000071333332c2, 0x000000bcaaaaa9ef,
  0x00000072666665f4, 0x000000beaaaaa9ed,
  0x00000031ffffffce, 0x0000005355555503,
  0x0000003ecccccc8e, 0x00000068aaaaaa43,
  0x0000003fffffffc0, 0x0000006aaaaaaa41,
  0x00000040cccccc8c, 0x0000006bffffff95,
  0x0000000cccccccc0, 0x0000001555555541,
  0x0000000dfffffff2, 0x000000175555553f,
  0x0000000eccccccbe, 0x00000018aaaaaa93,
  0x0000000f33333324, 0x000000195555553d,
  0x00000001fffffffe, 0x00000002ffffffef,
  0x0000000355555552, 0x00000004ffffffe3,
  0x00000003fffffffc, 0x00000005ffffffdd,
  0x00000003fffffffc, 0x00000005ffffffdd,
  0x0000000155555554, 0x00000001fffffff5,
  0x00000001fffffffe, 0x00000002ffffffef,
  0x00000001fffffffe, 0x00000002ffffffef,
  0x0000000155555554, 0x00000001fffffff5,
  0x00000000aaaaaaaa, 0x00000000fffffffb,
  0x00000000aaaaaaaa, 0x00000000fffffffb,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffeaaaaaaac, 0xfffffffe0000000d,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff55555556, 0xffffffff00000007,
  0xfffffffe00000002, 0xfffffffd00000013,
  0xffffffe8aaaaaac2, 0xffffffdd000000d3,
  0xffffffff55555556, 0xffffffff00000007,
  0xfffffffe00000002, 0xfffffffd00000013,
  0xffffffe8aaaaaac2, 0xffffffdd000000d3,
  0xffffff95555555c0, 0xffffff60000003c1,
  0xfffffffeaaaaaaac, 0xfffffffe0000000d,
  0xffffffe95555556c, 0xffffffde000000cd,
  0xffffff960000006a, 0xffffff61000003bb,
  0xffffff42000000be, 0xfffffee3000006af,
  0xffffffeaaaaaaac0, 0xffffffe0000000c1,
  0xffffff97555555be, 0xffffff63000003af,
  0xffffff4355555612, 0xfffffee5000006a3,
  0xfffffeeeaaaaabbc, 0xfffffe660000099d,
  0xffffffacaaaaaafe, 0xffffff83000002ef,
  0xffffff58aaaaab52, 0xffffff05000005e3,
  0xffffff04000000fc, 0xfffffe86000008dd,
  0xffffa9b0aaab00fa, 0xffff7e89000308cb,
  0xffffffac00000054, 0xffffff82000002f5,
  0xffffff57555555fe, 0xffffff03000005ef,
  0xffffaa04000055fc, 0xffff7f06000305dd,
  0xffff54b00000ab50, 0xfffeff08000605d1,
  0xffffffab555555aa, 0xffffff81000002fb,
  0xffffaa58000055a8, 0xffff7f84000302e9,
  0xffff55040000aafc, 0xfffeff86000602dd,
  0xfffeffaf555655a6, 0xfffe7f87000902d7,
  0xffffaaacaaaafffe, 0xffff80030002ffef,
  0xffff5558aaab5552, 0xffff00050005ffe3,
  0xffff00040000fffc, 0xfffe80060008ffdd,
  0xdddcdde22223221e, 0xcccb4cd4333c330f,
  0xffffaaac00005554, 0xffff80020002fff5,
  0xffff55575555fffe, 0xffff00030005ffef,
  0xdddd333577782220, 0xcccbccd133393321,
  0xa4f9a4fd05b105ae, 0x8000000000000000,
  0xffffaaab5555aaaa, 0xffff80010002fffb,
  0xdddd88897777cccc, 0xcccc4ccf3336332d,
  0xa4f9fa5105b0b05a, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xddddddde22222222, 0xccccccce33333333,
  0xa4fa4fa5b05b05b0, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xc71c71c78e38e38e, 0xaaaaaaacffffffff,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaacfffffffe, 0x80000005ffffffef,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xd555555500000000, 0xfffffffd00000000,
  0xaaaaaaac55555554, 0x80000004fffffff5,
  0x8000000000000000, 0x8000000000000000,
  0xd555555500000000, 0xfffffffd00000000,
  0x2aaaaaa955555556, 0x7ffffff900000006,
  0xaaaaaaabaaaaaaaa, 0x80000003fffffffb,
  0x00000000aaaaaaaa, 0x00000000fffffffb,
  0x5555555500000000, 0x7ffffffd00000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555500000000, 0x7ffffffd00000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555455555556, 0x7ffffffc00000007,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x38e38e391c71c71c, 0x55555553fffffffd,
  0x5b05b05ba4fa4fa4, 0x7fffffffffffffff,
  0x5b0605b0fa4f4fa4, 0x7fffffffffffffff,
  0x5b065b05a4f9a4fa, 0x7fffffffffffffff,
  0x2222222288888888, 0x33333332ccccccc9,
  0x22227777dddd8888, 0x3333b332ccc9ccc9,
  0x2222cccc8887ddde, 0x33343331ccc6cccf,
  0x222322208887888a, 0x3334b32fccc3ccdb,
  0x0000555555550000, 0x00007ffffffd0001,
  0x0000aaa9ffff5556, 0x0000fffefffa0007,
  0x0000fffdffff0002, 0x00017ffcfff70013,
  0x0001555155540004, 0x0001fff9fff40025,
  0x00005554aaaa5556, 0x00007ffefffd0007,
  0x0000aaa8aaaa0002, 0x0000fffcfffa0013,
  0x0000fffbffff0004, 0x00017ff9fff70025,
  0x0001005155545504, 0x00018079fff6fd25,
  0x00005553ffffaaac, 0x00007ffdfffd000d,
  0x0000aaa75554aaae, 0x0000fffafffa001f,
  0x0000aafcaaa9ffae, 0x0001007afff9fd1f,
  0x0000ab515554aa04, 0x000100f9fff9fa25,
  0x0000555355550002, 0x00007ffcfffd0013,
  0x000055a8aaaa5502, 0x0000807cfffcfd13,
  0x000055fd5554ff58, 0x000080fbfffcfa19,
  0x000056515554ff04, 0x00008179fffcf725,
  0x0000005555555500, 0x0000007ffffffd01,
  0x000000a9ffffff56, 0x000000fefffffa07,
  0x000000fdffffff02, 0x0000017cfffff713,
  0x0000015155555404, 0x000001f9fffff425,
  0x00000054aaaaaa56, 0x0000007efffffd07,
  0x000000a8aaaaaa02, 0x000000fcfffffa13,
  0x000000fbffffff04, 0x00000179fffff725,
  0x0000011155555444, 0x00000199fffff665,
  0x00000053ffffffac, 0x0000007dfffffd0d,
  0x000000a7555554ae, 0x000000fafffffa1f,
  0x000000bcaaaaa9ee, 0x0000011afffff95f,
  0x000000beaaaaa9ec, 0x0000011dfffff94d,
  0x0000005355555502, 0x0000007cfffffd13,
  0x00000068aaaaaa42, 0x0000009cfffffc53,
  0x0000006aaaaaaa40, 0x0000009ffffffc41,
  0x0000006bffffff94, 0x000000a1fffffc35,
  0x0000001555555540, 0x0000001fffffff41,
  0x000000175555553e, 0x00000022ffffff2f,
  0x00000018aaaaaa92, 0x00000024ffffff23,
  0x000000195555553c, 0x00000025ffffff1d,
  0x00000002ffffffee, 0x00000002fffffff5,
  0x00000004ffffffe2, 0x00000004ffffffed,
  0x00000005ffffffdc, 0x00000005ffffffe9,
  0x00000005ffffffdc, 0x00000005ffffffe9,
  0x00000001fffffff4, 0x00000001fffffff9,
  0x00000002ffffffee, 0x00000002fffffff5,
  0x00000002ffffffee, 0x00000002fffffff5,
  0x00000001fffffff4, 0x00000001fffffff9,
  0x00000000fffffffa, 0x00000000fffffffd,
  0x00000000fffffffa, 0x00000000fffffffd,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffe0000000c, 0xfffffffe00000009,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000006, 0xffffffff00000005,
  0xfffffffd00000012, 0xfffffffd0000000d,
  0xffffffdd000000d2, 0xffffffdd0000008d,
  0xffffffff00000006, 0xffffffff00000005,
  0xfffffffd00000012, 0xfffffffd0000000d,
  0xffffffdd000000d2, 0xffffffdd0000008d,
  0xffffff60000003c0, 0xffffff6000000281,
  0xfffffffe0000000c, 0xfffffffe00000009,
  0xffffffde000000cc, 0xffffffde00000089,
  0xffffff61000003ba, 0xffffff610000027d,
  0xfffffee3000006ae, 0xfffffee300000475,
  0xffffffe0000000c0, 0xffffffe000000081,
  0xffffff63000003ae, 0xffffff6300000275,
  0xfffffee5000006a2, 0xfffffee50000046d,
  0xfffffe660000099c, 0xfffffe6600000669,
  0xffffff83000002ee, 0xffffff83000001f5,
  0xffffff05000005e2, 0xffffff05000003ed,
  0xfffffe86000008dc, 0xfffffe86000005e9,
  0xffff7e89000308ca, 0xffff7e89000205dd,
  0xffffff82000002f4, 0xffffff82000001f9,
  0xffffff03000005ee, 0xffffff03000003f5,
  0xffff7f06000305dc, 0xffff7f06000203e9,
  0xfffeff08000605d0, 0xfffeff08000403e1,
  0xffffff81000002fa, 0xffffff81000001fd,
  0xffff7f84000302e8, 0xffff7f84000201f1,
  0xfffeff86000602dc, 0xfffeff86000401e9,
  0xfffe7f87000902d6, 0xfffe7f87000601e5,
  0xffff80030002ffee, 0xffff80030001fff5,
  0xffff00050005ffe2, 0xffff00050003ffed,
  0xfffe80060008ffdc, 0xfffe80060005ffe9,
  0xcccb4cd4333c330e, 0xcccb4cd3ccd2ccb5,
  0xffff80020002fff4, 0xffff80020001fff9,
  0xffff00030005ffee, 0xffff00030003fff5,
  0xcccbccd133393320, 0xcccbccd0ccd0ccc1,
  0x8000000000000000, 0x8000000000000000,
  0xffff80010002fffa, 0xffff80010001fffd,
  0xcccc4ccf3336332c, 0xcccc4cceccceccc9,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xccccccce33333332, 0xcccccccdcccccccd,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaacfffffffe, 0xaaaaaaac55555555,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x80000005ffffffee, 0x80000004fffffff5,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfffffffd00000000, 0xfffffffe00000000,
  0x80000004fffffff4, 0x80000003fffffff9,
  0x8000000000000000, 0x8000000000000000,
  0xfffffffd00000000, 0xfffffffe00000000,
  0x7ffffff900000006, 0x7ffffffb00000004,
  0x80000003fffffffa, 0x80000002fffffffd,
  0x00000000fffffffa, 0x00000000fffffffd,
  0x7ffffffd00000000, 0x7ffffffe00000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffd00000000, 0x7ffffffe00000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffc00000006, 0x7ffffffd00000005,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x55555553fffffffc, 0x55555554aaaaaaa9,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x33333332ccccccc8, 0x3333333333333331,
  0x3333b332ccc9ccc8, 0x3333b33333313331,
  0x33343331ccc6ccce, 0x33343332332f3335,
  0x3334b32fccc3ccda, 0x3334b330332d333d,
  0x00007ffffffd0000, 0x00007ffffffe0001,
  0x0000fffefffa0006, 0x0000fffefffc0005,
  0x00017ffcfff70012, 0x00017ffcfffa000d,
  0x0001fff9fff40024, 0x0001fff9fff80019,
  0x00007ffefffd0006, 0x00007ffefffe0005,
  0x0000fffcfffa0012, 0x0000fffcfffc000d,
  0x00017ff9fff70024, 0x00017ff9fffa0019,
  0x00018079fff6fd24, 0x00018079fff9fe19,
  0x00007ffdfffd000c, 0x00007ffdfffe0009,
  0x0000fffafffa001e, 0x0000fffafffc0015,
  0x0001007afff9fd1e, 0x0001007afffbfe15,
  0x000100f9fff9fa24, 0x000100f9fffbfc19,
  0x00007ffcfffd0012, 0x00007ffcfffe000d,
  0x0000807cfffcfd12, 0x0000807cfffdfe0d,
  0x000080fbfffcfa18, 0x000080fbfffdfc11,
  0x00008179fffcf724, 0x00008179fffdfa19,
  0x0000007ffffffd00, 0x0000007ffffffe01,
  0x000000fefffffa06, 0x000000fefffffc05,
  0x0000017cfffff712, 0x0000017cfffffa0d,
  0x000001f9fffff424, 0x000001f9fffff819,
  0x0000007efffffd06, 0x0000007efffffe05,
  0x000000fcfffffa12, 0x000000fcfffffc0d,
  0x00000179fffff724, 0x00000179fffffa19,
  0x00000199fffff664, 0x00000199fffff999,
  0x0000007dfffffd0c, 0x0000007dfffffe09,
  0x000000fafffffa1e, 0x000000fafffffc15,
  0x0000011afffff95e, 0x0000011afffffb95,
  0x0000011dfffff94c, 0x0000011dfffffb89,
  0x0000007cfffffd12, 0x0000007cfffffe0d,
  0x0000009cfffffc52, 0x0000009cfffffd8d,
  0x0000009ffffffc40, 0x0000009ffffffd81,
  0x000000a1fffffc34, 0x000000a1fffffd79,
  0x0000001fffffff40, 0x0000001fffffff81,
  0x00000022ffffff2e, 0x00000022ffffff75,
  0x00000024ffffff22, 0x00000024ffffff6d,
  0x00000025ffffff1c, 0x00000025ffffff69,
  0x00000002fffffff4, 0x00000002fffffffb,
  0x00000004ffffffec, 0x00000004fffffff7,
  0x00000005ffffffe8, 0x00000005fffffff5,
  0x00000005ffffffe8, 0x00000005fffffff5,
  0x00000001fffffff8, 0x00000001fffffffd,
  0x00000002fffffff4, 0x00000002fffffffb,
  0x00000002fffffff4, 0x00000002fffffffb,
  0x00000001fffffff8, 0x00000001fffffffd,
  0x00000000fffffffc, 0x00000000ffffffff,
  0x00000000fffffffc, 0x00000000ffffffff,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffe00000008, 0xfffffffe00000005,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000004, 0xffffffff00000003,
  0xfffffffd0000000c, 0xfffffffd00000007,
  0xffffffdd0000008c, 0xffffffdd00000047,
  0xffffffff00000004, 0xffffffff00000003,
  0xfffffffd0000000c, 0xfffffffd00000007,
  0xffffffdd0000008c, 0xffffffdd00000047,
  0xffffff6000000280, 0xffffff6000000141,
  0xfffffffe00000008, 0xfffffffe00000005,
  0xffffffde00000088, 0xffffffde00000045,
  0xffffff610000027c, 0xffffff610000013f,
  0xfffffee300000474, 0xfffffee30000023b,
  0xffffffe000000080, 0xffffffe000000041,
  0xffffff6300000274, 0xffffff630000013b,
  0xfffffee50000046c, 0xfffffee500000237,
  0xfffffe6600000668, 0xfffffe6600000335,
  0xffffff83000001f4, 0xffffff83000000fb,
  0xffffff05000003ec, 0xffffff05000001f7,
  0xfffffe86000005e8, 0xfffffe86000002f5,
  0xffff7e89000205dc, 0xffff7e89000102ef,
  0xffffff82000001f8, 0xffffff82000000fd,
  0xffffff03000003f4, 0xffffff03000001fb,
  0xffff7f06000203e8, 0xffff7f06000101f5,
  0xfffeff08000403e0, 0xfffeff08000201f1,
  0xffffff81000001fc, 0xffffff81000000ff,
  0xffff7f84000201f0, 0xffff7f84000100f9,
  0xfffeff86000401e8, 0xfffeff86000200f5,
  0xfffe7f87000601e4, 0xfffe7f87000300f3,
  0xffff80030001fff4, 0xffff80030000fffb,
  0xffff00050003ffec, 0xffff00050001fff7,
  0xfffe80060005ffe8, 0xfffe80060002fff5,
  0xcccb4cd3ccd2ccb4, 0xcccb4cd36669665b,
  0xffff80020001fff8, 0xffff80020000fffd,
  0xffff00030003fff4, 0xffff00030001fffb,
  0xcccbccd0ccd0ccc0, 0xcccbccd066686661,
  0x8000000000000000, 0x8000000000000000,
  0xffff80010001fffc, 0xffff80010000ffff,
  0xcccc4cceccceccc8, 0xcccc4cce66676665,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xcccccccdcccccccc, 0xcccccccd66666667,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaac55555554, 0xaaaaaaabaaaaaaab,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x80000004fffffff4, 0x80000003fffffffb,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xfffffffe00000000, 0xffffffff00000000,
  0x80000003fffffff8, 0x80000002fffffffd,
  0x8000000000000000, 0x8000000000000000,
  0xfffffffe00000000, 0xffffffff00000000,
  0x7ffffffb00000004, 0x7ffffffd00000002,
  0x80000002fffffffc, 0x80000001ffffffff,
  0x00000000fffffffc, 0x00000000ffffffff,
  0x7ffffffe00000000, 0x7fffffff00000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffe00000000, 0x7fffffff00000001,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffd00000004, 0x7ffffffe00000003,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x55555554aaaaaaa8, 0x5555555555555555,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x3333333333333330, 0x3333333399999999,
  0x3333b33333313330, 0x3333b33399989999,
  0x33343332332f3334, 0x333433329997999b,
  0x3334b330332d333c, 0x3334b3309996999f,
  0x00007ffffffe0000, 0x00007fffffff0001,
  0x0000fffefffc0004, 0x0000fffefffe0003,
  0x00017ffcfffa000c, 0x00017ffcfffd0007,
  0x0001fff9fff80018, 0x0001fff9fffc000d,
  0x00007ffefffe0004, 0x00007ffeffff0003,
  0x0000fffcfffc000c, 0x0000fffcfffe0007,
  0x00017ff9fffa0018, 0x00017ff9fffd000d,
  0x00018079fff9fe18, 0x00018079fffcff0d,
  0x00007ffdfffe0008, 0x00007ffdffff0005,
  0x0000fffafffc0014, 0x0000fffafffe000b,
  0x0001007afffbfe14, 0x0001007afffdff0b,
  0x000100f9fffbfc18, 0x000100f9fffdfe0d,
  0x00007ffcfffe000c, 0x00007ffcffff0007,
  0x0000807cfffdfe0c, 0x0000807cfffeff07,
  0x000080fbfffdfc10, 0x000080fbfffefe09,
  0x00008179fffdfa18, 0x00008179fffefd0d,
  0x0000007ffffffe00, 0x0000007fffffff01,
  0x000000fefffffc04, 0x000000fefffffe03,
  0x0000017cfffffa0c, 0x0000017cfffffd07,
  0x000001f9fffff818, 0x000001f9fffffc0d,
  0x0000007efffffe04, 0x0000007effffff03,
  0x000000fcfffffc0c, 0x000000fcfffffe07,
  0x00000179fffffa18, 0x00000179fffffd0d,
  0x00000199fffff998, 0x00000199fffffccd,
  0x0000007dfffffe08, 0x0000007dffffff05,
  0x000000fafffffc14, 0x000000fafffffe0b,
  0x0000011afffffb94, 0x0000011afffffdcb,
  0x0000011dfffffb88, 0x0000011dfffffdc5,
  0x0000007cfffffe0c, 0x0000007cffffff07,
  0x0000009cfffffd8c, 0x0000009cfffffec7,
  0x0000009ffffffd80, 0x0000009ffffffec1,
  0x000000a1fffffd78, 0x000000a1fffffebd,
  0x0000001fffffff80, 0x0000001fffffffc1,
  0x00000022ffffff74, 0x00000022ffffffbb,
  0x00000024ffffff6c, 0x00000024ffffffb7,
  0x00000025ffffff68, 0x00000025ffffffb5,
  0x00000002fffffffa, 0xfffffffd00000001,
  0x00000004fffffff6, 0xfffffffb00000001,
  0x00000005fffffff4, 0xfffffffa00000001,
  0x00000005fffffff4, 0xfffffffa00000001,
  0x00000001fffffffc, 0xfffffffe00000001,
  0x00000002fffffffa, 0xfffffffd00000001,
  0x00000002fffffffa, 0xfffffffd00000001,
  0x00000001fffffffc, 0xfffffffe00000001,
  0x00000000fffffffe, 0xffffffff00000001,
  0x00000000fffffffe, 0xffffffff00000001,
  0x0000000000000000, 0x0000000000000001,
  0xfffffffe00000004, 0x0000000200000001,
  0x0000000000000000, 0x0000000000000001,
  0xffffffff00000002, 0x0000000100000001,
  0xfffffffd00000006, 0x0000000300000001,
  0xffffffdd00000046, 0x0000002300000001,
  0xffffffff00000002, 0x0000000100000001,
  0xfffffffd00000006, 0x0000000300000001,
  0xffffffdd00000046, 0x0000002300000001,
  0xffffff6000000140, 0x000000a000000001,
  0xfffffffe00000004, 0x0000000200000001,
  0xffffffde00000044, 0x0000002200000001,
  0xffffff610000013e, 0x0000009f00000001,
  0xfffffee30000023a, 0x0000011d00000001,
  0xffffffe000000040, 0x0000002000000001,
  0xffffff630000013a, 0x0000009d00000001,
  0xfffffee500000236, 0x0000011b00000001,
  0xfffffe6600000334, 0x0000019a00000001,
  0xffffff83000000fa, 0x0000007d00000001,
  0xffffff05000001f6, 0x000000fb00000001,
  0xfffffe86000002f4, 0x0000017a00000001,
  0xffff7e89000102ee, 0x0000817700000001,
  0xffffff82000000fc, 0x0000007e00000001,
  0xffffff03000001fa, 0x000000fd00000001,
  0xffff7f06000101f4, 0x000080fa00000001,
  0xfffeff08000201f0, 0x000100f800000001,
  0xffffff81000000fe, 0x0000007f00000001,
  0xffff7f84000100f8, 0x0000807c00000001,
  0xfffeff86000200f4, 0x0001007a00000001,
  0xfffe7f87000300f2, 0x0001807900000001,
  0xffff80030000fffa, 0x00007ffd00000001,
  0xffff00050001fff6, 0x0000fffb00000001,
  0xfffe80060002fff4, 0x00017ffa00000001,
  0xcccb4cd36669665a, 0x3334b32d00000001,
  0xffff80020000fffc, 0x00007ffe00000001,
  0xffff00030001fffa, 0x0000fffd00000001,
  0xcccbccd066686660, 0x3334333000000001,
  0x8000000000000000, 0x7fffffffffffffff,
  0xffff80010000fffe, 0x00007fff00000001,
  0xcccc4cce66676664, 0x3333b33200000001,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0xcccccccd66666666, 0x3333333300000001,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0xaaaaaaabaaaaaaaa, 0x5555555500000001,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0x80000003fffffffa, 0x7ffffffd00000001,
  0x8000000000000000, 0x7fffffffffffffff,
  0x8000000000000000, 0x7fffffffffffffff,
  0xffffffff00000000, 0x0000000000000000,
  0x80000002fffffffc, 0x7ffffffe00000001,
  0x8000000000000000, 0x7fffffffffffffff,
  0xffffffff00000000, 0x0000000000000000,
  0x7ffffffd00000002, 0x8000000100000000,
  0x80000001fffffffe, 0x7fffffff00000001,
  0x00000000fffffffe, 0xffffffff00000002,
  0x7fffffff00000000, 0x8000000000000002,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffff00000000, 0x8000000000000002,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7ffffffe00000002, 0x8000000100000001,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x5555555555555554, 0xaaaaaaaa00000001,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x7fffffffffffffff, 0x8000000000000000,
  0x3333333399999998, 0xcccccccc00000001,
  0x3333b33399989998, 0xcccc4ccc00000001,
  0x333433329997999a, 0xcccbcccd00000001,
  0x3334b3309996999e, 0xcccb4ccf00000001,
  0x00007fffffff0000, 0xffff800000000001,
  0x0000fffefffe0002, 0xffff000100000001,
  0x00017ffcfffd0006, 0xfffe800300000001,
  0x0001fff9fffc000c, 0xfffe000600000001,
  0x00007ffeffff0002, 0xffff800100000001,
  0x0000fffcfffe0006, 0xffff000300000001,
  0x00017ff9fffd000c, 0xfffe800600000001,
  0x00018079fffcff0c, 0xfffe7f8600000001,
  0x00007ffdffff0004, 0xffff800200000001,
  0x0000fffafffe000a, 0xffff000500000001,
  0x0001007afffdff0a, 0xfffeff8500000001,
  0x000100f9fffdfe0c, 0xfffeff0600000001,
  0x00007ffcffff0006, 0xffff800300000001,
  0x0000807cfffeff06, 0xffff7f8300000001,
  0x000080fbfffefe08, 0xffff7f0400000001,
  0x00008179fffefd0c, 0xffff7e8600000001,
  0x0000007fffffff00, 0xffffff8000000001,
  0x000000fefffffe02, 0xffffff0100000001,
  0x0000017cfffffd06, 0xfffffe8300000001,
  0x000001f9fffffc0c, 0xfffffe0600000001,
  0x0000007effffff02, 0xffffff8100000001,
  0x000000fcfffffe06, 0xffffff0300000001,
  0x00000179fffffd0c, 0xfffffe8600000001,
  0x00000199fffffccc, 0xfffffe6600000001,
  0x0000007dffffff04, 0xffffff8200000001,
  0x000000fafffffe0a, 0xffffff0500000001,
  0x0000011afffffdca, 0xfffffee500000001,
  0x0000011dfffffdc4, 0xfffffee200000001,
  0x0000007cffffff06, 0xffffff8300000001,
  0x0000009cfffffec6, 0xffffff6300000001,
  0x0000009ffffffec0, 0xffffff6000000001,
  0x000000a1fffffebc, 0xffffff5e00000001,
  0x0000001fffffffc0, 0xffffffe000000001,
  0x00000022ffffffba, 0xffffffdd00000001,
  0x00000024ffffffb6, 0xffffffdb00000001,
  0x00000025ffffffb4, 0xffffffda00000001,
  0xfffffffd00000000, 0xfffffffd00000007,
  0xfffffffb00000000, 0xfffffffb0000000b,
  0xfffffffa00000000, 0xfffffffa0000000d,
  0xfffffffa00000000, 0xfffffffa0000000d,
  0xfffffffe00000000, 0xfffffffe00000005,
  0xfffffffd00000000, 0xfffffffd00000007,
  0xfffffffd00000000, 0xfffffffd00000007,
  0xfffffffe00000000, 0xfffffffe00000005,
  0xffffffff00000000, 0xffffffff00000003,
  0xffffffff00000000, 0xffffffff00000003,
  0x0000000000000000, 0x0000000000000001,
  0x0000000200000000, 0x00000001fffffffd,
  0x0000000000000000, 0x0000000000000001,
  0x0000000100000000, 0x00000000ffffffff,
  0x0000000300000000, 0x00000002fffffffb,
  0x0000002300000000, 0x00000022ffffffbb,
  0x0000000100000000, 0x00000000ffffffff,
  0x0000000300000000, 0x00000002fffffffb,
  0x0000002300000000, 0x00000022ffffffbb,
  0x000000a000000000, 0x0000009ffffffec1,
  0x0000000200000000, 0x00000001fffffffd,
  0x0000002200000000, 0x00000021ffffffbd,
  0x0000009f00000000, 0x0000009efffffec3,
  0x0000011d00000000, 0x0000011cfffffdc7,
  0x0000002000000000, 0x0000001fffffffc1,
  0x0000009d00000000, 0x0000009cfffffec7,
  0x0000011b00000000, 0x0000011afffffdcb,
  0x0000019a00000000, 0x00000199fffffccd,
  0x0000007d00000000, 0x0000007cffffff07,
  0x000000fb00000000, 0x000000fafffffe0b,
  0x0000017a00000000, 0x00000179fffffd0d,
  0x0000817700000000, 0x00008176fffefd13,
  0x0000007e00000000, 0x0000007dffffff05,
  0x000000fd00000000, 0x000000fcfffffe07,
  0x000080fa00000000, 0x000080f9fffefe0d,
  0x000100f800000000, 0x000100f7fffdfe11,
  0x0000007f00000000, 0x0000007effffff03,
  0x0000807c00000000, 0x0000807bfffeff09,
  0x0001007a00000000, 0x00010079fffdff0d,
  0x0001807900000000, 0x00018078fffcff0f,
  0x00007ffd00000000, 0x00007ffcffff0007,
  0x0000fffb00000000, 0x0000fffafffe000b,
  0x00017ffa00000000, 0x00017ff9fffd000d,
  0x3334b32d00000000, 0x3334b32c999699a7,
  0x00007ffe00000000, 0x00007ffdffff0005,
  0x0000fffd00000000, 0x0000fffcfffe0007,
  0x3334333000000000, 0x3334332f999799a1,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00007fff00000000, 0x00007ffeffff0003,
  0x3333b33200000000, 0x3333b3319998999d,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x3333333300000000, 0x333333329999999b,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555500000000, 0x5555555455555557,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffd00000000, 0x7ffffffc00000007,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000000, 0x00000000ffffffff,
  0x7ffffffe00000000, 0x7ffffffd00000005,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x0000000000000000, 0x00000000ffffffff,
  0x8000000100000000, 0x80000002fffffffd,
  0x7fffffff00000000, 0x7ffffffe00000003,
  0xffffffff00000001, 0xffffffff00000003,
  0x8000000000000001, 0x8000000100000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000001, 0x8000000100000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000100000000, 0x80000001ffffffff,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaaa00000000, 0xaaaaaaaaaaaaaaad,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xcccccccc00000000, 0xcccccccc66666669,
  0xcccc4ccc00000000, 0xcccc4ccc66676669,
  0xcccbcccd00000000, 0xcccbcccd66686667,
  0xcccb4ccf00000000, 0xcccb4ccf66696663,
  0xffff800000000000, 0xffff800000010001,
  0xffff000100000000, 0xffff00010001ffff,
  0xfffe800300000000, 0xfffe80030002fffb,
  0xfffe000600000000, 0xfffe00060003fff5,
  0xffff800100000000, 0xffff80010000ffff,
  0xffff000300000000, 0xffff00030001fffb,
  0xfffe800600000000, 0xfffe80060002fff5,
  0xfffe7f8600000000, 0xfffe7f86000300f5,
  0xffff800200000000, 0xffff80020000fffd,
  0xffff000500000000, 0xffff00050001fff7,
  0xfffeff8500000000, 0xfffeff85000200f7,
  0xfffeff0600000000, 0xfffeff06000201f5,
  0xffff800300000000, 0xffff80030000fffb,
  0xffff7f8300000000, 0xffff7f83000100fb,
  0xffff7f0400000000, 0xffff7f04000101f9,
  0xffff7e8600000000, 0xffff7e86000102f5,
  0xffffff8000000000, 0xffffff8000000101,
  0xffffff0100000000, 0xffffff01000001ff,
  0xfffffe8300000000, 0xfffffe83000002fb,
  0xfffffe0600000000, 0xfffffe06000003f5,
  0xffffff8100000000, 0xffffff81000000ff,
  0xffffff0300000000, 0xffffff03000001fb,
  0xfffffe8600000000, 0xfffffe86000002f5,
  0xfffffe6600000000, 0xfffffe6600000335,
  0xffffff8200000000, 0xffffff82000000fd,
  0xffffff0500000000, 0xffffff05000001f7,
  0xfffffee500000000, 0xfffffee500000237,
  0xfffffee200000000, 0xfffffee20000023d,
  0xffffff8300000000, 0xffffff83000000fb,
  0xffffff6300000000, 0xffffff630000013b,
  0xffffff6000000000, 0xffffff6000000141,
  0xffffff5e00000000, 0xffffff5e00000145,
  0xffffffe000000000, 0xffffffe000000041,
  0xffffffdd00000000, 0xffffffdd00000047,
  0xffffffdb00000000, 0xffffffdb0000004b,
  0xffffffda00000000, 0xffffffda0000004d,
  0xfffffffd00000006, 0xfffffffdfffffffd,
  0xfffffffb0000000a, 0xfffffffcaaaaaaa5,
  0xfffffffa0000000c, 0xfffffffbfffffff9,
  0xfffffffa0000000c, 0xfffffffbfffffff9,
  0xfffffffe00000004, 0xfffffffeaaaaaaa9,
  0xfffffffd00000006, 0xfffffffdfffffffd,
  0xfffffffd00000006, 0xfffffffdfffffffd,
  0xfffffffe00000004, 0xfffffffeaaaaaaa9,
  0xffffffff00000002, 0xffffffff55555555,
  0xffffffff00000002, 0xffffffff55555555,
  0x0000000000000000, 0x0000000000000001,
  0x00000001fffffffc, 0x0000000155555559,
  0x0000000000000000, 0x0000000000000001,
  0x00000000fffffffe, 0x00000000aaaaaaad,
  0x00000002fffffffa, 0x0000000200000005,
  0x00000022ffffffba, 0x0000001755555585,
  0x00000000fffffffe, 0x00000000aaaaaaad,
  0x00000002fffffffa, 0x0000000200000005,
  0x00000022ffffffba, 0x0000001755555585,
  0x0000009ffffffec0, 0x0000006aaaaaab81,
  0x00000001fffffffc, 0x0000000155555559,
  0x00000021ffffffbc, 0x00000016aaaaaad9,
  0x0000009efffffec2, 0x0000006a000000d5,
  0x0000011cfffffdc6, 0x000000be0000017d,
  0x0000001fffffffc0, 0x0000001555555581,
  0x0000009cfffffec6, 0x00000068aaaaab7d,
  0x0000011afffffdca, 0x000000bcaaaaac25,
  0x00000199fffffccc, 0x0000011155555779,
  0x0000007cffffff06, 0x00000053555555fd,
  0x000000fafffffe0a, 0x000000a7555556a5,
  0x00000179fffffd0c, 0x000000fc000001f9,
  0x00008176fffefd12, 0x0000564f555601f5,
  0x0000007dffffff04, 0x00000054000000a9,
  0x000000fcfffffe06, 0x000000a8aaaaabfd,
  0x000080f9fffefe0c, 0x000055fc0000abf9,
  0x000100f7fffdfe10, 0x0000ab50000156a1,
  0x0000007effffff02, 0x00000054aaaaab55,
  0x0000807bfffeff08, 0x000055a80000ab51,
  0x00010079fffdff0c, 0x0000aafc000155f9,
  0x00018078fffcff0e, 0x00010050aaacab4d,
  0x00007ffcffff0006, 0x000055535555fffd,
  0x0000fffafffe000a, 0x0000aaa75556aaa5,
  0x00017ff9fffd000c, 0x0000fffc0001fff9,
  0x3334b32c999699a6, 0x2223221e4446443d,
  0x00007ffdffff0004, 0x000055540000aaa9,
  0x0000fffcfffe0006, 0x0000aaa8aaabfffd,
  0x3334332f999799a0, 0x2222cccaeef04441,
  0x7fffffffffffffff, 0x5b065b040b620b5d,
  0x00007ffeffff0002, 0x00005554aaab5555,
  0x3333b3319998999c, 0x22227776eeef9999,
  0x7fffffffffffffff, 0x5b0605b00b6160b5,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x333333329999999a, 0x2222222244444445,
  0x7fffffffffffffff, 0x5b05b05b60b60b61,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x5555555455555556, 0x38e38e391c71c71d,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffc00000006, 0x55555553fffffffd,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000ffffffff, 0x2aaaaaa9ffffffff,
  0x7ffffffd00000004, 0x55555554aaaaaaa9,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x00000000ffffffff, 0x2aaaaaa9ffffffff,
  0x80000002fffffffd, 0xd5555554aaaaaaab,
  0x7ffffffe00000002, 0x5555555555555555,
  0xffffffff00000002, 0xffffffff55555555,
  0x8000000100000000, 0xaaaaaaaa00000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000100000000, 0xaaaaaaaa00000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x80000001fffffffe, 0xaaaaaaaaaaaaaaad,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaaaaaaaaaac, 0xc71c71c638e38e39,
  0x8000000000000000, 0xa4fa4fa349f49f49,
  0x8000000000000000, 0xa4f9fa4df49e9f49,
  0x8000000000000000, 0xa4f9a4f949f349f5,
  0xcccccccc66666668, 0xdddddddd11111111,
  0xcccc4ccc66676668, 0xdddd8887bbbb1111,
  0xcccbcccd66686666, 0xdddd3333110fbbbd,
  0xcccb4ccf66696662, 0xdddcdddf110f1115,
  0xffff800000010000, 0xffffaaaaaaaa0001,
  0xffff00010001fffe, 0xffff5555fffeaaad,
  0xfffe80030002fffa, 0xffff0001fffe0005,
  0xfffe00060003fff4, 0xfffeaaaeaaa80009,
  0xffff80010000fffe, 0xffffaaab5554aaad,
  0xffff00030001fffa, 0xffff555755540005,
  0xfffe80060002fff4, 0xffff0003fffe0009,
  0xfffe7f86000300f4, 0xfffeffaeaaa8aa09,
  0xffff80020000fffc, 0xffffaaabffff5559,
  0xffff00050001fff6, 0xffff5558aaa9555d,
  0xfffeff85000200f6, 0xffff55035553ff5d,
  0xfffeff06000201f4, 0xffff54aeaaa95409,
  0xffff80030000fffa, 0xffffaaacaaaa0005,
  0xffff7f83000100fa, 0xffffaa575554aa05,
  0xffff7f04000101f8, 0xffffaa02aaa9feb1,
  0xffff7e86000102f4, 0xffffa9aeaaa9fe09,
  0xffffff8000000100, 0xffffffaaaaaaaa01,
  0xffffff01000001fe, 0xffffff55fffffead,
  0xfffffe83000002fa, 0xffffff01fffffe05,
  0xfffffe06000003f4, 0xfffffeaeaaaaa809,
  0xffffff81000000fe, 0xffffffab555554ad,
  0xffffff03000001fa, 0xffffff5755555405,
  0xfffffe86000002f4, 0xffffff03fffffe09,
  0xfffffe6600000334, 0xfffffeeeaaaaa889,
  0xffffff82000000fc, 0xffffffabffffff59,
  0xffffff05000001f6, 0xffffff58aaaaa95d,
  0xfffffee500000236, 0xffffff43555553dd,
  0xfffffee20000023c, 0xffffff41555553d9,
  0xffffff83000000fa, 0xffffffacaaaaaa05,
  0xffffff630000013a, 0xffffff9755555485,
  0xffffff6000000140, 0xffffff9555555481,
  0xffffff5e00000144, 0xffffff93ffffff29,
  0xffffffe000000040, 0xffffffeaaaaaaa81,
  0xffffffdd00000046, 0xffffffe8aaaaaa7d,
  0xffffffdb0000004a, 0xffffffe755555525,
  0xffffffda0000004c, 0xffffffe6aaaaaa79,
  0xfffffffdfffffffc, 0xfffffffeccccccc9,
  0xfffffffcaaaaaaa4, 0xfffffffdfffffff9,
  0xfffffffbfffffff8, 0xfffffffd99999991,
  0xfffffffbfffffff8, 0xfffffffd99999991,
  0xfffffffeaaaaaaa8, 0xffffffff33333331,
  0xfffffffdfffffffc, 0xfffffffeccccccc9,
  0xfffffffdfffffffc, 0xfffffffeccccccc9,
  0xfffffffeaaaaaaa8, 0xffffffff33333331,
  0xffffffff55555554, 0xffffffff99999999,
  0xffffffff55555554, 0xffffffff99999999,
  0x0000000000000000, 0x0000000000000001,
  0x0000000155555558, 0x00000000ccccccd1,
  0x0000000000000000, 0x0000000000000001,
  0x00000000aaaaaaac, 0x0000000066666669,
  0x0000000200000004, 0x0000000133333339,
  0x0000001755555584, 0x0000000e00000039,
  0x00000000aaaaaaac, 0x0000000066666669,
  0x0000000200000004, 0x0000000133333339,
  0x0000001755555584, 0x0000000e00000039,
  0x0000006aaaaaab80, 0x0000004000000101,
  0x0000000155555558, 0x00000000ccccccd1,
  0x00000016aaaaaad8, 0x0000000d999999d1,
  0x0000006a000000d4, 0x0000003f99999a99,
  0x000000be0000017c, 0x00000072000001c9,
  0x0000001555555580, 0x0000000ccccccd01,
  0x00000068aaaaab7c, 0x0000003ecccccdc9,
  0x000000bcaaaaac24, 0x00000071333334f9,
  0x0000011155555778, 0x000000a400000291,
  0x00000053555555fc, 0x00000032000000c9,
  0x000000a7555556a4, 0x00000064666667f9,
  0x000000fc000001f8, 0x0000009733333591,
  0x0000564f555601f4, 0x000033c933340259,
  0x00000054000000a8, 0x0000003266666731,
  0x000000a8aaaaabfc, 0x00000065333334c9,
  0x000055fc0000abf8, 0x0000339733340191,
  0x0000ab50000156a0, 0x000066c9999b34c1,
  0x00000054aaaaab54, 0x00000032cccccd99,
  0x000055a80000ab50, 0x00003364cccd9a61,
  0x0000aafc000155f8, 0x000066973334cd91,
  0x00010050aaacab4c, 0x000099ca00026729,
  0x000055535555fffc, 0x000033320000ccc9,
  0x0000aaa75556aaa4, 0x000066646667fff9,
  0x0000fffc0001fff8, 0x0000999733359991,
  0x2223221e4446443c, 0x147b7adf1ebab849,
  0x000055540000aaa8, 0x0000333266673331,
  0x0000aaa8aaabfffc, 0x000066653334ccc9,
  0x2222cccaeef04440, 0x147b47ad1eb9eb81,
  0x5b065b040b620b5c, 0x369d69cfa7427409,
  0x00005554aaab5554, 0x00003332cccd9999,
  0x22227776eeef9998, 0x147b147ab852b851,
  0x5b0605b00b6160b4, 0x369d369d40db40d9,
  0x7fffffffffffffff, 0x69d069d00da80da1,
  0x2222222244444444, 0x147ae147eb851eb9,
  0x5b05b05b60b60b60, 0x369d036a740da741,
  0x7fffffffffffffff, 0x69d0369d40da7409,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x38e38e391c71c71c, 0x2222222288888889,
  0x7fffffffffffffff, 0x5555555555555551,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x55555553fffffffc, 0x33333332ccccccc9,
  0x7fffffffffffffff, 0x66666665fffffff9,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x2aaaaaa9ffffffff, 0x4ccccccbffffffff,
  0x55555554aaaaaaa8, 0x3333333333333331,
  0x7fffffffffffffff, 0x66666666ccccccc9,
  0x2aaaaaa9ffffffff, 0x33333332ccccccc9,
  0xd5555554aaaaaaab, 0xffffffff33333331,
  0x5555555555555554, 0x3333333399999999,
  0xffffffff55555554, 0xffffffff99999999,
  0xaaaaaaaa00000000, 0xcccccccc00000001,
  0x8000000000000000, 0xaaaaaaa911111111,
  0xaaaaaaaa00000000, 0xcccccccc00000001,
  0x8000000000000000, 0x9999999866666669,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0xaaaaaaaaaaaaaaac, 0xcccccccc66666669,
  0x8000000000000000, 0xaaaaaaa977777779,
  0x8000000000000000, 0x962fc961258bf259,
  0x8000000000000000, 0x962f962df257f259,
  0xc71c71c638e38e38, 0xdddddddd11111111,
  0xa4fa4fa349f49f48, 0xc962fc94bf258bf1,
  0xa4f9fa4df49e9f48, 0xc962c9618bf18bf1,
  0xa4f9a4f949f349f4, 0xc962962ebf23f259,
  0xdddddddd11111110, 0xeb851eb7ae147ae1,
  0xdddd8887bbbb1110, 0xeb84eb847ae07ae1,
  0xdddd3333110fbbbc, 0xeb84b851ae12e149,
  0xdddcdddf110f1114, 0xeb84851f47abae19,
  0xffffaaaaaaaa0000, 0xffffcccccccc0001,
  0xffff5555fffeaaac, 0xffff9999fffe6669,
  0xffff0001fffe0004, 0xffff666799973339,
  0xfffeaaaeaaa80008, 0xffff333599966671,
  0xffffaaab5554aaac, 0xffffcccd33326669,
  0xffff555755540004, 0xffff999acccb3339,
  0xffff0003fffe0008, 0xffff6668ccca6671,
  0xfffeffaeaaa8aa08, 0xffff663599973271,
  0xffffaaabffff5558, 0xffffcccd9998ccd1,
  0xffff5558aaa9555c, 0xffff999b99980009,
  0xffff55035553ff5c, 0xffff99686664cc09,
  0xffff54aeaaa95408, 0xffff99359997fe71,
  0xffffaaacaaaa0004, 0xffffcccdffff3339,
  0xffffaa575554aa04, 0xffffcc9acccbff39,
  0xffffaa02aaa9feb0, 0xffffcc67ffff31a1,
  0xffffa9aeaaa9fe08, 0xffffcc359998ca71,
  0xffffffaaaaaaaa00, 0xffffffcccccccc01,
  0xffffff55fffffeac, 0xffffff99fffffe69,
  0xffffff01fffffe04, 0xffffff6799999739,
  0xfffffeaeaaaaa808, 0xffffff3599999671,
  0xffffffab555554ac, 0xffffffcd33333269,
  0xffffff5755555404, 0xffffff9acccccb39,
  0xffffff03fffffe08, 0xffffff68ccccca71,
  0xfffffeeeaaaaa888, 0xffffff5bfffffd71,
  0xffffffabffffff58, 0xffffffcd999998d1,
  0xffffff58aaaaa95c, 0xffffff9b99999809,
  0xffffff43555553dc, 0xffffff8ecccccb09,
  0xffffff41555553d8, 0xffffff8d999997d1,
  0xffffffacaaaaaa04, 0xffffffcdffffff39,
  0xffffff9755555484, 0xffffffc133333239,
  0xffffff9555555480, 0xffffffbfffffff01,
  0xffffff93ffffff28, 0xffffffbf33333231,
  0xffffffeaaaaaaa80, 0xfffffff333333301,
  0xffffffe8aaaaaa7c, 0xfffffff1ffffffc9,
  0xffffffe755555524, 0xfffffff1333332f9,
  0xffffffe6aaaaaa78, 0xfffffff0cccccc91,
  0xfffffffeccccccc8, 0xfffffffffffd0001,
  0xfffffffdfffffff8, 0xfffffffffffb0001,
  0xfffffffd99999990, 0xfffffffffffa0001,
  0xfffffffd99999990, 0xfffffffffffa0001,
  0xffffffff33333330, 0xfffffffffffe0001,
  0xfffffffeccccccc8, 0xfffffffffffd0001,
  0xfffffffeccccccc8, 0xfffffffffffd0001,
  0xffffffff33333330, 0xfffffffffffe0001,
  0xffffffff99999998, 0xffffffffffff0001,
  0xffffffff99999998, 0xffffffffffff0001,
  0x0000000000000000, 0x0000000000000001,
  0x00000000ccccccd0, 0x0000000000020001,
  0x0000000000000000, 0x0000000000000001,
  0x0000000066666668, 0x0000000000010001,
  0x0000000133333338, 0x0000000000030001,
  0x0000000e00000038, 0x0000000000230001,
  0x0000000066666668, 0x0000000000010001,
  0x0000000133333338, 0x0000000000030001,
  0x0000000e00000038, 0x0000000000230001,
  0x0000004000000100, 0x0000000000a00001,
  0x00000000ccccccd0, 0x0000000000020001,
  0x0000000d999999d0, 0x0000000000220001,
  0x0000003f99999a98, 0x00000000009f0001,
  0x00000072000001c8, 0x00000000011d0001,
  0x0000000ccccccd00, 0x0000000000200001,
  0x0000003ecccccdc8, 0x00000000009d0001,
  0x00000071333334f8, 0x00000000011b0001,
  0x000000a400000290, 0x00000000019a0001,
  0x00000032000000c8, 0x00000000007d0001,
  0x00000064666667f8, 0x0000000000fb0001,
  0x0000009733333590, 0x00000000017a0001,
  0x000033c933340258, 0x0000000081770001,
  0x0000003266666730, 0x00000000007e0001,
  0x00000065333334c8, 0x0000000000fd0001,
  0x0000339733340190, 0x0000000080fa0001,
  0x000066c9999b34c0, 0x0000000100f80001,
  0x00000032cccccd98, 0x00000000007f0001,
  0x00003364cccd9a60, 0x00000000807c0001,
  0x000066973334cd90, 0x00000001007a0001,
  0x000099ca00026728, 0x0000000180790001,
  0x000033320000ccc8, 0x000000007ffd0001,
  0x000066646667fff8, 0x00000000fffb0001,
  0x0000999733359990, 0x000000017ffa0001,
  0x147b7adf1ebab848, 0x00003334b32d0001,
  0x0000333266673330, 0x000000007ffe0001,
  0x000066653334ccc8, 0x00000000fffd0001,
  0x147b47ad1eb9eb80, 0x0000333433300001,
  0x369d69cfa7427408, 0x0000888988850001,
  0x00003332cccd9998, 0x000000007fff0001,
  0x147b147ab852b850, 0x00003333b3320001,
  0x369d369d40db40d8, 0x0000888908870001,
  0x69d069d00da80da0, 0x0001088908840001,
  0x147ae147eb851eb8, 0x0000333333330001,
  0x369d036a740da740, 0x0000888888880001,
  0x69d0369d40da7408, 0x0001088888850001,
  0x7fffffffffffffff, 0x0001888888830001,
  0x2222222288888888, 0x0000555555550001,
  0x5555555555555550, 0x0000d55555520001,
  0x7fffffffffffffff, 0x0001555555500001,
  0x7fffffffffffffff, 0x0001d555554f0001,
  0x33333332ccccccc8, 0x00007ffffffd0001,
  0x66666665fffffff8, 0x0000fffffffb0001,
  0x7fffffffffffffff, 0x00017ffffffa0001,
  0x4ccccccbffffffff, 0x0000fffffffa0001,
  0x3333333333333330, 0x00007ffffffe0001,
  0x66666666ccccccc8, 0x0000fffffffd0001,
  0x33333332ccccccc8, 0x00007ffffffd0001,
  0xffffffff33333330, 0xfffffffffffe0001,
  0x3333333399999998, 0x00007fffffff0001,
  0xffffffff99999998, 0xffffffffffff0001,
  0xcccccccc00000000, 0xffff800000000001,
  0xaaaaaaa911111110, 0xffff2aaaaaaa0001,
  0xcccccccc00000000, 0xffff800000000001,
  0x9999999866666668, 0xffff000000010001,
  0x8000000000000000, 0xfffeaaaaaaab0001,
  0x8000000000000000, 0xfffe777777770001,
  0xcccccccc66666668, 0xffff800000010001,
  0xaaaaaaa977777778, 0xffff2aaaaaab0001,
  0x962fc961258bf258, 0xfffef77777770001,
  0x962f962df257f258, 0xfffef776f7770001,
  0xdddddddd11111110, 0xffffaaaaaaaa0001,
  0xc962fc94bf258bf0, 0xffff777777760001,
  0xc962c9618bf18bf0, 0xffff7776f7760001,
  0xc962962ebf23f258, 0xffff777677770001,
  0xeb851eb7ae147ae0, 0xffffcccccccc0001,
  0xeb84eb847ae07ae0, 0xffffcccc4ccc0001,
  0xeb84b851ae12e148, 0xffffcccbcccd0001,
  0xeb84851f47abae18, 0xffffcccb4ccf0001,
  0xffffcccccccc0000, 0xffffffff80000001,
  0xffff9999fffe6668, 0xffffffff00010001,
  0xffff666799973338, 0xfffffffe80030001,
  0xffff333599966670, 0xfffffffe00060001,
  0xffffcccd33326668, 0xffffffff80010001,
  0xffff999acccb3338, 0xffffffff00030001,
  0xffff6668ccca6670, 0xfffffffe80060001,
  0xffff663599973270, 0xfffffffe7f860001,
  0xffffcccd9998ccd0, 0xffffffff80020001,
  0xffff999b99980008, 0xffffffff00050001,
  0xffff99686664cc08, 0xfffffffeff850001,
  0xffff99359997fe70, 0xfffffffeff060001,
  0xffffcccdffff3338, 0xffffffff80030001,
  0xffffcc9acccbff38, 0xffffffff7f830001,
  0xffffcc67ffff31a0, 0xffffffff7f040001,
  0xffffcc359998ca70, 0xffffffff7e860001,
  0xffffffcccccccc00, 0xffffffffff800001,
  0xffffff99fffffe68, 0xffffffffff010001,
  0xffffff6799999738, 0xfffffffffe830001,
  0xffffff3599999670, 0xfffffffffe060001,
  0xffffffcd33333268, 0xffffffffff810001,
  0xffffff9acccccb38, 0xffffffffff030001,
  0xffffff68ccccca70, 0xfffffffffe860001,
  0xffffff5bfffffd70, 0xfffffffffe660001,
  0xffffffcd999998d0, 0xffffffffff820001,
  0xffffff9b99999808, 0xffffffffff050001,
  0xffffff8ecccccb08, 0xfffffffffee50001,
  0xffffff8d999997d0, 0xfffffffffee20001,
  0xffffffcdffffff38, 0xffffffffff830001,
  0xffffffc133333238, 0xffffffffff630001,
  0xffffffbfffffff00, 0xffffffffff600001,
  0xffffffbf33333230, 0xffffffffff5e0001,
  0xfffffff333333300, 0xffffffffffe00001,
  0xfffffff1ffffffc8, 0xffffffffffdd0001,
  0xfffffff1333332f8, 0xffffffffffdb0001,
  0xfffffff0cccccc90, 0xffffffffffda0001,
  0xfffffffffffd0000, 0xfffffffffffd0007,
  0xfffffffffffb0000, 0xfffffffffffb000b,
  0xfffffffffffa0000, 0xfffffffffffa000d,
  0xfffffffffffa0000, 0xfffffffffffa000d,
  0xfffffffffffe0000, 0xfffffffffffe0005,
  0xfffffffffffd0000, 0xfffffffffffd0007,
  0xfffffffffffd0000, 0xfffffffffffd0007,
  0xfffffffffffe0000, 0xfffffffffffe0005,
  0xffffffffffff0000, 0xffffffffffff0003,
  0xffffffffffff0000, 0xffffffffffff0003,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000020000, 0x000000000001fffd,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000010000, 0x000000000000ffff,
  0x0000000000030000, 0x000000000002fffb,
  0x0000000000230000, 0x000000000022ffbb,
  0x0000000000010000, 0x000000000000ffff,
  0x0000000000030000, 0x000000000002fffb,
  0x0000000000230000, 0x000000000022ffbb,
  0x0000000000a00000, 0x00000000009ffec1,
  0x0000000000020000, 0x000000000001fffd,
  0x0000000000220000, 0x000000000021ffbd,
  0x00000000009f0000, 0x00000000009efec3,
  0x00000000011d0000, 0x00000000011cfdc7,
  0x0000000000200000, 0x00000000001fffc1,
  0x00000000009d0000, 0x00000000009cfec7,
  0x00000000011b0000, 0x00000000011afdcb,
  0x00000000019a0000, 0x000000000199fccd,
  0x00000000007d0000, 0x00000000007cff07,
  0x0000000000fb0000, 0x0000000000fafe0b,
  0x00000000017a0000, 0x000000000179fd0d,
  0x0000000081770000, 0x000000008175fd13,
  0x00000000007e0000, 0x00000000007dff05,
  0x0000000000fd0000, 0x0000000000fcfe07,
  0x0000000080fa0000, 0x0000000080f8fe0d,
  0x0000000100f80000, 0x0000000100f5fe11,
  0x00000000007f0000, 0x00000000007eff03,
  0x00000000807c0000, 0x00000000807aff09,
  0x00000001007a0000, 0x000000010077ff0d,
  0x0000000180790000, 0x000000018075ff0f,
  0x000000007ffd0000, 0x000000007ffc0007,
  0x00000000fffb0000, 0x00000000fff9000b,
  0x000000017ffa0000, 0x000000017ff7000d,
  0x00003334b32d0000, 0x000033344cc399a7,
  0x000000007ffe0000, 0x000000007ffd0005,
  0x00000000fffd0000, 0x00000000fffb0007,
  0x0000333433300000, 0x00003333ccc799a1,
  0x0000888988850000, 0x000088887771eef7,
  0x000000007fff0000, 0x000000007ffe0003,
  0x00003333b3320000, 0x000033334cca999d,
  0x0000888908870000, 0x00008887f774eef3,
  0x0001088908840000, 0x00010886f771eef9,
  0x0000333333330000, 0x00003332cccc999b,
  0x0000888888880000, 0x000088877776eef1,
  0x0001088888850000, 0x000108867773eef7,
  0x0001888888830000, 0x000188857771eefb,
  0x0000555555550000, 0x00005554aaaa5557,
  0x0000d55555520000, 0x0000d553aaa7555d,
  0x0001555555500000, 0x00015552aaa55561,
  0x0001d555554f0000, 0x0001d551aaa45563,
  0x00007ffffffd0000, 0x00007ffefffd0007,
  0x0000fffffffb0000, 0x0000fffdfffb000b,
  0x00017ffffffa0000, 0x00017ffcfffa000d,
  0x0000fffffffa0000, 0x0000fffdfffa000d,
  0x00007ffffffe0000, 0x00007ffefffe0005,
  0x0000fffffffd0000, 0x0000fffdfffd0007,
  0x00007ffffffd0000, 0x00007ffefffd0007,
  0xfffffffffffe0000, 0xfffffffffffe0005,
  0x00007fffffff0000, 0x00007ffeffff0003,
  0xffffffffffff0000, 0xffffffffffff0003,
  0xffff800000000000, 0xffff800100000001,
  0xffff2aaaaaaa0000, 0xffff2aac5554aaad,
  0xffff800000000000, 0xffff800100000001,
  0xffff000000010000, 0xffff00020000ffff,
  0xfffeaaaaaaab0000, 0xfffeaaad5555aaab,
  0xfffe777777770000, 0xfffe777a88881113,
  0xffff800000010000, 0xffff80010000ffff,
  0xffff2aaaaaab0000, 0xffff2aac5555aaab,
  0xfffef77777770000, 0xfffef77988881113,
  0xfffef776f7770000, 0xfffef77908891113,
  0xffffaaaaaaaa0000, 0xffffaaab5554aaad,
  0xffff777777760000, 0xffff777888871115,
  0xffff7776f7760000, 0xffff777808881115,
  0xffff777677770000, 0xffff7777888a1113,
  0xffffcccccccc0000, 0xffffcccd33326669,
  0xffffcccc4ccc0000, 0xffffccccb3336669,
  0xffffcccbcccd0000, 0xffffcccc33356667,
  0xffffcccb4ccf0000, 0xffffcccbb3386663,
  0xffffffff80000000, 0xffffffff80010001,
  0xffffffff00010000, 0xffffffff0002ffff,
  0xfffffffe80030000, 0xfffffffe8005fffb,
  0xfffffffe00060000, 0xfffffffe0009fff5,
  0xffffffff80010000, 0xffffffff8001ffff,
  0xffffffff00030000, 0xffffffff0004fffb,
  0xfffffffe80060000, 0xfffffffe8008fff5,
  0xfffffffe7f860000, 0xfffffffe7f8900f5,
  0xffffffff80020000, 0xffffffff8002fffd,
  0xffffffff00050000, 0xffffffff0006fff7,
  0xfffffffeff850000, 0xfffffffeff8700f7,
  0xfffffffeff060000, 0xfffffffeff0801f5,
  0xffffffff80030000, 0xffffffff8003fffb,
  0xffffffff7f830000, 0xffffffff7f8400fb,
  0xffffffff7f040000, 0xffffffff7f0501f9,
  0xffffffff7e860000, 0xffffffff7e8702f5,
  0xffffffffff800000, 0xffffffffff800101,
  0xffffffffff010000, 0xffffffffff0101ff,
  0xfffffffffe830000, 0xfffffffffe8302fb,
  0xfffffffffe060000, 0xfffffffffe0603f5,
  0xffffffffff810000, 0xffffffffff8100ff,
  0xffffffffff030000, 0xffffffffff0301fb,
  0xfffffffffe860000, 0xfffffffffe8602f5,
  0xfffffffffe660000, 0xfffffffffe660335,
  0xffffffffff820000, 0xffffffffff8200fd,
  0xffffffffff050000, 0xffffffffff0501f7,
  0xfffffffffee50000, 0xfffffffffee50237,
  0xfffffffffee20000, 0xfffffffffee2023d,
  0xffffffffff830000, 0xffffffffff8300fb,
  0xffffffffff630000, 0xffffffffff63013b,
  0xffffffffff600000, 0xffffffffff600141,
  0xffffffffff5e0000, 0xffffffffff5e0145,
  0xffffffffffe00000, 0xffffffffffe00041,
  0xffffffffffdd0000, 0xffffffffffdd0047,
  0xffffffffffdb0000, 0xffffffffffdb004b,
  0xffffffffffda0000, 0xffffffffffda004d,
  0xfffffffffffd0006, 0xfffffffffffd000d,
  0xfffffffffffb000a, 0xfffffffffffb0015,
  0xfffffffffffa000c, 0xfffffffffffa0019,
  0xfffffffffffa000c, 0xfffffffffffa0019,
  0xfffffffffffe0004, 0xfffffffffffe0009,
  0xfffffffffffd0006, 0xfffffffffffd000d,
  0xfffffffffffd0006, 0xfffffffffffd000d,
  0xfffffffffffe0004, 0xfffffffffffe0009,
  0xffffffffffff0002, 0xffffffffffff0005,
  0xffffffffffff0002, 0xffffffffffff0005,
  0x0000000000000000, 0x0000000000000001,
  0x000000000001fffc, 0x000000000001fff9,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffe, 0x000000000000fffd,
  0x000000000002fffa, 0x000000000002fff5,
  0x000000000022ffba, 0x000000000022ff75,
  0x000000000000fffe, 0x000000000000fffd,
  0x000000000002fffa, 0x000000000002fff5,
  0x000000000022ffba, 0x000000000022ff75,
  0x00000000009ffec0, 0x00000000009ffd81,
  0x000000000001fffc, 0x000000000001fff9,
  0x000000000021ffbc, 0x000000000021ff79,
  0x00000000009efec2, 0x00000000009efd85,
  0x00000000011cfdc6, 0x00000000011cfb8d,
  0x00000000001fffc0, 0x00000000001fff81,
  0x00000000009cfec6, 0x00000000009cfd8d,
  0x00000000011afdca, 0x00000000011afb95,
  0x000000000199fccc, 0x000000000199f999,
  0x00000000007cff06, 0x00000000007cfe0d,
  0x0000000000fafe0a, 0x0000000000fafc15,
  0x000000000179fd0c, 0x000000000179fa19,
  0x000000008175fd12, 0x000000008174fa25,
  0x00000000007dff04, 0x00000000007dfe09,
  0x0000000000fcfe06, 0x0000000000fcfc0d,
  0x0000000080f8fe0c, 0x0000000080f7fc19,
  0x0000000100f5fe10, 0x0000000100f3fc21,
  0x00000000007eff02, 0x00000000007efe05,
  0x00000000807aff08, 0x000000008079fe11,
  0x000000010077ff0c, 0x000000010075fe19,
  0x000000018075ff0e, 0x000000018072fe1d,
  0x000000007ffc0006, 0x000000007ffb000d,
  0x00000000fff9000a, 0x00000000fff70015,
  0x000000017ff7000c, 0x000000017ff40019,
  0x000033344cc399a6, 0x00003333e65a334d,
  0x000000007ffd0004, 0x000000007ffc0009,
  0x00000000fffb0006, 0x00000000fff9000d,
  0x00003333ccc799a0, 0x00003333665f3341,
  0x000088887771eef6, 0x00008887665edded,
  0x000000007ffe0002, 0x000000007ffd0005,
  0x000033334cca999c, 0x00003332e6633339,
  0x00008887f774eef2, 0x00008886e662dde5,
  0x00010886f771eef8, 0x00010884e65fddf1,
  0x00003332cccc999a, 0x0000333266663335,
  0x000088877776eef0, 0x000088866665dde1,
  0x000108867773eef6, 0x000108846662dded,
  0x000188857771eefa, 0x000188826660ddf5,
  0x00005554aaaa5556, 0x00005553ffffaaad,
  0x0000d553aaa7555c, 0x0000d551fffcaab9,
  0x00015552aaa55560, 0x0001554ffffaaac1,
  0x0001d551aaa45562, 0x0001d54dfff9aac5,
  0x00007ffefffd0006, 0x00007ffdfffd000d,
  0x0000fffdfffb000a, 0x0000fffbfffb0015,
  0x00017ffcfffa000c, 0x00017ff9fffa0019,
  0x0000fffdfffa000c, 0x0000fffbfffa0019,
  0x00007ffefffe0004, 0x00007ffdfffe0009,
  0x0000fffdfffd0006, 0x0000fffbfffd000d,
  0x00007ffefffd0006, 0x00007ffdfffd000d,
  0xfffffffffffe0004, 0xfffffffffffe0009,
  0x00007ffeffff0002, 0x00007ffdffff0005,
  0xffffffffffff0002, 0xffffffffffff0005,
  0xffff800100000000, 0xffff800200000001,
  0xffff2aac5554aaac, 0xffff2aadffff5559,
  0xffff800100000000, 0xffff800200000001,
  0xffff00020000fffe, 0xffff00040000fffd,
  0xfffeaaad5555aaaa, 0xfffeaab000005555,
  0xfffe777a88881112, 0xfffe777d99992225,
  0xffff80010000fffe, 0xffff80020000fffd,
  0xffff2aac5555aaaa, 0xffff2aae00005555,
  0xfffef77988881112, 0xfffef77b99992225,
  0xfffef77908891112, 0xfffef77b199b2225,
  0xffffaaab5554aaac, 0xffffaaabffff5559,
  0xffff777888871114, 0xffff777999982229,
  0xffff777808881114, 0xffff7779199a2229,
  0xffff7777888a1112, 0xffff7778999d2225,
  0xffffcccd33326668, 0xffffcccd9998ccd1,
  0xffffccccb3336668, 0xffffcccd199accd1,
  0xffffcccc33356666, 0xffffcccc999dcccd,
  0xffffcccbb3386662, 0xffffcccc19a1ccc5,
  0xffffffff80010000, 0xffffffff80020001,
  0xffffffff0002fffe, 0xffffffff0004fffd,
  0xfffffffe8005fffa, 0xfffffffe8008fff5,
  0xfffffffe0009fff4, 0xfffffffe000dffe9,
  0xffffffff8001fffe, 0xffffffff8002fffd,
  0xffffffff0004fffa, 0xffffffff0006fff5,
  0xfffffffe8008fff4, 0xfffffffe800bffe9,
  0xfffffffe7f8900f4, 0xfffffffe7f8c01e9,
  0xffffffff8002fffc, 0xffffffff8003fff9,
  0xffffffff0006fff6, 0xffffffff0008ffed,
  0xfffffffeff8700f6, 0xfffffffeff8901ed,
  0xfffffffeff0801f4, 0xfffffffeff0a03e9,
  0xffffffff8003fffa, 0xffffffff8004fff5,
  0xffffffff7f8400fa, 0xffffffff7f8501f5,
  0xffffffff7f0501f8, 0xffffffff7f0603f1,
  0xffffffff7e8702f4, 0xffffffff7e8805e9,
  0xffffffffff800100, 0xffffffffff800201,
  0xffffffffff0101fe, 0xffffffffff0103fd,
  0xfffffffffe8302fa, 0xfffffffffe8305f5,
  0xfffffffffe0603f4, 0xfffffffffe0607e9,
  0xffffffffff8100fe, 0xffffffffff8101fd,
  0xffffffffff0301fa, 0xffffffffff0303f5,
  0xfffffffffe8602f4, 0xfffffffffe8605e9,
  0xfffffffffe660334, 0xfffffffffe660669,
  0xffffffffff8200fc, 0xffffffffff8201f9,
  0xffffffffff0501f6, 0xffffffffff0503ed,
  0xfffffffffee50236, 0xfffffffffee5046d,
  0xfffffffffee2023c, 0xfffffffffee20479,
  0xffffffffff8300fa, 0xffffffffff8301f5,
  0xffffffffff63013a, 0xffffffffff630275,
  0xffffffffff600140, 0xffffffffff600281,
  0xffffffffff5e0144, 0xffffffffff5e0289,
  0xffffffffffe00040, 0xffffffffffe00081,
  0xffffffffffdd0046, 0xffffffffffdd008d,
  0xffffffffffdb004a, 0xffffffffffdb0095,
  0xffffffffffda004c, 0xffffffffffda0099,
  0xfffffffffffd000c, 0xfffffffffffd0013,
  0xfffffffffffb0014, 0xfffffffffffb001f,
  0xfffffffffffa0018, 0xfffffffffffa0025,
  0xfffffffffffa0018, 0xfffffffffffa0025,
  0xfffffffffffe0008, 0xfffffffffffe000d,
  0xfffffffffffd000c, 0xfffffffffffd0013,
  0xfffffffffffd000c, 0xfffffffffffd0013,
  0xfffffffffffe0008, 0xfffffffffffe000d,
  0xffffffffffff0004, 0xffffffffffff0007,
  0xffffffffffff0004, 0xffffffffffff0007,
  0x0000000000000000, 0x0000000000000001,
  0x000000000001fff8, 0x000000000001fff5,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffc, 0x000000000000fffb,
  0x000000000002fff4, 0x000000000002ffef,
  0x000000000022ff74, 0x000000000022ff2f,
  0x000000000000fffc, 0x000000000000fffb,
  0x000000000002fff4, 0x000000000002ffef,
  0x000000000022ff74, 0x000000000022ff2f,
  0x00000000009ffd80, 0x00000000009ffc41,
  0x000000000001fff8, 0x000000000001fff5,
  0x000000000021ff78, 0x000000000021ff35,
  0x00000000009efd84, 0x00000000009efc47,
  0x00000000011cfb8c, 0x00000000011cf953,
  0x00000000001fff80, 0x00000000001fff41,
  0x00000000009cfd8c, 0x00000000009cfc53,
  0x00000000011afb94, 0x00000000011af95f,
  0x000000000199f998, 0x000000000199f665,
  0x00000000007cfe0c, 0x00000000007cfd13,
  0x0000000000fafc14, 0x0000000000fafa1f,
  0x000000000179fa18, 0x000000000179f725,
  0x000000008174fa24, 0x000000008173f737,
  0x00000000007dfe08, 0x00000000007dfd0d,
  0x0000000000fcfc0c, 0x0000000000fcfa13,
  0x0000000080f7fc18, 0x0000000080f6fa25,
  0x0000000100f3fc20, 0x0000000100f1fa31,
  0x00000000007efe04, 0x00000000007efd07,
  0x000000008079fe10, 0x000000008078fd19,
  0x000000010075fe18, 0x000000010073fd25,
  0x000000018072fe1c, 0x00000001806ffd2b,
  0x000000007ffb000c, 0x000000007ffa0013,
  0x00000000fff70014, 0x00000000fff5001f,
  0x000000017ff40018, 0x000000017ff10025,
  0x00003333e65a334c, 0x000033337ff0ccf3,
  0x000000007ffc0008, 0x000000007ffb000d,
  0x00000000fff9000c, 0x00000000fff70013,
  0x00003333665f3340, 0x00003332fff6cce1,
  0x00008887665eddec, 0x00008886554bcce3,
  0x000000007ffd0004, 0x000000007ffc0007,
  0x00003332e6633338, 0x000033327ffbccd5,
  0x00008886e662dde4, 0x00008885d550ccd7,
  0x00010884e65fddf0, 0x00010882d54dcce9,
  0x0000333266663334, 0x00003331ffffcccf,
  0x000088866665dde0, 0x000088855554ccd1,
  0x000108846662ddec, 0x000108825551cce3,
  0x000188826660ddf4, 0x0001887f554fccef,
  0x00005553ffffaaac, 0x0000555355550003,
  0x0000d551fffcaab8, 0x0000d55055520015,
  0x0001554ffffaaac0, 0x0001554d55500021,
  0x0001d54dfff9aac4, 0x0001d54a554f0027,
  0x00007ffdfffd000c, 0x00007ffcfffd0013,
  0x0000fffbfffb0014, 0x0000fff9fffb001f,
  0x00017ff9fffa0018, 0x00017ff6fffa0025,
  0x0000fffbfffa0018, 0x0000fff9fffa0025,
  0x00007ffdfffe0008, 0x00007ffcfffe000d,
  0x0000fffbfffd000c, 0x0000fff9fffd0013,
  0x00007ffdfffd000c, 0x00007ffcfffd0013,
  0xfffffffffffe0008, 0xfffffffffffe000d,
  0x00007ffdffff0004, 0x00007ffcffff0007,
  0xffffffffffff0004, 0xffffffffffff0007,
  0xffff800200000000, 0xffff800300000001,
  0xffff2aadffff5558, 0xffff2aafaaaa0005,
  0xffff800200000000, 0xffff800300000001,
  0xffff00040000fffc, 0xffff00060000fffb,
  0xfffeaab000005554, 0xfffeaab2aaaaffff,
  0xfffe777d99992224, 0xfffe7780aaaa3337,
  0xffff80020000fffc, 0xffff80030000fffb,
  0xffff2aae00005554, 0xffff2aafaaaaffff,
  0xfffef77b99992224, 0xfffef77daaaa3337,
  0xfffef77b199b2224, 0xfffef77d2aad3337,
  0xffffaaabffff5558, 0xffffaaacaaaa0005,
  0xffff777999982228, 0xffff777aaaa9333d,
  0xffff7779199a2228, 0xffff777a2aac333d,
  0xffff7778999d2224, 0xffff7779aab03337,
  0xffffcccd9998ccd0, 0xffffcccdffff3339,
  0xffffcccd199accd0, 0xffffcccd80023339,
  0xffffcccc999dcccc, 0xffffcccd00063333,
  0xffffcccc19a1ccc4, 0xffffcccc800b3327,
  0xffffffff80020000, 0xffffffff80030001,
  0xffffffff0004fffc, 0xffffffff0006fffb,
  0xfffffffe8008fff4, 0xfffffffe800bffef,
  0xfffffffe000dffe8, 0xfffffffe0011ffdd,
  0xffffffff8002fffc, 0xffffffff8003fffb,
  0xffffffff0006fff4, 0xffffffff0008ffef,
  0xfffffffe800bffe8, 0xfffffffe800effdd,
  0xfffffffe7f8c01e8, 0xfffffffe7f8f02dd,
  0xffffffff8003fff8, 0xffffffff8004fff5,
  0xffffffff0008ffec, 0xffffffff000affe3,
  0xfffffffeff8901ec, 0xfffffffeff8b02e3,
  0xfffffffeff0a03e8, 0xfffffffeff0c05dd,
  0xffffffff8004fff4, 0xffffffff8005ffef,
  0xffffffff7f8501f4, 0xffffffff7f8602ef,
  0xffffffff7f0603f0, 0xffffffff7f0705e9,
  0xffffffff7e8805e8, 0xffffffff7e8908dd,
  0xffffffffff800200, 0xffffffffff800301,
  0xffffffffff0103fc, 0xffffffffff0105fb,
  0xfffffffffe8305f4, 0xfffffffffe8308ef,
  0xfffffffffe0607e8, 0xfffffffffe060bdd,
  0xffffffffff8101fc, 0xffffffffff8102fb,
  0xffffffffff0303f4, 0xffffffffff0305ef,
  0xfffffffffe8605e8, 0xfffffffffe8608dd,
  0xfffffffffe660668, 0xfffffffffe66099d,
  0xffffffffff8201f8, 0xffffffffff8202f5,
  0xffffffffff0503ec, 0xffffffffff0505e3,
  0xfffffffffee5046c, 0xfffffffffee506a3,
  0xfffffffffee20478, 0xfffffffffee206b5,
  0xffffffffff8301f4, 0xffffffffff8302ef,
  0xffffffffff630274, 0xffffffffff6303af,
  0xffffffffff600280, 0xffffffffff6003c1,
  0xffffffffff5e0288, 0xffffffffff5e03cd,
  0xffffffffffe00080, 0xffffffffffe000c1,
  0xffffffffffdd008c, 0xffffffffffdd00d3,
  0xffffffffffdb0094, 0xffffffffffdb00df,
  0xffffffffffda0098, 0xffffffffffda00e5,
  0xfffffffffffd0012, 0xfffffffffffffd01,
  0xfffffffffffb001e, 0xfffffffffffffb01,
  0xfffffffffffa0024, 0xfffffffffffffa01,
  0xfffffffffffa0024, 0xfffffffffffffa01,
  0xfffffffffffe000c, 0xfffffffffffffe01,
  0xfffffffffffd0012, 0xfffffffffffffd01,
  0xfffffffffffd0012, 0xfffffffffffffd01,
  0xfffffffffffe000c, 0xfffffffffffffe01,
  0xffffffffffff0006, 0xffffffffffffff01,
  0xffffffffffff0006, 0xffffffffffffff01,
  0x0000000000000000, 0x0000000000000001,
  0x000000000001fff4, 0x0000000000000201,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000fffa, 0x0000000000000101,
  0x000000000002ffee, 0x0000000000000301,
  0x000000000022ff2e, 0x0000000000002301,
  0x000000000000fffa, 0x0000000000000101,
  0x000000000002ffee, 0x0000000000000301,
  0x000000000022ff2e, 0x0000000000002301,
  0x00000000009ffc40, 0x000000000000a001,
  0x000000000001fff4, 0x0000000000000201,
  0x000000000021ff34, 0x0000000000002201,
  0x00000000009efc46, 0x0000000000009f01,
  0x00000000011cf952, 0x0000000000011d01,
  0x00000000001fff40, 0x0000000000002001,
  0x00000000009cfc52, 0x0000000000009d01,
  0x00000000011af95e, 0x0000000000011b01,
  0x000000000199f664, 0x0000000000019a01,
  0x00000000007cfd12, 0x0000000000007d01,
  0x0000000000fafa1e, 0x000000000000fb01,
  0x000000000179f724, 0x0000000000017a01,
  0x000000008173f736, 0x0000000000817701,
  0x00000000007dfd0c, 0x0000000000007e01,
  0x0000000000fcfa12, 0x000000000000fd01,
  0x0000000080f6fa24, 0x000000000080fa01,
  0x0000000100f1fa30, 0x000000000100f801,
  0x00000000007efd06, 0x0000000000007f01,
  0x000000008078fd18, 0x0000000000807c01,
  0x000000010073fd24, 0x0000000001007a01,
  0x00000001806ffd2a, 0x0000000001807901,
  0x000000007ffa0012, 0x00000000007ffd01,
  0x00000000fff5001e, 0x0000000000fffb01,
  0x000000017ff10024, 0x00000000017ffa01,
  0x000033337ff0ccf2, 0x0000003334b32d01,
  0x000000007ffb000c, 0x00000000007ffe01,
  0x00000000fff70012, 0x0000000000fffd01,
  0x00003332fff6cce0, 0x0000003334333001,
  0x00008886554bcce2, 0x0000008889888501,
  0x000000007ffc0006, 0x00000000007fff01,
  0x000033327ffbccd4, 0x0000003333b33201,
  0x00008885d550ccd6, 0x0000008889088701,
  0x00010882d54dcce8, 0x0000010889088401,
  0x00003331ffffccce, 0x0000003333333301,
  0x000088855554ccd0, 0x0000008888888801,
  0x000108825551cce2, 0x0000010888888501,
  0x0001887f554fccee, 0x0000018888888301,
  0x0000555355550002, 0x0000005555555501,
  0x0000d55055520014, 0x000000d555555201,
  0x0001554d55500020, 0x0000015555555001,
  0x0001d54a554f0026, 0x000001d555554f01,
  0x00007ffcfffd0012, 0x0000007ffffffd01,
  0x0000fff9fffb001e, 0x000000fffffffb01,
  0x00017ff6fffa0024, 0x0000017ffffffa01,
  0x0000fff9fffa0024, 0x000000fffffffa01,
  0x00007ffcfffe000c, 0x0000007ffffffe01,
  0x0000fff9fffd0012, 0x000000fffffffd01,
  0x00007ffcfffd0012, 0x0000007ffffffd01,
  0xfffffffffffe000c, 0xfffffffffffffe01,
  0x00007ffcffff0006, 0x0000007fffffff01,
  0xffffffffffff0006, 0xffffffffffffff01,
  0xffff800300000000, 0xffffff8000000001,
  0xffff2aafaaaa0004, 0xffffff2aaaaaaa01,
  0xffff800300000000, 0xffffff8000000001,
  0xffff00060000fffa, 0xffffff0000000101,
  0xfffeaab2aaaafffe, 0xfffffeaaaaaaab01,
  0xfffe7780aaaa3336, 0xfffffe7777777701,
  0xffff80030000fffa, 0xffffff8000000101,
  0xffff2aafaaaafffe, 0xffffff2aaaaaab01,
  0xfffef77daaaa3336, 0xfffffef777777701,
  0xfffef77d2aad3336, 0xfffffef776f77701,
  0xffffaaacaaaa0004, 0xffffffaaaaaaaa01,
  0xffff777aaaa9333c, 0xffffff7777777601,
  0xffff777a2aac333c, 0xffffff7776f77601,
  0xffff7779aab03336, 0xffffff7776777701,
  0xffffcccdffff3338, 0xffffffcccccccc01,
  0xffffcccd80023338, 0xffffffcccc4ccc01,
  0xffffcccd00063332, 0xffffffcccbcccd01,
  0xffffcccc800b3326, 0xffffffcccb4ccf01,
  0xffffffff80030000, 0xffffffffff800001,
  0xffffffff0006fffa, 0xffffffffff000101,
  0xfffffffe800bffee, 0xfffffffffe800301,
  0xfffffffe0011ffdc, 0xfffffffffe000601,
  0xffffffff8003fffa, 0xffffffffff800101,
  0xffffffff0008ffee, 0xffffffffff000301,
  0xfffffffe800effdc, 0xfffffffffe800601,
  0xfffffffe7f8f02dc, 0xfffffffffe7f8601,
  0xffffffff8004fff4, 0xffffffffff800201,
  0xffffffff000affe2, 0xffffffffff000501,
  0xfffffffeff8b02e2, 0xfffffffffeff8501,
  0xfffffffeff0c05dc, 0xfffffffffeff0601,
  0xffffffff8005ffee, 0xffffffffff800301,
  0xffffffff7f8602ee, 0xffffffffff7f8301,
  0xffffffff7f0705e8, 0xffffffffff7f0401,
  0xffffffff7e8908dc, 0xffffffffff7e8601,
  0xffffffffff800300, 0xffffffffffff8001,
  0xffffffffff0105fa, 0xffffffffffff0101,
  0xfffffffffe8308ee, 0xfffffffffffe8301,
  0xfffffffffe060bdc, 0xfffffffffffe0601,
  0xffffffffff8102fa, 0xffffffffffff8101,
  0xffffffffff0305ee, 0xffffffffffff0301,
  0xfffffffffe8608dc, 0xfffffffffffe8601,
  0xfffffffffe66099c, 0xfffffffffffe6601,
  0xffffffffff8202f4, 0xffffffffffff8201,
  0xffffffffff0505e2, 0xffffffffffff0501,
  0xfffffffffee506a2, 0xfffffffffffee501,
  0xfffffffffee206b4, 0xfffffffffffee201,
  0xffffffffff8302ee, 0xffffffffffff8301,
  0xffffffffff6303ae, 0xffffffffffff6301,
  0xffffffffff6003c0, 0xffffffffffff6001,
  0xffffffffff5e03cc, 0xffffffffffff5e01,
  0xffffffffffe000c0, 0xffffffffffffe001,
  0xffffffffffdd00d2, 0xffffffffffffdd01,
  0xffffffffffdb00de, 0xffffffffffffdb01,
  0xffffffffffda00e4, 0xffffffffffffda01,
  0xfffffffffffffd00, 0xfffffffffffffd07,
  0xfffffffffffffb00, 0xfffffffffffffb0b,
  0xfffffffffffffa00, 0xfffffffffffffa0d,
  0xfffffffffffffa00, 0xfffffffffffffa0d,
  0xfffffffffffffe00, 0xfffffffffffffe05,
  0xfffffffffffffd00, 0xfffffffffffffd07,
  0xfffffffffffffd00, 0xfffffffffffffd07,
  0xfffffffffffffe00, 0xfffffffffffffe05,
  0xffffffffffffff00, 0xffffffffffffff03,
  0xffffffffffffff00, 0xffffffffffffff03,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000200, 0x00000000000001fd,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000100, 0x00000000000000ff,
  0x0000000000000300, 0x00000000000002fb,
  0x0000000000002300, 0x00000000000022bb,
  0x0000000000000100, 0x00000000000000ff,
  0x0000000000000300, 0x00000000000002fb,
  0x0000000000002300, 0x00000000000022bb,
  0x000000000000a000, 0x0000000000009ec1,
  0x0000000000000200, 0x00000000000001fd,
  0x0000000000002200, 0x00000000000021bd,
  0x0000000000009f00, 0x0000000000009dc3,
  0x0000000000011d00, 0x0000000000011ac7,
  0x0000000000002000, 0x0000000000001fc1,
  0x0000000000009d00, 0x0000000000009bc7,
  0x0000000000011b00, 0x00000000000118cb,
  0x0000000000019a00, 0x00000000000196cd,
  0x0000000000007d00, 0x0000000000007c07,
  0x000000000000fb00, 0x000000000000f90b,
  0x0000000000017a00, 0x000000000001770d,
  0x0000000000817700, 0x0000000000807413,
  0x0000000000007e00, 0x0000000000007d05,
  0x000000000000fd00, 0x000000000000fb07,
  0x000000000080fa00, 0x00000000007ff80d,
  0x000000000100f800, 0x0000000000fef611,
  0x0000000000007f00, 0x0000000000007e03,
  0x0000000000807c00, 0x00000000007f7b09,
  0x0000000001007a00, 0x0000000000fe790d,
  0x0000000001807900, 0x00000000017d780f,
  0x00000000007ffd00, 0x00000000007efd07,
  0x0000000000fffb00, 0x0000000000fdfb0b,
  0x00000000017ffa00, 0x00000000017cfa0d,
  0x0000003334b32d00, 0x00000032ce49c6a7,
  0x00000000007ffe00, 0x00000000007efe05,
  0x0000000000fffd00, 0x0000000000fdfd07,
  0x0000003334333000, 0x00000032cdcac9a1,
  0x0000008889888500, 0x00000087787573f7,
  0x00000000007fff00, 0x00000000007eff03,
  0x0000003333b33200, 0x00000032cd4bcb9d,
  0x0000008889088700, 0x0000008777f675f3,
  0x0000010889088400, 0x0000010677f672f9,
  0x0000003333333300, 0x00000032cccccc9b,
  0x0000008888888800, 0x00000087777776f1,
  0x0000010888888500, 0x00000106777773f7,
  0x0000018888888300, 0x00000185777771fb,
  0x0000005555555500, 0x00000054aaaaaa57,
  0x000000d555555200, 0x000000d3aaaaa75d,
  0x0000015555555000, 0x00000152aaaaa561,
  0x000001d555554f00, 0x000001d1aaaaa463,
  0x0000007ffffffd00, 0x0000007efffffd07,
  0x000000fffffffb00, 0x000000fdfffffb0b,
  0x0000017ffffffa00, 0x0000017cfffffa0d,
  0x000000fffffffa00, 0x000000fdfffffa0d,
  0x0000007ffffffe00, 0x0000007efffffe05,
  0x000000fffffffd00, 0x000000fdfffffd07,
  0x0000007ffffffd00, 0x0000007efffffd07,
  0xfffffffffffffe00, 0xfffffffffffffe05,
  0x0000007fffffff00, 0x0000007effffff03,
  0xffffffffffffff00, 0xffffffffffffff03,
  0xffffff8000000000, 0xffffff8100000001,
  0xffffff2aaaaaaa00, 0xffffff2c555554ad,
  0xffffff8000000000, 0xffffff8100000001,
  0xffffff0000000100, 0xffffff02000000ff,
  0xfffffeaaaaaaab00, 0xfffffead555555ab,
  0xfffffe7777777700, 0xfffffe7a88888813,
  0xffffff8000000100, 0xffffff81000000ff,
  0xffffff2aaaaaab00, 0xffffff2c555555ab,
  0xfffffef777777700, 0xfffffef988888813,
  0xfffffef776f77700, 0xfffffef988098813,
  0xffffffaaaaaaaa00, 0xffffffab555554ad,
  0xffffff7777777600, 0xffffff7888888715,
  0xffffff7776f77600, 0xffffff7888098715,
  0xffffff7776777700, 0xffffff78878a8813,
  0xffffffcccccccc00, 0xffffffcd33333269,
  0xffffffcccc4ccc00, 0xffffffcd32b43269,
  0xffffffcccbcccd00, 0xffffffcd32353367,
  0xffffffcccb4ccf00, 0xffffffcd31b63563,
  0xffffffffff800000, 0xffffffffff810001,
  0xffffffffff000100, 0xffffffffff0200ff,
  0xfffffffffe800300, 0xfffffffffe8302fb,
  0xfffffffffe000600, 0xfffffffffe0405f5,
  0xffffffffff800100, 0xffffffffff8100ff,
  0xffffffffff000300, 0xffffffffff0202fb,
  0xfffffffffe800600, 0xfffffffffe8305f5,
  0xfffffffffe7f8600, 0xfffffffffe8286f5,
  0xffffffffff800200, 0xffffffffff8101fd,
  0xffffffffff000500, 0xffffffffff0204f7,
  0xfffffffffeff8500, 0xffffffffff0185f7,
  0xfffffffffeff0600, 0xffffffffff0107f5,
  0xffffffffff800300, 0xffffffffff8102fb,
  0xffffffffff7f8300, 0xffffffffff8083fb,
  0xffffffffff7f0400, 0xffffffffff8005f9,
  0xffffffffff7e8600, 0xffffffffff7f88f5,
  0xffffffffffff8000, 0xffffffffffff8101,
  0xffffffffffff0100, 0xffffffffffff02ff,
  0xfffffffffffe8300, 0xfffffffffffe85fb,
  0xfffffffffffe0600, 0xfffffffffffe09f5,
  0xffffffffffff8100, 0xffffffffffff81ff,
  0xffffffffffff0300, 0xffffffffffff04fb,
  0xfffffffffffe8600, 0xfffffffffffe88f5,
  0xfffffffffffe6600, 0xfffffffffffe6935,
  0xffffffffffff8200, 0xffffffffffff82fd,
  0xffffffffffff0500, 0xffffffffffff06f7,
  0xfffffffffffee500, 0xfffffffffffee737,
  0xfffffffffffee200, 0xfffffffffffee43d,
  0xffffffffffff8300, 0xffffffffffff83fb,
  0xffffffffffff6300, 0xffffffffffff643b,
  0xffffffffffff6000, 0xffffffffffff6141,
  0xffffffffffff5e00, 0xffffffffffff5f45,
  0xffffffffffffe000, 0xffffffffffffe041,
  0xffffffffffffdd00, 0xffffffffffffdd47,
  0xffffffffffffdb00, 0xffffffffffffdb4b,
  0xffffffffffffda00, 0xffffffffffffda4d,
  0xfffffffffffffd06, 0xfffffffffffffd0d,
  0xfffffffffffffb0a, 0xfffffffffffffb15,
  0xfffffffffffffa0c, 0xfffffffffffffa19,
  0xfffffffffffffa0c, 0xfffffffffffffa19,
  0xfffffffffffffe04, 0xfffffffffffffe09,
  0xfffffffffffffd06, 0xfffffffffffffd0d,
  0xfffffffffffffd06, 0xfffffffffffffd0d,
  0xfffffffffffffe04, 0xfffffffffffffe09,
  0xffffffffffffff02, 0xffffffffffffff05,
  0xffffffffffffff02, 0xffffffffffffff05,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000001fc, 0x00000000000001f9,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fe, 0x00000000000000fd,
  0x00000000000002fa, 0x00000000000002f5,
  0x00000000000022ba, 0x0000000000002275,
  0x00000000000000fe, 0x00000000000000fd,
  0x00000000000002fa, 0x00000000000002f5,
  0x00000000000022ba, 0x0000000000002275,
  0x0000000000009ec0, 0x0000000000009d81,
  0x00000000000001fc, 0x00000000000001f9,
  0x00000000000021bc, 0x0000000000002179,
  0x0000000000009dc2, 0x0000000000009c85,
  0x0000000000011ac6, 0x000000000001188d,
  0x0000000000001fc0, 0x0000000000001f81,
  0x0000000000009bc6, 0x0000000000009a8d,
  0x00000000000118ca, 0x0000000000011695,
  0x00000000000196cc, 0x0000000000019399,
  0x0000000000007c06, 0x0000000000007b0d,
  0x000000000000f90a, 0x000000000000f715,
  0x000000000001770c, 0x0000000000017419,
  0x0000000000807412, 0x00000000007f7125,
  0x0000000000007d04, 0x0000000000007c09,
  0x000000000000fb06, 0x000000000000f90d,
  0x00000000007ff80c, 0x00000000007ef619,
  0x0000000000fef610, 0x0000000000fcf421,
  0x0000000000007e02, 0x0000000000007d05,
  0x00000000007f7b08, 0x00000000007e7a11,
  0x0000000000fe790c, 0x0000000000fc7819,
  0x00000000017d780e, 0x00000000017a771d,
  0x00000000007efd06, 0x00000000007dfd0d,
  0x0000000000fdfb0a, 0x0000000000fbfb15,
  0x00000000017cfa0c, 0x000000000179fa19,
  0x00000032ce49c6a6, 0x0000003267e0604d,
  0x00000000007efe04, 0x00000000007dfe09,
  0x0000000000fdfd06, 0x0000000000fbfd0d,
  0x00000032cdcac9a0, 0x0000003267626341,
  0x00000087787573f6, 0x00000086676262ed,
  0x00000000007eff02, 0x00000000007dff05,
  0x00000032cd4bcb9c, 0x0000003266e46539,
  0x0000008777f675f2, 0x0000008666e464e5,
  0x0000010677f672f8, 0x0000010466e461f1,
  0x00000032cccccc9a, 0x0000003266666635,
  0x00000087777776f0, 0x00000086666665e1,
  0x00000106777773f6, 0x00000104666662ed,
  0x00000185777771fa, 0x00000182666660f5,
  0x00000054aaaaaa56, 0x00000053ffffffad,
  0x000000d3aaaaa75c, 0x000000d1fffffcb9,
  0x00000152aaaaa560, 0x0000014ffffffac1,
  0x000001d1aaaaa462, 0x000001cdfffff9c5,
  0x0000007efffffd06, 0x0000007dfffffd0d,
  0x000000fdfffffb0a, 0x000000fbfffffb15,
  0x0000017cfffffa0c, 0x00000179fffffa19,
  0x000000fdfffffa0c, 0x000000fbfffffa19,
  0x0000007efffffe04, 0x0000007dfffffe09,
  0x000000fdfffffd06, 0x000000fbfffffd0d,
  0x0000007efffffd06, 0x0000007dfffffd0d,
  0xfffffffffffffe04, 0xfffffffffffffe09,
  0x0000007effffff02, 0x0000007dffffff05,
  0xffffffffffffff02, 0xffffffffffffff05,
  0xffffff8100000000, 0xffffff8200000001,
  0xffffff2c555554ac, 0xffffff2dffffff59,
  0xffffff8100000000, 0xffffff8200000001,
  0xffffff02000000fe, 0xffffff04000000fd,
  0xfffffead555555aa, 0xfffffeb000000055,
  0xfffffe7a88888812, 0xfffffe7d99999925,
  0xffffff81000000fe, 0xffffff82000000fd,
  0xffffff2c555555aa, 0xffffff2e00000055,
  0xfffffef988888812, 0xfffffefb99999925,
  0xfffffef988098812, 0xfffffefb991b9925,
  0xffffffab555554ac, 0xffffffabffffff59,
  0xffffff7888888714, 0xffffff7999999829,
  0xffffff7888098714, 0xffffff79991b9829,
  0xffffff78878a8812, 0xffffff79989d9925,
  0xffffffcd33333268, 0xffffffcd999998d1,
  0xffffffcd32b43268, 0xffffffcd991b98d1,
  0xffffffcd32353366, 0xffffffcd989d99cd,
  0xffffffcd31b63562, 0xffffffcd981f9bc5,
  0xffffffffff810000, 0xffffffffff820001,
  0xffffffffff0200fe, 0xffffffffff0400fd,
  0xfffffffffe8302fa, 0xfffffffffe8602f5,
  0xfffffffffe0405f4, 0xfffffffffe0805e9,
  0xffffffffff8100fe, 0xffffffffff8200fd,
  0xffffffffff0202fa, 0xffffffffff0402f5,
  0xfffffffffe8305f4, 0xfffffffffe8605e9,
  0xfffffffffe8286f4, 0xfffffffffe8587e9,
  0xffffffffff8101fc, 0xffffffffff8201f9,
  0xffffffffff0204f6, 0xffffffffff0404ed,
  0xffffffffff0185f6, 0xffffffffff0386ed,
  0xffffffffff0107f4, 0xffffffffff0309e9,
  0xffffffffff8102fa, 0xffffffffff8202f5,
  0xffffffffff8083fa, 0xffffffffff8184f5,
  0xffffffffff8005f8, 0xffffffffff8107f1,
  0xffffffffff7f88f4, 0xffffffffff808be9,
  0xffffffffffff8100, 0xffffffffffff8201,
  0xffffffffffff02fe, 0xffffffffffff04fd,
  0xfffffffffffe85fa, 0xfffffffffffe88f5,
  0xfffffffffffe09f4, 0xfffffffffffe0de9,
  0xffffffffffff81fe, 0xffffffffffff82fd,
  0xffffffffffff04fa, 0xffffffffffff06f5,
  0xfffffffffffe88f4, 0xfffffffffffe8be9,
  0xfffffffffffe6934, 0xfffffffffffe6c69,
  0xffffffffffff82fc, 0xffffffffffff83f9,
  0xffffffffffff06f6, 0xffffffffffff08ed,
  0xfffffffffffee736, 0xfffffffffffee96d,
  0xfffffffffffee43c, 0xfffffffffffee679,
  0xffffffffffff83fa, 0xffffffffffff84f5,
  0xffffffffffff643a, 0xffffffffffff6575,
  0xffffffffffff6140, 0xffffffffffff6281,
  0xffffffffffff5f44, 0xffffffffffff6089,
  0xffffffffffffe040, 0xffffffffffffe081,
  0xffffffffffffdd46, 0xffffffffffffdd8d,
  0xffffffffffffdb4a, 0xffffffffffffdb95,
  0xffffffffffffda4c, 0xffffffffffffda99,
  0xfffffffffffffd0c, 0xfffffffffffffd13,
  0xfffffffffffffb14, 0xfffffffffffffb1f,
  0xfffffffffffffa18, 0xfffffffffffffa25,
  0xfffffffffffffa18, 0xfffffffffffffa25,
  0xfffffffffffffe08, 0xfffffffffffffe0d,
  0xfffffffffffffd0c, 0xfffffffffffffd13,
  0xfffffffffffffd0c, 0xfffffffffffffd13,
  0xfffffffffffffe08, 0xfffffffffffffe0d,
  0xffffffffffffff04, 0xffffffffffffff07,
  0xffffffffffffff04, 0xffffffffffffff07,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000001f8, 0x00000000000001f5,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fc, 0x00000000000000fb,
  0x00000000000002f4, 0x00000000000002ef,
  0x0000000000002274, 0x000000000000222f,
  0x00000000000000fc, 0x00000000000000fb,
  0x00000000000002f4, 0x00000000000002ef,
  0x0000000000002274, 0x000000000000222f,
  0x0000000000009d80, 0x0000000000009c41,
  0x00000000000001f8, 0x00000000000001f5,
  0x0000000000002178, 0x0000000000002135,
  0x0000000000009c84, 0x0000000000009b47,
  0x000000000001188c, 0x0000000000011653,
  0x0000000000001f80, 0x0000000000001f41,
  0x0000000000009a8c, 0x0000000000009953,
  0x0000000000011694, 0x000000000001145f,
  0x0000000000019398, 0x0000000000019065,
  0x0000000000007b0c, 0x0000000000007a13,
  0x000000000000f714, 0x000000000000f51f,
  0x0000000000017418, 0x0000000000017125,
  0x00000000007f7124, 0x00000000007e6e37,
  0x0000000000007c08, 0x0000000000007b0d,
  0x000000000000f90c, 0x000000000000f713,
  0x00000000007ef618, 0x00000000007df425,
  0x0000000000fcf420, 0x0000000000faf231,
  0x0000000000007d04, 0x0000000000007c07,
  0x00000000007e7a10, 0x00000000007d7919,
  0x0000000000fc7818, 0x0000000000fa7725,
  0x00000000017a771c, 0x000000000177762b,
  0x00000000007dfd0c, 0x00000000007cfd13,
  0x0000000000fbfb14, 0x0000000000f9fb1f,
  0x000000000179fa18, 0x000000000176fa25,
  0x0000003267e0604c, 0x000000320176f9f3,
  0x00000000007dfe08, 0x00000000007cfe0d,
  0x0000000000fbfd0c, 0x0000000000f9fd13,
  0x0000003267626340, 0x0000003200f9fce1,
  0x00000086676262ec, 0x00000085564f51e3,
  0x00000000007dff04, 0x00000000007cff07,
  0x0000003266e46538, 0x00000032007cfed5,
  0x0000008666e464e4, 0x0000008555d253d7,
  0x0000010466e461f0, 0x0000010255d250e9,
  0x0000003266666634, 0x00000031ffffffcf,
  0x00000086666665e0, 0x00000085555554d1,
  0x00000104666662ec, 0x00000102555551e3,
  0x00000182666660f4, 0x0000017f55554fef,
  0x00000053ffffffac, 0x0000005355555503,
  0x000000d1fffffcb8, 0x000000d055555215,
  0x0000014ffffffac0, 0x0000014d55555021,
  0x000001cdfffff9c4, 0x000001ca55554f27,
  0x0000007dfffffd0c, 0x0000007cfffffd13,
  0x000000fbfffffb14, 0x000000f9fffffb1f,
  0x00000179fffffa18, 0x00000176fffffa25,
  0x000000fbfffffa18, 0x000000f9fffffa25,
  0x0000007dfffffe08, 0x0000007cfffffe0d,
  0x000000fbfffffd0c, 0x000000f9fffffd13,
  0x0000007dfffffd0c, 0x0000007cfffffd13,
  0xfffffffffffffe08, 0xfffffffffffffe0d,
  0x0000007dffffff04, 0x0000007cffffff07,
  0xffffffffffffff04, 0xffffffffffffff07,
  0xffffff8200000000, 0xffffff8300000001,
  0xffffff2dffffff58, 0xffffff2faaaaaa05,
  0xffffff8200000000, 0xffffff8300000001,
  0xffffff04000000fc, 0xffffff06000000fb,
  0xfffffeb000000054, 0xfffffeb2aaaaaaff,
  0xfffffe7d99999924, 0xfffffe80aaaaaa37,
  0xffffff82000000fc, 0xffffff83000000fb,
  0xffffff2e00000054, 0xffffff2faaaaaaff,
  0xfffffefb99999924, 0xfffffefdaaaaaa37,
  0xfffffefb991b9924, 0xfffffefdaa2daa37,
  0xffffffabffffff58, 0xffffffacaaaaaa05,
  0xffffff7999999828, 0xffffff7aaaaaa93d,
  0xffffff79991b9828, 0xffffff7aaa2da93d,
  0xffffff79989d9924, 0xffffff7aa9b0aa37,
  0xffffffcd999998d0, 0xffffffcdffffff39,
  0xffffffcd991b98d0, 0xffffffcdff82ff39,
  0xffffffcd989d99cc, 0xffffffcdff060033,
  0xffffffcd981f9bc4, 0xffffffcdfe890227,
  0xffffffffff820000, 0xffffffffff830001,
  0xffffffffff0400fc, 0xffffffffff0600fb,
  0xfffffffffe8602f4, 0xfffffffffe8902ef,
  0xfffffffffe0805e8, 0xfffffffffe0c05dd,
  0xffffffffff8200fc, 0xffffffffff8300fb,
  0xffffffffff0402f4, 0xffffffffff0602ef,
  0xfffffffffe8605e8, 0xfffffffffe8905dd,
  0xfffffffffe8587e8, 0xfffffffffe8888dd,
  0xffffffffff8201f8, 0xffffffffff8301f5,
  0xffffffffff0404ec, 0xffffffffff0604e3,
  0xffffffffff0386ec, 0xffffffffff0587e3,
  0xffffffffff0309e8, 0xffffffffff050bdd,
  0xffffffffff8202f4, 0xffffffffff8302ef,
  0xffffffffff8184f4, 0xffffffffff8285ef,
  0xffffffffff8107f0, 0xffffffffff8209e9,
  0xffffffffff808be8, 0xffffffffff818edd,
  0xffffffffffff8200, 0xffffffffffff8301,
  0xffffffffffff04fc, 0xffffffffffff06fb,
  0xfffffffffffe88f4, 0xfffffffffffe8bef,
  0xfffffffffffe0de8, 0xfffffffffffe11dd,
  0xffffffffffff82fc, 0xffffffffffff83fb,
  0xffffffffffff06f4, 0xffffffffffff08ef,
  0xfffffffffffe8be8, 0xfffffffffffe8edd,
  0xfffffffffffe6c68, 0xfffffffffffe6f9d,
  0xffffffffffff83f8, 0xffffffffffff84f5,
  0xffffffffffff08ec, 0xffffffffffff0ae3,
  0xfffffffffffee96c, 0xfffffffffffeeba3,
  0xfffffffffffee678, 0xfffffffffffee8b5,
  0xffffffffffff84f4, 0xffffffffffff85ef,
  0xffffffffffff6574, 0xffffffffffff66af,
  0xffffffffffff6280, 0xffffffffffff63c1,
  0xffffffffffff6088, 0xffffffffffff61cd,
  0xffffffffffffe080, 0xffffffffffffe0c1,
  0xffffffffffffdd8c, 0xffffffffffffddd3,
  0xffffffffffffdb94, 0xffffffffffffdbdf,
  0xffffffffffffda98, 0xffffffffffffdae5,
  0xfffffffffffffd12, 0xffffffffffffff41,
  0xfffffffffffffb1e, 0xfffffffffffffec1,
  0xfffffffffffffa24, 0xfffffffffffffe81,
  0xfffffffffffffa24, 0xfffffffffffffe81,
  0xfffffffffffffe0c, 0xffffffffffffff81,
  0xfffffffffffffd12, 0xffffffffffffff41,
  0xfffffffffffffd12, 0xffffffffffffff41,
  0xfffffffffffffe0c, 0xffffffffffffff81,
  0xffffffffffffff06, 0xffffffffffffffc1,
  0xffffffffffffff06, 0xffffffffffffffc1,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000001f4, 0x0000000000000081,
  0x0000000000000000, 0x0000000000000001,
  0x00000000000000fa, 0x0000000000000041,
  0x00000000000002ee, 0x00000000000000c1,
  0x000000000000222e, 0x00000000000008c1,
  0x00000000000000fa, 0x0000000000000041,
  0x00000000000002ee, 0x00000000000000c1,
  0x000000000000222e, 0x00000000000008c1,
  0x0000000000009c40, 0x0000000000002801,
  0x00000000000001f4, 0x0000000000000081,
  0x0000000000002134, 0x0000000000000881,
  0x0000000000009b46, 0x00000000000027c1,
  0x0000000000011652, 0x0000000000004741,
  0x0000000000001f40, 0x0000000000000801,
  0x0000000000009952, 0x0000000000002741,
  0x000000000001145e, 0x00000000000046c1,
  0x0000000000019064, 0x0000000000006681,
  0x0000000000007a12, 0x0000000000001f41,
  0x000000000000f51e, 0x0000000000003ec1,
  0x0000000000017124, 0x0000000000005e81,
  0x00000000007e6e36, 0x0000000000205dc1,
  0x0000000000007b0c, 0x0000000000001f81,
  0x000000000000f712, 0x0000000000003f41,
  0x00000000007df424, 0x0000000000203e81,
  0x0000000000faf230, 0x0000000000403e01,
  0x0000000000007c06, 0x0000000000001fc1,
  0x00000000007d7918, 0x0000000000201f01,
  0x0000000000fa7724, 0x0000000000401e81,
  0x000000000177762a, 0x0000000000601e41,
  0x00000000007cfd12, 0x00000000001fff41,
  0x0000000000f9fb1e, 0x00000000003ffec1,
  0x000000000176fa24, 0x00000000005ffe81,
  0x000000320176f9f2, 0x0000000ccd2ccb41,
  0x00000000007cfe0c, 0x00000000001fff81,
  0x0000000000f9fd12, 0x00000000003fff41,
  0x0000003200f9fce0, 0x0000000ccd0ccc01,
  0x00000085564f51e2, 0x0000002222622141,
  0x00000000007cff06, 0x00000000001fffc1,
  0x00000032007cfed4, 0x0000000ccceccc81,
  0x0000008555d253d6, 0x00000022224221c1,
  0x0000010255d250e8, 0x0000004222422101,
  0x00000031ffffffce, 0x0000000cccccccc1,
  0x00000085555554d0, 0x0000002222222201,
  0x00000102555551e2, 0x0000004222222141,
  0x0000017f55554fee, 0x00000062222220c1,
  0x0000005355555502, 0x0000001555555541,
  0x000000d055555214, 0x0000003555555481,
  0x0000014d55555020, 0x0000005555555401,
  0x000001ca55554f26, 0x00000075555553c1,
  0x0000007cfffffd12, 0x0000001fffffff41,
  0x000000f9fffffb1e, 0x0000003ffffffec1,
  0x00000176fffffa24, 0x0000005ffffffe81,
  0x000000f9fffffa24, 0x0000003ffffffe81,
  0x0000007cfffffe0c, 0x0000001fffffff81,
  0x000000f9fffffd12, 0x0000003fffffff41,
  0x0000007cfffffd12, 0x0000001fffffff41,
  0xfffffffffffffe0c, 0xffffffffffffff81,
  0x0000007cffffff06, 0x0000001fffffffc1,
  0xffffffffffffff06, 0xffffffffffffffc1,
  0xffffff8300000000, 0xffffffe000000001,
  0xffffff2faaaaaa04, 0xffffffcaaaaaaa81,
  0xffffff8300000000, 0xffffffe000000001,
  0xffffff06000000fa, 0xffffffc000000041,
  0xfffffeb2aaaaaafe, 0xffffffaaaaaaaac1,
  0xfffffe80aaaaaa36, 0xffffff9dddddddc1,
  0xffffff83000000fa, 0xffffffe000000041,
  0xffffff2faaaaaafe, 0xffffffcaaaaaaac1,
  0xfffffefdaaaaaa36, 0xffffffbdddddddc1,
  0xfffffefdaa2daa36, 0xffffffbdddbdddc1,
  0xffffffacaaaaaa04, 0xffffffeaaaaaaa81,
  0xffffff7aaaaaa93c, 0xffffffdddddddd81,
  0xffffff7aaa2da93c, 0xffffffddddbddd81,
  0xffffff7aa9b0aa36, 0xffffffdddd9dddc1,
  0xffffffcdffffff38, 0xfffffff333333301,
  0xffffffcdff82ff38, 0xfffffff333133301,
  0xffffffcdff060032, 0xfffffff332f33341,
  0xffffffcdfe890226, 0xfffffff332d333c1,
  0xffffffffff830000, 0xffffffffffe00001,
  0xffffffffff0600fa, 0xffffffffffc00041,
  0xfffffffffe8902ee, 0xffffffffffa000c1,
  0xfffffffffe0c05dc, 0xffffffffff800181,
  0xffffffffff8300fa, 0xffffffffffe00041,
  0xffffffffff0602ee, 0xffffffffffc000c1,
  0xfffffffffe8905dc, 0xffffffffffa00181,
  0xfffffffffe8888dc, 0xffffffffff9fe181,
  0xffffffffff8301f4, 0xffffffffffe00081,
  0xffffffffff0604e2, 0xffffffffffc00141,
  0xffffffffff0587e2, 0xffffffffffbfe141,
  0xffffffffff050bdc, 0xffffffffffbfc181,
  0xffffffffff8302ee, 0xffffffffffe000c1,
  0xffffffffff8285ee, 0xffffffffffdfe0c1,
  0xffffffffff8209e8, 0xffffffffffdfc101,
  0xffffffffff818edc, 0xffffffffffdfa181,
  0xffffffffffff8300, 0xffffffffffffe001,
  0xffffffffffff06fa, 0xffffffffffffc041,
  0xfffffffffffe8bee, 0xffffffffffffa0c1,
  0xfffffffffffe11dc, 0xffffffffffff8181,
  0xffffffffffff83fa, 0xffffffffffffe041,
  0xffffffffffff08ee, 0xffffffffffffc0c1,
  0xfffffffffffe8edc, 0xffffffffffffa181,
  0xfffffffffffe6f9c, 0xffffffffffff9981,
  0xffffffffffff84f4, 0xffffffffffffe081,
  0xffffffffffff0ae2, 0xffffffffffffc141,
  0xfffffffffffeeba2, 0xffffffffffffb941,
  0xfffffffffffee8b4, 0xffffffffffffb881,
  0xffffffffffff85ee, 0xffffffffffffe0c1,
  0xffffffffffff66ae, 0xffffffffffffd8c1,
  0xffffffffffff63c0, 0xffffffffffffd801,
  0xffffffffffff61cc, 0xffffffffffffd781,
  0xffffffffffffe0c0, 0xfffffffffffff801,
  0xffffffffffffddd2, 0xfffffffffffff741,
  0xffffffffffffdbde, 0xfffffffffffff6c1,
  0xffffffffffffdae4, 0xfffffffffffff681,
  0xffffffffffffff40, 0xffffffffffffffef,
  0xfffffffffffffec0, 0xffffffffffffffe3,
  0xfffffffffffffe80, 0xffffffffffffffdd,
  0xfffffffffffffe80, 0xffffffffffffffdd,
  0xffffffffffffff80, 0xfffffffffffffff5,
  0xffffffffffffff40, 0xffffffffffffffef,
  0xffffffffffffff40, 0xffffffffffffffef,
  0xffffffffffffff80, 0xfffffffffffffff5,
  0xffffffffffffffc0, 0xfffffffffffffffb,
  0xffffffffffffffc0, 0xfffffffffffffffb,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000080, 0x000000000000000d,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000040, 0x0000000000000007,
  0x00000000000000c0, 0x0000000000000013,
  0x00000000000008c0, 0x00000000000000d3,
  0x0000000000000040, 0x0000000000000007,
  0x00000000000000c0, 0x0000000000000013,
  0x00000000000008c0, 0x00000000000000d3,
  0x0000000000002800, 0x00000000000003c1,
  0x0000000000000080, 0x000000000000000d,
  0x0000000000000880, 0x00000000000000cd,
  0x00000000000027c0, 0x00000000000003bb,
  0x0000000000004740, 0x00000000000006af,
  0x0000000000000800, 0x00000000000000c1,
  0x0000000000002740, 0x00000000000003af,
  0x00000000000046c0, 0x00000000000006a3,
  0x0000000000006680, 0x000000000000099d,
  0x0000000000001f40, 0x00000000000002ef,
  0x0000000000003ec0, 0x00000000000005e3,
  0x0000000000005e80, 0x00000000000008dd,
  0x0000000000205dc0, 0x00000000000308cb,
  0x0000000000001f80, 0x00000000000002f5,
  0x0000000000003f40, 0x00000000000005ef,
  0x0000000000203e80, 0x00000000000305dd,
  0x0000000000403e00, 0x00000000000605d1,
  0x0000000000001fc0, 0x00000000000002fb,
  0x0000000000201f00, 0x00000000000302e9,
  0x0000000000401e80, 0x00000000000602dd,
  0x0000000000601e40, 0x00000000000902d7,
  0x00000000001fff40, 0x000000000002ffef,
  0x00000000003ffec0, 0x000000000005ffe3,
  0x00000000005ffe80, 0x000000000008ffdd,
  0x0000000ccd2ccb40, 0x00000001333c330f,
  0x00000000001fff80, 0x000000000002fff5,
  0x00000000003fff40, 0x000000000005ffef,
  0x0000000ccd0ccc00, 0x0000000133393321,
  0x0000002222622140, 0x000000033339331f,
  0x00000000001fffc0, 0x000000000002fffb,
  0x0000000ccceccc80, 0x000000013336332d,
  0x00000022224221c0, 0x000000033336332b,
  0x0000004222422100, 0x0000000633363319,
  0x0000000cccccccc0, 0x0000000133333333,
  0x0000002222222200, 0x0000000333333331,
  0x0000004222222140, 0x000000063333331f,
  0x00000062222220c0, 0x0000000933333313,
  0x0000001555555540, 0x00000001ffffffff,
  0x0000003555555480, 0x00000004ffffffed,
  0x0000005555555400, 0x00000007ffffffe1,
  0x00000075555553c0, 0x0000000affffffdb,
  0x0000001fffffff40, 0x00000002ffffffef,
  0x0000003ffffffec0, 0x00000005ffffffe3,
  0x0000005ffffffe80, 0x00000008ffffffdd,
  0x0000003ffffffe80, 0x00000005ffffffdd,
  0x0000001fffffff80, 0x00000002fffffff5,
  0x0000003fffffff40, 0x00000005ffffffef,
  0x0000001fffffff40, 0x00000002ffffffef,
  0xffffffffffffff80, 0xfffffffffffffff5,
  0x0000001fffffffc0, 0x00000002fffffffb,
  0xffffffffffffffc0, 0xfffffffffffffffb,
  0xffffffe000000000, 0xfffffffd00000001,
  0xffffffcaaaaaaa80, 0xfffffffafffffffd,
  0xffffffe000000000, 0xfffffffd00000001,
  0xffffffc000000040, 0xfffffffa00000007,
  0xffffffaaaaaaaac0, 0xfffffff800000003,
  0xffffff9dddddddc0, 0xfffffff6cccccccb,
  0xffffffe000000040, 0xfffffffd00000007,
  0xffffffcaaaaaaac0, 0xfffffffb00000003,
  0xffffffbdddddddc0, 0xfffffff9cccccccb,
  0xffffffbdddbdddc0, 0xfffffff9ccc9cccb,
  0xffffffeaaaaaaa80, 0xfffffffdfffffffd,
  0xffffffdddddddd80, 0xfffffffcccccccc5,
  0xffffffddddbddd80, 0xfffffffcccc9ccc5,
  0xffffffdddd9dddc0, 0xfffffffcccc6cccb,
  0xfffffff333333300, 0xfffffffeccccccc9,
  0xfffffff333133300, 0xfffffffeccc9ccc9,
  0xfffffff332f33340, 0xfffffffeccc6cccf,
  0xfffffff332d333c0, 0xfffffffeccc3ccdb,
  0xffffffffffe00000, 0xfffffffffffd0001,
  0xffffffffffc00040, 0xfffffffffffa0007,
  0xffffffffffa000c0, 0xfffffffffff70013,
  0xffffffffff800180, 0xfffffffffff40025,
  0xffffffffffe00040, 0xfffffffffffd0007,
  0xffffffffffc000c0, 0xfffffffffffa0013,
  0xffffffffffa00180, 0xfffffffffff70025,
  0xffffffffff9fe180, 0xfffffffffff6fd25,
  0xffffffffffe00080, 0xfffffffffffd000d,
  0xffffffffffc00140, 0xfffffffffffa001f,
  0xffffffffffbfe140, 0xfffffffffff9fd1f,
  0xffffffffffbfc180, 0xfffffffffff9fa25,
  0xffffffffffe000c0, 0xfffffffffffd0013,
  0xffffffffffdfe0c0, 0xfffffffffffcfd13,
  0xffffffffffdfc100, 0xfffffffffffcfa19,
  0xffffffffffdfa180, 0xfffffffffffcf725,
  0xffffffffffffe000, 0xfffffffffffffd01,
  0xffffffffffffc040, 0xfffffffffffffa07,
  0xffffffffffffa0c0, 0xfffffffffffff713,
  0xffffffffffff8180, 0xfffffffffffff425,
  0xffffffffffffe040, 0xfffffffffffffd07,
  0xffffffffffffc0c0, 0xfffffffffffffa13,
  0xffffffffffffa180, 0xfffffffffffff725,
  0xffffffffffff9980, 0xfffffffffffff665,
  0xffffffffffffe080, 0xfffffffffffffd0d,
  0xffffffffffffc140, 0xfffffffffffffa1f,
  0xffffffffffffb940, 0xfffffffffffff95f,
  0xffffffffffffb880, 0xfffffffffffff94d,
  0xffffffffffffe0c0, 0xfffffffffffffd13,
  0xffffffffffffd8c0, 0xfffffffffffffc53,
  0xffffffffffffd800, 0xfffffffffffffc41,
  0xffffffffffffd780, 0xfffffffffffffc35,
  0xfffffffffffff800, 0xffffffffffffff41,
  0xfffffffffffff740, 0xffffffffffffff2f,
  0xfffffffffffff6c0, 0xffffffffffffff23,
  0xfffffffffffff680, 0xffffffffffffff1d,
  0xffffffffffffffee, 0xfffffffffffffff5,
  0xffffffffffffffe2, 0xffffffffffffffed,
  0xffffffffffffffdc, 0xffffffffffffffe9,
  0xffffffffffffffdc, 0xffffffffffffffe9,
  0xfffffffffffffff4, 0xfffffffffffffff9,
  0xffffffffffffffee, 0xfffffffffffffff5,
  0xffffffffffffffee, 0xfffffffffffffff5,
  0xfffffffffffffff4, 0xfffffffffffffff9,
  0xfffffffffffffffa, 0xfffffffffffffffd,
  0xfffffffffffffffa, 0xfffffffffffffffd,
  0x0000000000000000, 0x0000000000000001,
  0x000000000000000c, 0x0000000000000009,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000006, 0x0000000000000005,
  0x0000000000000012, 0x000000000000000d,
  0x00000000000000d2, 0x000000000000008d,
  0x0000000000000006, 0x0000000000000005,
  0x0000000000000012, 0x000000000000000d,
  0x00000000000000d2, 0x000000000000008d,
  0x00000000000003c0, 0x0000000000000281,
  0x000000000000000c, 0x0000000000000009,
  0x00000000000000cc, 0x0000000000000089,
  0x00000000000003ba, 0x000000000000027d,
  0x00000000000006ae, 0x0000000000000475,
  0x00000000000000c0, 0x0000000000000081,
  0x00000000000003ae, 0x0000000000000275,
  0x00000000000006a2, 0x000000000000046d,
  0x000000000000099c, 0x0000000000000669,
  0x00000000000002ee, 0x00000000000001f5,
  0x00000000000005e2, 0x00000000000003ed,
  0x00000000000008dc, 0x00000000000005e9,
  0x00000000000308ca, 0x00000000000205dd,
  0x00000000000002f4, 0x00000000000001f9,
  0x00000000000005ee, 0x00000000000003f5,
  0x00000000000305dc, 0x00000000000203e9,
  0x00000000000605d0, 0x00000000000403e1,
  0x00000000000002fa, 0x00000000000001fd,
  0x00000000000302e8, 0x00000000000201f1,
  0x00000000000602dc, 0x00000000000401e9,
  0x00000000000902d6, 0x00000000000601e5,
  0x000000000002ffee, 0x000000000001fff5,
  0x000000000005ffe2, 0x000000000003ffed,
  0x000000000008ffdc, 0x000000000005ffe9,
  0x00000001333c330e, 0x00000000ccd2ccb5,
  0x000000000002fff4, 0x000000000001fff9,
  0x000000000005ffee, 0x000000000003fff5,
  0x0000000133393320, 0x00000000ccd0ccc1,
  0x000000033339331e, 0x0000000222262215,
  0x000000000002fffa, 0x000000000001fffd,
  0x000000013336332c, 0x00000000ccceccc9,
  0x000000033336332a, 0x000000022224221d,
  0x0000000633363318, 0x0000000422242211,
  0x0000000133333332, 0x00000000cccccccd,
  0x0000000333333330, 0x0000000222222221,
  0x000000063333331e, 0x0000000422222215,
  0x0000000933333312, 0x000000062222220d,
  0x00000001fffffffe, 0x0000000155555555,
  0x00000004ffffffec, 0x0000000355555549,
  0x00000007ffffffe0, 0x0000000555555541,
  0x0000000affffffda, 0x000000075555553d,
  0x00000002ffffffee, 0x00000001fffffff5,
  0x00000005ffffffe2, 0x00000003ffffffed,
  0x00000008ffffffdc, 0x00000005ffffffe9,
  0x00000005ffffffdc, 0x00000003ffffffe9,
  0x00000002fffffff4, 0x00000001fffffff9,
  0x00000005ffffffee, 0x00000003fffffff5,
  0x00000002ffffffee, 0x00000001fffffff5,
  0xfffffffffffffff4, 0xfffffffffffffff9,
  0x00000002fffffffa, 0x00000001fffffffd,
  0xfffffffffffffffa, 0xfffffffffffffffd,
  0xfffffffd00000000, 0xfffffffe00000001,
  0xfffffffafffffffc, 0xfffffffcaaaaaaa9,
  0xfffffffd00000000, 0xfffffffe00000001,
  0xfffffffa00000006, 0xfffffffc00000005,
  0xfffffff800000002, 0xfffffffaaaaaaaad,
  0xfffffff6ccccccca, 0xfffffff9dddddddd,
  0xfffffffd00000006, 0xfffffffe00000005,
  0xfffffffb00000002, 0xfffffffcaaaaaaad,
  0xfffffff9ccccccca, 0xfffffffbdddddddd,
  0xfffffff9ccc9ccca, 0xfffffffbdddbdddd,
  0xfffffffdfffffffc, 0xfffffffeaaaaaaa9,
  0xfffffffcccccccc4, 0xfffffffdddddddd9,
  0xfffffffcccc9ccc4, 0xfffffffddddbddd9,
  0xfffffffcccc6ccca, 0xfffffffdddd9dddd,
  0xfffffffeccccccc8, 0xffffffff33333331,
  0xfffffffeccc9ccc8, 0xffffffff33313331,
  0xfffffffeccc6ccce, 0xffffffff332f3335,
  0xfffffffeccc3ccda, 0xffffffff332d333d,
  0xfffffffffffd0000, 0xfffffffffffe0001,
  0xfffffffffffa0006, 0xfffffffffffc0005,
  0xfffffffffff70012, 0xfffffffffffa000d,
  0xfffffffffff40024, 0xfffffffffff80019,
  0xfffffffffffd0006, 0xfffffffffffe0005,
  0xfffffffffffa0012, 0xfffffffffffc000d,
  0xfffffffffff70024, 0xfffffffffffa0019,
  0xfffffffffff6fd24, 0xfffffffffff9fe19,
  0xfffffffffffd000c, 0xfffffffffffe0009,
  0xfffffffffffa001e, 0xfffffffffffc0015,
  0xfffffffffff9fd1e, 0xfffffffffffbfe15,
  0xfffffffffff9fa24, 0xfffffffffffbfc19,
  0xfffffffffffd0012, 0xfffffffffffe000d,
  0xfffffffffffcfd12, 0xfffffffffffdfe0d,
  0xfffffffffffcfa18, 0xfffffffffffdfc11,
  0xfffffffffffcf724, 0xfffffffffffdfa19,
  0xfffffffffffffd00, 0xfffffffffffffe01,
  0xfffffffffffffa06, 0xfffffffffffffc05,
  0xfffffffffffff712, 0xfffffffffffffa0d,
  0xfffffffffffff424, 0xfffffffffffff819,
  0xfffffffffffffd06, 0xfffffffffffffe05,
  0xfffffffffffffa12, 0xfffffffffffffc0d,
  0xfffffffffffff724, 0xfffffffffffffa19,
  0xfffffffffffff664, 0xfffffffffffff999,
  0xfffffffffffffd0c, 0xfffffffffffffe09,
  0xfffffffffffffa1e, 0xfffffffffffffc15,
  0xfffffffffffff95e, 0xfffffffffffffb95,
  0xfffffffffffff94c, 0xfffffffffffffb89,
  0xfffffffffffffd12, 0xfffffffffffffe0d,
  0xfffffffffffffc52, 0xfffffffffffffd8d,
  0xfffffffffffffc40, 0xfffffffffffffd81,
  0xfffffffffffffc34, 0xfffffffffffffd79,
  0xffffffffffffff40, 0xffffffffffffff81,
  0xffffffffffffff2e, 0xffffffffffffff75,
  0xffffffffffffff22, 0xffffffffffffff6d,
  0xffffffffffffff1c, 0xffffffffffffff69,
  0xfffffffffffffff4, 0xfffffffffffffffb,
  0xffffffffffffffec, 0xfffffffffffffff7,
  0xffffffffffffffe8, 0xfffffffffffffff5,
  0xffffffffffffffe8, 0xfffffffffffffff5,
  0xfffffffffffffff8, 0xfffffffffffffffd,
  0xfffffffffffffff4, 0xfffffffffffffffb,
  0xfffffffffffffff4, 0xfffffffffffffffb,
  0xfffffffffffffff8, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xffffffffffffffff,
  0xfffffffffffffffc, 0xffffffffffffffff,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000008, 0x0000000000000005,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000004, 0x0000000000000003,
  0x000000000000000c, 0x0000000000000007,
  0x000000000000008c, 0x0000000000000047,
  0x0000000000000004, 0x0000000000000003,
  0x000000000000000c, 0x0000000000000007,
  0x000000000000008c, 0x0000000000000047,
  0x0000000000000280, 0x0000000000000141,
  0x0000000000000008, 0x0000000000000005,
  0x0000000000000088, 0x0000000000000045,
  0x000000000000027c, 0x000000000000013f,
  0x0000000000000474, 0x000000000000023b,
  0x0000000000000080, 0x0000000000000041,
  0x0000000000000274, 0x000000000000013b,
  0x000000000000046c, 0x0000000000000237,
  0x0000000000000668, 0x0000000000000335,
  0x00000000000001f4, 0x00000000000000fb,
  0x00000000000003ec, 0x00000000000001f7,
  0x00000000000005e8, 0x00000000000002f5,
  0x00000000000205dc, 0x00000000000102ef,
  0x00000000000001f8, 0x00000000000000fd,
  0x00000000000003f4, 0x00000000000001fb,
  0x00000000000203e8, 0x00000000000101f5,
  0x00000000000403e0, 0x00000000000201f1,
  0x00000000000001fc, 0x00000000000000ff,
  0x00000000000201f0, 0x00000000000100f9,
  0x00000000000401e8, 0x00000000000200f5,
  0x00000000000601e4, 0x00000000000300f3,
  0x000000000001fff4, 0x000000000000fffb,
  0x000000000003ffec, 0x000000000001fff7,
  0x000000000005ffe8, 0x000000000002fff5,
  0x00000000ccd2ccb4, 0x000000006669665b,
  0x000000000001fff8, 0x000000000000fffd,
  0x000000000003fff4, 0x000000000001fffb,
  0x00000000ccd0ccc0, 0x0000000066686661,
  0x0000000222262214, 0x000000011113110b,
  0x000000000001fffc, 0x000000000000ffff,
  0x00000000ccceccc8, 0x0000000066676665,
  0x000000022224221c, 0x000000011112110f,
  0x0000000422242210, 0x0000000211121109,
  0x00000000cccccccc, 0x0000000066666667,
  0x0000000222222220, 0x0000000111111111,
  0x0000000422222214, 0x000000021111110b,
  0x000000062222220c, 0x0000000311111107,
  0x0000000155555554, 0x00000000aaaaaaab,
  0x0000000355555548, 0x00000001aaaaaaa5,
  0x0000000555555540, 0x00000002aaaaaaa1,
  0x000000075555553c, 0x00000003aaaaaa9f,
  0x00000001fffffff4, 0x00000000fffffffb,
  0x00000003ffffffec, 0x00000001fffffff7,
  0x00000005ffffffe8, 0x00000002fffffff5,
  0x00000003ffffffe8, 0x00000001fffffff5,
  0x00000001fffffff8, 0x00000000fffffffd,
  0x00000003fffffff4, 0x00000001fffffffb,
  0x00000001fffffff4, 0x00000000fffffffb,
  0xfffffffffffffff8, 0xfffffffffffffffd,
  0x00000001fffffffc, 0x00000000ffffffff,
  0xfffffffffffffffc, 0xffffffffffffffff,
  0xfffffffe00000000, 0xffffffff00000001,
  0xfffffffcaaaaaaa8, 0xfffffffe55555555,
  0xfffffffe00000000, 0xffffffff00000001,
  0xfffffffc00000004, 0xfffffffe00000003,
  0xfffffffaaaaaaaac, 0xfffffffd55555557,
  0xfffffff9dddddddc, 0xfffffffceeeeeeef,
  0xfffffffe00000004, 0xffffffff00000003,
  0xfffffffcaaaaaaac, 0xfffffffe55555557,
  0xfffffffbdddddddc, 0xfffffffdeeeeeeef,
  0xfffffffbdddbdddc, 0xfffffffdeeedeeef,
  0xfffffffeaaaaaaa8, 0xffffffff55555555,
  0xfffffffdddddddd8, 0xfffffffeeeeeeeed,
  0xfffffffddddbddd8, 0xfffffffeeeedeeed,
  0xfffffffdddd9dddc, 0xfffffffeeeeceeef,
  0xffffffff33333330, 0xffffffff99999999,
  0xffffffff33313330, 0xffffffff99989999,
  0xffffffff332f3334, 0xffffffff9997999b,
  0xffffffff332d333c, 0xffffffff9996999f,
  0xfffffffffffe0000, 0xffffffffffff0001,
  0xfffffffffffc0004, 0xfffffffffffe0003,
  0xfffffffffffa000c, 0xfffffffffffd0007,
  0xfffffffffff80018, 0xfffffffffffc000d,
  0xfffffffffffe0004, 0xffffffffffff0003,
  0xfffffffffffc000c, 0xfffffffffffe0007,
  0xfffffffffffa0018, 0xfffffffffffd000d,
  0xfffffffffff9fe18, 0xfffffffffffcff0d,
  0xfffffffffffe0008, 0xffffffffffff0005,
  0xfffffffffffc0014, 0xfffffffffffe000b,
  0xfffffffffffbfe14, 0xfffffffffffdff0b,
  0xfffffffffffbfc18, 0xfffffffffffdfe0d,
  0xfffffffffffe000c, 0xffffffffffff0007,
  0xfffffffffffdfe0c, 0xfffffffffffeff07,
  0xfffffffffffdfc10, 0xfffffffffffefe09,
  0xfffffffffffdfa18, 0xfffffffffffefd0d,
  0xfffffffffffffe00, 0xffffffffffffff01,
  0xfffffffffffffc04, 0xfffffffffffffe03,
  0xfffffffffffffa0c, 0xfffffffffffffd07,
  0xfffffffffffff818, 0xfffffffffffffc0d,
  0xfffffffffffffe04, 0xffffffffffffff03,
  0xfffffffffffffc0c, 0xfffffffffffffe07,
  0xfffffffffffffa18, 0xfffffffffffffd0d,
  0xfffffffffffff998, 0xfffffffffffffccd,
  0xfffffffffffffe08, 0xffffffffffffff05,
  0xfffffffffffffc14, 0xfffffffffffffe0b,
  0xfffffffffffffb94, 0xfffffffffffffdcb,
  0xfffffffffffffb88, 0xfffffffffffffdc5,
  0xfffffffffffffe0c, 0xffffffffffffff07,
  0xfffffffffffffd8c, 0xfffffffffffffec7,
  0xfffffffffffffd80, 0xfffffffffffffec1,
  0xfffffffffffffd78, 0xfffffffffffffebd,
  0xffffffffffffff80, 0xffffffffffffffc1,
  0xffffffffffffff74, 0xffffffffffffffbb,
  0xffffffffffffff6c, 0xffffffffffffffb7,
  0xffffffffffffff68, 0xffffffffffffffb5,
};
const unsigned kExpectedCount_NEON_sqdmlsl2_2D_4S_S = 3844;

#endif  // VIXL_SIM_SQDMLSL2_2D_4S_S_TRACE_AARCH64_H_
