# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class ServerConfig(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'instance': 'ServerConfigInstance',
        'search': 'ServerConfigSearch',
        'plugin': 'ServerConfigPlugin',
        'theme': 'ServerConfigPlugin',
        'email': 'ServerConfigEmail',
        'contact_form': 'ServerConfigEmail',
        'server_version': 'str',
        'server_commit': 'str',
        'signup': 'ServerConfigSignup',
        'transcoding': 'ServerConfigTranscoding',
        '_import': 'ServerConfigImport',
        'auto_blacklist': 'ServerConfigAutoBlacklist',
        'avatar': 'ServerConfigAvatar',
        'video': 'ServerConfigVideo',
        'video_caption': 'ServerConfigVideoCaption',
        'user': 'ServerConfigUser',
        'trending': 'ServerConfigTrending',
        'tracker': 'ServerConfigEmail',
        'followings': 'ServerConfigFollowings'
    }

    attribute_map = {
        'instance': 'instance',
        'search': 'search',
        'plugin': 'plugin',
        'theme': 'theme',
        'email': 'email',
        'contact_form': 'contactForm',
        'server_version': 'serverVersion',
        'server_commit': 'serverCommit',
        'signup': 'signup',
        'transcoding': 'transcoding',
        '_import': 'import',
        'auto_blacklist': 'autoBlacklist',
        'avatar': 'avatar',
        'video': 'video',
        'video_caption': 'videoCaption',
        'user': 'user',
        'trending': 'trending',
        'tracker': 'tracker',
        'followings': 'followings'
    }

    def __init__(self, instance=None, search=None, plugin=None, theme=None, email=None, contact_form=None, server_version=None, server_commit=None, signup=None, transcoding=None, _import=None, auto_blacklist=None, avatar=None, video=None, video_caption=None, user=None, trending=None, tracker=None, followings=None, local_vars_configuration=None):  # noqa: E501
        """ServerConfig - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._instance = None
        self._search = None
        self._plugin = None
        self._theme = None
        self._email = None
        self._contact_form = None
        self._server_version = None
        self._server_commit = None
        self._signup = None
        self._transcoding = None
        self.__import = None
        self._auto_blacklist = None
        self._avatar = None
        self._video = None
        self._video_caption = None
        self._user = None
        self._trending = None
        self._tracker = None
        self._followings = None
        self.discriminator = None

        if instance is not None:
            self.instance = instance
        if search is not None:
            self.search = search
        if plugin is not None:
            self.plugin = plugin
        if theme is not None:
            self.theme = theme
        if email is not None:
            self.email = email
        if contact_form is not None:
            self.contact_form = contact_form
        if server_version is not None:
            self.server_version = server_version
        if server_commit is not None:
            self.server_commit = server_commit
        if signup is not None:
            self.signup = signup
        if transcoding is not None:
            self.transcoding = transcoding
        if _import is not None:
            self._import = _import
        if auto_blacklist is not None:
            self.auto_blacklist = auto_blacklist
        if avatar is not None:
            self.avatar = avatar
        if video is not None:
            self.video = video
        if video_caption is not None:
            self.video_caption = video_caption
        if user is not None:
            self.user = user
        if trending is not None:
            self.trending = trending
        if tracker is not None:
            self.tracker = tracker
        if followings is not None:
            self.followings = followings

    @property
    def instance(self):
        """Gets the instance of this ServerConfig.  # noqa: E501


        :return: The instance of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigInstance
        """
        return self._instance

    @instance.setter
    def instance(self, instance):
        """Sets the instance of this ServerConfig.


        :param instance: The instance of this ServerConfig.  # noqa: E501
        :type instance: ServerConfigInstance
        """

        self._instance = instance

    @property
    def search(self):
        """Gets the search of this ServerConfig.  # noqa: E501


        :return: The search of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigSearch
        """
        return self._search

    @search.setter
    def search(self, search):
        """Sets the search of this ServerConfig.


        :param search: The search of this ServerConfig.  # noqa: E501
        :type search: ServerConfigSearch
        """

        self._search = search

    @property
    def plugin(self):
        """Gets the plugin of this ServerConfig.  # noqa: E501


        :return: The plugin of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigPlugin
        """
        return self._plugin

    @plugin.setter
    def plugin(self, plugin):
        """Sets the plugin of this ServerConfig.


        :param plugin: The plugin of this ServerConfig.  # noqa: E501
        :type plugin: ServerConfigPlugin
        """

        self._plugin = plugin

    @property
    def theme(self):
        """Gets the theme of this ServerConfig.  # noqa: E501


        :return: The theme of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigPlugin
        """
        return self._theme

    @theme.setter
    def theme(self, theme):
        """Sets the theme of this ServerConfig.


        :param theme: The theme of this ServerConfig.  # noqa: E501
        :type theme: ServerConfigPlugin
        """

        self._theme = theme

    @property
    def email(self):
        """Gets the email of this ServerConfig.  # noqa: E501


        :return: The email of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigEmail
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this ServerConfig.


        :param email: The email of this ServerConfig.  # noqa: E501
        :type email: ServerConfigEmail
        """

        self._email = email

    @property
    def contact_form(self):
        """Gets the contact_form of this ServerConfig.  # noqa: E501


        :return: The contact_form of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigEmail
        """
        return self._contact_form

    @contact_form.setter
    def contact_form(self, contact_form):
        """Sets the contact_form of this ServerConfig.


        :param contact_form: The contact_form of this ServerConfig.  # noqa: E501
        :type contact_form: ServerConfigEmail
        """

        self._contact_form = contact_form

    @property
    def server_version(self):
        """Gets the server_version of this ServerConfig.  # noqa: E501


        :return: The server_version of this ServerConfig.  # noqa: E501
        :rtype: str
        """
        return self._server_version

    @server_version.setter
    def server_version(self, server_version):
        """Sets the server_version of this ServerConfig.


        :param server_version: The server_version of this ServerConfig.  # noqa: E501
        :type server_version: str
        """

        self._server_version = server_version

    @property
    def server_commit(self):
        """Gets the server_commit of this ServerConfig.  # noqa: E501


        :return: The server_commit of this ServerConfig.  # noqa: E501
        :rtype: str
        """
        return self._server_commit

    @server_commit.setter
    def server_commit(self, server_commit):
        """Sets the server_commit of this ServerConfig.


        :param server_commit: The server_commit of this ServerConfig.  # noqa: E501
        :type server_commit: str
        """

        self._server_commit = server_commit

    @property
    def signup(self):
        """Gets the signup of this ServerConfig.  # noqa: E501


        :return: The signup of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigSignup
        """
        return self._signup

    @signup.setter
    def signup(self, signup):
        """Sets the signup of this ServerConfig.


        :param signup: The signup of this ServerConfig.  # noqa: E501
        :type signup: ServerConfigSignup
        """

        self._signup = signup

    @property
    def transcoding(self):
        """Gets the transcoding of this ServerConfig.  # noqa: E501


        :return: The transcoding of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigTranscoding
        """
        return self._transcoding

    @transcoding.setter
    def transcoding(self, transcoding):
        """Sets the transcoding of this ServerConfig.


        :param transcoding: The transcoding of this ServerConfig.  # noqa: E501
        :type transcoding: ServerConfigTranscoding
        """

        self._transcoding = transcoding

    @property
    def _import(self):
        """Gets the _import of this ServerConfig.  # noqa: E501


        :return: The _import of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigImport
        """
        return self.__import

    @_import.setter
    def _import(self, _import):
        """Sets the _import of this ServerConfig.


        :param _import: The _import of this ServerConfig.  # noqa: E501
        :type _import: ServerConfigImport
        """

        self.__import = _import

    @property
    def auto_blacklist(self):
        """Gets the auto_blacklist of this ServerConfig.  # noqa: E501


        :return: The auto_blacklist of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigAutoBlacklist
        """
        return self._auto_blacklist

    @auto_blacklist.setter
    def auto_blacklist(self, auto_blacklist):
        """Sets the auto_blacklist of this ServerConfig.


        :param auto_blacklist: The auto_blacklist of this ServerConfig.  # noqa: E501
        :type auto_blacklist: ServerConfigAutoBlacklist
        """

        self._auto_blacklist = auto_blacklist

    @property
    def avatar(self):
        """Gets the avatar of this ServerConfig.  # noqa: E501


        :return: The avatar of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigAvatar
        """
        return self._avatar

    @avatar.setter
    def avatar(self, avatar):
        """Sets the avatar of this ServerConfig.


        :param avatar: The avatar of this ServerConfig.  # noqa: E501
        :type avatar: ServerConfigAvatar
        """

        self._avatar = avatar

    @property
    def video(self):
        """Gets the video of this ServerConfig.  # noqa: E501


        :return: The video of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigVideo
        """
        return self._video

    @video.setter
    def video(self, video):
        """Sets the video of this ServerConfig.


        :param video: The video of this ServerConfig.  # noqa: E501
        :type video: ServerConfigVideo
        """

        self._video = video

    @property
    def video_caption(self):
        """Gets the video_caption of this ServerConfig.  # noqa: E501


        :return: The video_caption of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigVideoCaption
        """
        return self._video_caption

    @video_caption.setter
    def video_caption(self, video_caption):
        """Sets the video_caption of this ServerConfig.


        :param video_caption: The video_caption of this ServerConfig.  # noqa: E501
        :type video_caption: ServerConfigVideoCaption
        """

        self._video_caption = video_caption

    @property
    def user(self):
        """Gets the user of this ServerConfig.  # noqa: E501


        :return: The user of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this ServerConfig.


        :param user: The user of this ServerConfig.  # noqa: E501
        :type user: ServerConfigUser
        """

        self._user = user

    @property
    def trending(self):
        """Gets the trending of this ServerConfig.  # noqa: E501


        :return: The trending of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigTrending
        """
        return self._trending

    @trending.setter
    def trending(self, trending):
        """Sets the trending of this ServerConfig.


        :param trending: The trending of this ServerConfig.  # noqa: E501
        :type trending: ServerConfigTrending
        """

        self._trending = trending

    @property
    def tracker(self):
        """Gets the tracker of this ServerConfig.  # noqa: E501


        :return: The tracker of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigEmail
        """
        return self._tracker

    @tracker.setter
    def tracker(self, tracker):
        """Sets the tracker of this ServerConfig.


        :param tracker: The tracker of this ServerConfig.  # noqa: E501
        :type tracker: ServerConfigEmail
        """

        self._tracker = tracker

    @property
    def followings(self):
        """Gets the followings of this ServerConfig.  # noqa: E501


        :return: The followings of this ServerConfig.  # noqa: E501
        :rtype: ServerConfigFollowings
        """
        return self._followings

    @followings.setter
    def followings(self, followings):
        """Sets the followings of this ServerConfig.


        :param followings: The followings of this ServerConfig.  # noqa: E501
        :type followings: ServerConfigFollowings
        """

        self._followings = followings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServerConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ServerConfig):
            return True

        return self.to_dict() != other.to_dict()
