/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import processing.app.Editor;
import processing.app.EditorTab;
import processing.app.syntax.SketchTextArea;

public class DiscourseFormat {
    private final Editor editor;
    private final SketchTextArea textarea;
    private final boolean html;

    public DiscourseFormat(Editor editor, EditorTab tab, boolean html) {
        this.editor = editor;
        this.textarea = tab.getTextArea();
        this.html = html;
    }

    public void show() {
        int stopLine;
        int startLine;
        StringBuilder cf = new StringBuilder(this.html ? "<pre>\n" : "[code]\n");
        int selStart = this.textarea.getSelectionStart();
        int selStop = this.textarea.getSelectionEnd();
        try {
            startLine = this.textarea.getLineOfOffset(selStart);
            stopLine = this.textarea.getLineOfOffset(selStop);
        }
        catch (BadLocationException e) {
            return;
        }
        if (selStart == selStop) {
            startLine = 0;
            stopLine = this.textarea.getLineCount() - 1;
        } else {
            try {
                if (this.textarea.getLineStartOffset(stopLine) == selStop) {
                    --stopLine;
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        for (int i = startLine; i <= stopLine; ++i) {
            this.appendFormattedLine(cf, i);
        }
        cf.append(this.html ? "\n</pre>" : "\n[/code]");
        StringSelection formatted = new StringSelection(cf.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(formatted, (clipboard1, contents) -> {});
        Clipboard unixclipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (unixclipboard != null) {
            unixclipboard.setContents(formatted, null);
        }
        this.editor.statusNotice("Code formatted for " + (this.html ? "HTML" : "the Arduino forum") + " has been copied to the clipboard.");
    }

    private void appendToHTML(char c, StringBuilder buffer) {
        if (!this.html) {
            buffer.append(c);
        } else if (c == '<') {
            buffer.append("&lt;");
        } else if (c == '>') {
            buffer.append("&gt;");
        } else if (c == '&') {
            buffer.append("&amp;");
        } else if (c > '\u007f') {
            buffer.append("&#").append((int)c).append(";");
        } else {
            buffer.append(c);
        }
    }

    private void appendFormattedLine(StringBuilder buffer, int line) {
        Segment segment = new Segment();
        this.textarea.getTextLine(line, segment);
        if (!this.html) {
            char[] segmentArray = segment.array;
            int segmentOffset = segment.offset;
            int segmentCount = segment.count;
            for (int j = 0; j < segmentCount; ++j) {
                char c = segmentArray[j + segmentOffset];
                this.appendToHTML(c, buffer);
            }
            return;
        }
        for (Token tokenList = this.textarea.getTokenListForLine(line); tokenList != null; tokenList = tokenList.getNextToken()) {
            if (tokenList.getType() == 0) continue;
            tokenList.appendHTMLRepresentation(buffer, (RSyntaxTextArea)this.textarea, false);
        }
        buffer.append('\n');
    }
}

