# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "databoxedge device share update",
)
class Update(AAZCommand):
    """Update share on the device.

    :example: Update share
        az databoxedge device share update -g rg -n share-name --device-name name --description test
    """

    _aaz_info = {
        "version": "2023-07-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.databoxedge/databoxedgedevices/{}/shares/{}", "2023-07-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.device_name = AAZStrArg(
            options=["--device-name"],
            help="The device name.",
            required=True,
            id_part="name",
        )
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The share name.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.access_protocol = AAZStrArg(
            options=["--access-protocol"],
            arg_group="Properties",
            help="Access protocol to be used by the share.",
            enum={"NFS": "NFS", "SMB": "SMB"},
        )
        _args_schema.azure_container_info = AAZObjectArg(
            options=["--azure-container-info"],
            arg_group="Properties",
            help="Azure container mapping for the share.",
            nullable=True,
        )
        _args_schema.client_access_rights = AAZListArg(
            options=["--client-access-rights"],
            arg_group="Properties",
            help="List of IP addresses and corresponding access rights on the share(required for NFS protocol).",
            nullable=True,
        )
        _args_schema.data_policy = AAZStrArg(
            options=["--data-policy"],
            arg_group="Properties",
            help="Data policy of the share.",
            nullable=True,
            enum={"Cloud": "Cloud", "Local": "Local"},
        )
        _args_schema.description = AAZStrArg(
            options=["--description"],
            arg_group="Properties",
            help="Description for the share.",
            nullable=True,
        )
        _args_schema.monitoring_status = AAZStrArg(
            options=["--monitoring-status"],
            arg_group="Properties",
            help="Current monitoring status of the share.",
            enum={"Disabled": "Disabled", "Enabled": "Enabled"},
        )
        _args_schema.refresh_details = AAZObjectArg(
            options=["--refresh-details"],
            arg_group="Properties",
            help="Details of the refresh job on this share.",
            nullable=True,
        )
        _args_schema.share_status = AAZStrArg(
            options=["--share-status"],
            arg_group="Properties",
            help="Current status of the share.",
            enum={"NeedsAttention": "NeedsAttention", "OK": "OK", "Offline": "Offline", "Unknown": "Unknown", "Updating": "Updating"},
        )
        _args_schema.user_access_rights = AAZListArg(
            options=["--user-access-rights"],
            arg_group="Properties",
            help="Mapping of users and corresponding access rights on the share (required for SMB protocol).",
            nullable=True,
        )

        azure_container_info = cls._args_schema.azure_container_info
        azure_container_info.container_name = AAZStrArg(
            options=["container-name"],
            help="Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).",
        )
        azure_container_info.data_format = AAZStrArg(
            options=["data-format"],
            help="Storage format used for the file represented by the share.",
            enum={"AzureFile": "AzureFile", "BlockBlob": "BlockBlob", "PageBlob": "PageBlob"},
        )
        azure_container_info.storage_account_credential_id = AAZStrArg(
            options=["storage-account-credential-id"],
            help="ID of the storage account credential used to access storage.",
        )

        client_access_rights = cls._args_schema.client_access_rights
        client_access_rights.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.client_access_rights.Element
        _element.access_permission = AAZStrArg(
            options=["access-permission"],
            help="Type of access to be allowed for the client.",
            enum={"NoAccess": "NoAccess", "ReadOnly": "ReadOnly", "ReadWrite": "ReadWrite"},
        )
        _element.client = AAZStrArg(
            options=["client"],
            help="IP of the client.",
        )

        refresh_details = cls._args_schema.refresh_details
        refresh_details.error_manifest_file = AAZStrArg(
            options=["error-manifest-file"],
            help="Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This could be a failed job or a successful job.",
            nullable=True,
        )
        refresh_details.in_progress_refresh_job_id = AAZStrArg(
            options=["in-progress-refresh-job-id"],
            help="If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that job. The field is empty if no job is in progress.",
            nullable=True,
        )
        refresh_details.last_completed_refresh_job_time_in_utc = AAZDateTimeArg(
            options=["last-completed-refresh-job-time-in-utc"],
            help="Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed job or a successful job.",
            nullable=True,
        )
        refresh_details.last_job = AAZStrArg(
            options=["last-job"],
            help="Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a successful job.",
            nullable=True,
        )

        user_access_rights = cls._args_schema.user_access_rights
        user_access_rights.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.user_access_rights.Element
        _element.access_type = AAZStrArg(
            options=["access-type"],
            help="Type of access to be allowed for the user.",
            enum={"Change": "Change", "Custom": "Custom", "Read": "Read"},
        )
        _element.user_id = AAZStrArg(
            options=["user-id"],
            help="User ID (already existing in the device).",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SharesGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.SharesCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SharesGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/shares/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "deviceName", self.ctx.args.device_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-07-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_share_read(cls._schema_on_200)

            return cls._schema_on_200

    class SharesCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBoxEdge/dataBoxEdgeDevices/{deviceName}/shares/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "deviceName", self.ctx.args.device_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-07-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_share_read(cls._schema_on_200)

            return cls._schema_on_200

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType, ".", typ_kwargs={"flags": {"required": True, "client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("accessProtocol", AAZStrType, ".access_protocol", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("azureContainerInfo", AAZObjectType, ".azure_container_info")
                properties.set_prop("clientAccessRights", AAZListType, ".client_access_rights")
                properties.set_prop("dataPolicy", AAZStrType, ".data_policy")
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("monitoringStatus", AAZStrType, ".monitoring_status", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("refreshDetails", AAZObjectType, ".refresh_details")
                properties.set_prop("shareStatus", AAZStrType, ".share_status", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("userAccessRights", AAZListType, ".user_access_rights")

            azure_container_info = _builder.get(".properties.azureContainerInfo")
            if azure_container_info is not None:
                azure_container_info.set_prop("containerName", AAZStrType, ".container_name", typ_kwargs={"flags": {"required": True}})
                azure_container_info.set_prop("dataFormat", AAZStrType, ".data_format", typ_kwargs={"flags": {"required": True}})
                azure_container_info.set_prop("storageAccountCredentialId", AAZStrType, ".storage_account_credential_id", typ_kwargs={"flags": {"required": True}})

            client_access_rights = _builder.get(".properties.clientAccessRights")
            if client_access_rights is not None:
                client_access_rights.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.clientAccessRights[]")
            if _elements is not None:
                _elements.set_prop("accessPermission", AAZStrType, ".access_permission", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("client", AAZStrType, ".client", typ_kwargs={"flags": {"required": True}})

            refresh_details = _builder.get(".properties.refreshDetails")
            if refresh_details is not None:
                refresh_details.set_prop("errorManifestFile", AAZStrType, ".error_manifest_file")
                refresh_details.set_prop("inProgressRefreshJobId", AAZStrType, ".in_progress_refresh_job_id")
                refresh_details.set_prop("lastCompletedRefreshJobTimeInUTC", AAZStrType, ".last_completed_refresh_job_time_in_utc")
                refresh_details.set_prop("lastJob", AAZStrType, ".last_job")

            user_access_rights = _builder.get(".properties.userAccessRights")
            if user_access_rights is not None:
                user_access_rights.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.userAccessRights[]")
            if _elements is not None:
                _elements.set_prop("accessType", AAZStrType, ".access_type", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("userId", AAZStrType, ".user_id", typ_kwargs={"flags": {"required": True}})

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_share_read = None

    @classmethod
    def _build_schema_share_read(cls, _schema):
        if cls._schema_share_read is not None:
            _schema.id = cls._schema_share_read.id
            _schema.name = cls._schema_share_read.name
            _schema.properties = cls._schema_share_read.properties
            _schema.system_data = cls._schema_share_read.system_data
            _schema.type = cls._schema_share_read.type
            return

        cls._schema_share_read = _schema_share_read = AAZObjectType()

        share_read = _schema_share_read
        share_read.id = AAZStrType(
            flags={"read_only": True},
        )
        share_read.name = AAZStrType(
            flags={"read_only": True},
        )
        share_read.properties = AAZObjectType(
            flags={"required": True, "client_flatten": True},
        )
        share_read.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        share_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_share_read.properties
        properties.access_protocol = AAZStrType(
            serialized_name="accessProtocol",
            flags={"required": True},
        )
        properties.azure_container_info = AAZObjectType(
            serialized_name="azureContainerInfo",
        )
        properties.client_access_rights = AAZListType(
            serialized_name="clientAccessRights",
        )
        properties.data_policy = AAZStrType(
            serialized_name="dataPolicy",
        )
        properties.description = AAZStrType()
        properties.monitoring_status = AAZStrType(
            serialized_name="monitoringStatus",
            flags={"required": True},
        )
        properties.refresh_details = AAZObjectType(
            serialized_name="refreshDetails",
        )
        properties.share_mappings = AAZListType(
            serialized_name="shareMappings",
            flags={"read_only": True},
        )
        properties.share_status = AAZStrType(
            serialized_name="shareStatus",
            flags={"required": True},
        )
        properties.user_access_rights = AAZListType(
            serialized_name="userAccessRights",
        )

        azure_container_info = _schema_share_read.properties.azure_container_info
        azure_container_info.container_name = AAZStrType(
            serialized_name="containerName",
            flags={"required": True},
        )
        azure_container_info.data_format = AAZStrType(
            serialized_name="dataFormat",
            flags={"required": True},
        )
        azure_container_info.storage_account_credential_id = AAZStrType(
            serialized_name="storageAccountCredentialId",
            flags={"required": True},
        )

        client_access_rights = _schema_share_read.properties.client_access_rights
        client_access_rights.Element = AAZObjectType()

        _element = _schema_share_read.properties.client_access_rights.Element
        _element.access_permission = AAZStrType(
            serialized_name="accessPermission",
            flags={"required": True},
        )
        _element.client = AAZStrType(
            flags={"required": True},
        )

        refresh_details = _schema_share_read.properties.refresh_details
        refresh_details.error_manifest_file = AAZStrType(
            serialized_name="errorManifestFile",
        )
        refresh_details.in_progress_refresh_job_id = AAZStrType(
            serialized_name="inProgressRefreshJobId",
        )
        refresh_details.last_completed_refresh_job_time_in_utc = AAZStrType(
            serialized_name="lastCompletedRefreshJobTimeInUTC",
        )
        refresh_details.last_job = AAZStrType(
            serialized_name="lastJob",
        )

        share_mappings = _schema_share_read.properties.share_mappings
        share_mappings.Element = AAZObjectType()

        _element = _schema_share_read.properties.share_mappings.Element
        _element.mount_point = AAZStrType(
            serialized_name="mountPoint",
            flags={"read_only": True},
        )
        _element.mount_type = AAZStrType(
            serialized_name="mountType",
            flags={"read_only": True},
        )
        _element.role_id = AAZStrType(
            serialized_name="roleId",
            flags={"read_only": True},
        )
        _element.role_type = AAZStrType(
            serialized_name="roleType",
            flags={"read_only": True},
        )
        _element.share_id = AAZStrType(
            serialized_name="shareId",
            flags={"required": True},
        )

        user_access_rights = _schema_share_read.properties.user_access_rights
        user_access_rights.Element = AAZObjectType()

        _element = _schema_share_read.properties.user_access_rights.Element
        _element.access_type = AAZStrType(
            serialized_name="accessType",
            flags={"required": True},
        )
        _element.user_id = AAZStrType(
            serialized_name="userId",
            flags={"required": True},
        )

        system_data = _schema_share_read.system_data
        system_data.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        _schema.id = cls._schema_share_read.id
        _schema.name = cls._schema_share_read.name
        _schema.properties = cls._schema_share_read.properties
        _schema.system_data = cls._schema_share_read.system_data
        _schema.type = cls._schema_share_read.type


__all__ = ["Update"]
