/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.model.Description;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class JvmApplicationProjectInitDescriptor
extends JvmProjectInitDescriptor {
    public JvmApplicationProjectInitDescriptor(Description description, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(description, libraryVersionProvider, documentationRegistry);
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.APPLICATION;
    }

    @Override
    public Set<ModularizationOption> getModularizationOptions() {
        return new TreeSet<ModularizationOption>(Arrays.asList(ModularizationOption.SINGLE_PROJECT, ModularizationOption.WITH_LIBRARY_PROJECTS));
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generateProjectBuildScript(projectName, settings, buildScriptBuilder);
        if ("app".equals(projectName)) {
            buildScriptBuilder.block(null, "application", (Action<? super ScriptBlockBuilder>)((Action)b -> {
                String mainClass;
                String string = mainClass = this.getLanguage() == Language.KOTLIN ? "AppKt" : "App";
                if (!this.isSingleProject(settings)) {
                    mainClass = "app." + mainClass;
                }
                b.propertyAssignment("Define the main class for the application.", "mainClass", this.withPackage(settings, mainClass), false);
            }));
        }
        if (this.isSingleProject(settings)) {
            this.applyApplicationPlugin(buildScriptBuilder);
            buildScriptBuilder.implementationDependency("This dependency is used by the application.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
        } else if ("app".equals(projectName)) {
            buildScriptBuilder.plugin(null, this.applicationConventionPlugin(settings));
            buildScriptBuilder.dependencies().dependency("implementation", null, "org.apache.commons:commons-text");
            buildScriptBuilder.dependencies().projectDependency("implementation", null, ":utilities");
        } else {
            buildScriptBuilder.plugin(null, this.libraryConventionPlugin(settings));
            if ("utilities".equals(projectName)) {
                buildScriptBuilder.dependencies().projectDependency("api", null, ":list");
            }
        }
    }

    @Override
    protected void sourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory, List<String> templates) {
        if (this.isSingleProject(settings)) {
            templates.add("App");
        } else {
            if ("app".equals(subproject)) {
                templates.add("multi/app/App");
                templates.add("multi/app/MessageUtils");
            }
            if ("list".equals(subproject)) {
                templates.add("multi/list/LinkedList");
            }
            if ("utilities".equals(subproject)) {
                templates.add("multi/utilities/JoinUtils");
                templates.add("multi/utilities/SplitUtils");
                templates.add("multi/utilities/StringUtils");
            }
        }
    }

    @Override
    protected void testSourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory, List<String> templates) {
        block10: {
            block9: {
                if (!this.isSingleProject(settings)) break block9;
                switch (settings.getTestFramework()) {
                    case SPOCK: {
                        templates.add("groovy/AppTest");
                        break block10;
                    }
                    case TESTNG: {
                        templates.add("testng/AppTest");
                        break block10;
                    }
                    case JUNIT: 
                    case KOTLINTEST: {
                        templates.add("AppTest");
                        break block10;
                    }
                    case JUNIT_JUPITER: {
                        templates.add("junitjupiter/AppTest");
                        break block10;
                    }
                    case SCALATEST: {
                        templates.add("AppSuite");
                        break block10;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if ("app".equals(subproject)) {
                templates.add("multi/app/junit5/MessageUtilsTest");
            }
            if ("list".equals(subproject)) {
                templates.add("multi/list/junit5/LinkedListTest");
            }
        }
    }
}

