/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlUtils;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NoteReader {
    private final InputSource inputSource;
    private List<Note> parsedNotes;

    static LatLon parseLatLon(UnaryOperator<String> attrs) {
        double lat = Double.parseDouble((String)attrs.apply("lat"));
        double lon = Double.parseDouble((String)attrs.apply("lon"));
        return new LatLon(lat, lon);
    }

    static Note parseNoteBasic(Attributes attrs) {
        return NoteReader.parseNoteBasic(attrs::getValue);
    }

    static Note parseNoteBasic(UnaryOperator<String> attrs) {
        return new Note(NoteReader.parseLatLon(attrs));
    }

    static Note parseNoteFull(Attributes attrs) {
        return NoteReader.parseNoteFull(attrs::getValue);
    }

    static Note parseNoteFull(UnaryOperator<String> attrs) {
        String closedTimeStr;
        Note note = NoteReader.parseNoteBasic(attrs);
        String id = (String)attrs.apply("id");
        if (id != null) {
            note.setId(Long.parseLong(id));
        }
        if ((closedTimeStr = (String)attrs.apply("closed_at")) == null) {
            note.setState(Note.State.OPEN);
        } else {
            note.setState(Note.State.CLOSED);
            note.setClosedAt(DateUtils.parseInstant(closedTimeStr));
        }
        String createdAt = (String)attrs.apply("created_at");
        if (createdAt != null) {
            note.setCreatedAt(DateUtils.parseInstant(createdAt));
        }
        return note;
    }

    public NoteReader(InputStream source) {
        this.inputSource = new InputSource(source);
    }

    public NoteReader(String source) {
        this.inputSource = new InputSource(new ByteArrayInputStream(source.getBytes(StandardCharsets.UTF_8)));
    }

    public List<Note> parse() throws SAXException, IOException {
        Parser parser = new Parser();
        try {
            XmlUtils.parseSafeSAX(this.inputSource, parser);
        }
        catch (ParserConfigurationException e) {
            Logging.error(e);
            throw new SAXException(e);
        }
        return this.parsedNotes;
    }

    private class Parser
    extends DefaultHandler {
        private NoteParseMode parseMode;
        private final StringBuilder buffer = new StringBuilder();
        private Note thisNote;
        private long commentUid;
        private String commentUsername;
        private NoteComment.Action noteAction;
        private Instant commentCreateDate;
        private boolean commentIsNew;
        private List<Note> notes;
        private String commentText;

        private Parser() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            this.buffer.setLength(0);
            switch (qName) {
                case "osm": {
                    this.parseMode = NoteParseMode.API;
                    this.notes = new ArrayList<Note>(100);
                    return;
                }
                case "osm-notes": {
                    this.parseMode = NoteParseMode.DUMP;
                    this.notes = new ArrayList<Note>(10000);
                    return;
                }
            }
            if (this.parseMode == NoteParseMode.API) {
                if ("note".equals(qName)) {
                    this.thisNote = NoteReader.parseNoteBasic(attrs);
                }
                return;
            }
            switch (qName) {
                case "note": {
                    this.thisNote = NoteReader.parseNoteFull(attrs);
                    break;
                }
                case "comment": {
                    this.commentUid = Long.parseLong(Optional.ofNullable(attrs.getValue("uid")).orElse("0"));
                    this.commentUsername = attrs.getValue("user");
                    this.noteAction = NoteComment.Action.valueOf(attrs.getValue("action").toUpperCase(Locale.ENGLISH));
                    this.commentCreateDate = DateUtils.parseInstant(attrs.getValue("timestamp"));
                    this.commentIsNew = Boolean.parseBoolean(Optional.ofNullable(attrs.getValue("is_new")).orElse("false"));
                    break;
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if (this.notes != null && "note".equals(qName)) {
                this.notes.add(this.thisNote);
            }
            if ("comment".equals(qName)) {
                User commentUser = User.createOsmUser(this.commentUid, this.commentUsername);
                if (this.commentUid == 0L) {
                    commentUser = User.getAnonymous();
                }
                if (this.parseMode == NoteParseMode.API) {
                    this.commentIsNew = false;
                }
                if (this.parseMode == NoteParseMode.DUMP) {
                    this.commentText = this.buffer.toString();
                }
                this.thisNote.addComment(new NoteComment(this.commentCreateDate, commentUser, this.commentText, this.noteAction, this.commentIsNew));
                this.commentUid = 0L;
                this.commentUsername = null;
                this.commentCreateDate = null;
                this.commentIsNew = false;
                this.commentText = null;
            }
            if (this.parseMode == NoteParseMode.DUMP) {
                return;
            }
            switch (qName) {
                case "id": {
                    this.thisNote.setId(Long.parseLong(this.buffer.toString()));
                    break;
                }
                case "status": {
                    this.thisNote.setState(Note.State.valueOf(this.buffer.toString().toUpperCase(Locale.ENGLISH)));
                    break;
                }
                case "date_created": {
                    this.thisNote.setCreatedAt(DateUtils.parseInstant(this.buffer.toString()));
                    break;
                }
                case "date_closed": {
                    this.thisNote.setClosedAt(DateUtils.parseInstant(this.buffer.toString()));
                    break;
                }
                case "date": {
                    this.commentCreateDate = DateUtils.parseInstant(this.buffer.toString());
                    break;
                }
                case "user": {
                    this.commentUsername = this.buffer.toString();
                    break;
                }
                case "uid": {
                    this.commentUid = Long.parseLong(this.buffer.toString());
                    break;
                }
                case "text": {
                    this.commentText = this.buffer.toString();
                    this.buffer.setLength(0);
                    break;
                }
                case "action": {
                    this.noteAction = NoteComment.Action.valueOf(this.buffer.toString().toUpperCase(Locale.ENGLISH));
                    break;
                }
            }
        }

        @Override
        public void endDocument() throws SAXException {
            NoteReader.this.parsedNotes = this.notes;
        }
    }

    private static enum NoteParseMode {
        API,
        DUMP;

    }
}

