/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.photoshop.PhotoshopReader;
import com.drew.metadata.photoshop.PsdHeaderDirectory;
import java.io.IOException;

public class PsdReader {
    public void extract(@NotNull SequentialReader reader, @NotNull Metadata metadata) {
        long sectionLength;
        PsdHeaderDirectory directory = new PsdHeaderDirectory();
        metadata.addDirectory(directory);
        try {
            int signature = reader.getInt32();
            if (signature != 943870035) {
                directory.addError("Invalid PSD file signature");
                return;
            }
            int version = reader.getUInt16();
            if (version != 1 && version != 2) {
                directory.addError("Invalid PSD file version (must be 1 or 2)");
                return;
            }
            reader.skip(6L);
            int channelCount = reader.getUInt16();
            directory.setInt(1, channelCount);
            int imageHeight = reader.getInt32();
            directory.setInt(2, imageHeight);
            int imageWidth = reader.getInt32();
            directory.setInt(3, imageWidth);
            int bitsPerChannel = reader.getUInt16();
            directory.setInt(4, bitsPerChannel);
            int colorMode = reader.getUInt16();
            directory.setInt(5, colorMode);
        }
        catch (IOException e) {
            directory.addError("Unable to read PSD header");
            return;
        }
        try {
            sectionLength = reader.getUInt32();
            reader.skip(sectionLength);
        }
        catch (IOException e) {
            return;
        }
        try {
            sectionLength = reader.getUInt32();
            assert (sectionLength <= Integer.MAX_VALUE);
            new PhotoshopReader().extract(reader, (int)sectionLength, metadata);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

