/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.quantiles.DirectUpdateDoublesSketch;
import com.yahoo.sketches.quantiles.HeapUpdateDoublesSketch;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import com.yahoo.sketches.quantiles.Util;

public class DoublesSketchBuilder {
    private int bK = 128;

    public DoublesSketchBuilder setK(int k) {
        Util.checkK(k);
        this.bK = k;
        return this;
    }

    public int getK() {
        return this.bK;
    }

    public UpdateDoublesSketch build() {
        return HeapUpdateDoublesSketch.newInstance(this.bK);
    }

    public UpdateDoublesSketch build(WritableMemory dstMem) {
        return DirectUpdateDoublesSketch.newInstance(this.bK, dstMem);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuantileSketchBuilder configuration:").append(Util.LS);
        sb.append("K     : ").append('\t').append(this.bK).append(Util.LS);
        return sb.toString();
    }
}

