/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.listener;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.RestoreInProgress;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.dao.GeoIpDataDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.geospatial.ip2geo.jobscheduler.DatasourceTask;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.threadpool.ThreadPool;

public class Ip2GeoListener
extends AbstractLifecycleComponent
implements ClusterStateListener {
    @Generated
    private static final Logger log = LogManager.getLogger(Ip2GeoListener.class);
    private static final int SCHEDULE_IN_MIN = 15;
    private static final int DELAY_IN_MILLIS = 10000;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final DatasourceDao datasourceDao;
    private final GeoIpDataDao geoIpDataDao;

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.localNodeClusterManager()) {
            return;
        }
        for (RestoreInProgress.Entry entry : (RestoreInProgress)event.state().custom("restore", (ClusterState.Custom)RestoreInProgress.EMPTY)) {
            List ip2GeoDataIndices;
            if (!RestoreInProgress.State.SUCCESS.equals((Object)entry.state())) continue;
            if (entry.indices().stream().anyMatch(index -> ".scheduler-geospatial-ip2geo-datasource".equals(index))) {
                this.threadPool.generic().submit(() -> this.forceUpdateGeoIpData());
            }
            if ((ip2GeoDataIndices = entry.indices().stream().filter(index -> index.startsWith(".geospatial-ip2geo-data")).collect(Collectors.toList())).isEmpty()) continue;
            this.threadPool.generic().submit(() -> this.geoIpDataDao.deleteIp2GeoDataIndex(ip2GeoDataIndices));
        }
    }

    private void forceUpdateGeoIpData() {
        this.datasourceDao.getAllDatasources(new ActionListener<List<Datasource>>(){

            public void onResponse(List<Datasource> datasources) {
                datasources.stream().forEach(x$0 -> Ip2GeoListener.this.scheduleForceUpdate((Datasource)x$0));
                Ip2GeoListener.this.datasourceDao.updateDatasource(datasources, new ActionListener<BulkResponse>(){

                    public void onResponse(BulkResponse bulkItemResponses) {
                        log.info("Datasources are updated for cleanup");
                    }

                    public void onFailure(Exception e) {
                        log.error("Failed to update datasource for cleanup after restoring", (Throwable)e);
                    }
                });
            }

            public void onFailure(Exception e) {
                log.error("Failed to get datasource after restoring", (Throwable)e);
            }
        });
    }

    private void scheduleForceUpdate(Datasource datasource) {
        IntervalSchedule schedule = new IntervalSchedule(Instant.now(), 15, ChronoUnit.MINUTES, 10000L);
        datasource.resetDatabase();
        datasource.setSystemSchedule(schedule);
        datasource.setTask(DatasourceTask.ALL);
    }

    protected void doStart() {
        if (DiscoveryNode.isClusterManagerNode((Settings)this.clusterService.getSettings())) {
            this.clusterService.addListener((ClusterStateListener)this);
        }
    }

    protected void doStop() {
        this.clusterService.removeListener((ClusterStateListener)this);
    }

    protected void doClose() throws IOException {
    }

    @Inject
    @Generated
    public Ip2GeoListener(ClusterService clusterService, ThreadPool threadPool, DatasourceDao datasourceDao, GeoIpDataDao geoIpDataDao) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.datasourceDao = datasourceDao;
        this.geoIpDataDao = geoIpDataDao;
    }
}

