/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.stats;

import java.util.concurrent.atomic.AtomicLong;

public enum KNNCounter {
    GRAPH_QUERY_ERRORS("graph_query_errors"),
    GRAPH_QUERY_REQUESTS("graph_query_requests"),
    GRAPH_INDEX_ERRORS("graph_index_errors"),
    GRAPH_INDEX_REQUESTS("graph_index_requests"),
    KNN_QUERY_REQUESTS("knn_query_requests"),
    SCRIPT_COMPILATIONS("script_compilations"),
    SCRIPT_COMPILATION_ERRORS("script_compilation_errors"),
    SCRIPT_QUERY_REQUESTS("script_query_requests"),
    SCRIPT_QUERY_ERRORS("script_query_errors"),
    TRAINING_REQUESTS("training_requests"),
    TRAINING_ERRORS("training_errors"),
    KNN_QUERY_WITH_FILTER_REQUESTS("knn_query_with_filter_requests");

    private String name;
    private AtomicLong count;

    private KNNCounter(String name) {
        this.name = name;
        this.count = new AtomicLong(0L);
    }

    public String getName() {
        return this.name;
    }

    public Long getCount() {
        return this.count.get();
    }

    public void increment() {
        this.count.getAndIncrement();
    }

    public void set(long value) {
        this.count.set(value);
    }
}

