/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.join.aggregations;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.join.aggregations.ChildrenToParentAggregator;
import org.opensearch.join.aggregations.InternalParent;
import org.opensearch.search.aggregations.AggregationExecutionException;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.NonCollectingAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public class ParentAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final Query parentFilter;
    private final Query childFilter;

    public ParentAggregatorFactory(String name, ValuesSourceConfig config, Query childFilter, Query parentFilter, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.childFilter = childFilter;
        this.parentFilter = parentFilter;
    }

    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NonCollectingAggregator(this.name, searchContext, parent, this.factories, metadata){

            public InternalAggregation buildEmptyAggregation() {
                return new InternalParent(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
            }
        };
    }

    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator children, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        ValuesSource rawValuesSource = this.config.getValuesSource();
        if (!(rawValuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
            throw new AggregationExecutionException("ValuesSource type " + rawValuesSource.toString() + "is not supported for aggregation " + this.name());
        }
        ValuesSource.Bytes.WithOrdinals valuesSource = (ValuesSource.Bytes.WithOrdinals)rawValuesSource;
        long maxOrd = valuesSource.globalMaxOrd((IndexSearcher)searchContext.searcher());
        return new ChildrenToParentAggregator(this.name, this.factories, searchContext, children, this.childFilter, this.parentFilter, valuesSource, maxOrd, cardinality, metadata);
    }

    public String getStatsSubtype() {
        return "other";
    }

    protected boolean supportsConcurrentSegmentSearch() {
        return false;
    }
}

