/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.aclib.gui;

import zext.plantuml.com.ctreber.aclib.gui.MonitoredObject;

public class MOInteger
extends MonitoredObject {
    private int fInteger;
    private boolean fCheckRange = false;
    private int fMin;
    private int fMax;

    public MOInteger() {
    }

    public MOInteger(int pInteger) {
        this.fInteger = pInteger;
    }

    public MOInteger(int pInteger, int pMin, int pMax) {
        this.fMin = pMin;
        this.fMax = pMax;
        this.fCheckRange = true;
        this.set(pInteger);
    }

    public void set(int pInteger) {
        if (!this.checkRange(pInteger)) {
            throw new IllegalArgumentException("Argument '" + pInteger + "' out of range [" + MOInteger.niceFormat(this.fMin) + "; " + MOInteger.niceFormat(this.fMax) + "]");
        }
        this.fInteger = pInteger;
        this.fireValueChanged();
    }

    private static String niceFormat(int pInteger) {
        if (pInteger == Integer.MAX_VALUE) {
            return "Infinity";
        }
        if (pInteger == Integer.MIN_VALUE) {
            return "-Infinity";
        }
        return Integer.toString(pInteger);
    }

    public int get() {
        return this.fInteger;
    }

    private boolean checkRange(int pInteger) {
        return !this.fCheckRange || this.fMin <= pInteger && pInteger <= this.fMax;
    }

    @Override
    public boolean checkRange() {
        return this.checkRange(this.fInteger);
    }
}

