/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.OWLIcons;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLAnnotationCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 324857847551294897L;
    private JLabel annotationURILabel;
    private JTextArea annotationContentArea;
    private JLabel iconLabel;
    private OWLEditorKit owlEditorKit;
    private static final Color LABEL_COLOR = Color.BLUE.darker();
    private OWLOntology ontology;
    private Font normalFont;
    private Font activeOntologyFont;

    public OWLAnnotationCellRenderer(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.annotationURILabel = new JLabel();
        this.annotationURILabel.setForeground(LABEL_COLOR);
        this.normalFont = this.annotationURILabel.getFont();
        this.activeOntologyFont = this.normalFont.deriveFont(1);
        this.annotationContentArea = new JTextArea();
        this.annotationContentArea.setFont(new Font("Dialog", 0, 12));
        this.annotationContentArea.setLineWrap(true);
        this.annotationContentArea.setWrapStyleWord(true);
        this.annotationContentArea.setOpaque(false);
        this.iconLabel = new JLabel();
        this.iconLabel.setIcon(OWLIcons.getIcon("individual.png"));
        JPanel contentPanel = new JPanel(new BorderLayout(3, 3));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(2, 20, 2, 2));
        contentPanel.setOpaque(false);
        contentPanel.add((Component)this.annotationContentArea, "Center");
        contentPanel.add((Component)this.iconLabel, "West");
        this.add((Component)this.annotationURILabel, "North");
        this.add((Component)contentPanel, "South");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof OWLAnnotation) {
            OWLAnnotation anno = (OWLAnnotation)value;
            String ren = this.owlEditorKit.getModelManager().getRendering((OWLObject)anno.getProperty());
            String val = this.owlEditorKit.getModelManager().getRendering((OWLObject)anno.getValue());
            this.annotationURILabel.setText(ren);
            this.annotationContentArea.setText(val);
            if (OWLRendererPreferences.getInstance().isHighlightActiveOntologyStatements() && this.owlEditorKit.getOWLModelManager().getActiveOntology().equals((Object)this.ontology)) {
                this.annotationURILabel.setFont(this.activeOntologyFont);
            } else {
                this.annotationURILabel.setFont(this.normalFont);
            }
            if (isSelected) {
                this.annotationContentArea.setForeground(list.getSelectionForeground());
                this.annotationURILabel.setForeground(list.getSelectionForeground());
            } else {
                this.annotationContentArea.setForeground(list.getForeground());
                this.annotationURILabel.setForeground(LABEL_COLOR);
            }
            this.iconLabel.setVisible(anno.getValue() instanceof IRI);
        } else {
            this.annotationURILabel.setText("WARNING!");
            this.annotationContentArea.setText("Value being rendered is NOT an annotation.  Probable flow control logic error.\nClass: " + value.getClass().getName());
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setBackground(list.getBackground());
        }
        return this;
    }

    public void setOntology(OWLOntology ontology) {
        this.ontology = ontology;
    }
}

