from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.Adaptor3d import *
from OCC.Core.TopoDS import *
from OCC.Core.Geom import *
from OCC.Core.gp import *
from OCC.Core.GeomAbs import *
from OCC.Core.TColStd import *
from OCC.Core.GeomAdaptor import *
from OCC.Core.Geom2dAdaptor import *
from OCC.Core.Adaptor2d import *


class BRepAdaptor_Array1OfCurve:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def __getitem__(self, index: int) -> BRepAdaptor_Curve: ...
    def __setitem__(self, index: int, value: BRepAdaptor_Curve) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[BRepAdaptor_Curve]: ...
    def next(self) -> BRepAdaptor_Curve: ...
    __next__ = next
    def Init(self, theValue: BRepAdaptor_Curve) -> None: ...
    def Size(self) -> int: ...
    def Length(self) -> int: ...
    def IsEmpty(self) -> bool: ...
    def Lower(self) -> int: ...
    def Upper(self) -> int: ...
    def IsDetectable(self) -> bool: ...
    def IsAllocated(self) -> bool: ...
    def First(self) -> BRepAdaptor_Curve: ...
    def Last(self) -> BRepAdaptor_Curve: ...
    def Value(self, theIndex: int) -> BRepAdaptor_Curve: ...
    def SetValue(self, theIndex: int, theValue: BRepAdaptor_Curve) -> None: ...

class BRepAdaptor_CompCurve(Adaptor3d_Curve):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, W: TopoDS_Wire, KnotByCurvilinearAbcissa: Optional[bool] = False) -> None: ...
    @overload
    def __init__(self, W: TopoDS_Wire, KnotByCurvilinearAbcissa: bool, First: float, Last: float, Tol: float) -> None: ...
    def BSpline(self) -> Geom_BSplineCurve: ...
    def Bezier(self) -> Geom_BezierCurve: ...
    def Circle(self) -> gp_Circ: ...
    def Continuity(self) -> GeomAbs_Shape: ...
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
    def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
    def DN(self, U: float, N: int) -> gp_Vec: ...
    def Degree(self) -> int: ...
    def Edge(self, U: float, E: TopoDS_Edge) -> float: ...
    def Ellipse(self) -> gp_Elips: ...
    def FirstParameter(self) -> float: ...
    def GetType(self) -> GeomAbs_CurveType: ...
    def Hyperbola(self) -> gp_Hypr: ...
    @overload
    def Initialize(self, W: TopoDS_Wire, KnotByCurvilinearAbcissa: bool) -> None: ...
    @overload
    def Initialize(self, W: TopoDS_Wire, KnotByCurvilinearAbcissa: bool, First: float, Last: float, Tol: float) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def IsClosed(self) -> bool: ...
    def IsPeriodic(self) -> bool: ...
    def IsRational(self) -> bool: ...
    def LastParameter(self) -> float: ...
    def Line(self) -> gp_Lin: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def Parabola(self) -> gp_Parab: ...
    def Period(self) -> float: ...
    def Resolution(self, R3d: float) -> float: ...
    def ShallowCopy(self) -> Adaptor3d_Curve: ...
    def Trim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Curve: ...
    def Value(self, U: float) -> gp_Pnt: ...
    def Wire(self) -> TopoDS_Wire: ...

class BRepAdaptor_Curve(Adaptor3d_Curve):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, E: TopoDS_Edge) -> None: ...
    @overload
    def __init__(self, E: TopoDS_Edge, F: TopoDS_Face) -> None: ...
    def BSpline(self) -> Geom_BSplineCurve: ...
    def Bezier(self) -> Geom_BezierCurve: ...
    def Circle(self) -> gp_Circ: ...
    def Continuity(self) -> GeomAbs_Shape: ...
    def Curve(self) -> GeomAdaptor_Curve: ...
    def CurveOnSurface(self) -> Adaptor3d_CurveOnSurface: ...
    def D0(self, U: float, P: gp_Pnt) -> None: ...
    def D1(self, U: float, P: gp_Pnt, V: gp_Vec) -> None: ...
    def D2(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec) -> None: ...
    def D3(self, U: float, P: gp_Pnt, V1: gp_Vec, V2: gp_Vec, V3: gp_Vec) -> None: ...
    def DN(self, U: float, N: int) -> gp_Vec: ...
    def Degree(self) -> int: ...
    def Edge(self) -> TopoDS_Edge: ...
    def Ellipse(self) -> gp_Elips: ...
    def FirstParameter(self) -> float: ...
    def GetType(self) -> GeomAbs_CurveType: ...
    def Hyperbola(self) -> gp_Hypr: ...
    @overload
    def Initialize(self, E: TopoDS_Edge) -> None: ...
    @overload
    def Initialize(self, E: TopoDS_Edge, F: TopoDS_Face) -> None: ...
    def Intervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def Is3DCurve(self) -> bool: ...
    def IsClosed(self) -> bool: ...
    def IsCurveOnSurface(self) -> bool: ...
    def IsPeriodic(self) -> bool: ...
    def IsRational(self) -> bool: ...
    def LastParameter(self) -> float: ...
    def Line(self) -> gp_Lin: ...
    def NbIntervals(self, S: GeomAbs_Shape) -> int: ...
    def NbKnots(self) -> int: ...
    def NbPoles(self) -> int: ...
    def OffsetCurve(self) -> Geom_OffsetCurve: ...
    def Parabola(self) -> gp_Parab: ...
    def Period(self) -> float: ...
    def Reset(self) -> None: ...
    def Resolution(self, R3d: float) -> float: ...
    def ShallowCopy(self) -> Adaptor3d_Curve: ...
    def Tolerance(self) -> float: ...
    def Trim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Curve: ...
    def Trsf(self) -> gp_Trsf: ...
    def Value(self, U: float) -> gp_Pnt: ...

class BRepAdaptor_Curve2d(Geom2dAdaptor_Curve):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, E: TopoDS_Edge, F: TopoDS_Face) -> None: ...
    def Edge(self) -> TopoDS_Edge: ...
    def Face(self) -> TopoDS_Face: ...
    def Initialize(self, E: TopoDS_Edge, F: TopoDS_Face) -> None: ...
    def ShallowCopy(self) -> Adaptor2d_Curve2d: ...

class BRepAdaptor_Surface(Adaptor3d_Surface):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, F: TopoDS_Face, R: Optional[bool] = True) -> None: ...
    def AxeOfRevolution(self) -> gp_Ax1: ...
    def BSpline(self) -> Geom_BSplineSurface: ...
    def BasisCurve(self) -> Adaptor3d_Curve: ...
    def BasisSurface(self) -> Adaptor3d_Surface: ...
    def Bezier(self) -> Geom_BezierSurface: ...
    def ChangeSurface(self) -> GeomAdaptor_Surface: ...
    def Cone(self) -> gp_Cone: ...
    def Cylinder(self) -> gp_Cylinder: ...
    def D0(self, U: float, V: float, P: gp_Pnt) -> None: ...
    def D1(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec) -> None: ...
    def D2(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec) -> None: ...
    def D3(self, U: float, V: float, P: gp_Pnt, D1U: gp_Vec, D1V: gp_Vec, D2U: gp_Vec, D2V: gp_Vec, D2UV: gp_Vec, D3U: gp_Vec, D3V: gp_Vec, D3UUV: gp_Vec, D3UVV: gp_Vec) -> None: ...
    def DN(self, U: float, V: float, Nu: int, Nv: int) -> gp_Vec: ...
    def Direction(self) -> gp_Dir: ...
    def Face(self) -> TopoDS_Face: ...
    def FirstUParameter(self) -> float: ...
    def FirstVParameter(self) -> float: ...
    def GetType(self) -> GeomAbs_SurfaceType: ...
    def Initialize(self, F: TopoDS_Face, Restriction: Optional[bool] = True) -> None: ...
    def IsUClosed(self) -> bool: ...
    def IsUPeriodic(self) -> bool: ...
    def IsURational(self) -> bool: ...
    def IsVClosed(self) -> bool: ...
    def IsVPeriodic(self) -> bool: ...
    def IsVRational(self) -> bool: ...
    def LastUParameter(self) -> float: ...
    def LastVParameter(self) -> float: ...
    def NbUIntervals(self, theSh: GeomAbs_Shape) -> int: ...
    def NbUKnots(self) -> int: ...
    def NbUPoles(self) -> int: ...
    def NbVIntervals(self, theSh: GeomAbs_Shape) -> int: ...
    def NbVKnots(self) -> int: ...
    def NbVPoles(self) -> int: ...
    def OffsetValue(self) -> float: ...
    def Plane(self) -> gp_Pln: ...
    def ShallowCopy(self) -> Adaptor3d_Surface: ...
    def Sphere(self) -> gp_Sphere: ...
    def Surface(self) -> GeomAdaptor_Surface: ...
    def Tolerance(self) -> float: ...
    def Torus(self) -> gp_Torus: ...
    def Trsf(self) -> gp_Trsf: ...
    def UContinuity(self) -> GeomAbs_Shape: ...
    def UDegree(self) -> int: ...
    def UIntervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def UPeriod(self) -> float: ...
    def UResolution(self, theR3d: float) -> float: ...
    def UTrim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Surface: ...
    def VContinuity(self) -> GeomAbs_Shape: ...
    def VDegree(self) -> int: ...
    def VIntervals(self, T: TColStd_Array1OfReal, S: GeomAbs_Shape) -> None: ...
    def VPeriod(self) -> float: ...
    def VResolution(self, theR3d: float) -> float: ...
    def VTrim(self, First: float, Last: float, Tol: float) -> Adaptor3d_Surface: ...
    def Value(self, U: float, V: float) -> gp_Pnt: ...

# harray1 classes

class BRepAdaptor_HArray1OfCurve(BRepAdaptor_Array1OfCurve, Standard_Transient):
    def __init__(self, theLower: int, theUpper: int) -> None: ...
    def Array1(self) -> BRepAdaptor_Array1OfCurve: ...

# harray2 classes
# hsequence classes

