/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.tree;

import java.io.Serializable;
import java.util.LinkedList;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class BreadthFirstSearch
implements Serializable {
    private static final long serialVersionUID = -5513673019948703483L;
    private TreeModel tree;
    private LinkedList<TreePath> queue;
    private final Object root;
    private Object node;

    public BreadthFirstSearch(TreeModel tree, Object root) {
        this.tree = tree;
        this.queue = new LinkedList();
        this.root = root;
        this.restart();
    }

    public BreadthFirstSearch(TreeModel tree) {
        this(tree, null);
    }

    protected Object getRoot() {
        if (this.root == null) {
            return this.tree.getRoot();
        }
        return this.root;
    }

    public TreePath next() {
        if (this.queue.isEmpty()) {
            return null;
        }
        TreePath next = this.queue.removeLast();
        this.node = next.getLastPathComponent();
        int n = this.tree.getChildCount(this.node);
        for (int i = 0; i < n; ++i) {
            this.queue.addFirst(next.pathByAddingChild(this.tree.getChild(this.node, i)));
        }
        return next;
    }

    public void prune() {
        if (this.node != null) {
            int n = this.tree.getChildCount(this.node);
            for (int i = 0; i < n; ++i) {
                this.queue.removeFirst();
            }
        }
    }

    public void restart() {
        this.queue.clear();
        Object root = this.getRoot();
        if (root != null) {
            this.queue.add(new TreePath(root));
        }
    }
}

