import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { CancelUpdateStackInput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link CancelUpdateStackCommand}.
 */
export interface CancelUpdateStackCommandInput extends CancelUpdateStackInput {
}
/**
 * @public
 *
 * The output of {@link CancelUpdateStackCommand}.
 */
export interface CancelUpdateStackCommandOutput extends __MetadataBearer {
}
/**
 * @public
 * <p>Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update
 *    and reverts to the previous stack configuration.</p>
 *          <note>
 *             <p>You can cancel only stacks that are in the <code>UPDATE_IN_PROGRESS</code> state.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, CancelUpdateStackCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, CancelUpdateStackCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // CancelUpdateStackInput
 *   StackName: "STRING_VALUE", // required
 *   ClientRequestToken: "STRING_VALUE",
 * };
 * const command = new CancelUpdateStackCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param CancelUpdateStackCommandInput - {@link CancelUpdateStackCommandInput}
 * @returns {@link CancelUpdateStackCommandOutput}
 * @see {@link CancelUpdateStackCommandInput} for command's `input` shape.
 * @see {@link CancelUpdateStackCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link TokenAlreadyExistsException} (client fault)
 *  <p>A client request token already exists.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class CancelUpdateStackCommand extends $Command<CancelUpdateStackCommandInput, CancelUpdateStackCommandOutput, CloudFormationClientResolvedConfig> {
    readonly input: CancelUpdateStackCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: CancelUpdateStackCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudFormationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CancelUpdateStackCommandInput, CancelUpdateStackCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
