import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DescribeStackInstanceInput,
  DescribeStackInstanceOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DescribeStackInstanceCommandInput
  extends DescribeStackInstanceInput {}
export interface DescribeStackInstanceCommandOutput
  extends DescribeStackInstanceOutput,
    __MetadataBearer {}
export declare class DescribeStackInstanceCommand extends $Command<
  DescribeStackInstanceCommandInput,
  DescribeStackInstanceCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DescribeStackInstanceCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeStackInstanceCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeStackInstanceCommandInput,
    DescribeStackInstanceCommandOutput
  >;
  private serialize;
  private deserialize;
}
