import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  ListStackSetOperationsInput,
  ListStackSetOperationsOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface ListStackSetOperationsCommandInput
  extends ListStackSetOperationsInput {}
export interface ListStackSetOperationsCommandOutput
  extends ListStackSetOperationsOutput,
    __MetadataBearer {}
export declare class ListStackSetOperationsCommand extends $Command<
  ListStackSetOperationsCommandInput,
  ListStackSetOperationsCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: ListStackSetOperationsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ListStackSetOperationsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    ListStackSetOperationsCommandInput,
    ListStackSetOperationsCommandOutput
  >;
  private serialize;
  private deserialize;
}
