﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/glacier/Glacier_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glacier {
namespace Model {

/**
 * <p>Provides options for specifying a range inventory retrieval
 * job.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glacier-2012-06-01/InventoryRetrievalJobInput">AWS
 * API Reference</a></p>
 */
class InventoryRetrievalJobInput {
 public:
  AWS_GLACIER_API InventoryRetrievalJobInput() = default;
  AWS_GLACIER_API InventoryRetrievalJobInput(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLACIER_API InventoryRetrievalJobInput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLACIER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The start of the date range in UTC for vault inventory retrieval that
   * includes archives created on or after this date. This value should be a string
   * in the ISO 8601 date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
   */
  inline const Aws::String& GetStartDate() const { return m_startDate; }
  inline bool StartDateHasBeenSet() const { return m_startDateHasBeenSet; }
  template <typename StartDateT = Aws::String>
  void SetStartDate(StartDateT&& value) {
    m_startDateHasBeenSet = true;
    m_startDate = std::forward<StartDateT>(value);
  }
  template <typename StartDateT = Aws::String>
  InventoryRetrievalJobInput& WithStartDate(StartDateT&& value) {
    SetStartDate(std::forward<StartDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The end of the date range in UTC for vault inventory retrieval that includes
   * archives created before this date. This value should be a string in the ISO 8601
   * date format, for example <code>2013-03-20T17:03:43Z</code>.</p>
   */
  inline const Aws::String& GetEndDate() const { return m_endDate; }
  inline bool EndDateHasBeenSet() const { return m_endDateHasBeenSet; }
  template <typename EndDateT = Aws::String>
  void SetEndDate(EndDateT&& value) {
    m_endDateHasBeenSet = true;
    m_endDate = std::forward<EndDateT>(value);
  }
  template <typename EndDateT = Aws::String>
  InventoryRetrievalJobInput& WithEndDate(EndDateT&& value) {
    SetEndDate(std::forward<EndDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the maximum number of inventory items returned per vault inventory
   * retrieval request. Valid values are greater than or equal to 1.</p>
   */
  inline const Aws::String& GetLimit() const { return m_limit; }
  inline bool LimitHasBeenSet() const { return m_limitHasBeenSet; }
  template <typename LimitT = Aws::String>
  void SetLimit(LimitT&& value) {
    m_limitHasBeenSet = true;
    m_limit = std::forward<LimitT>(value);
  }
  template <typename LimitT = Aws::String>
  InventoryRetrievalJobInput& WithLimit(LimitT&& value) {
    SetLimit(std::forward<LimitT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An opaque string that represents where to continue pagination of the vault
   * inventory retrieval results. You use the marker in a new <b>InitiateJob</b>
   * request to obtain additional inventory items. If there are no more inventory
   * items, this value is <code>null</code>.</p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  inline bool MarkerHasBeenSet() const { return m_markerHasBeenSet; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  InventoryRetrievalJobInput& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_startDate;
  bool m_startDateHasBeenSet = false;

  Aws::String m_endDate;
  bool m_endDateHasBeenSet = false;

  Aws::String m_limit;
  bool m_limitHasBeenSet = false;

  Aws::String m_marker;
  bool m_markerHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glacier
}  // namespace Aws
