﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qconnect/QConnectRequest.h>
#include <aws/qconnect/QConnect_EXPORTS.h>

#include <utility>

namespace Aws {
namespace QConnect {
namespace Model {

/**
 */
class DeleteMessageTemplateRequest : public QConnectRequest {
 public:
  AWS_QCONNECT_API DeleteMessageTemplateRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteMessageTemplate"; }

  AWS_QCONNECT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier of the knowledge base. Can be either the ID or the ARN. URLs
   * cannot contain the ARN.</p>
   */
  inline const Aws::String& GetKnowledgeBaseId() const { return m_knowledgeBaseId; }
  inline bool KnowledgeBaseIdHasBeenSet() const { return m_knowledgeBaseIdHasBeenSet; }
  template <typename KnowledgeBaseIdT = Aws::String>
  void SetKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    m_knowledgeBaseIdHasBeenSet = true;
    m_knowledgeBaseId = std::forward<KnowledgeBaseIdT>(value);
  }
  template <typename KnowledgeBaseIdT = Aws::String>
  DeleteMessageTemplateRequest& WithKnowledgeBaseId(KnowledgeBaseIdT&& value) {
    SetKnowledgeBaseId(std::forward<KnowledgeBaseIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the message template. Can be either the ID or the ARN.</p>
   */
  inline const Aws::String& GetMessageTemplateId() const { return m_messageTemplateId; }
  inline bool MessageTemplateIdHasBeenSet() const { return m_messageTemplateIdHasBeenSet; }
  template <typename MessageTemplateIdT = Aws::String>
  void SetMessageTemplateId(MessageTemplateIdT&& value) {
    m_messageTemplateIdHasBeenSet = true;
    m_messageTemplateId = std::forward<MessageTemplateIdT>(value);
  }
  template <typename MessageTemplateIdT = Aws::String>
  DeleteMessageTemplateRequest& WithMessageTemplateId(MessageTemplateIdT&& value) {
    SetMessageTemplateId(std::forward<MessageTemplateIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_knowledgeBaseId;
  bool m_knowledgeBaseIdHasBeenSet = false;

  Aws::String m_messageTemplateId;
  bool m_messageTemplateIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QConnect
}  // namespace Aws
