/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.columns.ui;

import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.plugin.manipulators.columns.CopyDataToOtherColumn;
import org.gephi.datalab.spi.DialogControls;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulator;
import org.gephi.datalab.spi.columns.AttributeColumnsManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CopyDataToOtherColumnUI
extends JPanel
implements AttributeColumnsManipulatorUI {
    CopyDataToOtherColumn manipulator;
    Column[] columns;
    private JComboBox columnsComboBox;
    private JLabel descriptionLabel;
    private JLabel sourceColumnLabel;

    public CopyDataToOtherColumnUI() {
        this.initComponents();
    }

    public void setup(AttributeColumnsManipulator m, GraphModel graphModel, Table table, Column column, DialogControls dialogControls) {
        this.manipulator = (CopyDataToOtherColumn)m;
        this.sourceColumnLabel.setText(NbBundle.getMessage(CopyDataToOtherColumnUI.class, (String)"CopyDataToOtherColumnUI.sourceColumnLabel.text", (Object)column.getTitle()));
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        ArrayList<Column> availableColumns = new ArrayList<Column>();
        for (Column c : table) {
            if (!ac.canChangeColumnData(c) || c == column) continue;
            availableColumns.add(c);
            this.columnsComboBox.addItem(c.getTitle());
        }
        this.columns = availableColumns.toArray(new Column[0]);
    }

    public void unSetup() {
        if (this.columnsComboBox.getSelectedIndex() != -1) {
            this.manipulator.setTargetColumn(this.columns[this.columnsComboBox.getSelectedIndex()]);
        } else {
            this.manipulator.setTargetColumn(null);
        }
    }

    public String getDisplayName() {
        return this.manipulator.getName();
    }

    public JPanel getSettingsPanel() {
        return this;
    }

    public boolean isModal() {
        return true;
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.columnsComboBox = new JComboBox();
        this.sourceColumnLabel = new JLabel();
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setText(NbBundle.getMessage(CopyDataToOtherColumnUI.class, (String)"CopyDataToOtherColumnUI.descriptionLabel.text"));
        this.sourceColumnLabel.setHorizontalAlignment(0);
        this.sourceColumnLabel.setText(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, -1, Short.MAX_VALUE).addComponent(this.columnsComboBox, 0, 192, Short.MAX_VALUE).addComponent(this.sourceColumnLabel, -1, 192, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.sourceColumnLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnsComboBox, -2, -1, -2).addContainerGap()));
    }
}

