#
# $Id: Country.pm,v 1.2 2006/07/23 13:16:36 vanbaal Exp $
#
# The data in this module is taken from
#   http://www.iana.org/cctld/cctld-whois.htm ,
#   http://www.iana.org/gtld/gtld.htm and
#   http://www.icann.org/tlds/ with some additions
#
# Copyright (C) 2001 Stichting LogReport Foundation <logreport@logreport.org>
#
#     This file is part of Lire.
#
#     Lire is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program (see COPYING); if not, check with
#     http://www.gnu.org/copyleft/gpl.html.
#
package Lire::WWW::Domain::Country;

use strict;
use vars qw/ $REVISION/;

{
    $REVISION  = '$Id: Country.pm,v 1.2 2006/07/23 13:16:36 vanbaal Exp $';
}

# -----------------------------------------------------------------------------
# Database
# -----------------------------------------------------------------------------

my %CountryHash = (
  ".aero" => ".aero (Air-transport industry)",
  ".biz"  => ".biz (Business)",
  ".com"  => ".com (Commercial)",
  ".coop" => ".coop (Cooperatives)",
  ".edu"  => ".edu (U.S. University)",
  ".gov"  => ".gov (U.S. Governmental)",
  ".info" => ".info (Informational)",
  ".int"  => ".int (International)",
  ".mil"  => ".mil (U.S. Military)",
  ".museum" => ".museum (Museums)",
  ".name" => ".name (Individuals)",
  ".net"  => ".net (Network)",
  ".org"  => ".org (Organizations)",
  ".pro"  => ".pro (Accountants, lawyers, and physicians)",
  ".ac" => ".ac (Ascension Island)",
  ".ad" => ".ad (Andorra)",
  ".ae" => ".ae (United Arab Emirates)",
  ".af" => ".af (Afghanistan)",
  ".ag" => ".ag (Antigua and Barbuda)",
  ".ai" => ".ai (Anguilla)",
  ".al" => ".al (Albania)",
  ".am" => ".am (Armenia)",
  ".an" => ".an (Netherlands Antilles)",
  ".ao" => ".ao (Angola)",
  ".aq" => ".aq (Antartica)",
  ".ar" => ".ar (Argentina)",
  ".as" => ".as (American Samoa)",
  ".at" => ".at (Austria)",
  ".au" => ".au (Australia)",
  ".aw" => ".aw (Aruba)",
  ".az" => ".az (Azerbaijan)",
  ".ba" => ".ba (Bosnia and Herzegovina)",
  ".bb" => ".bb (Barbados)",
  ".bd" => ".bd (Bangladesh)",
  ".be" => ".be (Belgium)",
  ".bf" => ".bf (Burkina Faso)",
  ".bg" => ".bg (Bulgaria)",
  ".bh" => ".bh (Bahrain)",
  ".bi" => ".bi (Burundi)",
  ".bj" => ".bj (Benin)",
  ".bm" => ".bm (Bermuda)",
  ".bn" => ".bn (Brunei Darussalam)",
  ".bo" => ".bo (Bolivia)",
  ".br" => ".br (Brazil)",
  ".bs" => ".bs (Bahamas)",
  ".bt" => ".bt (Bhutan)",
  ".bv" => ".bv (Bouvet Island)",
  ".bw" => ".bw (Botswana)",
  ".by" => ".by (Belarus)",
  ".bz" => ".bz (Belize)",
  ".ca" => ".ca (Canada)",
  ".cc" => ".cc (Cocos (Keeling) Islands)",
  ".cd" => ".cd (Democratic Republic of the Congo)",
  ".cf" => ".cf (Central African Republic)",
  ".cg" => ".cg (Republic of Congo)",
  ".ch" => ".ch (Switzerland)",
  ".ci" => ".ci (Cote d'Ivoire)",
  ".ck" => ".ck (Cook Islands)",
  ".cl" => ".cl (Chile)",
  ".cm" => ".cm (Cameroon)",
  ".cn" => ".cn (China)",
  ".co" => ".co (Colombia)",
  ".cr" => ".cr (Costa Rica)",
  ".cu" => ".cu (Cuba)",
  ".cv" => ".cv (Cap Verde)",
  ".cx" => ".cx (Christmas Island)",
  ".cy" => ".cy (Cyprus)",
  ".cz" => ".cz (Czech Republic)",
  ".de" => ".de (Germany)",
  ".dj" => ".dj (Djibouti)",
  ".dk" => ".dk (Denmark)",
  ".dm" => ".dm (Dominica)",
  ".do" => ".do (Dominican Republic)",
  ".dz" => ".dz (Algeria)",
  ".ec" => ".ec (Ecuador)",
  ".ee" => ".ee (Estonia)",
  ".eg" => ".eg (Egypt)",
  ".eh" => ".eh (Western Sahara)",
  ".er" => ".er (Eritrea)",
  ".es" => ".es (Spain)",
  ".et" => ".et (Ethiopia)",
  ".fi" => ".fi (Finland)",
  ".fj" => ".fj (Fiji)",
  ".fk" => ".fk (Falkland Islands (Malvina))",
  ".fm" => ".fm (Federal State of Micronesia)",
  ".fo" => ".fo (Faroe Islands)",
  ".fr" => ".fr (France)",
  ".ga" => ".ga (Gabon)",
  ".gd" => ".gd (Grenada)",
  ".ge" => ".ge (Georgia)",
  ".gf" => ".gf (French Guiana)",
  ".gg" => ".gg (Guernsey)",
  ".gh" => ".gh (Ghana)",
  ".gi" => ".gi (Gibraltar)",
  ".gl" => ".gl (Greenland)",
  ".gm" => ".gm (Gambia)",
  ".gn" => ".gn (Guinea)",
  ".gp" => ".gp (Guadeloupe)",
  ".gq" => ".gq (Equatorial Guinea)",
  ".gr" => ".gr (Greece)",
  ".gs" => ".gs (South Georgia and the South Sandwich Islands)",
  ".gt" => ".gt (Guatemala)",
  ".gu" => ".gu (Guam)",
  ".gw" => ".gw (Guinea-Bissau)",
  ".gy" => ".gy (Guyana)",
  ".hk" => ".hk (Hong Kong)",
  ".hm" => ".hm (Heard and McDonald Islands)",
  ".hn" => ".hn (Honduras)",
  ".hr" => ".hr (Croatia/Hrvatska)",
  ".ht" => ".ht (Haiti)",
  ".hu" => ".hu (Hungary)",
  ".id" => ".id (Indonesia)",
  ".ie" => ".ie (Ireland)",
  ".il" => ".il (Israel)",
  ".im" => ".im (Isle of Man)",
  ".in" => ".in (India)",
  ".io" => ".io (British Indian Ocean Territory)",
  ".iq" => ".iq (Iraq)",
  ".ir" => ".ir (Iran (Islamic Republic of))",
  ".is" => ".is (Iceland)",
  ".it" => ".it (Italy)",
  ".je" => ".je (Jersey)",
  ".jm" => ".jm (Jamaica)",
  ".jo" => ".jo (Jordan)",
  ".jp" => ".jp (Japan)",
  ".ke" => ".ke (Kenya)",
  ".kg" => ".kg (Kyrgyzstan)",
  ".kh" => ".kh (Cambodia)",
  ".ki" => ".ki (Kiribati)",
  ".km" => ".km (Comoros)",
  ".kn" => ".kn (Saint Kitts and Nevis)",
  ".kp" => ".kp (Democratic People's Republic Korea)",
  ".kr" => ".kr (Republic of Korea)",
  ".kw" => ".kw (Kuwait)",
  ".ky" => ".ky (Cayman Islands)",
  ".kz" => ".kz (Kazakhstan)",
  ".la" => ".la (Lao People's Democratic Republic)",
  ".lb" => ".lb (Lebanon)",
  ".lc" => ".lc (Saint Lucia)",
  ".li" => ".li (Liechtenstein)",
  ".lk" => ".lk (Sri Lanka)",
  ".lr" => ".lr (Liberia)",
  ".ls" => ".ls (Lesotho)",
  ".lt" => ".lt (Lithuania)",
  ".lu" => ".lu (Luxembourg)",
  ".lv" => ".lv (Latvia)",
  ".ly" => ".ly (Libyan Arab Jamahiriya)",
  ".ma" => ".ma (Morocco)",
  ".mc" => ".mc (Monaco)",
  ".md" => ".md (Republic of Moldova)",
  ".mg" => ".mg (Madagascar)",
  ".mh" => ".mh (Marshall Islands)",
  ".mk" => ".mk (Macedonia, Former Yugoslav Republic)",
  ".ml" => ".ml (Mali)",
  ".mm" => ".mm (Myanmar)",
  ".mn" => ".mn (Mongolia)",
  ".mo" => ".mo (Macau)",
  ".mp" => ".mp (Northern Mariana Islands)",
  ".mq" => ".mq (Martinique)",
  ".mr" => ".mr (Mauritania)",
  ".ms" => ".ms (Montserrat)",
  ".mt" => ".mt (Malta)",
  ".mu" => ".mu (Mauritius)",
  ".mv" => ".mv (Maldives)",
  ".mw" => ".mw (Malawi)",
  ".mx" => ".mx (Mexico)",
  ".my" => ".my (Malaysia)",
  ".mz" => ".mz (Mozambique)",
  ".na" => ".na (Namibia)",
  ".nc" => ".nc (New Caledonia)",
  ".ne" => ".ne (Niger)",
  ".nf" => ".nf (Norfolk Island)",
  ".ng" => ".ng (Nigeria)",
  ".ni" => ".ni (Nicaragua)",
  ".nl" => ".nl (Netherlands)",
  ".no" => ".no (Norway)",
  ".np" => ".np (Nepal)",
  ".nr" => ".nr (Nauru)",
  ".nu" => ".nu (Niue)",
  ".nz" => ".nz (New Zealand)",
  ".om" => ".om (Oman)",
  ".pa" => ".pa (Panama)",
  ".pe" => ".pe (Peru)",
  ".pf" => ".pf (French Polynesia)",
  ".pg" => ".pg (Papua New Guinea)",
  ".ph" => ".ph (Philippines)",
  ".pk" => ".pk (Pakistan)",
  ".pl" => ".pl (Poland)",
  ".pm" => ".pm (St. Pierre and Miquelon)",
  ".pn" => ".pn (Pitcairn Island)",
  ".pr" => ".pr (Puerto Rico)",
  ".ps" => ".ps (Palestinian Territories)",
  ".pt" => ".pt (Portugal)",
  ".pw" => ".pw (Palau)",
  ".py" => ".py (Paraguay)",
  ".qa" => ".qa (Qatar)",
  ".re" => ".re (Reunion Island)",
  ".ro" => ".ro (Romania)",
  ".ru" => ".ru (Russian Federation)",
  ".rw" => ".rw (Rwanda)",
  ".sa" => ".sa (Saudi Arabia)",
  ".sb" => ".sb (Solomon Islands)",
  ".sc" => ".sc (Seychelles)",
  ".sd" => ".sd (Sudan)",
  ".se" => ".se (Sweden)",
  ".sg" => ".sg (Singapore)",
  ".sh" => ".sh (St. Helena)",
  ".si" => ".si (Slovenia)",
  ".sj" => ".sj (Svalbard and Jan Mayen Islands)",
  ".sk" => ".sk (Slovak Republic)",
  ".sl" => ".sl (Sierra Leone)",
  ".sm" => ".sm (San Marino)",
  ".sn" => ".sn (Senegal)",
  ".so" => ".so (Somalia)",
  ".sr" => ".sr (Suriname)",
  ".st" => ".st (Sao Tome and Principe)",
  ".sv" => ".sv (El Salvador)",
  ".sy" => ".sy (Syrian Arab Republic)",
  ".sz" => ".sz (Swaziland)",
  ".tc" => ".tc (Turks and Caicos Islands)",
  ".td" => ".td (Chad)",
  ".tf" => ".tf (French Southern Territories)",
  ".tg" => ".tg (Togo)",
  ".th" => ".th (Thailand)",
  ".tj" => ".tj (Tajikistan)",
  ".tk" => ".tk (Tokelau)",
  ".tm" => ".tm (Turkmenistan)",
  ".tn" => ".tn (Tunisia)",
  ".to" => ".to (Tonga)",
  ".tp" => ".tp (East Timor)",
  ".tr" => ".tr (Turkey)",
  ".tt" => ".tt (Trinidad and Tobago)",
  ".tv" => ".tv (Tuvalu)",
  ".tw" => ".tw (Taiwan)",
  ".tz" => ".tz (Tanzania)",
  ".ua" => ".ua (Ukraine)",
  ".ug" => ".ug (Uganda)",
  ".uk" => ".uk (United Kingdom)",
  ".um" => ".um (US Minor Outlying Islands)",
  ".us" => ".us (United States)",
  ".uy" => ".uy (Uruguay)",
  ".uz" => ".uz (Uzbekistan)",
  ".va" => ".va (Holy See (City Vatican State))",
  ".vc" => ".vc (Saint Vincent and the Grenadines)",
  ".ve" => ".ve (Venezuela)",
  ".vg" => ".vg (Virgin Islands (British))",
  ".vi" => ".vi (Virgin Islands (USA))",
  ".vn" => ".vn (Vietnam)",
  ".vu" => ".vu (Vanuatu)",
  ".wf" => ".wf (Wallis and Futuna Islands)",
  ".ws" => ".ws (Western Samoa)",
  ".ye" => ".ye (Yemen)",
  ".yt" => ".yt (Mayotte)",
  ".yu" => ".yu (Yugoslavia)",
  ".za" => ".za (South Africa)",
  ".zm" => ".zm (Zambia)",
  ".zw" => ".zw (Zimbabwe)",
);


# -----------------------------------------------------------------------------
# Functions
# -----------------------------------------------------------------------------

sub getCountry {
    my ($domain) = @_;
    my ($dm) = $domain =~/(\.\w+)$/;
    return undef unless defined $dm;

    return $CountryHash{lc $dm};
}

1;

