/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory.webservices;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import org.apache.naming.StringManager;

public class ServiceProxy
implements InvocationHandler {
    private static final StringManager sm = StringManager.getManager(ServiceProxy.class);
    private final Service service;
    private static Method portQNameClass = null;
    private static Method portClass = null;
    private Hashtable<String, QName> portComponentRef = null;

    public ServiceProxy(Service service) throws ServiceException {
        this.service = service;
        try {
            portQNameClass = Service.class.getDeclaredMethod("getPort", QName.class, Class.class);
            portClass = Service.class.getDeclaredMethod("getPort", Class.class);
        }
        catch (Exception exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (portQNameClass.equals(method)) {
            return this.getProxyPortQNameClass(objectArray);
        }
        if (portClass.equals(method)) {
            return this.getProxyPortClass(objectArray);
        }
        try {
            return method.invoke((Object)this.service, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    private Object getProxyPortQNameClass(Object[] objectArray) throws ServiceException {
        QName qName = (QName)objectArray[0];
        String string = qName.getLocalPart();
        Class clazz = (Class)objectArray[1];
        Iterator iterator = this.service.getPorts();
        while (iterator.hasNext()) {
            QName qName2 = (QName)iterator.next();
            String string2 = qName2.getLocalPart();
            if (!string2.equals(string)) continue;
            return this.service.getPort(qName, clazz);
        }
        throw new ServiceException(sm.getString("serviceProxy.portNotFound", qName));
    }

    public void setPortComponentRef(Hashtable<String, QName> hashtable) {
        this.portComponentRef = hashtable;
    }

    private Remote getProxyPortClass(Object[] objectArray) throws ServiceException {
        Class clazz = (Class)objectArray[0];
        if (this.portComponentRef == null) {
            return this.service.getPort(clazz);
        }
        QName qName = this.portComponentRef.get(clazz.getName());
        if (qName != null) {
            return this.service.getPort(qName, clazz);
        }
        return this.service.getPort(clazz);
    }
}

